/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer;

import java.awt.Rectangle;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import ome.model.units.BigResult;
import omero.gateway.SecurityContext;
import omero.gateway.model.ChannelData;
import omero.gateway.model.DataObject;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PixelsData;
import omero.gateway.model.WellSampleData;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.agents.events.FocusGainedEvent;
import org.openmicroscopy.shoola.agents.events.iviewer.CopyRndSettings;
import org.openmicroscopy.shoola.agents.events.iviewer.ImageViewport;
import org.openmicroscopy.shoola.agents.events.iviewer.MeasurementTool;
import org.openmicroscopy.shoola.agents.events.iviewer.RendererUnloadedEvent;
import org.openmicroscopy.shoola.agents.events.iviewer.RndSettingsChanged;
import org.openmicroscopy.shoola.agents.events.iviewer.RndSettingsCopied;
import org.openmicroscopy.shoola.agents.events.iviewer.RndSettingsSaved;
import org.openmicroscopy.shoola.agents.events.iviewer.SaveRelatedData;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImage;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImageObject;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewerState;
import org.openmicroscopy.shoola.agents.events.measurement.MeasurementToolLoaded;
import org.openmicroscopy.shoola.agents.events.measurement.ROIEvent;
import org.openmicroscopy.shoola.agents.events.measurement.SelectChannel;
import org.openmicroscopy.shoola.agents.events.measurement.SelectPlane;
import org.openmicroscopy.shoola.agents.events.metadata.ChannelSavedEvent;
import org.openmicroscopy.shoola.agents.events.treeviewer.DeleteObjectEvent;
import org.openmicroscopy.shoola.agents.events.treeviewer.DisplayModeEvent;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerFactory;
import org.openmicroscopy.shoola.env.Agent;
import org.openmicroscopy.shoola.env.Environment;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.ReconnectedEvent;
import org.openmicroscopy.shoola.env.data.events.ReloadRenderingEngine;
import org.openmicroscopy.shoola.env.data.events.UserGroupSwitched;
import org.openmicroscopy.shoola.env.data.events.ViewInPluginEvent;
import org.openmicroscopy.shoola.env.data.util.AgentSaveInfo;
import org.openmicroscopy.shoola.env.event.AgentEvent;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.ViewObjectEvent;

public class ImViewerAgent
implements Agent,
AgentEventListener {
    public static final String ERROR = " An error occurred while modifying the rendering settings.";
    private static Registry registry;
    private int displayMode = -1;

    public static Registry getRegistry() {
        return registry;
    }

    public static ExperimenterData getUserDetails() {
        return (ExperimenterData)registry.lookup("/current_user/details");
    }

    public static boolean isFastConnection() {
        int value = (Integer)registry.lookup("/connection/speed");
        return value == 0;
    }

    public static boolean isRunAsPlugin() {
        Environment env = (Environment)registry.lookup("/env");
        if (env == null) {
            return false;
        }
        return env.runAsPlugin() > 0;
    }

    private void handleViewImage(ViewImage evt) {
        if (evt == null) {
            return;
        }
        Boolean available = (Boolean)registry.lookup("/services/SERVER/BinaryAvailable");
        if (available != null && !available.booleanValue()) {
            return;
        }
        List<ViewImageObject> images = evt.getImages();
        ViewImageObject object = images.get(0);
        DataObject image = object.getImage();
        Rectangle r = evt.getRequesterBounds();
        ImViewer view = null;
        boolean b = evt.isSeparateWindow();
        if (image != null) {
            if (evt.getPlugin() > 0) {
                ViewInPluginEvent event = new ViewInPluginEvent(evt.getSecurityContext(), image, evt.getPlugin());
                EventBus bus = registry.getEventBus();
                bus.post(event);
                return;
            }
            PixelsData pixels = null;
            if (image instanceof ImageData) {
                pixels = ((ImageData)image).getDefaultPixels();
            } else if (image instanceof WellSampleData) {
                pixels = ((WellSampleData)image).getImage().getDefaultPixels();
            }
            if (pixels != null) {
                view = ImViewerFactory.getImageViewer(evt.getSecurityContext(), image, r, b);
            }
        } else if (evt.getPlugin() > 0) {
            ViewInPluginEvent event = new ViewInPluginEvent(evt.getSecurityContext(), object.getImageID(), evt.getPlugin());
            EventBus bus = registry.getEventBus();
            bus.post(event);
        } else {
            view = ImViewerFactory.getImageViewer(evt.getSecurityContext(), object.getImageID(), r, b);
        }
        if (view != null) {
            view.activate(object.getSettings(), object.getSelectedUserID(), this.displayMode, object.getSelectedRndDef());
            view.setContext(object.getParent(), object.getGrandParent());
        }
    }

    public static void logBigResultExeption(Object src, Object exception, String property) {
        if (exception instanceof BigResult) {
            ImViewerAgent.getRegistry().getLogger().warn(src, "Arithmetic overflow; " + property + " is " + ((BigResult)((Object)exception)).result.doubleValue());
        }
    }

    public static boolean canCreate() {
        Boolean b = (Boolean)registry.lookup("canCreate");
        return b;
    }

    private void handleSaveRelatedData(SaveRelatedData evt) {
        if (evt == null) {
            return;
        }
        ImViewerFactory.storeEvent(evt);
    }

    private void handleMeasurementToolLoaded(MeasurementToolLoaded evt) {
        if (evt == null) {
            return;
        }
        MeasurementTool request = (MeasurementTool)evt.getACT();
        PixelsData pixels = request.getPixels();
        if (pixels == null) {
            return;
        }
        long pixelsID = pixels.getId();
        ImViewer view = ImViewerFactory.getImageViewer(evt.getSecurityContext(), pixelsID);
        if (view != null) {
            switch (evt.getIndex()) {
                case 0: {
                    view.addToView(evt.getView());
                    break;
                }
                case 1: {
                    view.removeFromView(evt.getView());
                }
            }
        }
    }

    private void handleSelectPlane(SelectPlane evt) {
        if (evt == null) {
            return;
        }
        long pixelsID = evt.getPixelsID();
        ImViewer view = ImViewerFactory.getImageViewer(null, pixelsID);
        if (view != null && !view.isPlayingMovie()) {
            Rectangle r = evt.getBounds();
            if (r != null) {
                view.setSelectedRegion(evt.getDefaultZ(), evt.getDefaultT(), evt.getBounds());
            } else {
                view.setSelectedXYPlane(evt.getDefaultZ(), evt.getDefaultT());
            }
        }
    }

    private void handleSelectChannel(SelectChannel evt) {
        if (evt == null) {
            return;
        }
        long pixelsID = evt.getPixelsID();
        ImViewer view = ImViewerFactory.getImageViewer(null, pixelsID);
        if (view != null && !view.isPlayingMovie()) {
            List l = view.getActiveChannels();
            List<Integer> channels = evt.getChannels();
            for (Integer c : channels) {
                if (l.contains(c)) continue;
                view.setChannelSelection(c, true);
            }
        }
    }

    public void handleCopyRndSettingsEvent(CopyRndSettings evt) {
        if (evt == null) {
            return;
        }
        ImViewerFactory.copyRndSettings(evt.getImage(), evt.getRndDef());
    }

    private void handleRndSettingsCopied(RndSettingsCopied evt) {
        Collection<Long> ids = evt.getImagesIDs();
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        Iterator<Long> i = ids.iterator();
        long id = evt.getRefPixelsID();
        while (i.hasNext()) {
            ImViewer view = ImViewerFactory.getImageViewerFromImage(null, i.next());
            if (view == null) continue;
            if (view.getPixelsID() != id) {
                view.pasteRenderingSettings();
                view.saveRndSettings(true);
            }
            view.reloadRenderingThumbs();
        }
    }

    public void handleRndSettingsSavedEvent(RndSettingsSaved evt) {
        if (evt == null) {
            return;
        }
        ImViewerFactory.rndSettingsSaved(evt.getRefPixelsID(), evt.getSettings());
    }

    public void handleRndSettingsChangedEvent(RndSettingsChanged evt) {
        if (evt == null) {
            return;
        }
        ImViewerFactory.rndSettingsChanged(evt.getImageID());
    }

    private void handleFocusGainedEvent(FocusGainedEvent evt) {
    }

    private void handleImageViewportEvent(ImageViewport evt) {
        if (evt == null) {
            return;
        }
        ImViewer viewer = ImViewerFactory.getImageViewer(null, evt.getPixelsID());
        if (viewer == null) {
            return;
        }
        viewer.scrollToViewport(evt.getBounds());
    }

    private void handleUserGroupSwitched(UserGroupSwitched evt) {
        if (evt == null) {
            return;
        }
        ImViewerFactory.onGroupSwitched(evt.isSuccessful());
    }

    private void handleReconnectedEvent(ReconnectedEvent evt) {
        ImViewerFactory.onGroupSwitched(true);
    }

    private void handleViewObjectEvent(ViewObjectEvent evt) {
        if (evt == null) {
            return;
        }
        Object o = evt.getObject();
        if (evt.browseObject()) {
            return;
        }
        if (o instanceof ImageData) {
            if (evt.getPlugin() > 0) {
                JComponent src = evt.getSource();
                if (src != null) {
                    src.setEnabled(true);
                }
                ViewInPluginEvent event = new ViewInPluginEvent(evt.getSecurityContext(), ((ImageData)o).getId(), evt.getPlugin());
                EventBus bus = registry.getEventBus();
                bus.post(event);
            } else {
                ImViewer view = ImViewerFactory.getImageViewer(evt.getSecurityContext(), ((ImageData)o).getId(), null, true);
                if (view != null) {
                    view.activate(null, ImViewerAgent.getUserDetails().getId(), this.displayMode, -1L);
                    JComponent src = evt.getSource();
                    if (src != null) {
                        src.setEnabled(true);
                    }
                }
            }
        }
    }

    private void handleRendererUnloadedEvent(RendererUnloadedEvent evt) {
        if (evt == null) {
            return;
        }
        ImViewer viewer = ImViewerFactory.getImageViewer(null, evt.getPixelsID());
        if (viewer == null) {
            return;
        }
        viewer.discard();
    }

    private void handleDeleteObjectEvent(DeleteObjectEvent evt) {
        if (evt == null) {
            return;
        }
        List<DataObject> objects = evt.getObjects();
        if (objects == null) {
            return;
        }
        Iterator<DataObject> i = objects.iterator();
        EventBus bus = registry.getEventBus();
        while (i.hasNext()) {
            DataObject object = i.next();
            if (object instanceof ImageData) {
                this.checkImageForDelete((ImageData)object);
                continue;
            }
            ImViewer viewer = ImViewerFactory.getImageViewerFromParent(object);
            if (viewer == null) continue;
            ViewerState event = new ViewerState(viewer.getPixelsID(), 0);
            bus.post(event);
            viewer.discard();
        }
    }

    private void handleReloadRenderingEngineEvent(ReloadRenderingEngine evt) {
        if (evt == null) {
            return;
        }
        List<Long> pixels = evt.getPixelsID();
        if (CollectionUtils.isEmpty(pixels)) {
            return;
        }
        Iterator<Long> i = pixels.iterator();
        UserNotifier un = registry.getUserNotifier();
        while (i.hasNext()) {
            Long id = i.next();
            ImViewer viewer = ImViewerFactory.getImageViewer(null, id);
            if (viewer == null) continue;
            un.notifyInfo("Reload", "The rendering engine could not be reloaded for " + viewer.getUI().getTitle() + ".\nThe viewer will now close.");
            viewer.discard();
        }
    }

    private void handleChannelSavedEvent(ChannelSavedEvent evt) {
        List<ChannelData> channels = evt.getChannels();
        Iterator<Long> i = evt.getImageIds().iterator();
        SecurityContext ctx = evt.getSecurityContext();
        while (i.hasNext()) {
            ImViewer viewer = ImViewerFactory.getImageViewerFromImage(ctx, i.next());
            if (viewer == null) continue;
            viewer.onUpdatedChannels(channels);
        }
    }

    private void handleDisplayModeEvent(DisplayModeEvent evt) {
        this.displayMode = evt.getDisplayMode();
        ImViewerFactory.setDisplayMode(this.displayMode);
    }

    private void checkImageForDelete(ImageData image) {
        if (image.getId() < 0L) {
            return;
        }
        PixelsData pixels = image.getDefaultPixels();
        if (pixels == null) {
            return;
        }
        EventBus bus = registry.getEventBus();
        ImViewer viewer = ImViewerFactory.getImageViewer(null, pixels.getId());
        if (viewer != null) {
            ViewerState event = new ViewerState(viewer.getPixelsID(), 0);
            bus.post(event);
            viewer.discard();
        }
    }

    @Override
    public void activate(boolean master) {
    }

    @Override
    public void terminate() {
        Environment env = (Environment)registry.lookup("/env");
        if (env.isRunAsPlugin()) {
            ImViewerFactory.onGroupSwitched(true);
        }
    }

    @Override
    public void setContext(Registry ctx) {
        registry = ctx;
        EventBus bus = registry.getEventBus();
        bus.register((AgentEventListener)this, ViewImage.class);
        bus.register((AgentEventListener)this, MeasurementToolLoaded.class);
        bus.register((AgentEventListener)this, SelectPlane.class);
        bus.register((AgentEventListener)this, CopyRndSettings.class);
        bus.register((AgentEventListener)this, SaveRelatedData.class);
        bus.register((AgentEventListener)this, FocusGainedEvent.class);
        bus.register((AgentEventListener)this, ImageViewport.class);
        bus.register((AgentEventListener)this, UserGroupSwitched.class);
        bus.register((AgentEventListener)this, ViewObjectEvent.class);
        bus.register((AgentEventListener)this, RendererUnloadedEvent.class);
        bus.register((AgentEventListener)this, DeleteObjectEvent.class);
        bus.register((AgentEventListener)this, RndSettingsSaved.class);
        bus.register((AgentEventListener)this, ReloadRenderingEngine.class);
        bus.register((AgentEventListener)this, ReconnectedEvent.class);
        bus.register((AgentEventListener)this, SelectChannel.class);
        bus.register((AgentEventListener)this, ChannelSavedEvent.class);
        bus.register((AgentEventListener)this, DisplayModeEvent.class);
        bus.register((AgentEventListener)this, RndSettingsCopied.class);
        bus.register((AgentEventListener)this, RndSettingsChanged.class);
        bus.register((AgentEventListener)this, ROIEvent.class);
    }

    @Override
    public boolean canTerminate() {
        return true;
    }

    @Override
    public AgentSaveInfo getDataToSave() {
        List<Object> list = ImViewerFactory.getInstancesToSave();
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return new AgentSaveInfo("Image Viewer", list);
    }

    @Override
    public void save(List<Object> instances) {
        ImViewerFactory.saveInstances(instances);
    }

    @Override
    public void eventFired(AgentEvent e) {
        if (e instanceof ViewImage) {
            this.handleViewImage((ViewImage)e);
        } else if (e instanceof MeasurementToolLoaded) {
            this.handleMeasurementToolLoaded((MeasurementToolLoaded)e);
        } else if (e instanceof SelectPlane) {
            this.handleSelectPlane((SelectPlane)e);
        } else if (e instanceof CopyRndSettings) {
            this.handleCopyRndSettingsEvent((CopyRndSettings)e);
        } else if (e instanceof SaveRelatedData) {
            this.handleSaveRelatedData((SaveRelatedData)e);
        } else if (e instanceof FocusGainedEvent) {
            this.handleFocusGainedEvent((FocusGainedEvent)e);
        } else if (e instanceof ImageViewport) {
            this.handleImageViewportEvent((ImageViewport)e);
        } else if (e instanceof UserGroupSwitched) {
            this.handleUserGroupSwitched((UserGroupSwitched)e);
        } else if (e instanceof ViewObjectEvent) {
            this.handleViewObjectEvent((ViewObjectEvent)e);
        } else if (e instanceof RendererUnloadedEvent) {
            this.handleRendererUnloadedEvent((RendererUnloadedEvent)e);
        } else if (e instanceof DeleteObjectEvent) {
            this.handleDeleteObjectEvent((DeleteObjectEvent)e);
        } else if (e instanceof RndSettingsSaved) {
            this.handleRndSettingsSavedEvent((RndSettingsSaved)e);
        } else if (e instanceof ReloadRenderingEngine) {
            this.handleReloadRenderingEngineEvent((ReloadRenderingEngine)e);
        } else if (e instanceof ReconnectedEvent) {
            this.handleReconnectedEvent((ReconnectedEvent)e);
        } else if (e instanceof SelectChannel) {
            this.handleSelectChannel((SelectChannel)e);
        } else if (e instanceof ChannelSavedEvent) {
            this.handleChannelSavedEvent((ChannelSavedEvent)e);
        } else if (e instanceof DisplayModeEvent) {
            this.handleDisplayModeEvent((DisplayModeEvent)e);
        } else if (e instanceof RndSettingsCopied) {
            this.handleRndSettingsCopied((RndSettingsCopied)e);
        } else if (e instanceof RndSettingsChanged) {
            this.handleRndSettingsChangedEvent((RndSettingsChanged)e);
        } else if (e instanceof ROIEvent) {
            this.handleROIEvent((ROIEvent)e);
        }
    }

    private void handleROIEvent(ROIEvent e) {
        ImViewer viewer = ImViewerFactory.getImageViewerFromImage(null, e.getImageId());
        if (viewer != null) {
            viewer.reloadROICount();
        }
    }
}

