/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.actions;

import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.actions.ViewerAction;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ManageRndSettingsAction
extends ViewerAction {
    public static final int COPY = 0;
    public static final int PASTE = 1;
    public static final int RESET = 2;
    public static final int SET_MIN_MAX = 3;
    public static final int SET_OWNER = 4;
    public static final int UNDO = 5;
    public static final int SET_ABSOLUTE_MIN_MAX = 6;
    private static final String NAME_COPY = "Copy Settings";
    private static final String DESCRIPTION_COPY = "Copy the rendering settings.";
    private static final String NAME_PASTE = "Paste Settings";
    private static final String DESCRIPTION_PASTE = "Paste the rendering settings.";
    private static final String NAME_RESET = "Reset Default Settings";
    private static final String DESCRIPTION_RESET = "Reset the rendering settings created while importing.";
    private static final String NAME_SET_MIN_MAX = "Min/Max";
    private static final String NAME_SET_ABSOLUTE_MIN_MAX = "Full Range";
    private static final String DESCRIPTION_SET_MIN_MAX = "Set the Pixels Intensity interval to min/maxfor all channels.";
    private static final String NAME_SET_OWNER = "Set Owner's Settings";
    private static final String DESCRIPTION_SET_OWNER = "Set the Owner's rendering settings.";
    private static final String NAME_UNDO = "Undo changes";
    private static final String DESCRIPTION_UNDO = "Undo the changes.";
    private static final String DESCRIPTION_SET_ABSOLUTE_MIN_MAX = "Set the Pixels Intensity interval to the full range for all channels.";
    private IconManager icons = IconManager.getInstance();
    private int index;

    private void checkIndex(int value) {
        switch (value) {
            case 0: {
                this.name = NAME_COPY;
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_COPY));
                this.putValue("SmallIcon", this.icons.getIcon(50));
                break;
            }
            case 1: {
                this.name = NAME_PASTE;
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_PASTE));
                this.putValue("SmallIcon", this.icons.getIcon(51));
                break;
            }
            case 2: {
                this.name = NAME_RESET;
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_RESET));
                this.putValue("SmallIcon", this.icons.getIcon(64));
                break;
            }
            case 3: {
                this.name = NAME_SET_MIN_MAX;
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_SET_MIN_MAX));
                this.putValue("SmallIcon", this.icons.getIcon(65));
                break;
            }
            case 6: {
                this.name = NAME_SET_ABSOLUTE_MIN_MAX;
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_SET_ABSOLUTE_MIN_MAX));
                this.putValue("SmallIcon", this.icons.getIcon(65));
                break;
            }
            case 4: {
                this.name = NAME_SET_OWNER;
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_SET_OWNER));
                this.putValue("SmallIcon", this.icons.getIcon(66));
                break;
            }
            case 5: {
                this.name = NAME_UNDO;
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_UNDO));
                this.putValue("SmallIcon", this.icons.getIcon(67));
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not supported.");
            }
        }
    }

    @Override
    protected void onStateChange(ChangeEvent e) {
        if (this.model.getState() == 6) {
            this.onTabSelection();
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    protected void onTabSelection() {
        if (this.model.getSelectedIndex() == 2) {
            this.setEnabled(false);
        } else {
            switch (this.index) {
                case 1: {
                    if (!this.model.hasSettingsToPaste()) {
                        this.setEnabled(false);
                        break;
                    }
                    this.setEnabled(this.model.canAnnotate());
                    break;
                }
                case 2: 
                case 3: {
                    this.setEnabled(this.model.canAnnotate());
                    break;
                }
                case 4: {
                    if (this.model.isUserOwner()) {
                        this.setEnabled(false);
                        break;
                    }
                    this.setEnabled(this.model.canAnnotate());
                    break;
                }
                case 0: {
                    this.setEnabled(this.model.canAnnotate());
                }
            }
        }
    }

    public ManageRndSettingsAction(ImViewer model, int index) {
        super(model);
        this.checkIndex(index);
        this.index = index;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (this.index) {
            case 0: {
                this.model.copyRenderingSettings();
                break;
            }
            case 1: {
                this.model.pasteRenderingSettings();
                break;
            }
            case 2: {
                this.model.resetDefaultRndSettings();
                break;
            }
            case 3: {
                this.model.setRangeAllChannels(false);
                break;
            }
            case 6: {
                this.model.setRangeAllChannels(true);
                break;
            }
            case 4: {
                this.model.setOwnerSettings();
            }
        }
    }
}

