/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.actions;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.actions.ViewerAction;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ROIToolAction
extends ViewerAction
implements MouseListener {
    private static final String NAME = "ROI Tool...";
    private static final String DESCRIPTION = "Bring up the ROI tool.";
    private Point point;
    private boolean pressed;

    @Override
    protected void onTabSelection() {
        if (ImViewerAgent.isRunAsPlugin()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(this.model.getSelectedIndex() != 2);
        }
    }

    @Override
    protected void onStateChange(ChangeEvent e) {
        if (this.model.getState() == 6) {
            this.onTabSelection();
        } else {
            this.setEnabled(false);
        }
    }

    public ROIToolAction(ImViewer model) {
        super(model, NAME);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager icons = IconManager.getInstance();
        this.putValue("SmallIcon", icons.getIcon(37));
        if (ImViewerAgent.isRunAsPlugin()) {
            this.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isEnabled() && !this.pressed) {
            this.model.showMeasurementTool(this.point);
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.pressed = true;
        this.point = me.getPoint();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.pressed = false;
        Object source = me.getSource();
        if (this.point == null) {
            this.point = me.getPoint();
        }
        if (source instanceof Component && this.isEnabled()) {
            SwingUtilities.convertPointToScreen(this.point, (Component)source);
            this.model.showMeasurementTool(this.point);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

