/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.util.saver;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.apache.commons.io.FileUtils;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.util.ImagePaintingFactory;
import org.openmicroscopy.shoola.agents.imviewer.util.saver.ImgSaverPreviewer;
import org.openmicroscopy.shoola.agents.imviewer.util.saver.ImgSaverUI;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.image.io.EncoderException;
import org.openmicroscopy.shoola.util.image.io.TIFFEncoder;
import org.openmicroscopy.shoola.util.image.io.WriterImage;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.NotificationDialog;
import org.openmicroscopy.shoola.util.ui.RegExFactory;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ImgSaver
extends JDialog {
    public static final String SAVE_IMAGE_PROPERTY = "saveImage";
    public static final int IMAGE = 0;
    public static final int GRID_IMAGE = 1;
    public static final int PROJECTED_IMAGE = 2;
    public static final int IMAGE_AND_COMPONENTS = 3;
    public static final int IMAGE_AND_COMPONENTS_GREY = 4;
    static final int LENS_IMAGE = 4;
    static final int LENS_IMAGE_AND_COMPONENTS = 5;
    static final int LENS_IMAGE_AND_COMPONENTS_GREY = 6;
    public static final int FULL = 0;
    public static final int PARTIAL = 1;
    public static final int BASIC = 2;
    static final String TITLE = "Save Image";
    static final String PREVIEW_TITLE = "Preview image to save.";
    static final int PREVIEW = 0;
    static final int DIRECT = 1;
    private static final String MESSAGE = "A file with the same name and \nextension already exists in this directory.\nDo you really want to save the image?";
    private ImViewer model;
    private ImgSaverUI uiDelegate;
    private String format;
    private BufferedImage mainImage;
    private List imageComponents;
    private int imageType;
    private int savingType;

    private void notifySave(String name) {
        NotificationDialog dialog = new NotificationDialog((JDialog)this, TITLE, this.getSaveMessage(name), true);
        dialog.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("hyperlinkOpen".equals(evt.getPropertyName())) {
                    UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
                    un.openApplication(null, (String)evt.getNewValue());
                }
            }
        });
        dialog.pack();
        UIUtilities.centerAndShow(dialog);
    }

    private String getSaveMessage(String name) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html><body>");
        buffer.append("<p>The image has been saved successfully.<br>");
        buffer.append("<a href=\"");
        buffer.append(name);
        buffer.append("\">View Image</a>.");
        buffer.append("</body><html>");
        return buffer.toString();
    }

    private void writeSingleImage(BufferedImage image, boolean constraint, String name) throws EncoderException, IOException {
        int width = image.getWidth();
        int h = image.getHeight();
        String v = this.getUnitBarValue();
        int s = (int)this.model.getUnitBarSize();
        BufferedImage newImage = new BufferedImage(width, h, 1);
        Graphics2D g2 = (Graphics2D)newImage.getGraphics();
        ImagePaintingFactory.setGraphicRenderingSettings(g2);
        g2.drawImage(image, null, 0, 0);
        if (constraint) {
            ImagePaintingFactory.paintScaleBar(g2, width - s - 10, h - 10, s, v);
        }
        this.writeImage(newImage, name);
    }

    private void createImages(int savingType) {
        boolean b = this.uiDelegate.includeROI();
        switch (savingType) {
            default: {
                this.imageType = 0;
                this.mainImage = this.model.getDisplayedImage(b);
                this.imageComponents = null;
                break;
            }
            case 1: {
                this.imageType = 1;
                this.mainImage = this.model.getGridImage();
                this.imageComponents = null;
                break;
            }
            case 2: {
                this.imageType = 2;
                this.mainImage = this.model.getDisplayedProjectedImage();
                this.imageComponents = null;
                break;
            }
            case 3: {
                this.imageType = 3;
                this.mainImage = this.model.getDisplayedImage(b);
                this.imageComponents = this.model.getImageComponents("rgb", b);
                break;
            }
            case 4: {
                this.imageType = 3;
                this.mainImage = this.model.getDisplayedImage(b);
                this.imageComponents = this.model.getImageComponents("greyscale", b);
                break;
            }
            case 5: {
                this.imageType = 5;
                this.mainImage = this.model.getZoomedLensImage();
                this.imageComponents = null;
                break;
            }
            case 6: {
                this.imageType = 6;
                this.mainImage = this.model.getZoomedLensImage();
                this.imageComponents = this.model.getLensImageComponents("rgb");
                break;
            }
            case 7: {
                this.imageType = 6;
                this.mainImage = this.model.getZoomedLensImage();
                this.imageComponents = this.model.getLensImageComponents("greyscale");
            }
        }
    }

    private void writeImage(BufferedImage image, String n) throws EncoderException, IOException {
        String extendedName = this.getExtendedName(n, this.format);
        File f = new File(extendedName);
        if ("tif".equals(this.format)) {
            TIFFEncoder encoder = new TIFFEncoder(Factory.createImage(image), new DataOutputStream(new FileOutputStream(f)));
            WriterImage.saveImage(encoder);
        } else {
            WriterImage.saveImage(f, image, this.format);
        }
        this.close();
    }

    private void setProperties() {
        this.setTitle(TITLE);
        this.setModal(true);
    }

    private void checkSavingType(int t) {
        switch (t) {
            case 1: {
                this.savingType = t;
                break;
            }
            default: {
                this.savingType = t;
            }
        }
    }

    public ImgSaver(JFrame owner, ImViewer model, int savingType, int defaultType, boolean withROI) {
        super(owner);
        this.checkSavingType(savingType);
        this.model = model;
        this.setProperties();
        this.uiDelegate = new ImgSaverUI(this, defaultType, withROI);
        this.pack();
    }

    String getExtendedName(String name, String format) {
        String extension = "." + format;
        Pattern pattern = RegExFactory.createPattern(extension);
        String n = RegExFactory.find(pattern, name) ? name : (RegExFactory.find(pattern = RegExFactory.createCaseInsensitivePattern(extension), name) ? name : name + "." + format);
        return n;
    }

    String getPartialImageName() {
        return UIUtilities.removeFileExtension(this.model.getImageName());
    }

    int getSavingType() {
        return this.savingType;
    }

    int getImageType() {
        return this.imageType;
    }

    void setFileFormat(String format) {
        this.format = format;
    }

    void previewImage() {
        ImgSaverPreviewer preview = new ImgSaverPreviewer(this);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.createImages(this.uiDelegate.getSavingType());
        this.setCursor(Cursor.getPredefinedCursor(0));
        preview.initialize();
        UIUtilities.centerAndShow(preview);
    }

    void setSelection(int index) {
        MessageBox dialog = new MessageBox(this, TITLE, MESSAGE);
        dialog.pack();
        Dimension d = dialog.getPreferredSize();
        dialog.setSize(d.width, d.height + 30);
        if (dialog.centerMsgBox() == 1) {
            dialog.setVisible(false);
            switch (index) {
                case 1: {
                    this.saveImage(true);
                    break;
                }
                case 0: {
                    this.previewImage();
                }
            }
            dialog.dispose();
        }
    }

    void close() {
        this.setVisible(false);
        this.dispose();
    }

    void saveImage(boolean init) {
        UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
        if (init) {
            this.createImages(this.uiDelegate.getSavingType());
        }
        boolean unitBar = this.model.isUnitBar();
        String v = this.getUnitBarValue();
        int s = (int)this.getUnitBarSize();
        try {
            String name = this.uiDelegate.getSelectedFilePath();
            FileUtils.forceMkdir((File)new File(name).getParentFile());
            if (this.imageComponents == null) {
                boolean constrain = unitBar && v != null && s < this.mainImage.getWidth() && this.imageType == 0;
                this.writeSingleImage(this.mainImage, constrain, name);
            } else {
                if (this.mainImage == null) {
                    return;
                }
                if (this.uiDelegate.isSaveImagesInSeparatedFiles()) {
                    boolean constrain = unitBar && v != null && s < this.mainImage.getWidth() && this.imageType == 0;
                    this.writeSingleImage(this.mainImage, constrain, name);
                    Iterator i = this.imageComponents.iterator();
                    int j = 0;
                    while (i.hasNext()) {
                        constrain = unitBar && v != null && this.imageType != 6;
                        this.writeSingleImage((BufferedImage)i.next(), constrain, name + "_" + j);
                        ++j;
                    }
                } else {
                    int width = this.mainImage.getWidth();
                    int h = this.mainImage.getHeight();
                    int n = this.imageComponents.size();
                    int w = width * (n + 1) + 10 * (n - 1);
                    BufferedImage newImage = new BufferedImage(w, h, 1);
                    Graphics2D g2 = (Graphics2D)newImage.getGraphics();
                    g2.setColor(Color.WHITE);
                    ImagePaintingFactory.setGraphicRenderingSettings(g2);
                    Iterator i = this.imageComponents.iterator();
                    int x = 0;
                    while (i.hasNext()) {
                        g2.drawImage((BufferedImage)i.next(), null, x, 0);
                        if (unitBar && v != null && this.imageType != 6) {
                            ImagePaintingFactory.paintScaleBar(g2, x + width - s - 10, h - 10, s, v);
                        }
                        g2.fillRect(x += width, 0, 10, h);
                        x += 10;
                    }
                    g2.drawImage(this.mainImage, null, x, 0);
                    if (unitBar && v != null && this.imageType != 6 && this.imageType != 5) {
                        ImagePaintingFactory.paintScaleBar(g2, x + width - s - 10, h - 10, s, v);
                    }
                    this.writeImage(newImage, name);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof IOException || e.getCause() instanceof IOException) {
                un.notifyInfo("Save Image failure", "Could not access file " + this.uiDelegate.getSelectedFilePath() + "\nMake sure you have the necessary permissions to perform this action.");
            } else {
                un.notifyError("Save Image failure", "An error occurred while saving the image.", e);
            }
            return;
        }
        this.notifySave(this.getExtendedName(this.uiDelegate.getSelectedFilePath(), this.format));
        if (this.uiDelegate.isSetDefaultFolder()) {
            UIUtilities.setDefaultFolder(this.uiDelegate.getCurrentDirectory());
        }
    }

    BufferedImage getImage() {
        return this.mainImage;
    }

    List getImageComponents() {
        return this.imageComponents;
    }

    boolean isUnitBar() {
        return this.model.isUnitBar();
    }

    String getUnitBarValue() {
        return this.model.getUnitBarValue();
    }

    double getUnitBarSize() {
        return this.model.getUnitBarSize();
    }

    Color getUnitBarColor() {
        return this.model.getUnitBarColor();
    }
}

