/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.view;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import omero.gateway.model.ChannelData;
import org.jdesktop.swingx.JXBusyLabel;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.actions.ColorPickerAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ViewerAction;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerControl;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerModel;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerUI;
import org.openmicroscopy.shoola.agents.util.ui.ChannelButton;
import org.openmicroscopy.shoola.env.data.model.ProjectionParam;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.colourpicker.LookupTableIconUtil;
import org.openmicroscopy.shoola.util.ui.slider.OneKnobSlider;
import org.openmicroscopy.shoola.util.ui.slider.TwoKnobsSlider;

class ControlPane
extends JPanel
implements ActionListener,
ChangeListener,
MouseWheelListener,
PropertyChangeListener {
    private static final int T = 0;
    private static final int Z = 1;
    private static final int BIN = 2;
    private static final Dimension DIMENSION = new Dimension(16, 16);
    private static final String Z_SLIDER_DESCRIPTION = "Select a z-section.";
    private static final String T_SLIDER_DESCRIPTION = "Select a timepoint.";
    private static final String LITEIME_SLIDER_DESCRIPTION = "Select a bin.";
    private static final String RATIO_SLIDER_DESCRIPTION = "Select the magnification factor of an image composing the grid.";
    private static final String ZOOM_SLIDER_DESCRIPTION = "Select the magnification factor of the image.";
    private static final String PROJECTION_SLIDER_DESCRIPTION = "Select the interval of z-sections to project.";
    private static final String Z_SLIDER_TIPSTRING = "Z";
    private static final String T_SLIDER_TIPSTRING = "T";
    private static final int SLIDER_HEIGHT = 100;
    private static final int FREQUENCY = 0;
    private static final int TYPE = 1;
    private static final String PROJECTION_DESCRIPTION = "Select the type of projection.";
    private static final int MAX_NO_TICKS = 10;
    private static final Dimension VBOX = new Dimension(1, 10);
    private ImViewerControl controller;
    private ImViewerModel model;
    private ImViewerUI view;
    private OneKnobSlider lifetimeSlider;
    private OneKnobSlider lifetimeSliderGrid;
    private OneKnobSlider zSlider;
    private OneKnobSlider tSlider;
    private OneKnobSlider zSliderGrid;
    private OneKnobSlider tSliderGrid;
    private OneKnobSlider tSliderProjection;
    private TwoKnobsSlider projectionRange;
    private OneKnobSlider gridRatioSlider;
    private OneKnobSlider ratioSlider;
    private OneKnobSlider projectionRatioSlider;
    private List<ChannelButton> channelButtons;
    private List<ChannelButton> channelButtonsGrid;
    private List<ChannelButton> channelButtonsProjection;
    private List<ChannelButton> overlayButtons;
    private JButton channelMovieButton;
    private JButton colorModelButton;
    private JButton colorModelButtonGrid;
    private JButton colorModelButtonProjection;
    private JButton colorPickerButton;
    private JToggleButton textVisibleButton;
    private JButton playTMovie;
    private JButton playLifetimeMovie;
    private JButton playLifetimeMovieGrid;
    private JButton playTMovieGrid;
    private JButton playZMovie;
    private JButton playZMovieGrid;
    private JButton projectionProject;
    private JComboBox projectionTypesBox;
    private Map<Integer, Integer> projectionTypes;
    private JSpinner projectionFrequency;
    private JXBusyLabel gridImageLabel;
    private IconManager icons;
    private JPanel controls;
    private JCheckBox overlays;
    private ActionListener overlaysListener;
    private JButton resetZoom;

    private void setSelectedXYPlane(int z, int t) {
        int bin = -1;
        if (this.model.isLifetimeImage()) {
            bin = this.lifetimeSlider.getValue();
        }
        this.controller.setSelectedXYPlane(z, t, bin);
    }

    private void mouseWheelMovedZ(MouseWheelEvent e) {
        boolean up = true;
        if (e.getWheelRotation() > 0) {
            up = false;
        }
        if (e.getScrollType() == 0) {
            int v = this.model.getDefaultZ() - e.getWheelRotation();
            if (up) {
                if (v <= this.model.getMaxZ()) {
                    this.setSelectedXYPlane(v, this.model.getRealSelectedT());
                }
            } else if (v >= 0) {
                this.setSelectedXYPlane(v, this.model.getRealSelectedT());
            }
        }
    }

    private void mouseWheelMovedT(MouseWheelEvent e) {
        boolean up = true;
        if (e.getWheelRotation() > 0) {
            up = false;
        }
        if (e.getScrollType() == 0) {
            int v = this.model.getRealSelectedT() - e.getWheelRotation();
            if (up) {
                if (v <= this.model.getRealT()) {
                    this.setSelectedXYPlane(this.model.getDefaultZ(), v);
                }
            } else if (v >= 0) {
                this.setSelectedXYPlane(this.model.getDefaultZ(), v);
            }
        }
    }

    private void mouseWheelMovedLifetime(MouseWheelEvent e) {
        boolean up = true;
        if (e.getWheelRotation() > 0) {
            up = false;
        }
        if (e.getScrollType() == 0) {
            int v = this.model.getRealSelectedT() - e.getWheelRotation();
            if (up) {
                if (v <= this.model.getMaxLifetimeBin()) {
                    this.setSelectedXYPlane(this.model.getDefaultZ(), this.model.getDefaultT());
                }
            } else if (v >= 0) {
                this.setSelectedXYPlane(this.model.getDefaultZ(), this.model.getDefaultT());
            }
        }
    }

    private String getColorModelDescription(String model) {
        if ("greyscale".equals(model)) {
            return "Switch between color and monochrome.";
        }
        if ("rgb".equals(model)) {
            return "Switch between color and monochrome.";
        }
        return null;
    }

    private Icon getColorModelIcon(String model) {
        if ("greyscale".equals(model)) {
            return this.icons.getIcon(23);
        }
        if ("rgb".equals(model)) {
            return this.icons.getIcon(24);
        }
        return null;
    }

    private String getColorModelFromIcon(JButton button) {
        if (button == null) {
            return null;
        }
        Icon icon = button.getIcon();
        if (this.icons.getIcon(23).equals(icon)) {
            return "greyscale";
        }
        return "rgb";
    }

    private void initComponents() {
        this.channelButtons = new ArrayList<ChannelButton>();
        this.channelButtonsGrid = new ArrayList<ChannelButton>();
        this.channelButtonsProjection = new ArrayList<ChannelButton>();
        this.projectionRange = new TwoKnobsSlider(0.0, 1.0, 0.0, 1.0);
        this.projectionRange.setOrientation(101);
        this.projectionRange.setEnabled(false);
        this.projectionRange.setToolTipText(PROJECTION_SLIDER_DESCRIPTION);
        this.zSlider = new OneKnobSlider(1, 0, 1, 0);
        this.zSlider.setEnabled(false);
        this.tSlider = new OneKnobSlider(0, 0, 1, 0);
        this.tSlider.setEnabled(false);
        this.zSliderGrid = new OneKnobSlider(1, 0, 1, 0);
        this.zSliderGrid.setEnabled(false);
        this.tSliderGrid = new OneKnobSlider(0, 0, 1, 0);
        this.tSliderGrid.setEnabled(false);
        this.tSliderProjection = new OneKnobSlider(0, 0, 1, 0);
        this.tSliderProjection.setEnabled(false);
        this.lifetimeSlider = new OneKnobSlider(0, 0, 1, 0);
        this.lifetimeSlider.setEnabled(false);
        this.lifetimeSliderGrid = new OneKnobSlider(0, 0, 1, 0);
        this.lifetimeSliderGrid.setEnabled(false);
        IconManager icons = IconManager.getInstance();
        this.gridRatioSlider = new OneKnobSlider(1, 1, 10, 5);
        this.gridRatioSlider.setEnabled(true);
        this.gridRatioSlider.setShowArrows(true);
        this.gridRatioSlider.setToolTipText(RATIO_SLIDER_DESCRIPTION);
        this.gridRatioSlider.setArrowsImageIcon(icons.getImageIcon(49), icons.getImageIcon(48));
        this.ratioSlider = new OneKnobSlider(1, 0, 11, 3);
        this.ratioSlider.setEnabled(true);
        this.ratioSlider.setShowArrows(true);
        this.ratioSlider.setToolTipText(ZOOM_SLIDER_DESCRIPTION);
        this.ratioSlider.setArrowsImageIcon(icons.getImageIcon(49), icons.getImageIcon(48), icons.getImageIcon(71), icons.getImageIcon(70));
        this.resetZoom = new JButton(icons.getImageIcon(40));
        this.resetZoom.setVisible(false);
        UIUtilities.unifiedButtonLookAndFeel(this.resetZoom);
        this.projectionRatioSlider = new OneKnobSlider(1, 0, 11, 3);
        this.projectionRatioSlider.setEnabled(true);
        this.projectionRatioSlider.setShowArrows(true);
        this.projectionRatioSlider.setToolTipText(ZOOM_SLIDER_DESCRIPTION);
        this.projectionRatioSlider.setArrowsImageIcon(icons.getImageIcon(49), icons.getImageIcon(48));
        this.channelMovieButton = new JButton(this.controller.getAction(ImViewerControl.CHANNEL_MOVIE));
        UIUtilities.unifiedButtonLookAndFeel(this.channelMovieButton);
        this.colorModelButton = new JButton();
        UIUtilities.unifiedButtonLookAndFeel(this.colorModelButton);
        this.colorModelButton.addActionListener(this.controller);
        this.colorModelButtonGrid = new JButton();
        UIUtilities.unifiedButtonLookAndFeel(this.colorModelButtonGrid);
        this.colorModelButtonGrid.addActionListener(this.controller);
        this.colorModelButtonProjection = new JButton();
        UIUtilities.unifiedButtonLookAndFeel(this.colorModelButtonProjection);
        this.colorModelButtonProjection.addActionListener(this.controller);
        ViewerAction a = this.controller.getAction(ImViewerControl.COLOR_PICKER);
        this.colorPickerButton = new JButton(a);
        this.colorPickerButton.addMouseListener((ColorPickerAction)a);
        UIUtilities.unifiedButtonLookAndFeel(this.colorPickerButton);
        this.textVisibleButton = new JToggleButton();
        this.textVisibleButton.setSelected(this.model.isTextVisible());
        this.textVisibleButton.setAction(this.controller.getAction(ImViewerControl.TEXT_VISIBLE));
        this.playTMovie = new JButton(this.controller.getAction(ImViewerControl.PLAY_MOVIE_T));
        UIUtilities.unifiedButtonLookAndFeel(this.playTMovie);
        this.playTMovieGrid = new JButton(this.controller.getAction(ImViewerControl.PLAY_MOVIE_T));
        UIUtilities.unifiedButtonLookAndFeel(this.playTMovieGrid);
        this.playZMovie = new JButton(this.controller.getAction(ImViewerControl.PLAY_MOVIE_Z));
        UIUtilities.unifiedButtonLookAndFeel(this.playZMovie);
        this.playZMovieGrid = new JButton(this.controller.getAction(ImViewerControl.PLAY_MOVIE_Z));
        UIUtilities.unifiedButtonLookAndFeel(this.playZMovieGrid);
        this.projectionProject = new JButton(this.controller.getAction(ImViewerControl.PROJECTION_PROJECT));
        this.projectionFrequency = new JSpinner(new SpinnerNumberModel(1, 1, 1, 1));
        JComponent comp = this.projectionFrequency.getEditor();
        if (comp instanceof JSpinner.NumberEditor) {
            JFormattedTextField field = ((JSpinner.NumberEditor)comp).getTextField();
            field.addActionListener(this);
            field.setActionCommand("0");
        }
        String[] names = new String[ProjectionParam.PROJECTIONS.size()];
        int index = 0;
        Iterator<Map.Entry<Integer, String>> i = ProjectionParam.PROJECTIONS.entrySet().iterator();
        this.projectionTypes = new HashMap<Integer, Integer>();
        while (i.hasNext()) {
            Map.Entry<Integer, String> entry = i.next();
            int j = entry.getKey();
            this.projectionTypes.put(index, j);
            names[index] = entry.getValue();
            ++index;
        }
        this.projectionTypesBox = new JComboBox<String>(names);
        this.projectionTypesBox.setBackground(this.getBackground());
        this.projectionTypesBox.setToolTipText(PROJECTION_DESCRIPTION);
        this.projectionTypesBox.setActionCommand("1");
        this.projectionTypesBox.addActionListener(this);
        this.playLifetimeMovie = new JButton(this.controller.getAction(ImViewerControl.PLAY_LIFETIME_MOVIE));
        UIUtilities.unifiedButtonLookAndFeel(this.playLifetimeMovie);
        this.playLifetimeMovieGrid = new JButton(this.controller.getAction(ImViewerControl.PLAY_LIFETIME_MOVIE));
        UIUtilities.unifiedButtonLookAndFeel(this.playLifetimeMovieGrid);
        Icon icon = this.textVisibleButton.getIcon();
        Dimension d = DIMENSION;
        if (icon != null) {
            d = new Dimension(icon.getIconWidth(), icon.getIconHeight());
        }
        this.gridImageLabel = new JXBusyLabel(d);
        this.gridImageLabel.setVisible(false);
        this.controls = new JPanel();
        double[][] size = new double[][]{{-2.0}, {-2.0, -2.0, -2.0, -2.0, 100.0, -2.0, -2.0}};
        this.controls.setLayout(new TableLayout(size));
    }

    private void initSlider(OneKnobSlider slider, int max, int v, String toolTip, String endLabel) {
        slider.setVisible(max != 0);
        slider.setMaximum(max);
        slider.setValue(v);
        slider.addChangeListener(this);
        slider.addMouseWheelListener(this);
        slider.setToolTipText(toolTip);
        slider.setEndLabel(endLabel);
        slider.setShowEndLabel(true);
        slider.setShowTipLabel(true);
        if (max > 1 && max <= 10) {
            slider.setPaintTicks(true);
            slider.setMajorTickSpacing(1);
        }
    }

    private void setSliderToolTip(int v, OneKnobSlider slider, int index) {
        String tip = "";
        switch (index) {
            case 0: {
                tip = "T=" + (v + 1) + "/" + this.model.getRealT();
                break;
            }
            case 1: {
                tip = "Z=" + (v + 1) + "/" + (this.model.getMaxZ() + 1);
                break;
            }
            case 2: {
                tip = "t=" + (v + 1) + "/" + this.model.getMaxLifetimeBin();
            }
        }
        slider.setToolTipText(tip);
    }

    private void initializeValues() {
        int maxZ = this.model.getMaxZ();
        int maxT = this.model.getRealT();
        this.projectionRange.setValues(maxZ + 1, 1.0, maxZ + 1, 1.0, 1.0, maxZ + 1);
        this.projectionRange.addPropertyChangeListener(this);
        this.projectionRange.addMouseWheelListener(this);
        this.projectionRange.setToolTipText(PROJECTION_SLIDER_DESCRIPTION);
        this.setRangeSliderToolTip(0, maxZ);
        this.initSlider(this.tSliderProjection, maxT - 1, this.model.getRealSelectedT(), T_SLIDER_DESCRIPTION, T_SLIDER_TIPSTRING);
        this.setSliderToolTip(this.model.getRealSelectedT(), this.tSliderProjection, 0);
        this.initSlider(this.zSlider, maxZ, this.model.getDefaultZ(), Z_SLIDER_DESCRIPTION, Z_SLIDER_TIPSTRING);
        this.initSlider(this.zSliderGrid, maxZ, this.model.getDefaultZ(), Z_SLIDER_DESCRIPTION, Z_SLIDER_TIPSTRING);
        this.setSliderToolTip(this.model.getDefaultZ(), this.zSlider, 1);
        this.setSliderToolTip(this.model.getDefaultZ(), this.zSliderGrid, 1);
        this.initSlider(this.tSlider, maxT - 1, this.model.getRealSelectedT(), T_SLIDER_DESCRIPTION, T_SLIDER_TIPSTRING);
        this.initSlider(this.tSliderGrid, maxT - 1, this.model.getRealSelectedT(), T_SLIDER_DESCRIPTION, T_SLIDER_TIPSTRING);
        this.setSliderToolTip(this.model.getRealSelectedT(), this.tSlider, 0);
        this.setSliderToolTip(this.model.getRealSelectedT(), this.tSliderGrid, 0);
        if (this.model.isBigImage()) {
            this.ratioSlider.addPropertyChangeListener(this);
            this.ratioSlider.setMaximum(this.model.getResolutionLevels() - 1);
            this.ratioSlider.setValue(this.model.getSelectedResolutionLevel());
            this.resetZoom.addActionListener(this.controller.getZoomActionFromLevels(this.model.getResolutionLevels() - 1));
            this.resetZoom.setToolTipText("Reset to full size.");
            this.resetZoom.setText("");
        }
        this.ratioSlider.addChangeListener(this);
        this.gridRatioSlider.addChangeListener(this);
        this.projectionRatioSlider.addChangeListener(this);
        this.playTMovie.setVisible(maxT > 1);
        this.playTMovieGrid.setVisible(maxT > 1);
        this.playZMovie.setVisible(maxZ != 0);
        this.playZMovieGrid.setVisible(maxZ != 0);
        this.colorModelButton.setIcon(this.getColorModelIcon(this.model.getColorModel()));
        this.colorModelButton.setToolTipText(this.getColorModelDescription(this.model.getColorModel()));
        this.colorModelButtonGrid.setIcon(this.getColorModelIcon(this.model.getColorModel()));
        this.colorModelButtonGrid.setToolTipText(this.getColorModelDescription(this.model.getColorModel()));
        this.colorModelButtonProjection.setIcon(this.getColorModelIcon(this.model.getColorModel()));
        this.colorModelButtonProjection.setToolTipText(this.getColorModelDescription(this.model.getColorModel()));
        SpinnerNumberModel m = (SpinnerNumberModel)this.projectionFrequency.getModel();
        m.setMaximum(Integer.valueOf(this.view.getMaxZ() + 1));
        this.projectionFrequency.addChangeListener(this);
        int maxBin = this.model.getMaxLifetimeBin();
        this.initSlider(this.lifetimeSlider, maxBin - 1, this.model.getSelectedBin(), LITEIME_SLIDER_DESCRIPTION, "t");
        this.setSliderToolTip(this.model.getSelectedBin(), this.lifetimeSlider, 2);
        this.lifetimeSlider.setPaintTicks(false);
        this.initSlider(this.lifetimeSliderGrid, maxBin - 1, this.model.getSelectedBin(), LITEIME_SLIDER_DESCRIPTION, "t");
        this.setSliderToolTip(this.model.getSelectedBin(), this.lifetimeSliderGrid, 2);
        this.playLifetimeMovie.setVisible(maxBin > 1);
        this.playLifetimeMovie.setEnabled(maxBin > 1);
        this.playLifetimeMovieGrid.setVisible(maxBin > 1);
        this.playLifetimeMovieGrid.setEnabled(maxBin > 1);
        if (this.model.isBigImage()) {
            this.resetZoom.setVisible(true);
        }
    }

    private JPanel layoutSlider(JComponent slider) {
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 1));
        pane.add(slider);
        return pane;
    }

    private JToolBar createButtonToolBar(JComponent button) {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        bar.add(button);
        return bar;
    }

    private JPanel createZSliderPane() {
        JPanel pane = new JPanel();
        double[][] tl = new double[][]{{-1.0}, {-1.0, -2.0}};
        pane.setLayout(new TableLayout(tl));
        pane.add((Component)this.zSlider, "0, 0");
        pane.add((Component)this.createButtonToolBar(this.playZMovie), "0, 1");
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(pane);
        return p;
    }

    private JPanel createZGridSliderPane() {
        JPanel pane = new JPanel();
        double[][] tl = new double[][]{{-1.0}, {-1.0, -2.0}};
        pane.setLayout(new TableLayout(tl));
        pane.add((Component)this.zSliderGrid, "0, 0");
        pane.add((Component)this.createButtonToolBar(this.playZMovieGrid), "0, 1");
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(pane);
        return p;
    }

    private JComponent buildToolBar() {
        if (!this.model.isLifetimeImage() || this.model.getModuloT() != null) {
            JToolBar bar = this.createBar();
            bar.add(this.colorModelButton);
            bar.add(Box.createRigidArea(VBOX));
            bar.add(this.colorPickerButton);
            return bar;
        }
        return this.colorModelButton;
    }

    private JToolBar buildGridBar() {
        JToolBar bar = this.createBar();
        bar.add((Component)this.gridImageLabel);
        bar.add(Box.createRigidArea(VBOX));
        bar.add(this.colorModelButtonGrid);
        return bar;
    }

    private JToolBar createBar() {
        JToolBar bar = new JToolBar(1);
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        return bar;
    }

    private JToolBar buildProjectionBar() {
        JToolBar bar = new JToolBar(1);
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        bar.add(this.colorModelButtonProjection);
        return bar;
    }

    private JPanel createChannelsPane() {
        Dimension d;
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        int w = 0;
        int h = 0;
        if (!this.model.isLifetimeImage() || this.model.getModuloT() != null) {
            p.add(Box.createRigidArea(VBOX));
            this.channelButtons = this.createChannelButtons();
            for (ChannelButton button : this.channelButtons) {
                d = button.getPreferredSize();
                if (d.width > w) {
                    w = d.width;
                }
                if (d.height > h) {
                    h = d.height;
                }
                button.addPropertyChangeListener(this.controller);
                p.add(button);
                p.add(Box.createRigidArea(VBOX));
            }
        }
        this.controls.add(Box.createVerticalStrut(20), "0, 0");
        int k = 1;
        this.controls.add((Component)this.buildToolBar(), "0, " + k + ", CENTER, CENTER");
        ++k;
        if (this.channelButtons.size() > 100) {
            JScrollPane sp = new JScrollPane(p);
            d = new Dimension(2 * w, h * 100);
            sp.setPreferredSize(d);
            this.controls.add((Component)sp, "0, " + k + ", RIGHT, CENTER");
        } else {
            this.controls.add((Component)p, "0, " + k);
        }
        ++k;
        if (!this.model.isLifetimeImage() || this.model.getModuloT() != null) {
            this.controls.add((Component)this.createButtonToolBar(this.channelMovieButton), "0, " + k + ", CENTER, CENTER");
        }
        this.controls.add((Component)this.ratioSlider, "0, " + ++k + ", CENTER, CENTER");
        this.controls.add((Component)this.resetZoom, "0, " + ++k + ", CENTER, CENTER");
        return UIUtilities.buildComponentPanel(this.controls);
    }

    private void buildGUI() {
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.createChannelsPane());
        this.add(this.createZSliderPane());
    }

    private void updateSlider(JSlider slider, int v) {
        slider.removeChangeListener(this);
        slider.setValue(v);
        slider.addChangeListener(this);
    }

    private void setSliderMax(JSlider slider, int max) {
        slider.removeChangeListener(this);
        slider.setMaximum(max);
        slider.addChangeListener(this);
    }

    ControlPane(ImViewerControl controller, ImViewerModel model, ImViewerUI view) {
        if (controller == null) {
            throw new NullPointerException("No control.");
        }
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.controller = controller;
        this.model = model;
        this.view = view;
        this.icons = IconManager.getInstance();
        this.initComponents();
    }

    List<ChannelButton> createChannelButtons() {
        ArrayList<ChannelButton> channelButtons = new ArrayList<ChannelButton>();
        List<ChannelData> data = this.model.getChannelData();
        Dimension dimMax = ChannelButton.DEFAULT_MIN_SIZE;
        for (ChannelData d : data) {
            int k = d.getIndex();
            boolean lut = CommonsLangUtils.isNotEmpty(this.model.getLookupTable(k));
            ChannelButton button = lut ? new ChannelButton(d.getChannelLabeling(), LookupTableIconUtil.getLUTIconImage(this.model.getLookupTable(k)), k, this.model.isChannelActive(k)) : new ChannelButton(d.getChannelLabeling(), this.model.getChannelColor(k), k, this.model.isChannelActive(k));
            channelButtons.add(button);
            Dimension dim = button.getPreferredSize();
            if (dim.width <= dimMax.width) continue;
            dimMax = new Dimension(dim.width, dimMax.height);
        }
        Iterator j = channelButtons.iterator();
        while (j.hasNext()) {
            ((ChannelButton)j.next()).setPreferredSize(dimMax);
        }
        return channelButtons;
    }

    void buildComponent() {
        this.initializeValues();
        this.buildGUI();
    }

    JPanel buildGridComponent() {
        Dimension d;
        if (this.model.getModuloT() == null && this.model.isLifetimeImage()) {
            return new JPanel();
        }
        JPanel p = this.createZGridSliderPane();
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 1));
        buttons.add(Box.createRigidArea(VBOX));
        this.channelButtonsGrid = this.createChannelButtons();
        Iterator<ChannelButton> i = this.channelButtonsGrid.iterator();
        int w = 0;
        int h = 0;
        while (i.hasNext()) {
            ChannelButton button = i.next();
            d = button.getPreferredSize();
            if (d.width > w) {
                w = d.width;
            }
            if (d.height > h) {
                h = d.height;
            }
            buttons.add(button);
            buttons.add(Box.createRigidArea(VBOX));
            button.addPropertyChangeListener(this.controller);
        }
        JPanel controls = new JPanel();
        double[][] size = new double[][]{{-2.0}, {-2.0, -2.0, -2.0, -2.0, 100.0}};
        controls.setLayout(new TableLayout(size));
        controls.add(Box.createVerticalStrut(10), "0, 0");
        JToolBar bar = this.buildGridBar();
        bar.add(Box.createRigidArea(VBOX));
        controls.add((Component)bar, "0, 1, CENTER, CENTER");
        controls.add((Component)this.createButtonToolBar(this.textVisibleButton), "0, 2, CENTER, CENTER");
        if (this.channelButtonsGrid.size() > 100) {
            JScrollPane sp = new JScrollPane(buttons);
            d = new Dimension(2 * w, h * 100);
            sp.setPreferredSize(d);
            controls.add((Component)sp, "0, 3, RIGHT, CENTER");
        } else {
            controls.add((Component)buttons, "0, 3");
        }
        controls.add((Component)this.gridRatioSlider, "0, 4, CENTER, CENTER");
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 0));
        content.add(UIUtilities.buildComponentPanel(controls));
        content.add(p);
        return content;
    }

    JPanel buildProjectionToolBar() {
        JPanel bar = new JPanel();
        bar.setBorder(null);
        bar.add(new JLabel("Intensity: "));
        bar.add(this.projectionTypesBox);
        bar.add(new JLabel(" Every n-th slice: "));
        bar.add(this.projectionFrequency);
        bar.add(Box.createRigidArea(VBOX));
        bar.add(this.projectionProject);
        JPanel projectionBar = new JPanel();
        projectionBar.setLayout(new FlowLayout(0, 0, 0));
        projectionBar.add(bar);
        return projectionBar;
    }

    JPanel buildProjectionComponent() {
        Dimension d;
        if (this.model.getModuloT() == null && this.model.isLifetimeImage()) {
            return new JPanel();
        }
        JPanel p = this.layoutSlider(this.projectionRange);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 1));
        buttons.add(Box.createRigidArea(VBOX));
        this.channelButtonsProjection = this.createChannelButtons();
        Iterator<ChannelButton> i = this.channelButtonsProjection.iterator();
        int w = 0;
        int h = 0;
        while (i.hasNext()) {
            ChannelButton button = i.next();
            d = button.getPreferredSize();
            if (d.width > w) {
                w = d.width;
            }
            if (d.height > h) {
                h = d.height;
            }
            buttons.add(button);
            buttons.add(Box.createRigidArea(VBOX));
            button.addPropertyChangeListener(this.controller);
        }
        JPanel controls = new JPanel();
        double[][] size = new double[][]{{-2.0}, {-2.0, -2.0, -2.0, 100.0}};
        controls.setLayout(new TableLayout(size));
        controls.add(Box.createVerticalStrut(20), "0, 0");
        int k = 1;
        controls.add((Component)this.buildProjectionBar(), "0, " + k + ", CENTER, CENTER");
        ++k;
        if (this.channelButtonsProjection.size() > 100) {
            JScrollPane sp = new JScrollPane(buttons);
            d = new Dimension(2 * w, h * 100);
            sp.setPreferredSize(d);
            controls.add((Component)sp, "0, " + k + ", RIGHT, CENTER");
        } else {
            controls.add((Component)buttons, "0, " + k + ", CENTER, CENTER");
        }
        controls.add((Component)this.projectionRatioSlider, "0, " + ++k + ", CENTER, CENTER");
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 0));
        content.add(UIUtilities.buildComponentPanel(controls));
        content.add(p);
        return content;
    }

    void setTimepoint(int t) {
        this.setSliderToolTip(t, this.tSlider, 0);
        this.setSliderToolTip(t, this.tSliderGrid, 0);
        this.updateSlider(this.tSlider, t);
        this.updateSlider(this.tSliderGrid, t);
        this.updateSlider(this.tSliderProjection, t);
    }

    void setBin(int v) {
        if (this.lifetimeSlider == null) {
            return;
        }
        this.setSliderToolTip(v, this.lifetimeSlider, 2);
        this.updateSlider(this.lifetimeSlider, v);
        this.setSliderToolTip(v, this.lifetimeSliderGrid, 2);
        this.updateSlider(this.lifetimeSliderGrid, v);
    }

    void setZSection(int z) {
        this.setSliderToolTip(z, this.zSlider, 1);
        this.setSliderToolTip(z, this.zSliderGrid, 1);
        this.updateSlider(this.zSlider, z);
        this.updateSlider(this.zSliderGrid, z);
    }

    void setColorModel() {
        boolean gs = this.model.getColorModel().equals("greyscale");
        for (ChannelButton button : this.channelButtons) {
            button.setSelected(this.model.isChannelActive(button.getChannelIndex()));
        }
        for (ChannelButton button : this.channelButtonsGrid) {
            if (gs) continue;
            button.setSelected(this.model.isChannelActive(button.getChannelIndex()));
        }
        for (ChannelButton button : this.channelButtonsProjection) {
            button.setSelected(this.model.isChannelActive(button.getChannelIndex()));
        }
        this.colorModelButton.setIcon(this.getColorModelIcon(this.model.getColorModel()));
        this.colorModelButton.setToolTipText(this.getColorModelDescription(this.model.getColorModel()));
        this.colorModelButtonGrid.setIcon(this.getColorModelIcon(this.model.getColorModel()));
        this.colorModelButtonGrid.setToolTipText(this.getColorModelDescription(this.model.getColorModel()));
        this.colorModelButtonProjection.setIcon(this.getColorModelIcon(this.model.getColorModel()));
        this.colorModelButtonProjection.setToolTipText(this.getColorModelDescription(this.model.getColorModel()));
    }

    void setChannelsSelection(List channels) {
        for (ChannelButton button : this.channelButtonsGrid) {
            int index = button.getChannelIndex();
            button.setSelected(channels.contains(index));
        }
    }

    void setChannelsSelection(int index) {
        switch (index) {
            case 0: {
                for (ChannelButton button : this.channelButtonsGrid) {
                    button.setSelected(this.model.isChannelActive(button.getChannelIndex()));
                }
                break;
            }
            case 1: {
                for (ChannelButton button : this.channelButtons) {
                    button.setSelected(this.model.isChannelActive(button.getChannelIndex()));
                }
                break;
            }
            case 2: {
                for (ChannelButton button : this.channelButtonsProjection) {
                    button.setSelected(this.model.isChannelActive(button.getChannelIndex()));
                }
                break;
            }
            case 3: {
                for (ChannelButton button : this.channelButtons) {
                    button.setSelected(this.model.isChannelActive(button.getChannelIndex()));
                }
                for (ChannelButton button : this.channelButtonsGrid) {
                    button.setSelected(this.model.isChannelActive(button.getChannelIndex()));
                }
                for (ChannelButton button : this.channelButtonsProjection) {
                    button.setSelected(this.model.isChannelActive(button.getChannelIndex()));
                }
                break;
            }
        }
    }

    void setChannelColor(int index, Color c) {
        for (ChannelButton button : this.channelButtons) {
            if (index != button.getChannelIndex()) continue;
            button.setColor(c);
            button.setImage(null);
        }
        for (ChannelButton button : this.channelButtonsGrid) {
            if (index != button.getChannelIndex()) continue;
            button.setColor(c);
            button.setImage(null);
        }
        for (ChannelButton button : this.channelButtonsProjection) {
            if (index != button.getChannelIndex()) continue;
            button.setColor(c);
            button.setImage(null);
        }
    }

    void setLookupTable(int index, String lut) {
        BufferedImage img = LookupTableIconUtil.getLUTIconImage(lut);
        for (ChannelButton button : this.channelButtons) {
            if (index != button.getChannelIndex()) continue;
            button.setImage(img);
        }
        for (ChannelButton button : this.channelButtonsGrid) {
            if (index != button.getChannelIndex()) continue;
            button.setImage(img);
        }
        for (ChannelButton button : this.channelButtonsProjection) {
            if (index != button.getChannelIndex()) continue;
            button.setImage(img);
        }
    }

    void resetRndSettings() {
        boolean lut;
        int index;
        for (ChannelButton button : this.channelButtons) {
            index = button.getChannelIndex();
            lut = CommonsLangUtils.isNotEmpty(this.model.getLookupTable(index));
            button.setSelected(this.model.isChannelActive(index));
            if (lut) {
                button.setImage(LookupTableIconUtil.getLUTIconImage(this.model.getLookupTable(index)));
                continue;
            }
            button.setColor(this.model.getChannelColor(index));
            button.setImage(null);
        }
        for (ChannelButton button : this.channelButtonsGrid) {
            index = button.getChannelIndex();
            lut = CommonsLangUtils.isNotEmpty(this.model.getLookupTable(index));
            button.setSelected(this.model.isChannelActive(index));
            if (lut) {
                button.setImage(LookupTableIconUtil.getLUTIconImage(this.model.getLookupTable(index)));
                continue;
            }
            button.setColor(this.model.getChannelColor(index));
            button.setImage(null);
        }
        for (ChannelButton button : this.channelButtonsProjection) {
            index = button.getChannelIndex();
            lut = CommonsLangUtils.isNotEmpty(this.model.getLookupTable(index));
            button.setSelected(this.model.isChannelActive(index));
            if (lut) {
                button.setImage(LookupTableIconUtil.getLUTIconImage(this.model.getLookupTable(index)));
                continue;
            }
            button.setColor(this.model.getChannelColor(index));
            button.setImage(null);
        }
        Icon icon = this.getColorModelIcon(this.model.getColorModel());
        String tip = this.getColorModelDescription(this.model.getColorModel());
        this.colorModelButton.setIcon(icon);
        this.colorModelButton.setToolTipText(tip);
        this.colorModelButtonGrid.setIcon(icon);
        this.colorModelButtonGrid.setToolTipText(tip);
        this.colorModelButtonProjection.setIcon(icon);
        this.colorModelButtonProjection.setToolTipText(tip);
        this.setZSection(this.model.getDefaultZ());
        this.setTimepoint(this.model.getDefaultT());
        this.setBin(this.model.getSelectedBin());
        ProjectionParam ref = this.model.getLastProjRef();
        if (ref != null) {
            this.projectionRange.setInterval(ref.getStartZ() + 1, ref.getEndZ() + 1);
        }
    }

    void switchRndControl() {
        this.setSliderMax(this.zSlider, this.model.getMaxZ());
        this.setSliderMax(this.zSliderGrid, this.model.getMaxZ());
        this.setSliderMax(this.tSliderGrid, this.model.getRealT());
        this.setSliderMax(this.tSlider, this.model.getRealT());
        if (this.lifetimeSlider != null) {
            this.setSliderMax(this.lifetimeSlider, this.model.getMaxLifetimeBin());
            this.setSliderMax(this.lifetimeSliderGrid, this.model.getMaxLifetimeBin());
        }
        this.resetRndSettings();
    }

    void onStateChange(boolean b) {
        Iterator<ChannelButton> i = this.channelButtons.iterator();
        while (i.hasNext()) {
            i.next().setEnabled(b);
        }
        i = this.channelButtonsGrid.iterator();
        while (i.hasNext()) {
            i.next().setEnabled(b);
        }
        i = this.channelButtonsProjection.iterator();
        while (i.hasNext()) {
            i.next().setEnabled(b);
        }
        this.colorModelButton.setEnabled(b);
        this.colorModelButtonGrid.setEnabled(b);
        this.colorModelButtonProjection.setEnabled(b);
        if (this.projectionTypesBox != null) {
            this.projectionTypesBox.setEnabled(b);
        }
        if (this.projectionFrequency != null) {
            this.projectionFrequency.setEnabled(b);
        }
        if (b) {
            this.onColorModelChanged();
        } else {
            if (this.overlays != null) {
                this.overlays.setEnabled(false);
            }
            if (this.overlayButtons != null) {
                i = this.overlayButtons.iterator();
                while (i.hasNext()) {
                    i.next().setEnabled(false);
                }
            }
        }
        if (this.model.isBigImage()) {
            boolean loading = this.model.getState() != 15;
            this.ratioSlider.setEnabled(loading);
            this.gridRatioSlider.setEnabled(loading);
            this.projectionRatioSlider.setEnabled(loading);
            if (this.resetZoom != null) {
                this.resetZoom.setEnabled(loading);
            }
        }
    }

    JPanel getTimeSliderPane(int index) {
        switch (index) {
            case 1: {
                JPanel p = new JPanel();
                p.setLayout(new BoxLayout(p, 0));
                p.add(this.createButtonToolBar(this.playTMovieGrid));
                p.add(this.tSliderGrid);
                return p;
            }
            case 2: {
                return this.layoutSlider(this.tSliderProjection);
            }
        }
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 0));
        pane.add(this.createButtonToolBar(this.playTMovie));
        pane.add(this.tSlider);
        return pane;
    }

    JPanel getLifetimeSliderPane(int index) {
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 0));
        switch (index) {
            default: {
                pane.add(this.createButtonToolBar(this.playLifetimeMovie));
                pane.add(this.lifetimeSlider);
                return pane;
            }
            case 1: 
        }
        pane.add(this.createButtonToolBar(this.playLifetimeMovieGrid));
        pane.add(this.lifetimeSliderGrid);
        return pane;
    }

    void enableSliders(boolean b) {
        this.enableZSliders(b);
        this.enableTSliders(b);
        if (b) {
            boolean v = this.model.getMaxLifetimeBin() > 1;
            this.lifetimeSlider.setEnabled(v);
            this.lifetimeSliderGrid.setEnabled(v);
        } else {
            this.lifetimeSlider.setEnabled(b);
            this.lifetimeSliderGrid.setEnabled(b);
        }
    }

    void enableZSliders(boolean b) {
        if (b) {
            this.zSlider.setEnabled(this.model.getMaxZ() != 0);
            this.zSliderGrid.setEnabled(this.model.getMaxZ() != 0);
            this.projectionRange.setEnabled(this.model.getMaxZ() != 0);
        } else {
            this.zSlider.setEnabled(b);
            this.zSliderGrid.setEnabled(b);
            this.projectionRange.setEnabled(b);
        }
    }

    void enableTSliders(boolean b) {
        if (b) {
            this.tSlider.setEnabled(this.model.getRealT() > 1);
            this.tSliderGrid.setEnabled(this.model.getRealT() > 1);
            this.tSliderProjection.setEnabled(this.model.getRealT() > 1);
        } else {
            this.tSlider.setEnabled(b);
            this.tSliderGrid.setEnabled(b);
            this.tSliderProjection.setEnabled(b);
        }
    }

    void setChannelActive(int index, int uiIndex) {
        switch (uiIndex) {
            case 0: {
                for (ChannelButton button : this.channelButtonsGrid) {
                    if (index != button.getChannelIndex()) continue;
                    button.setSelected(true);
                }
                break;
            }
            case 3: {
                for (ChannelButton button : this.channelButtons) {
                    if (index != button.getChannelIndex()) continue;
                    button.setSelected(true);
                }
                for (ChannelButton button : this.channelButtonsGrid) {
                    if (index != button.getChannelIndex()) continue;
                    button.setSelected(true);
                }
                for (ChannelButton button : this.channelButtonsProjection) {
                    if (index != button.getChannelIndex()) continue;
                    button.setSelected(true);
                }
                break;
            }
        }
    }

    List getActiveChannelsInGrid() {
        ArrayList<Integer> active = new ArrayList<Integer>();
        for (ChannelButton button : this.channelButtonsGrid) {
            if (!button.isSelected()) continue;
            active.add(button.getChannelIndex());
        }
        return active;
    }

    List getActiveChannelsInProjection() {
        ArrayList<Integer> active = new ArrayList<Integer>();
        for (ChannelButton button : this.channelButtonsProjection) {
            if (!button.isSelected()) continue;
            active.add(button.getChannelIndex());
        }
        return active;
    }

    void setZoomFactor(int zoomIndex) {
        if (this.ratioSlider.getMinimum() > zoomIndex || this.ratioSlider.getMaximum() < zoomIndex) {
            return;
        }
        this.ratioSlider.removeChangeListener(this);
        this.ratioSlider.setValue(zoomIndex);
        this.ratioSlider.addChangeListener(this);
        this.projectionRatioSlider.removeChangeListener(this);
        this.projectionRatioSlider.setValue(zoomIndex);
        this.projectionRatioSlider.addChangeListener(this);
    }

    int getProjectionStartZ() {
        return this.projectionRange.getStartValueAsInt() - 1;
    }

    int getProjectionEndZ() {
        return this.projectionRange.getEndValueAsInt() - 1;
    }

    void setGridMagnificationFactor(int zoomIndex) {
        if (this.gridRatioSlider.getMinimum() > zoomIndex || this.gridRatioSlider.getMaximum() < zoomIndex) {
            return;
        }
        this.gridRatioSlider.removeChangeListener(this);
        this.gridRatioSlider.setValue(zoomIndex);
        this.gridRatioSlider.addChangeListener(this);
    }

    int getProjectionStepping() {
        return (Integer)this.projectionFrequency.getValue();
    }

    int getProjectionType() {
        int index = this.projectionTypesBox.getSelectedIndex();
        return this.projectionTypes.get(index);
    }

    void resetZoomValues() {
    }

    String getProjectionTypeName() {
        int index = this.projectionTypesBox.getSelectedIndex();
        return ProjectionParam.PROJECTIONS.get(index);
    }

    void createGridImage(boolean busy) {
        this.gridImageLabel.setVisible(busy);
        this.gridImageLabel.setBusy(busy);
    }

    boolean isSourceDisplayed(Object source) {
        Iterator<ChannelButton> i = this.channelButtons.iterator();
        while (i.hasNext()) {
            if (i.next() != source) continue;
            return true;
        }
        i = this.channelButtonsGrid.iterator();
        while (i.hasNext()) {
            if (i.next() != source) continue;
            return true;
        }
        i = this.channelButtonsProjection.iterator();
        while (i.hasNext()) {
            if (i.next() != source) continue;
            return true;
        }
        return false;
    }

    void onColorModelChanged() {
        String colorModel = this.model.getColorModel();
        if (this.overlays == null) {
            return;
        }
        if ("greyscale".equals(colorModel)) {
            this.overlays.removeActionListener(this.overlaysListener);
            this.overlays.setSelected(false);
            this.overlays.addActionListener(this.overlaysListener);
            this.overlays.setEnabled(false);
            Iterator<ChannelButton> i = this.overlayButtons.iterator();
            while (i.hasNext()) {
                i.next().setEnabled(false);
            }
        } else {
            boolean ready = this.model.getState() == 6;
            this.overlays.setEnabled(ready);
            Iterator<ChannelButton> i = this.overlayButtons.iterator();
            while (i.hasNext()) {
                i.next().setEnabled(ready);
            }
        }
    }

    void buildOverlays() {
        Map<Integer, Integer> m = this.model.getOverLays();
        if (m == null || m.size() == 0) {
            return;
        }
        this.overlays = new JCheckBox("Overlays");
        this.overlaysListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPane.this.controller.renderOverlays(ControlPane.this.overlays.isSelected());
            }
        };
        this.overlays.addActionListener(this.overlaysListener);
        TableLayout layout = (TableLayout)this.controls.getLayout();
        int row = layout.getNumRow() - 1;
        this.overlayButtons = new ArrayList<ChannelButton>();
        Iterator<Map.Entry<Integer, Integer>> i = m.entrySet().iterator();
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        int j = 0;
        int w = 0;
        int h = 0;
        while (i.hasNext()) {
            Map.Entry<Integer, Integer> entry = i.next();
            int index = entry.getKey();
            Color c = new Color(entry.getValue());
            ChannelButton button = new ChannelButton("" + j, c, index, true);
            button.setOverlay(true);
            button.addPropertyChangeListener(this.controller);
            this.overlayButtons.add(button);
            p.add(button);
            p.add(Box.createRigidArea(VBOX));
            w = button.getPreferredSize().width;
            h = button.getPreferredSize().height;
            ++j;
        }
        JPanel pane = new JPanel();
        double[][] size = new double[][]{{-2.0}, {-2.0, -2.0}};
        pane.setLayout(new TableLayout(size));
        pane.add((Component)this.overlays, "0, 0, CENTER, CENTER");
        if (this.overlayButtons.size() > 8) {
            JScrollPane sp = new JScrollPane(p);
            Dimension d = new Dimension(2 * w, h * 8);
            sp.setPreferredSize(d);
            pane.add((Component)sp, "0, 1, CENTER, CENTER");
        } else {
            pane.add((Component)p, "0, 1, CENTER, CENTER");
        }
        this.controls.add((Component)pane, "0, " + row + ", LEFT, CENTER");
    }

    void renderOverlays(int index, boolean selected) {
        if (index == -1) {
            return;
        }
        for (ChannelButton b : this.overlayButtons) {
            if (b.getChannelIndex() != index) continue;
            b.setSelected(selected);
            break;
        }
    }

    Map<Long, Integer> getSelectedOverlays() {
        HashMap<Long, Integer> m = new HashMap<Long, Integer>();
        for (ChannelButton b : this.overlayButtons) {
            Color c = b.getColor();
            if (!b.isSelected() || c == null) continue;
            m.put(Long.valueOf(b.getChannelIndex()), c.getRGB() & 0xFFFFFF);
        }
        return m;
    }

    boolean isOverlayActive() {
        return this.overlays.isSelected();
    }

    String getSelectedPaneColorModel() {
        switch (this.view.getTabbedIndex()) {
            case 1: {
                return this.getColorModelFromIcon(this.colorModelButtonGrid);
            }
            case 2: {
                return this.getColorModelFromIcon(this.colorModelButtonProjection);
            }
        }
        return this.getColorModelFromIcon(this.colorModelButton);
    }

    void setRangeSliderToolTip(int start, int end) {
        String tip = "Selected Range Z=" + (start + 1) + "-" + (end + 1) + "/" + (this.model.getMaxZ() + 1);
        this.projectionRange.setToolTipText(tip);
    }

    void onChannelUpdated() {
        Dimension dimMax = this.updateText(this.channelButtons);
        this.updateText(this.channelButtonsGrid);
        this.updateText(this.channelButtonsProjection);
        this.resizeChannelButton(dimMax, this.channelButtons);
        this.resizeChannelButton(dimMax, this.channelButtonsGrid);
        this.resizeChannelButton(dimMax, this.channelButtonsProjection);
        this.repaint();
    }

    private Dimension updateText(List<ChannelButton> buttons) {
        Iterator<ChannelButton> i = buttons.iterator();
        Dimension dimMax = new Dimension(0, 0);
        while (i.hasNext()) {
            ChannelButton cb = i.next();
            ChannelData data = this.model.getChannelData(cb.getChannelIndex());
            cb.setText(data.getChannelLabeling());
            Dimension d = cb.getPreferredSize();
            if (d.width <= dimMax.width) continue;
            dimMax = new Dimension(d.width, d.height);
        }
        return dimMax;
    }

    private void resizeChannelButton(Dimension d, List<ChannelButton> buttons) {
        Iterator<ChannelButton> j = buttons.iterator();
        while (j.hasNext()) {
            j.next().setPreferredSize(d);
        }
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComponent comp;
        int index = Integer.parseInt(e.getActionCommand());
        if (index == 0 && (comp = this.projectionFrequency.getEditor()) instanceof JSpinner.NumberEditor) {
            JFormattedTextField field = ((JSpinner.NumberEditor)comp).getTextField();
            String value = field.getText();
            int v = -1;
            try {
                v = Integer.parseInt(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (v == -1 || v > this.model.getMaxZ() || v < 1) {
                return;
            }
            this.projectionFrequency.setValue(v);
        }
        this.controller.setProjectionRange(true);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object object = e.getSource();
        if (object instanceof JSlider) {
            if (object.equals(this.gridRatioSlider)) {
                double r = (double)this.gridRatioSlider.getValue() / 10.0;
                this.controller.setGridMagnificationFactor(r);
                return;
            }
            if (object.equals(this.ratioSlider)) {
                if (this.model.isBigImage()) {
                    if (!this.ratioSlider.isDragging()) {
                        this.controller.setZoomFactor(this.ratioSlider.getValue());
                    }
                } else {
                    this.controller.setZoomFactor(this.ratioSlider.getValue());
                }
            } else if (object.equals(this.projectionRatioSlider)) {
                this.controller.setZoomFactor(this.projectionRatioSlider.getValue());
            }
            if (object.equals(this.zSlider) || object.equals(this.tSlider)) {
                this.setSelectedXYPlane(this.zSlider.getValue(), this.tSlider.getValue());
            } else if (object.equals(this.lifetimeSlider)) {
                this.controller.setSelectedXYPlane(this.model.getDefaultZ(), this.model.getRealSelectedT(), this.lifetimeSlider.getValue());
            } else if (object.equals(this.lifetimeSliderGrid)) {
                this.controller.setSelectedXYPlane(this.model.getDefaultZ(), this.model.getRealSelectedT(), this.lifetimeSliderGrid.getValue());
            } else if (object.equals(this.zSliderGrid) || object.equals(this.tSliderGrid)) {
                this.setSelectedXYPlane(this.zSliderGrid.getValue(), this.tSliderGrid.getValue());
            } else if (object.equals(this.tSliderProjection) && !this.tSliderProjection.getValueIsAdjusting()) {
                try {
                    this.setSelectedXYPlane(-1, this.tSliderProjection.getValue());
                    this.controller.setProjectionRange(true);
                }
                catch (Exception exception) {}
            }
        } else if (object.equals(this.projectionFrequency)) {
            this.controller.setProjectionRange(true);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        Object source = e.getSource();
        if (source == this.zSlider && this.zSlider.isEnabled()) {
            this.mouseWheelMovedZ(e);
        } else if (source == this.tSlider && this.tSlider.isEnabled()) {
            this.mouseWheelMovedT(e);
        } else if (source == this.zSliderGrid && this.zSliderGrid.isEnabled()) {
            this.mouseWheelMovedZ(e);
        } else if (source == this.tSliderGrid && this.tSliderGrid.isEnabled()) {
            this.mouseWheelMovedT(e);
        } else if (source == this.lifetimeSlider && this.lifetimeSlider.isEnabled()) {
            this.mouseWheelMovedLifetime(e);
        } else if (source == this.lifetimeSliderGrid && this.lifetimeSliderGrid.isEnabled()) {
            this.mouseWheelMovedLifetime(e);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("rightMoved".equals(name) || "leftMoved".equals(name)) {
            this.controller.setProjectionRange(false);
        } else if ("knobReleased".equals(name)) {
            this.controller.setProjectionRange(true);
        } else if ("oneKnobReleasedProperty".equals(name)) {
            this.controller.setZoomFactor(this.ratioSlider.getValue());
        }
    }
}

