/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.view;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.openmicroscopy.shoola.agents.imviewer.util.HistoryItem;
import org.openmicroscopy.shoola.agents.imviewer.view.HistoryCanvas;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerControl;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerModel;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerUI;

class HistoryUI
extends JPanel {
    static final String TITLE = "History";
    private ImViewerModel model;
    private ImViewerUI view;
    private HistoryCanvas canvas;

    private void initComponents(ImViewerControl controller) {
        this.canvas = new HistoryCanvas(controller);
    }

    private void buildGUI() {
        this.setBorder(null);
        double[][] size = new double[][]{{-1.0}, {-1.0}};
        this.setLayout(new TableLayout(size));
        this.add((Component)this.canvas, "0, 0");
    }

    HistoryUI(ImViewerUI view, ImViewerModel model, ImViewerControl controller) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        this.model = model;
        this.view = view;
        this.initComponents(controller);
        this.buildGUI();
    }

    void doGridLayout() {
        JComponent desktop = this.canvas.getInternalDesktop();
        desktop.removeAll();
        List<HistoryItem> nodes = this.model.getHistory();
        if (nodes == null || nodes.size() == 0) {
            return;
        }
        Iterator<HistoryItem> i = nodes.iterator();
        while (i.hasNext()) {
            desktop.add(i.next());
        }
        Rectangle r = new Rectangle();
        int w = r.width;
        if (w == 0) {
            w = this.view.geRestoreSize().width;
        }
        this.canvas.doGridLayout(w, this.model.getHistory());
    }

    void addHistoryItem(HistoryItem node) {
        if (node == null) {
            return;
        }
        JComponent desktop = this.canvas.getInternalDesktop();
        desktop.add(node);
        Rectangle r = this.getBounds();
        this.canvas.doGridLayout(r.width, this.model.getHistory());
        JScrollPane dskDecorator = this.canvas.getDeskDecorator();
        Rectangle bounds = node.getBounds();
        JScrollBar hbar = dskDecorator.getHorizontalScrollBar();
        hbar.setValue(hbar.getMaximum() + bounds.width);
    }

    void clearHistory() {
        if (this.canvas != null) {
            this.canvas.clearHistory(this.model.getHistory());
        }
    }

    Dimension getIdealSize() {
        Dimension d = this.canvas.getPreferredSize();
        List<HistoryItem> nodes = this.model.getHistory();
        if (nodes != null && nodes.size() >= 1) {
            d = nodes.get(0).getPreferredSize();
        }
        JComponent tb = this.canvas.getTitleBar();
        Insets insets = this.canvas.getInsets();
        int h = tb.getPreferredSize().height + insets.bottom + insets.top;
        return new Dimension(this.getPreferredSize().width, d.height + h);
    }
}

