/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.view;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import omero.gateway.model.DataObject;
import omero.gateway.model.ImageData;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerModel;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerUI;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class StatusBar
extends JPanel {
    private JLabel leftStatus;
    private JLabel rightStatus;
    private JComponent centerStatus;
    private JButton statusButton;
    private ImViewerModel model;
    private ImViewerUI view;

    private void initComponents() {
        IconManager icons = IconManager.getInstance();
        this.statusButton = new JButton(icons.getIcon(0));
        this.statusButton.setContentAreaFilled(false);
        this.statusButton.setBorder(null);
        this.statusButton.setToolTipText("Load the planes information.");
        this.formatToolTip();
        this.statusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JLabel label = new JLabel();
                label.setText(StatusBar.this.statusButton.getToolTipText());
                StatusBar.this.view.showImageInfo(label);
            }
        });
        UIUtilities.unifiedButtonLookAndFeel(this.statusButton);
        this.leftStatus = new JLabel();
        this.rightStatus = new JLabel();
        this.centerStatus = new JPanel();
    }

    private void buildUI() {
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.add(this.statusButton);
        this.add(Box.createHorizontalStrut(10));
        this.add(this.leftStatus);
        this.add(Box.createHorizontalStrut(15));
        this.add(this.centerStatus);
        this.add(UIUtilities.buildComponentPanelRight(this.rightStatus));
        this.add(Box.createRigidArea(new Dimension(20, 5)));
    }

    StatusBar(ImViewerModel model, ImViewerUI view) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        this.model = model;
        this.view = view;
        this.initComponents();
        this.buildUI();
    }

    void formatToolTip() {
        ImageData image = this.model.getImage();
        if (image == null) {
            return;
        }
        List<String> l = null;
        String s = "";
        l = EditorUtil.formatObjectTooltip((DataObject)image);
        s = UIUtilities.formatString(image.getName(), -1);
        ArrayList<String> ll = new ArrayList<String>();
        ll.add(s);
        if (l != null) {
            ll.addAll(l);
        }
        this.statusButton.setToolTipText(UIUtilities.formatToolTipText(ll));
    }

    String getRightStatus() {
        return this.rightStatus.getText();
    }

    void setLeftStatus(String s) {
        this.leftStatus.setText(s);
    }

    void setRightStatus(String s) {
        this.rightStatus.setText(s);
    }

    void setCenterStatus(JComponent comp) {
        this.centerStatus.removeAll();
        if (comp != null) {
            this.centerStatus.add(comp);
            this.revalidate();
            this.repaint();
        }
    }
}

