/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import omero.gateway.model.GroupData;
import org.jdesktop.swingx.JXBusyLabel;
import org.openmicroscopy.shoola.agents.events.iviewer.ScriptDisplay;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.actions.ActivityImageAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ROIToolAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ViewerAction;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerControl;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerFactory;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerUI;
import org.openmicroscopy.shoola.agents.imviewer.view.ViewerPreferences;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ToolBar
extends JPanel {
    static final int UNCOMPRESSED = 0;
    static final int MEDIUM = 1;
    static final int LOW = 2;
    private static final Dimension H_SPACE = new Dimension(2, 5);
    private static final String[] compression = new String[3];
    private static final String[] compressionPartial;
    private ImViewerControl controller;
    private ImViewerUI view;
    private JToolBar bar;
    private JToggleButton rndButton;
    private JToggleButton metadataButton;
    private JToggleButton historyButton;
    private JComboBox compressionBox;
    private JButton pasteButton;
    private JButton measurementButton;
    private JButton closeButton;
    private JButton detachButton;
    private JXBusyLabel measurementLabel;
    private JXBusyLabel busyLabel;
    private JCheckBox interpolation;
    private static final int MEASUREMENT_INDEX = 13;
    private static final int RND_INDEX = 0;
    private static final int METADATA_INDEX = 1;
    private JButton script;

    private Icon getPermissionsIcon(GroupData g) {
        IconManager icons = IconManager.getInstance();
        switch (g.getPermissions().getPermissionsLevel()) {
            case 0: {
                return icons.getIcon(75);
            }
            case 1: {
                return icons.getIcon(76);
            }
            case 2: {
                return icons.getIcon(77);
            }
            case 3: {
                return icons.getIcon(79);
            }
            case 4: {
                return icons.getIcon(78);
            }
            case 5: {
                return icons.getIcon(78);
            }
        }
        return null;
    }

    private void createControlsBar() {
        this.bar = new JToolBar();
        this.bar.setFloatable(false);
        this.bar.setRollover(true);
        this.bar.setBorder(null);
        this.pasteButton = new JButton(this.controller.getAction(ImViewerControl.PASTE_RND_SETTINGS));
        UIUtilities.unifiedButtonLookAndFeel(this.pasteButton);
        this.pasteButton.setEnabled(this.view.hasSettingsToPaste());
        this.rndButton = new JToggleButton();
        this.rndButton.setSelected(this.view.isRendererShown());
        this.rndButton.setAction(this.controller.getAction(ImViewerControl.RENDERER));
        if (this.view.isSeparateWindow()) {
            this.bar.add((Component)this.rndButton, 0);
        }
        this.metadataButton = new JToggleButton();
        this.metadataButton.setSelected(this.view.isRendererShown());
        this.metadataButton.setAction(this.controller.getAction(ImViewerControl.METADATA));
        if (this.view.isSeparateWindow()) {
            this.bar.add((Component)this.metadataButton, 1);
        }
        this.historyButton = new JToggleButton();
        this.historyButton.setSelected(this.view.isHistoryShown());
        this.historyButton.setAction(this.controller.getAction(ImViewerControl.HISTORY));
        JButton b = new JButton(this.controller.getAction(ImViewerControl.REFRESH));
        UIUtilities.unifiedButtonLookAndFeel(b);
        this.bar.add(b);
        this.closeButton = new JButton(this.controller.getAction(ImViewerControl.CLOSE));
        UIUtilities.unifiedButtonLookAndFeel(this.closeButton);
        this.detachButton = new JButton(this.controller.getAction(ImViewerControl.DETACH));
        UIUtilities.unifiedButtonLookAndFeel(this.detachButton);
        if (!this.view.isSeparateWindow()) {
            this.bar.add((Component)this.closeButton, 0);
            this.bar.add((Component)this.detachButton, 1);
        }
        this.bar.add(Box.createRigidArea(H_SPACE));
        this.bar.add(new JSeparator(1));
        this.bar.add(Box.createRigidArea(H_SPACE));
        b = new JButton(this.controller.getAction(ImViewerControl.COPY_RND_SETTINGS));
        UIUtilities.unifiedButtonLookAndFeel(b);
        this.bar.add(b);
        this.bar.add(this.pasteButton);
        b = new JButton(this.controller.getAction(ImViewerControl.SAVE_RND_SETTINGS));
        UIUtilities.unifiedButtonLookAndFeel(b);
        this.bar.add(b);
        this.bar.add(new JSeparator(1));
        b = new JButton(this.controller.getAction(ImViewerControl.MOVIE));
        UIUtilities.unifiedButtonLookAndFeel(b);
        this.bar.add(b);
        b = new JButton(this.controller.getAction(ImViewerControl.LENS));
        UIUtilities.unifiedButtonLookAndFeel(b);
        this.bar.add(b);
        this.bar.add(new JSeparator(1));
        ViewerAction a = this.controller.getAction(ImViewerControl.MEASUREMENT_TOOL);
        this.measurementButton = new JButton(a);
        this.measurementButton.addMouseListener((ROIToolAction)a);
        UIUtilities.unifiedButtonLookAndFeel(this.measurementButton);
        this.bar.add(this.measurementButton);
        Icon icon = this.measurementButton.getIcon();
        int h = 16;
        int w = 16;
        if (icon != null) {
            if (icon.getIconHeight() > h) {
                h = icon.getIconHeight();
            }
            if (icon.getIconWidth() > w) {
                w = icon.getIconWidth();
            }
        }
        this.bar.add(new JSeparator(1));
        b = new JButton(this.controller.getAction(ImViewerControl.SAVE));
        UIUtilities.unifiedButtonLookAndFeel(b);
        this.bar.add(b);
        this.bar.add(this.script);
        a = this.controller.getAction(ImViewerControl.ACTIVITY);
        b = new JButton(a);
        b.addMouseListener((ActivityImageAction)a);
        UIUtilities.unifiedButtonLookAndFeel(b);
        Dimension d = new Dimension(w, h);
        this.busyLabel = new JXBusyLabel(d);
        this.busyLabel.setEnabled(true);
        this.busyLabel.setVisible(false);
        this.measurementLabel = new JXBusyLabel(d);
        this.measurementLabel.setToolTipText("Loading Measurements. Please wait.");
        this.measurementLabel.setEnabled(true);
        this.measurementLabel.setVisible(true);
    }

    private void initComponents() {
        this.compressionBox = EditorUtil.createComboBox(compression, 0, this.getBackground());
        this.compressionBox.setBackground(this.getBackground());
        this.interpolation = new JCheckBox();
        this.interpolation.setBackground(this.getBackground());
        this.interpolation.setToolTipText("Enables/Disables interpolation when images are scaled up");
        this.script = new JButton();
        IconManager im = IconManager.getInstance();
        this.script.setIcon(im.getIcon(80));
        UIUtilities.unifiedButtonLookAndFeel(this.script);
        this.script.setEnabled(ImViewerAgent.canCreate());
        this.script.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptDisplay evt = new ScriptDisplay((Component)e.getSource());
                ImViewerAgent.getRegistry().getEventBus().post(evt);
            }
        });
        this.createControlsBar();
    }

    private void buildGUI() {
        GroupData g;
        this.removeAll();
        JPanel p = new JPanel();
        JLabel l = new JLabel("Compression:");
        p.add(l);
        p.add(this.compressionBox);
        JLabel l2 = new JLabel("Interpolate:");
        p.add(l2);
        p.add(this.interpolation);
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(null);
        JPanel bars = new JPanel();
        bars.setLayout(new FlowLayout(0, 0, 0));
        bars.setBorder(null);
        bars.add(this.bar);
        if (p != null) {
            bars.add(p);
        }
        if ((g = this.view.getSelectedGroup()) != null) {
            p = new JPanel();
            l = new JLabel(g.getName());
            l.setIcon(this.getPermissionsIcon(g));
            p.add(l);
            bars.add(p);
        }
        this.add(UIUtilities.buildComponentPanel(bars));
        this.add(UIUtilities.buildComponentPanelRight((JComponent)this.busyLabel));
    }

    ToolBar(ImViewerUI view, ImViewerControl controller) {
        if (view == null) {
            throw new NullPointerException("No View.");
        }
        if (controller == null) {
            throw new NullPointerException("No Control.");
        }
        this.view = view;
        this.controller = controller;
        this.initComponents();
    }

    void buildComponent() {
        int value;
        int setUp;
        int compression;
        ViewerPreferences pref = ImViewerFactory.getPreferences();
        if (pref != null) {
            this.rndButton.setSelected(pref.isRenderer());
        }
        if ((compression = ImViewerFactory.getCompressionLevel()) != (setUp = this.view.convertCompressionLevel(value = ((Integer)ImViewerAgent.getRegistry().lookup("/connection/speed")).intValue()))) {
            compression = setUp;
        }
        if (this.view.isLargePlane() && value > 0) {
            compression = 2;
        }
        int index = this.view.convertCompressionLevel();
        if (compression >= 0 && compression <= 2) {
            index = compression;
        }
        this.compressionBox.setSelectedIndex(index);
        this.compressionBox.addActionListener(this.controller.getAction(ImViewerControl.COMPRESSION));
        this.interpolation.setSelected(this.controller.isInterpolation());
        this.interpolation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ToolBar.this.controller.setInterpolation(ToolBar.this.interpolation.isSelected());
            }
        });
        this.buildGUI();
    }

    void setCompressionLevel(int index) {
        this.compressionBox.removeActionListener(this.controller.getAction(ImViewerControl.COMPRESSION));
        this.compressionBox.setSelectedIndex(index);
        this.compressionBox.addActionListener(this.controller.getAction(ImViewerControl.COMPRESSION));
    }

    void displayRenderer() {
        this.rndButton.setSelected(this.view.isRendererShown());
        this.metadataButton.setSelected(this.view.isRendererShown());
    }

    void displayHistory() {
        this.historyButton.setSelected(this.view.isHistoryShown());
    }

    void enablePasteButton(boolean b) {
        this.pasteButton.setEnabled(b);
    }

    void setStatus(boolean busy) {
        this.busyLabel.setBusy(busy);
        this.busyLabel.setVisible(busy);
    }

    void setMeasurementLaunchingStatus(boolean b) {
        if (this.bar != null) {
            this.measurementLabel.setBusy(b);
            if (!b) {
                this.bar.remove((Component)this.measurementLabel);
                this.bar.add((Component)this.measurementButton, 13);
            } else {
                this.bar.remove(this.measurementButton);
                this.bar.add((Component)this.measurementLabel, 13);
            }
            this.bar.revalidate();
            this.bar.repaint();
        }
    }

    void setSeparateWindow() {
        this.bar.remove(this.closeButton);
        this.bar.remove(this.detachButton);
        this.bar.add((Component)this.rndButton, 0);
        this.bar.add((Component)this.metadataButton, 1);
        this.bar.revalidate();
        this.bar.repaint();
    }

    void onStateChange(boolean b) {
    }

    int getUICompressionLevel() {
        return this.compressionBox.getSelectedIndex();
    }

    void onImport() {
    }

    static {
        ToolBar.compression[0] = "None";
        ToolBar.compression[1] = "Medium";
        ToolBar.compression[2] = "High";
        compressionPartial = new String[2];
        ToolBar.compressionPartial[0] = "Medium";
        ToolBar.compressionPartial[1] = "High";
    }
}

