/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util.roitable;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import omero.gateway.model.FolderData;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.ROINode;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.ROIUtil;

public class ROINodeMap {
    private ListMultimap<String, ROINode> nodesMap = ArrayListMultimap.create();

    public void clear() {
        this.nodesMap.clear();
    }

    public void add(ROINode node) {
        this.nodesMap.put((Object)ROIUtil.getUUID(node.getUserObject()), (Object)node);
    }

    public Collection<ROINode> get(Object obj) {
        String key = ROIUtil.getUUID(obj);
        if (key != null) {
            return this.nodesMap.get((Object)key);
        }
        return Collections.EMPTY_LIST;
    }

    public Collection<ROINode> values() {
        return this.nodesMap.values();
    }

    public ROINode findFolderNode(FolderData folder) {
        Collection<ROINode> tmp = this.get(folder);
        switch (tmp.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return tmp.iterator().next();
            }
        }
        throw new RuntimeException("Multiple ROINodes found for " + folder);
    }

    public Collection<Long> getChildFolderIds(Collection<FolderData> folders) {
        HashSet<Long> ids = new HashSet<Long>();
        for (FolderData f : folders) {
            if (ids.contains(f.getId())) continue;
            ROINode fnode = this.findFolderNode(f);
            ArrayList<ROINode> subNodes = new ArrayList<ROINode>();
            ROIUtil.getAllDecendants(fnode, subNodes);
            for (ROINode subNode : subNodes) {
                if (!subNode.isFolderNode()) continue;
                ids.add(((FolderData)subNode.getUserObject()).getId());
            }
            ids.remove(f.getId());
        }
        return ids;
    }
}

