/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util.roitable;

import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import javax.activation.DataHandler;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import omero.log.LogMessage;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.ROINode;
import org.openmicroscopy.shoola.agents.measurement.view.ROITable;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;

public class TableRowTransferHandler
extends TransferHandler {
    private JTable table = null;
    private DataFlavor flavor = new DataFlavor(int[].class, "Integer Array");

    public TableRowTransferHandler(JTable table) {
        this.table = table;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        return new DataHandler((Object)this.table.getSelectedRows(), this.flavor.getMimeType());
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        boolean b = info.getComponent() == this.table && info.isDrop() && this.checkDropTarget(info);
        this.table.setCursor(b ? DragSource.DefaultMoveDrop : DragSource.DefaultMoveNoDrop);
        return b;
    }

    private boolean checkDropTarget(TransferHandler.TransferSupport info) {
        JTable.DropLocation dl = (JTable.DropLocation)info.getDropLocation();
        int index = dl.getRow();
        ROINode target = (ROINode)((ROITable)((Object)this.table)).getNodeAtRow(index);
        if (target == null) {
            return true;
        }
        if (!target.canEdit() || !target.isFolderNode()) {
            return false;
        }
        int[] selection = this.table.getSelectedRows();
        for (int i = 0; i < selection.length; ++i) {
            ROINode n = (ROINode)((ROITable)((Object)this.table)).getNodeAtRow(selection[i]);
            if (n == null || !n.isAncestorOf(target)) continue;
            return false;
        }
        return true;
    }

    private boolean checkDragSource() {
        if (this.table.getSelectedColumn() > 0) {
            return false;
        }
        int[] selection = this.table.getSelectedRows();
        for (int i = 0; i < selection.length; ++i) {
            ROINode n = (ROINode)((ROITable)((Object)this.table)).getNodeAtRow(selection[i]);
            if (n != null && n.canEdit()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getSourceActions(JComponent c) {
        if (this.checkDragSource()) {
            return 2;
        }
        return 0;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        if (!info.isDrop()) {
            return false;
        }
        ROITable target = (ROITable)((Object)info.getComponent());
        JTable.DropLocation dl = (JTable.DropLocation)info.getDropLocation();
        int index = dl.getRow();
        int max = this.table.getModel().getRowCount();
        if (index < 0 || index > max) {
            index = max;
        }
        target.setCursor(Cursor.getPredefinedCursor(0));
        try {
            int[] rowsToMove = (int[])info.getTransferable().getTransferData(this.flavor);
            target.handleDragAndDrop(rowsToMove, index);
            return true;
        }
        catch (Exception e) {
            LogMessage msg = new LogMessage("DnD action failed", (Throwable)e);
            MetadataViewerAgent.getRegistry().getLogger().warn((Object)this, msg);
            return false;
        }
    }

    @Override
    protected void exportDone(JComponent c, Transferable t, int act) {
        if (act == 2 || act == 0) {
            this.table.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

