/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import com.google.common.collect.ImmutableList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import omero.gateway.model.ChannelData;
import omero.log.Logger;
import org.apache.commons.collections.CollectionUtils;
import org.jhotdraw.draw.Figure;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.util.TabPaneInterface;
import org.openmicroscopy.shoola.agents.measurement.util.model.AnalysisStatsWrapper;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerUI;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.rnd.roi.ROIShapeStats;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.file.ExcelWriter;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.roi.figures.MeasureTextFigure;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;

class IntensityResultsView
extends JPanel
implements ActionListener,
TabPaneInterface {
    public static final int INDEX = 6;
    private static final String ADD_NAME = "Add";
    private static final String ADD_DESCRIPTION = "Add Intensities for the selected ROIs to results table.";
    private static final String ADDALL_NAME = "Add Selected";
    private static final String ADDALL_DESCRIPTION = "Add Intensities for all the shapes of the selected ROIs to results table.";
    private static final String REMOVE_NAME = "Remove";
    private static final String REMOVE_DESCRIPTION = "Remove Results in selected row from table.";
    private static final String REMOVE_ALL_NAME = "Remove All";
    private static final String REMOVE_ALL_DESCRIPTION = "Remove all the Results from table.";
    private static final String SAVE_NAME = "Export to Excel...";
    private static final String SAVE_DESCRIPTION = "Save Intensities to Excel File.";
    private MeasurementViewerUI view;
    private JTable results;
    private ResultsTableModel resultsModel;
    private JButton removeButton;
    private JButton saveButton;
    private JButton addButton;
    private JButton addAllButton;
    private JButton removeAllButton;
    private State state = State.READY;
    private static final String NAME = "Intensity Results View";
    private static final int REMOVE = 0;
    private static final int ADD = 1;
    private static final int ADDALL = 4;
    private static final int REMOVE_ALL = 2;
    private static final int SAVE = 3;
    private MeasurementViewerModel model;
    private Map<ROIShape, Map<Integer, ROIShapeStats>> ROIStats;
    private Map<Integer, String> channelName = new TreeMap<Integer, String>();
    private Map<Integer, Color> channelColour = new TreeMap<Integer, Color>();
    private Map<Integer, Double> channelSum = new TreeMap<Integer, Double>();
    private Map<Integer, Double> channelMin = new TreeMap<Integer, Double>();
    private Map<Integer, Double> channelMax = new TreeMap<Integer, Double>();
    private Map<Integer, Double> channelMean = new TreeMap<Integer, Double>();
    private Map<Integer, Double> channelStdDev = new TreeMap<Integer, Double>();
    private Map<String, Integer> nameMap = new HashMap<String, Integer>();
    private Map<Coord3D, Map<Integer, Double>> minStats;
    private Map<Coord3D, Map<Integer, Double>> maxStats;
    private Map<Coord3D, Map<Integer, Double>> meanStats;
    private Map<Coord3D, Map<Integer, Double>> stdDevStats;
    private Map<Coord3D, Map<Integer, Double>> sumStats;
    private Map<Coord3D, ROIShape> shapeMap;
    private Coord3D coord;
    private ROIShape shape;

    @Override
    public int getIndex() {
        return 6;
    }

    private void initComponents() {
        this.state = State.READY;
        this.removeButton = new JButton(REMOVE_NAME);
        this.removeButton.setToolTipText(UIUtilities.formatToolTipText(REMOVE_DESCRIPTION));
        this.removeButton.setActionCommand("0");
        this.removeButton.addActionListener(this);
        this.saveButton = new JButton(SAVE_NAME);
        this.saveButton.setToolTipText(UIUtilities.formatToolTipText(SAVE_DESCRIPTION));
        this.saveButton.setActionCommand("3");
        this.saveButton.addActionListener(this);
        this.setButtonsEnabled(false);
        this.addButton = new JButton(ADD_NAME);
        this.addButton.setToolTipText(UIUtilities.formatToolTipText(ADD_DESCRIPTION));
        this.addButton.setActionCommand("1");
        this.addButton.addActionListener(this);
        this.addAllButton = new JButton(ADDALL_NAME);
        this.addAllButton.setToolTipText(UIUtilities.formatToolTipText(ADDALL_DESCRIPTION));
        this.addAllButton.setActionCommand("4");
        this.addAllButton.addActionListener(this);
        this.removeAllButton = new JButton(REMOVE_ALL_NAME);
        this.removeAllButton.setToolTipText(UIUtilities.formatToolTipText(REMOVE_ALL_DESCRIPTION));
        this.removeAllButton.setActionCommand("2");
        this.removeAllButton.addActionListener(this);
        this.addAllButton.setEnabled(false);
        this.removeAllButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    private void setButtonsEnabled(boolean enabled) {
        this.saveButton.setEnabled(enabled);
    }

    private void configureRowSorter() {
        int z = this.resultsModel.findColumn("Z");
        int t = this.resultsModel.findColumn("T");
        int c = this.resultsModel.findColumn("Channel");
        this.resultsModel.setColumnClass(z, Integer.class);
        this.resultsModel.setColumnClass(t, Integer.class);
        this.results.setDefaultRenderer(Integer.class, this.results.getDefaultRenderer(String.class));
        TableRowSorter<ResultsTableModel> sorter = new TableRowSorter<ResultsTableModel>(this.resultsModel);
        sorter.setSortKeys((List<RowSorter.SortKey>)ImmutableList.of((Object)new RowSorter.SortKey(z, SortOrder.ASCENDING), (Object)new RowSorter.SortKey(t, SortOrder.ASCENDING), (Object)new RowSorter.SortKey(c, SortOrder.ASCENDING)));
        this.results.setRowSorter(sorter);
    }

    private void buildGUI() {
        this.resultsModel = new ResultsTableModel();
        this.resultsModel.addColumn("id");
        this.resultsModel.addColumn("Z");
        this.resultsModel.addColumn("T");
        this.resultsModel.addColumn("Channel");
        this.resultsModel.addColumn("Text");
        this.resultsModel.addColumn("Min");
        this.resultsModel.addColumn("Max");
        this.resultsModel.addColumn("Sum");
        this.resultsModel.addColumn("Mean");
        this.resultsModel.addColumn("stdDev");
        this.results = new JTable(this.resultsModel);
        this.configureRowSorter();
        this.results.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                IntensityResultsView.this.onFigureSelected();
            }
        });
        JPanel centrePanel = new JPanel();
        centrePanel.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.results);
        centrePanel.add((Component)scrollPane, "Center");
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout());
        bottomPanel.add(this.addAllButton);
        bottomPanel.add(this.removeButton);
        bottomPanel.add(this.removeAllButton);
        bottomPanel.add(this.saveButton);
        JPanel containerPanel = new JPanel();
        containerPanel.setLayout(new BorderLayout());
        containerPanel.add((Component)centrePanel, "Center");
        containerPanel.add((Component)bottomPanel, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)containerPanel, "Center");
    }

    private boolean isValueDisplayed(ROIShape shape, String channelName) {
        long id = shape.getID();
        int z = shape.getCoord3D().getZSection();
        int t = shape.getCoord3D().getTimePoint();
        for (int i = 0; i < this.resultsModel.getRowCount(); ++i) {
            String v;
            ROIShape s = ((ShapeAsID)this.resultsModel.getValueAt(i, 0)).getShape();
            if (s.getID() != id || s.getCoord3D().getZSection() != z || s.getCoord3D().getTimePoint() != t || !(v = (String)this.resultsModel.getValueAt(i, 3)).equals(channelName)) continue;
            return true;
        }
        return false;
    }

    private void getResults(ROIShape shape) {
        Vector rows = new Vector();
        ShapeAsID shapeID = new ShapeAsID(shape);
        Iterator<String> channelIterator = this.channelName.values().iterator();
        if (this.minStats.get(this.coord) == null) {
            return;
        }
        this.channelMin = this.minStats.get(this.coord);
        this.channelMax = this.maxStats.get(this.coord);
        this.channelMean = this.meanStats.get(this.coord);
        this.channelStdDev = this.stdDevStats.get(this.coord);
        this.channelSum = this.sumStats.get(this.coord);
        while (channelIterator.hasNext()) {
            String cName = channelIterator.next();
            int channel = this.nameMap.get(cName);
            if (this.isValueDisplayed(shape, cName)) continue;
            Vector<Object> rowData = new Vector<Object>();
            rowData.add(shapeID);
            rowData.add(shape.getCoord3D().getZSection() + 1);
            rowData.add(shape.getCoord3D().getTimePoint() + 1);
            rowData.add(cName);
            rowData.add(MeasurementAttributes.TEXT.get(shape.getFigure()));
            rowData.add(this.channelMin.get(channel));
            rowData.add(this.channelMax.get(channel));
            rowData.add(this.channelSum.get(channel));
            rowData.add(this.channelMean.get(channel));
            rowData.add(this.channelStdDev.get(channel));
            rows.add(rowData);
        }
        for (Vector vector : rows) {
            this.resultsModel.addRow(vector);
        }
        this.results.repaint();
    }

    private void saveResults() {
        FileChooser chooser = this.view.createSaveToExcelChooser();
        if (chooser.showDialog() != 0) {
            return;
        }
        File file = chooser.getFormattedSelectedFile();
        ExcelWriter writer = null;
        try {
            String filename = file.getAbsolutePath();
            writer = new ExcelWriter(filename);
            writer.openFile();
            writer.createSheet("Intensity Results");
            writer.writeTableToSheet(0, 0, this.resultsModel);
            BufferedImage originalImage = this.model.getRenderedImage();
            BufferedImage image = Factory.copyBufferedImage(originalImage);
            this.model.setAttributes(MeasurementAttributes.SHOWID, true);
            this.model.setAttributes(MeasurementAttributes.SHOWID, false);
            try {
                if (image != null) {
                    this.model.getDrawingView().print(image.getGraphics());
                    writer.addImageToWorkbook("ThumbnailImage", image);
                    int col = writer.getMaxColumn(0);
                    writer.writeImage(0, col + 1, 256, 256, "ThumbnailImage");
                }
            }
            catch (Exception e) {
                Logger logger = MeasurementAgent.getRegistry().getLogger();
                logger.error((Object)this, "Cannot write Image: " + e.toString());
            }
            writer.close();
        }
        catch (IOException e) {
            Logger logger = MeasurementAgent.getRegistry().getLogger();
            logger.error((Object)this, "Cannot save ROI results: " + e.toString());
            UserNotifier un = MeasurementAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Save Results", "An error occurred while trying to save the data.\nPlease try again.");
            file.delete();
            try {
                writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        Registry reg = MeasurementAgent.getRegistry();
        UserNotifier un = reg.getUserNotifier();
        un.notifyInfo("Save ROI results", "The ROI results have been successfully saved.");
    }

    private void removeResults() {
        int[] rows = this.results.getSelectedRows();
        for (int i = 0; i < rows.length; ++i) {
            this.resultsModel.removeRow(rows[i] - i);
        }
        this.results.clearSelection();
        this.setButtonsEnabled(this.results.getRowCount() > 0);
    }

    private Set<ROIShape> getShapesInRows() {
        HashSet<ROIShape> shapes = new HashSet<ROIShape>();
        for (int i = 0; i < this.resultsModel.getRowCount(); ++i) {
            shapes.add(((ShapeAsID)this.resultsModel.getValueAt(i, 0)).getShape());
        }
        return shapes;
    }

    private boolean validFigures(Set<Figure> selectedFigures) {
        if (CollectionUtils.isEmpty(selectedFigures)) {
            return false;
        }
        for (Figure figure : selectedFigures) {
            if (!(figure instanceof MeasureTextFigure)) continue;
            return false;
        }
        return true;
    }

    private void addResults() {
        Set<Figure> selectedFigures = this.view.getDrawingView().getSelectedFigures();
        if (!this.validFigures(selectedFigures)) {
            return;
        }
        if (CollectionUtils.isEmpty(selectedFigures) || this.state == State.ANALYSING) {
            return;
        }
        this.state = State.ANALYSING;
        ArrayList<ROIShape> shapeList = new ArrayList<ROIShape>();
        Set<ROIShape> alreadyInTable = this.getShapesInRows();
        Iterator<Figure> iterator = selectedFigures.iterator();
        Map analysisResults = this.model.getAnalysisResults();
        if (analysisResults == null) {
            analysisResults = Collections.emptyMap();
        }
        while (iterator.hasNext()) {
            Map shapeStatsByChannel;
            ROIFigure fig = (ROIFigure)iterator.next();
            ROIShape shape = fig.getROIShape();
            if (alreadyInTable.contains(shape)) {
                this.removeShape(shape);
            }
            if ((shapeStatsByChannel = (Map)analysisResults.get(shape)) != null && !shapeStatsByChannel.isEmpty()) continue;
            shapeList.add(shape);
        }
        if (shapeList.size() > 0) {
            this.view.calculateStats(shapeList);
            this.onFigureSelected();
        }
        this.state = State.READY;
    }

    private void removeShape(ROIShape shape) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 0; i < this.resultsModel.getRowCount(); ++i) {
            if (!((ShapeAsID)this.resultsModel.getValueAt(i, 0)).getShape().equals(shape)) continue;
            indexes.add(i);
        }
        Iterator j = indexes.iterator();
        while (j.hasNext()) {
            this.resultsModel.removeRow((Integer)j.next());
        }
    }

    private void setControls(boolean value) {
        this.addAllButton.setEnabled(value);
        this.removeAllButton.setEnabled(value);
        this.removeButton.setEnabled(value);
        this.saveButton.setEnabled(value);
    }

    private void addAllResults() {
        Set<Figure> selectedFigures = this.view.getDrawingView().getSelectedFigures();
        if (CollectionUtils.isEmpty(selectedFigures) || this.state == State.ANALYSING) {
            return;
        }
        this.state = State.ANALYSING;
        this.setControls(false);
        ArrayList<ROIShape> shapeList = new ArrayList<ROIShape>();
        Set<ROIShape> alreadyInTable = this.getShapesInRows();
        Iterator<Figure> i = selectedFigures.iterator();
        Map analysisResults = this.model.getAnalysisResults();
        if (analysisResults == null) {
            analysisResults = Collections.emptyMap();
        }
        while (i.hasNext()) {
            ROIFigure fig = (ROIFigure)i.next();
            if (fig instanceof MeasureTextFigure) continue;
            TreeMap<Coord3D, ROIShape> treeMap = fig.getROI().getShapes();
            Iterator<Coord3D> j = treeMap.keySet().iterator();
            while (j.hasNext()) {
                Map shapeStatsByChannel;
                ROIShape shape = treeMap.get(j.next());
                if (alreadyInTable.contains(shape) || (shapeStatsByChannel = (Map)analysisResults.get(shape)) != null && !shapeStatsByChannel.isEmpty()) continue;
                shapeList.add(shape);
            }
        }
        if (shapeList.isEmpty()) {
            if (!analysisResults.isEmpty()) {
                this.displayAnalysisResults();
            }
        } else {
            this.view.calculateStats(shapeList);
        }
    }

    IntensityResultsView(MeasurementViewerUI view, MeasurementViewerModel model) {
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.view = view;
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    String getComponentName() {
        return NAME;
    }

    Icon getComponentIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(27);
    }

    void displayAnalysisResults() {
        this.ROIStats = this.model.getAnalysisResults();
        this.onFigureSelected();
        if (this.ROIStats == null || this.ROIStats.size() == 0) {
            this.state = State.READY;
            return;
        }
        this.shapeMap = new TreeMap<Coord3D, ROIShape>(new Coord3D());
        this.minStats = new TreeMap<Coord3D, Map<Integer, Double>>(new Coord3D());
        this.maxStats = new TreeMap<Coord3D, Map<Integer, Double>>(new Coord3D());
        this.meanStats = new TreeMap<Coord3D, Map<Integer, Double>>(new Coord3D());
        this.sumStats = new TreeMap<Coord3D, Map<Integer, Double>>(new Coord3D());
        this.stdDevStats = new TreeMap<Coord3D, Map<Integer, Double>>(new Coord3D());
        Iterator<Map.Entry<ROIShape, Map<Integer, ROIShapeStats>>> j = this.ROIStats.entrySet().iterator();
        this.channelName = new TreeMap<Integer, String>();
        this.nameMap = new HashMap<String, Integer>();
        List<ChannelData> metadata = this.model.getMetadata();
        while (j.hasNext()) {
            Map.Entry<ROIShape, Map<Integer, ROIShapeStats>> entry = j.next();
            this.shape = entry.getKey();
            if (this.shape.getFigure() instanceof MeasureTextFigure) {
                this.state = State.READY;
                return;
            }
            Coord3D c3D = this.shape.getCoord3D();
            Map<AnalysisStatsWrapper.StatsType, Map> shapeStats = AnalysisStatsWrapper.convertStats(entry.getValue());
            if (shapeStats != null) {
                this.minStats.put(c3D, shapeStats.get((Object)AnalysisStatsWrapper.StatsType.MIN));
                this.maxStats.put(c3D, shapeStats.get((Object)AnalysisStatsWrapper.StatsType.MAX));
                this.meanStats.put(c3D, shapeStats.get((Object)AnalysisStatsWrapper.StatsType.MEAN));
                this.sumStats.put(c3D, shapeStats.get((Object)AnalysisStatsWrapper.StatsType.SUM));
                this.stdDevStats.put(c3D, shapeStats.get((Object)AnalysisStatsWrapper.StatsType.STDDEV));
            }
            this.channelName.clear();
            this.nameMap.clear();
            this.channelColour.clear();
            for (ChannelData channelData : metadata) {
                int channel = channelData.getIndex();
                if (!this.model.isChannelActive(channel)) continue;
                this.channelName.put(channel, channelData.getChannelLabeling());
                this.nameMap.put(this.channelName.get(channel), channel);
                this.channelColour.put(channel, (Color)this.model.getActiveChannels().get(channel));
            }
            if (this.channelName.size() == 0 || this.nameMap.size() == 0 || this.channelColour.size() == 0) {
                this.state = State.READY;
                return;
            }
            this.coord = c3D;
            this.getResults(this.shape);
        }
        this.setButtonsEnabled(true);
        this.onFigureSelected();
        this.state = State.READY;
    }

    void onFigureSelected() {
        Set<Figure> selectedFigures = this.view.getDrawingView().getSelectedFigures();
        boolean valid = this.validFigures(selectedFigures);
        this.addButton.setEnabled(valid);
        this.addAllButton.setEnabled(valid);
        if (this.results != null) {
            int count = this.results.getRowCount();
            int[] rows = this.results.getSelectedRows();
            this.removeButton.setEnabled(rows != null && rows.length > 0);
            this.removeAllButton.setEnabled(count > 0);
        } else {
            this.removeButton.setEnabled(false);
            this.removeAllButton.setEnabled(false);
        }
    }

    void removeAllResults() {
        int count = this.results.getRowCount();
        for (int i = count - 1; i >= 0; --i) {
            this.resultsModel.removeRow(i);
        }
        this.model.setAnalysisResults(null);
        this.setButtonsEnabled(false);
        this.onFigureSelected();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 1: {
                this.addResults();
                break;
            }
            case 4: {
                this.addAllResults();
                break;
            }
            case 3: {
                this.saveResults();
                break;
            }
            case 0: {
                this.removeResults();
                break;
            }
            case 2: {
                this.removeAllResults();
            }
        }
    }

    static class ResultsTableModel
    extends DefaultTableModel {
        private Map<Integer, Class<?>> columnClasses = new HashMap();

        ResultsTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Class<?> columnClass = this.columnClasses.get(columnIndex);
            return columnClass == null ? Object.class : columnClass;
        }

        public void setColumnClass(int columnIndex, Class<?> columnClass) {
            if (columnClass == null) {
                throw new IllegalArgumentException(new NullPointerException());
            }
            if (columnClass == Object.class) {
                this.columnClasses.remove(columnIndex);
            } else {
                this.columnClasses.put(columnIndex, columnClass);
            }
        }
    }

    private static class ShapeAsID {
        private final ROIShape shape;
        private final String id;

        private ShapeAsID(ROIShape shape) {
            if (shape == null) {
                throw new IllegalArgumentException(new NullPointerException());
            }
            this.shape = shape;
            this.id = shape.getROI().isClientSide() ? "--" : Long.toString(shape.getROIShapeID());
        }

        public String toString() {
            return this.id;
        }

        private ROIShape getShape() {
            return this.shape;
        }
    }

    static enum State {
        ANALYSING,
        READY;

    }
}

