/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeSelectionModel;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FolderData;
import omero.gateway.model.ROIData;
import omero.gateway.util.Pojos;
import omero.log.LogMessage;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.ColumnFactory;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jhotdraw.draw.Figure;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.util.TabPaneInterface;
import org.openmicroscopy.shoola.agents.measurement.util.model.AnnotationDescription;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.ROINode;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.ROITableModel;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerControl;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerUI;
import org.openmicroscopy.shoola.agents.measurement.view.ROITable;
import org.openmicroscopy.shoola.agents.util.SelectionWizard;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.views.calls.ROIFolderSaver;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.ui.FancyTextField;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ObjectManager
extends JPanel
implements TabPaneInterface {
    private static Vector<String> COLUMN_NAMES = new Vector(6);
    private static Map<String, Integer> COLUMN_WIDTHS;
    private static final int INDEX = 1;
    private static final String NAME = "Manager";
    private static final String DEFAULT_FILTER_TEXT = "Filter ROI Folders...";
    private ROITable objectsTable;
    private MeasurementViewerModel model;
    private MeasurementViewerUI view;
    private MeasurementViewerControl control;
    private JToolBar bar;
    private JButton filterButton;
    private JTextField filterField;
    private TreeSelectionListener treeSelectionListener;
    private boolean initFilterMenuSelection = true;

    private void initComponents() {
        ROINode root = new ROINode("root");
        this.objectsTable = new ROITable(new ROITableModel(root, COLUMN_NAMES), COLUMN_NAMES, this);
        this.objectsTable.setRootVisible(false);
        this.treeSelectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreeSelectionModel tsm = ObjectManager.this.objectsTable.getTreeSelectionModel();
                if (tsm.isSelectionEmpty()) {
                    return;
                }
                int[] index = tsm.getSelectionRows();
                if (index.length == 0) {
                    return;
                }
                if (index.length == 1) {
                    ROINode node = (ROINode)ObjectManager.this.objectsTable.getNodeAtRow(ObjectManager.this.objectsTable.getSelectedRow());
                    if (node == null) {
                        return;
                    }
                    Object nodeValue = node.getUserObject();
                    ObjectManager.this.view.clearInspector();
                    if (nodeValue instanceof ROIShape) {
                        ObjectManager.this.view.selectFigure(((ROIShape)nodeValue).getFigure());
                    }
                    if (nodeValue instanceof FolderData) {
                        ObjectManager.this.view.selectFigure(null);
                    }
                    int col = ObjectManager.this.objectsTable.getSelectedColumn();
                    int row = ObjectManager.this.objectsTable.getSelectedRow();
                    if (row < 0 || col < 0) {
                        return;
                    }
                } else {
                    for (int i = 0; i < index.length; ++i) {
                        Object nodeValue;
                        ROIShape shape = ObjectManager.this.objectsTable.getROIShapeAtRow(index[i]);
                        if (shape != null) {
                            ObjectManager.this.view.selectFigure(shape.getFigure());
                            continue;
                        }
                        ROINode node = (ROINode)ObjectManager.this.objectsTable.getNodeAtRow(index[i]);
                        if (node == null || !((nodeValue = node.getUserObject()) instanceof FolderData)) continue;
                        ObjectManager.this.view.selectFigure(null);
                        break;
                    }
                }
            }
        };
        this.objectsTable.addTreeSelectionListener(this.treeSelectionListener);
        ColumnFactory columnFactory = new ColumnFactory(){

            public void configureColumnWidths(JXTable table, TableColumnExt columnExt) {
                columnExt.setPreferredWidth(((Integer)COLUMN_WIDTHS.get(columnExt.getHeaderValue())).intValue());
            }
        };
        this.objectsTable.setHorizontalScrollEnabled(true);
        this.objectsTable.setColumnControlVisible(true);
        this.objectsTable.setColumnFactory(columnFactory);
        IconManager icons = IconManager.getInstance();
        this.bar = new JToolBar();
        this.bar.setFloatable(false);
        this.bar.setRollover(true);
        this.bar.setBorder(null);
        this.filterButton = new JButton(icons.getIcon(49));
        this.filterButton.setText("Add ROI Folders");
        this.filterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectManager.this.showFilterDialog();
            }
        });
        this.filterField = new FancyTextField(DEFAULT_FILTER_TEXT, 50);
        this.filterField.addPropertyChangeListener("EDIT_PROPERTY", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ObjectManager.this.filterFolders((String)evt.getNewValue());
            }
        });
    }

    private void showFilterDialog() {
        ArrayList<Object> available = new ArrayList<Object>();
        ArrayList<Object> selected = new ArrayList<Object>();
        for (FolderData f : this.getFolders()) {
            if (this.objectsTable.getIDFilter().contains(f.getId())) {
                selected.add(f);
                continue;
            }
            available.add(f);
        }
        IconManager icons = IconManager.getInstance();
        SelectionWizard wizard = new SelectionWizard(MeasurementAgent.getRegistry().getTaskBar().getFrame(), available, selected, FolderData.class, this.canCreateFolder(), MeasurementAgent.getUserDetails());
        wizard.setTitle("Displayed Folders", "Select the folders which are displayed in the ROI table", icons.getIcon(48));
        wizard.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectedItems".equals(evt.getPropertyName())) {
                    Collection<FolderData> folders = Collections.EMPTY_LIST;
                    Map m = (Map)evt.getNewValue();
                    if (m == null || m.size() != 1) {
                        return;
                    }
                    folders = (Collection)m.get(FolderData.class);
                    Iterator it = folders.iterator();
                    ArrayList<FolderData> toSave = new ArrayList<FolderData>();
                    while (it.hasNext()) {
                        FolderData f = (FolderData)it.next();
                        if (f.getId() >= 0L) continue;
                        toSave.add(f);
                        it.remove();
                    }
                    if (!toSave.isEmpty()) {
                        folders.addAll(ObjectManager.this.model.saveROIFolders(toSave, false));
                    }
                    ObjectManager.this.handleFilterSelection(folders);
                }
            }
        });
        UIUtilities.centerAndShow(wizard);
    }

    private void handleFilterSelection(Collection<FolderData> folders) {
        this.objectsTable.getIDFilter().clear();
        for (FolderData f : folders) {
            this.objectsTable.getIDFilter().add(f.getId());
            this.objectsTable.getIDFilter().addAll(this.getAllDescendantIds(f));
        }
        this.rebuildTable();
    }

    private Collection<Long> getAllDescendantIds(FolderData f) {
        HashSet<Long> ids = new HashSet<Long>();
        for (FolderData fd : this.getFolders()) {
            if (!this.isAncestor(f, fd)) continue;
            ids.add(fd.getId());
        }
        return ids;
    }

    private boolean isAncestor(FolderData f1, FolderData f2) {
        if (f2.getParentFolder() != null) {
            if (f2.getParentFolder().getId() == f1.getId()) {
                return true;
            }
            return this.isAncestor(f1, f2.getParentFolder());
        }
        return false;
    }

    private void filterFolders(String text) {
        this.objectsTable.setNameFilter(text);
        this.rebuildTable();
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout());
        this.bar.add(this.filterButton);
        this.bar.add(this.filterField);
        this.add((Component)this.bar, "North");
        this.add((Component)new JScrollPane((Component)((Object)this.objectsTable)), "Center");
    }

    ObjectManager(MeasurementViewerUI view, MeasurementViewerControl control, MeasurementViewerModel model) {
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (control == null) {
            throw new IllegalArgumentException("No control.");
        }
        this.view = view;
        this.model = model;
        this.control = control;
        this.initComponents();
        this.buildGUI();
    }

    void showROIManagementMenu(int x, int y) {
        this.objectsTable.showROIManagementMenu(this.view.getDrawingView(), x, y);
    }

    void rebuildTable(Map<FolderData, Collection<ROIData>> result, ROIFolderSaver.ROIFolderAction action) {
        if (action == ROIFolderSaver.ROIFolderAction.CREATE_FOLDER || action == ROIFolderSaver.ROIFolderAction.ADD_TO_FOLDER && MapUtils.isNotEmpty(result)) {
            for (FolderData f : result.keySet()) {
                this.objectsTable.getIDFilter().add(f.getId());
            }
        }
        this.rebuildTable();
    }

    void rebuildTable() {
        if (this.initFilterMenuSelection) {
            for (FolderData f : this.model.getUsedFolders()) {
                this.objectsTable.getIDFilter().add(f.getId());
            }
            this.initFilterMenuSelection = false;
        }
        Set<Long> expandedFolderIds = this.objectsTable.getExpandedFolders();
        expandedFolderIds.addAll(Pojos.extractIds(this.objectsTable.getRecentlyModifiedFolders()));
        this.objectsTable.clear();
        this.objectsTable.initFolders(this.getFolders());
        this.objectsTable.addROIShapeList(this.extractShapes(this.model.getROI().values()));
        this.objectsTable.collapseAll();
        this.objectsTable.expandFolders(expandedFolderIds);
        this.objectsTable.setAutoCreateColumnsFromModel(false);
    }

    List<ROIShape> extractShapes(Collection<ROI> rois) {
        ArrayList<ROIShape> result = new ArrayList<ROIShape>();
        for (ROI roi : rois) {
            TreeMap<Coord3D, ROIShape> shapeList = roi.getShapes();
            result.addAll(shapeList.values());
        }
        return result;
    }

    String getComponentName() {
        return NAME;
    }

    Icon getComponentIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(2);
    }

    void addFigures(Collection l) {
        for (ROI roi : l) {
            Iterator<ROIShape> j = roi.getShapes().values().iterator();
            while (j.hasNext()) {
                this.objectsTable.addROIShape(j.next());
            }
        }
    }

    void addROIShapes(List<ROIShape> shapeList) {
        this.objectsTable.initFolders(this.getFolders());
        this.objectsTable.addROIShapeList(shapeList);
    }

    void setSelectedFigures(List<ROIShape> l, boolean clear) {
        Iterator<ROIShape> i = l.iterator();
        TreeSelectionModel tsm = this.objectsTable.getTreeSelectionModel();
        ROIFigure figure = null;
        if (clear) {
            tsm.clearSelection();
        }
        this.objectsTable.removeTreeSelectionListener(this.treeSelectionListener);
        try {
            while (i.hasNext()) {
                ROIShape shape = i.next();
                figure = shape.getFigure();
                this.objectsTable.selectROIShape(figure.getROIShape());
            }
            this.objectsTable.repaint();
            if (figure != null) {
                this.objectsTable.scrollToROIShape(figure.getROIShape());
            }
        }
        catch (Exception e) {
            MeasurementAgent.getRegistry().getLogger().info((Object)this, "Figure selection " + e);
        }
        this.objectsTable.addTreeSelectionListener(this.treeSelectionListener);
    }

    void removeFigure(ROIFigure figure) {
        if (figure == null) {
            return;
        }
        this.objectsTable.removeROIShape(figure.getROIShape());
        this.objectsTable.repaint();
    }

    void removeFigures(List<ROIFigure> figures) {
        if (figures == null || figures.size() == 0) {
            return;
        }
        Iterator<ROIFigure> i = figures.iterator();
        while (i.hasNext()) {
            this.objectsTable.removeROIShape(i.next().getROIShape());
        }
        this.objectsTable.repaint();
    }

    void deleteROIShapes(List<ROIShape> shapeList) {
        this.view.deleteROIShapes(shapeList);
        this.rebuildTable();
    }

    void reset() {
        this.model.getROIComponent().reset();
    }

    void duplicateROI(long id, List<ROIShape> shapeList) {
        this.view.duplicateROI(id, shapeList);
        this.rebuildTable();
    }

    void calculateStats(List<ROIShape> shapeList) {
        this.view.calculateStats(shapeList);
    }

    void mergeROI(List<Long> idList, List<ROIShape> shapeList) {
        this.view.mergeROI(idList, shapeList);
        this.rebuildTable();
    }

    void splitROI(long id, List<ROIShape> shapeList) {
        this.view.splitROI(id, shapeList);
        this.rebuildTable();
    }

    void update() {
        this.objectsTable.refresh();
        this.objectsTable.invalidate();
        this.objectsTable.repaint();
    }

    void propagateROI(ROI roi) {
        this.view.showROIAssistant(roi);
    }

    void showMessage(String messageString) {
        this.view.setStatus(messageString);
    }

    void showReadyMessage() {
        this.view.setReadyStatus();
    }

    void onSelectedFigures() {
        ArrayList<Object> tmp = new ArrayList<Object>();
        tmp.addAll(this.model.getSelectedFigures());
        this.objectsTable.onSelection(tmp);
    }

    Collection<Figure> getSelectedFigures() {
        return this.model.getSelectedFigures();
    }

    @Override
    public int getIndex() {
        return 1;
    }

    void loadTags() {
        this.control.loadTags();
    }

    Collection<Figure> getSelectedFiguresFromTables() {
        Collection<Object> l = this.objectsTable.getSelectedObjects();
        if (CollectionUtils.isEmpty(l)) {
            return null;
        }
        Iterator<Object> i = l.iterator();
        ArrayList<Figure> list = new ArrayList<Figure>();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof ROI) {
                ROI roi = (ROI)o;
                list.addAll(roi.getAllFigures());
                continue;
            }
            if (!(o instanceof ROIShape)) continue;
            ROIShape shape = (ROIShape)o;
            list.add(shape.getFigure());
        }
        return list;
    }

    public int getState() {
        return this.model.getState();
    }

    public void addRoisToFolder(Collection<ROIShape> selectedObjects, Collection<FolderData> folders) {
        List<ROIData> allRois = this.model.getROIData();
        HashMap<Long, ROIData> selectedRois = new HashMap<Long, ROIData>();
        for (ROIShape shape : selectedObjects) {
            ROIData rd;
            if (selectedRois.containsKey(shape.getID()) || (rd = this.findROI(allRois, shape.getROI())) == null) continue;
            selectedRois.put(shape.getID(), rd);
        }
        this.model.addROIsToFolder(allRois, selectedRois.values(), folders);
    }

    public void moveROIsToFolder(Collection<ROIShape> selectedObjects, Collection<FolderData> folders) {
        List<ROIData> allRois = this.model.getROIData();
        HashMap<Long, ROIData> selectedRois = new HashMap<Long, ROIData>();
        for (ROIShape shape : selectedObjects) {
            ROIData rd;
            if (selectedRois.containsKey(shape.getID()) || (rd = this.findROI(allRois, shape.getROI())) == null) continue;
            selectedRois.put(shape.getID(), rd);
        }
        this.model.moveROIsToFolder(allRois, selectedRois.values(), folders);
    }

    private ROIData findROI(Collection<ROIData> coll, ROI roi) {
        for (ROIData next : coll) {
            if (!next.getUuid().equals(roi.getUUID())) continue;
            return next;
        }
        return null;
    }

    public void deleteFolders(Collection<FolderData> folders) {
        this.saveROIs();
        this.model.deleteFolders(folders);
    }

    public void removeRoisFromFolder(Collection<ROIShape> selectedObjects, Collection<FolderData> folders) {
        this.saveROIs();
        HashMap<Long, ROIData> rois = new HashMap<Long, ROIData>();
        for (ROIShape shape : selectedObjects) {
            ROI roi = shape.getROI();
            if (roi.isClientSide() || rois.containsKey(roi.getID())) continue;
            ROIData data = new ROIData();
            data.setId(roi.getID());
            data.setImage(this.model.getImage().asImage());
            rois.put(roi.getID(), data);
        }
        this.model.removeROIsFromFolder(rois.values(), folders);
    }

    public void saveROIFolders(Collection<FolderData> folders) {
        this.saveROIs();
        this.model.saveROIFolders(folders, true);
    }

    public boolean canCreateFolder() {
        if (this.model.getImage() == null) {
            return false;
        }
        return this.model.getImage().canAnnotate();
    }

    Collection<FolderData> getFolders() {
        return this.model.getFolders();
    }

    private Collection<ROIData> saveROIs() {
        if (this.model.hasROIToSave()) {
            Registry reg = MeasurementAgent.getRegistry();
            List<ROIData> roiList = this.model.getROIData();
            ExperimenterData exp = MeasurementAgent.getUserDetails();
            OmeroImageService svc = reg.getImageService();
            try {
                return svc.saveROI(this.model.getSecurityContext(), this.model.getImageID(), exp.getId(), roiList);
            }
            catch (Exception e) {
                reg.getUserNotifier().notifyWarning("Could not save ROIs", "Failed to save some unsaved ROIs");
                reg.getLogger().warn((Object)this, new LogMessage("Could not save ROIs", (Throwable)e));
            }
        }
        return Collections.EMPTY_LIST;
    }

    static {
        COLUMN_NAMES.add("ROI");
        COLUMN_NAMES.add("id");
        COLUMN_NAMES.add("Z");
        COLUMN_NAMES.add("T");
        COLUMN_NAMES.add("Type");
        COLUMN_NAMES.add(AnnotationDescription.annotationDescription.get(AnnotationKeys.TEXT));
        COLUMN_NAMES.add("Show");
        COLUMN_WIDTHS = new HashMap<String, Integer>();
        COLUMN_WIDTHS.put(COLUMN_NAMES.get(0), 180);
        COLUMN_WIDTHS.put(COLUMN_NAMES.get(1), 36);
        COLUMN_WIDTHS.put(COLUMN_NAMES.get(2), 36);
        COLUMN_WIDTHS.put(COLUMN_NAMES.get(3), 36);
        COLUMN_WIDTHS.put(COLUMN_NAMES.get(4), 36);
        COLUMN_WIDTHS.put(COLUMN_NAMES.get(5), 96);
        COLUMN_WIDTHS.put(COLUMN_NAMES.get(6), 36);
    }
}

