/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata;

import java.io.File;
import omero.cmd.OriginalMetadataResponse;
import omero.gateway.SecurityContext;
import org.openmicroscopy.shoola.agents.metadata.EditorLoader;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.env.data.RequestCallback;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.util.OriginalMetadataParser;
import org.openmicroscopy.shoola.env.data.views.CallHandle;

public class OriginalMetadataLoader
extends EditorLoader {
    private CallHandle handle;
    private Object uiView;
    private long imageID;
    private File file;

    private void onNullResult() {
        super.handleNullResult();
        this.file.delete();
        this.viewer.setLoadedFile(null, null, this.uiView);
    }

    public OriginalMetadataLoader(Editor viewer, SecurityContext ctx, long imageID, Object uiView) {
        super(viewer, ctx);
        this.uiView = uiView;
        this.imageID = imageID;
        this.file = new File(MetadataViewerAgent.getTmpDir(), "image_" + imageID + "." + "txt");
        this.file.deleteOnExit();
    }

    @Override
    public void load() {
        this.handle = this.mhView.loadFile(this.ctx, this.file, this.imageID, 2, this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleNullResult() {
    }

    @Override
    public void update(DSCallFeedbackEvent fe) {
        Object o = fe.getPartialResult();
        if (o != null) {
            if (o instanceof Boolean) {
                Boolean b = (Boolean)o;
                if (!b.booleanValue()) {
                    this.onNullResult();
                }
            } else {
                RequestCallback callBack = (RequestCallback)((Object)o);
                callBack.setAdapter(this);
            }
        }
    }

    @Override
    public void handleResult(Object result) {
        if (result instanceof Boolean) {
            boolean b = (Boolean)result;
            if (!b) {
                this.onNullResult();
            }
        } else if (result instanceof OriginalMetadataResponse) {
            OriginalMetadataParser parser = new OriginalMetadataParser(this.file);
            try {
                parser.read((OriginalMetadataResponse)result, "=");
                this.viewer.setLoadedFile(null, this.file, this.uiView);
            }
            catch (Exception e) {
                this.onNullResult();
            }
        }
    }
}

