/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.DataObject;
import omero.gateway.model.FileAnnotationData;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.editor.AnnotationTaskPaneUI;
import org.openmicroscopy.shoola.agents.metadata.editor.DocComponent;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorUI;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.WrapLayout;

public class AttachmentsTaskPaneUI
extends AnnotationTaskPaneUI {
    private List<DocComponent> filesDocList = new ArrayList<DocComponent>();
    private JPopupMenu docSelectionMenu;
    private boolean selectable;
    private JButton removeDocsButton;
    private JButton addDocsButton;

    AttachmentsTaskPaneUI(EditorModel model, EditorUI view, EditorControl controller) {
        super(model, view, controller);
        this.setLayout(new WrapLayout(0));
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
    }

    boolean attachFiles(File[] files) {
        List<FileAnnotationData> list = this.getCurrentAttachmentsSelection();
        ArrayList<File> toAdd = new ArrayList<File>();
        for (int i = 0; i < files.length; ++i) {
            toAdd.add(files[i]);
        }
        if (toAdd.size() > 0) {
            try {
                Iterator j = toAdd.iterator();
                while (j.hasNext()) {
                    list.add(new FileAnnotationData((File)j.next()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.firePropertyChange("save", (Object)false, (Object)true);
        }
        this.layoutAttachments(list);
        return toAdd.size() > 0;
    }

    void removeAttachedFile(Object file) {
        FileAnnotationData data;
        if (file == null) {
            return;
        }
        FileAnnotationData fData = (FileAnnotationData)file;
        List<FileAnnotationData> attachments = this.getCurrentAttachmentsSelection();
        Iterator<FileAnnotationData> i = attachments.iterator();
        ArrayList<FileAnnotationData> toKeep = new ArrayList<FileAnnotationData>();
        while (i.hasNext()) {
            data = i.next();
            if (data.getId() == fData.getId()) continue;
            toKeep.add(data);
        }
        if (this.filesDocList.size() > 0) {
            for (DocComponent doc : this.filesDocList) {
                Object fa = doc.getData();
                if (!(fa instanceof FileAnnotationData) || (data = (FileAnnotationData)fa).getId() > 0L || data.equals(file)) continue;
                toKeep.add(data);
            }
        }
        this.handleObjectsSelection(FileAnnotationData.class, toKeep, true);
    }

    List<FileAnnotationData> removeAttachedFiles() {
        ArrayList<FileAnnotationData> list = new ArrayList<FileAnnotationData>();
        if (this.filesDocList.size() == 0) {
            return list;
        }
        ArrayList<FileAnnotationData> toKeep = new ArrayList<FileAnnotationData>();
        for (DocComponent doc : this.filesDocList) {
            Object object = doc.getData();
            if (doc.canUnlink()) {
                FileAnnotationData data;
                if (!(object instanceof FileAnnotationData) || (data = (FileAnnotationData)object).getId() <= 0L) continue;
                list.add(data);
                continue;
            }
            toKeep.add((FileAnnotationData)object);
        }
        this.handleObjectsSelection(FileAnnotationData.class, toKeep, false);
        return list;
    }

    void handleObjectsSelection(Class<?> type, Collection objects, boolean fire) {
        this.layoutAttachments(objects);
    }

    private List<FileAnnotationData> getCurrentAttachmentsSelection() {
        ArrayList<FileAnnotationData> list = new ArrayList<FileAnnotationData>();
        if (this.filesDocList.size() == 0) {
            return list;
        }
        for (DocComponent doc : this.filesDocList) {
            FileAnnotationData data;
            Object object = doc.getData();
            if (!(object instanceof FileAnnotationData) || (data = (FileAnnotationData)object).getId() <= 0L) continue;
            list.add(data);
        }
        return list;
    }

    @Override
    void refreshUI() {
        this.clearDisplay();
        Collection<FileAnnotationData> list = this.model.isMultiSelection() ? this.model.getAllAttachments() : this.model.getAttachments();
        this.layoutAttachments(list);
        this.addDocsButton.setEnabled(this.model.canAddAnnotationLink());
        this.removeDocsButton.setEnabled(this.model.canAddAnnotationLink());
    }

    void layoutAttachments(Collection list) {
        DocComponent doc;
        this.removeAll();
        this.filesDocList.clear();
        int h = 0;
        if (list != null && list.size() > 0) {
            Iterator i = list.iterator();
            switch (this.filter) {
                case SHOW_ALL: {
                    while (i.hasNext()) {
                        DataObject data = (DataObject)i.next();
                        doc = new DocComponent(data, this.model, true, this.selectable);
                        doc.addPropertyChangeListener(this.controller);
                        this.filesDocList.add(doc);
                        this.add(doc);
                        int v = doc.getPreferredSize().height;
                        if (h >= v) continue;
                        h = v;
                    }
                    break;
                }
                case ADDED_BY_OTHERS: {
                    while (i.hasNext()) {
                        DataObject data = (DataObject)i.next();
                        doc = new DocComponent(data, this.model, true, this.selectable);
                        doc.addPropertyChangeListener(this.controller);
                        this.filesDocList.add(doc);
                        if (!this.model.isAnnotatedByOther(data)) continue;
                        this.add(doc);
                        int v = doc.getPreferredSize().height;
                        if (h >= v) continue;
                        h = v;
                    }
                    break;
                }
                case ADDED_BY_ME: {
                    while (i.hasNext()) {
                        DataObject data = (DataObject)i.next();
                        doc = new DocComponent(data, this.model, true, this.selectable);
                        doc.addPropertyChangeListener(this.controller);
                        this.filesDocList.add(doc);
                        if (!this.model.isLinkOwner(data)) continue;
                        this.add(doc);
                        int v = doc.getPreferredSize().height;
                        if (h >= v) continue;
                        h = v;
                    }
                    break;
                }
            }
        }
        if (this.filesDocList.size() == 0) {
            doc = new DocComponent(null, this.model, true, false);
            this.filesDocList.add(doc);
            this.add(doc);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    void clearDisplay() {
        this.removeAll();
        this.filesDocList.clear();
    }

    @Override
    List<JButton> getToolbarButtons() {
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        IconManager icons = IconManager.getInstance();
        this.addDocsButton = new JButton(icons.getIcon(56));
        this.addDocsButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.addDocsButton.setToolTipText("Attach a file");
        this.addDocsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (AttachmentsTaskPaneUI.this.addDocsButton.isEnabled()) {
                    Point p = e.getPoint();
                    AttachmentsTaskPaneUI.this.createDocSelectionMenu().show(AttachmentsTaskPaneUI.this.addDocsButton, p.x, p.y);
                }
            }
        });
        UIUtilities.unifiedButtonLookAndFeel(this.addDocsButton);
        buttons.add(this.addDocsButton);
        this.removeDocsButton = new JButton(icons.getIcon(57));
        UIUtilities.unifiedButtonLookAndFeel(this.removeDocsButton);
        this.removeDocsButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.removeDocsButton.setToolTipText("Remove file");
        this.removeDocsButton.addMouseListener(this.controller);
        this.removeDocsButton.setActionCommand("20");
        buttons.add(this.removeDocsButton);
        final JButton selectButton = new JButton(icons.getIcon(81));
        selectButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        selectButton.setToolTipText("Select files for scripts");
        selectButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (selectButton.isEnabled()) {
                    AttachmentsTaskPaneUI.this.selectable = !AttachmentsTaskPaneUI.this.selectable;
                    AttachmentsTaskPaneUI.this.refreshUI();
                }
            }
        });
        UIUtilities.unifiedButtonLookAndFeel(selectButton);
        buttons.add(selectButton);
        return buttons;
    }

    private JPopupMenu createDocSelectionMenu() {
        if (this.docSelectionMenu != null) {
            return this.docSelectionMenu;
        }
        this.docSelectionMenu = new JPopupMenu();
        JMenuItem item = new JMenuItem("Local file...");
        item.setToolTipText("Import a local file to the server and attach it.");
        item.addActionListener(this.controller);
        item.setActionCommand("0");
        this.docSelectionMenu.add(item);
        item = new JMenuItem("Uploaded file...");
        item.setToolTipText("Attach a file already uploaded to the server.");
        item.addActionListener(this.controller);
        item.setActionCommand("1");
        this.docSelectionMenu.add(item);
        return this.docSelectionMenu;
    }

    @Override
    List<AnnotationData> getAnnotationsToSave() {
        Integer count;
        ArrayList<AnnotationData> l = new ArrayList<AnnotationData>();
        Collection<FileAnnotationData> original = this.model.getAllAttachments();
        Iterator<FileAnnotationData> j = original.iterator();
        ArrayList<Long> ids = new ArrayList<Long>();
        while (j.hasNext()) {
            ids.add(((AnnotationData)j.next()).getId());
        }
        Iterator<DocComponent> i = this.filesDocList.iterator();
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        HashMap<Long, AnnotationData> annotations = new HashMap<Long, AnnotationData>();
        while (i.hasNext()) {
            DocComponent doc = i.next();
            Object object = doc.getData();
            if (!(object instanceof FileAnnotationData)) continue;
            AnnotationData annotation = (AnnotationData)object;
            long id = annotation.getId();
            if (!ids.contains(id)) {
                l.add(annotation);
                continue;
            }
            count = (Integer)map.get(id);
            if (count != null) {
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
                map.put(id, count);
                continue;
            }
            count = 1;
            annotations.put(id, annotation);
            map.put(id, count);
        }
        Iterator k = map.entrySet().iterator();
        int n = this.filesDocList.size();
        while (k.hasNext()) {
            AnnotationData annotation;
            Map<DataObject, Boolean> m;
            Map.Entry entry = k.next();
            count = (Integer)entry.getValue();
            if (count == null || count != n || (m = this.model.getObjectsWith(annotation = (AnnotationData)annotations.get(entry.getKey()))).size() >= count) continue;
            l.add(annotation);
        }
        return l;
    }

    @Override
    List<Object> getAnnotationsToRemove() {
        long id;
        ArrayList<Object> l = new ArrayList<Object>();
        HashSet<Long> idsToKeep = new HashSet<Long>();
        for (DocComponent doc : this.filesDocList) {
            AnnotationData annotationData;
            Object object = doc.getData();
            if (!(object instanceof FileAnnotationData) || (id = (annotationData = (AnnotationData)object).getId()) <= 0L) continue;
            idsToKeep.add(id);
        }
        Collection<FileAnnotationData> original = this.model.getAllAttachments();
        for (AnnotationData annotationData : original) {
            id = annotationData.getId();
            if (idsToKeep.contains(id)) continue;
            l.add(annotationData);
        }
        return l;
    }

    Collection<FileAnnotationData> getSelectedFileAnnotations() {
        ArrayList<FileAnnotationData> result = new ArrayList<FileAnnotationData>();
        for (DocComponent c : this.filesDocList) {
            if (!c.isSelected()) continue;
            result.add((FileAnnotationData)c.getData());
        }
        return result;
    }

    boolean hasAttachmentsToUnlink() {
        if (this.filesDocList.size() == 0) {
            return false;
        }
        for (DocComponent doc : this.filesDocList) {
            Object object = doc.getData();
            if (!doc.canUnlink() || !(object instanceof FileAnnotationData)) continue;
            return true;
        }
        return false;
    }

    @Override
    void onRelatedNodesSet() {
    }

    @Override
    int getUnfilteredAnnotationCount() {
        if (this.model.isMultiSelection()) {
            return this.model.getAllAttachments().size();
        }
        return this.model.getAttachments().size();
    }
}

