/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import ome.formats.model.UnitsFactory;
import ome.model.units.BigResult;
import omero.gateway.model.ChannelAcquisitionData;
import omero.gateway.model.ChannelData;
import omero.gateway.model.DataObject;
import omero.gateway.model.FilterSetData;
import omero.gateway.model.LightSourceData;
import omero.model.AcquisitionMode;
import omero.model.ContrastMethod;
import omero.model.Illumination;
import omero.model.Length;
import omero.model.LengthI;
import omero.model.PlaneInfo;
import org.apache.commons.lang.time.DateUtils;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.AcquisitionDataUI;
import org.openmicroscopy.shoola.agents.metadata.editor.DetectorComponent;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.FilterGroupComponent;
import org.openmicroscopy.shoola.agents.metadata.editor.LightSourceComponent;
import org.openmicroscopy.shoola.agents.util.DataComponent;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.env.data.model.EnumerationObject;
import org.openmicroscopy.shoola.util.ui.ColourIcon;
import org.openmicroscopy.shoola.util.ui.JLabelButton;
import org.openmicroscopy.shoola.util.ui.NumericalTextField;
import org.openmicroscopy.shoola.util.ui.OMEComboBox;
import org.openmicroscopy.shoola.util.ui.OMETextArea;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ChannelAcquisitionComponent
extends JPanel
implements PropertyChangeListener {
    private static final int GENERAL = 0;
    private static final DecimalFormat msFormat = new DecimalFormat("# ms");
    private static final DecimalFormat sFormat = new DecimalFormat("0.0 s");
    private AcquisitionDataUI parent;
    private ChannelData channel;
    private OMEComboBox illuminationBox;
    private OMEComboBox contrastMethodBox;
    private OMEComboBox modeBox;
    private Map<String, DataComponent> fieldsGeneral;
    private LightSourceComponent lightPane;
    private DetectorComponent detectorPane;
    private FilterGroupComponent filterSetPane;
    private FilterGroupComponent lightPathPane;
    private JLabelButton unsetGeneral;
    private boolean unsetGeneralShown;
    private JPanel generalPane;
    private boolean init;
    private EditorModel model;
    private JXTaskPane exposureTask;
    private ColourIcon icon;

    private void resetBoxes() {
        List<EnumerationObject> l = this.model.getChannelEnumerations(Editor.ILLUMINATION_TYPE);
        Object[] array = new EnumerationObject[l.size() + 1];
        Iterator<EnumerationObject> j = l.iterator();
        int i = 0;
        while (j.hasNext()) {
            array[i] = j.next();
            ++i;
        }
        array[i] = new EnumerationObject("Not Set");
        this.illuminationBox = EditorUtil.createComboBox(array);
        l = this.model.getChannelEnumerations(Editor.CONTRAST_METHOD);
        array = new EnumerationObject[l.size() + 1];
        j = l.iterator();
        i = 0;
        while (j.hasNext()) {
            array[i] = j.next();
            ++i;
        }
        array[i] = new EnumerationObject("Not Set");
        this.contrastMethodBox = EditorUtil.createComboBox(array);
        l = this.model.getChannelEnumerations(Editor.MODE);
        array = new EnumerationObject[l.size() + 1];
        j = l.iterator();
        i = 0;
        while (j.hasNext()) {
            array[i] = j.next();
            ++i;
        }
        array[i] = new EnumerationObject("Not Set");
        this.modeBox = EditorUtil.createComboBox(array);
        l = this.model.getChannelEnumerations(Editor.BINNING);
        array = new EnumerationObject[l.size() + 1];
        j = l.iterator();
        i = 0;
        while (j.hasNext()) {
            array[i] = j.next();
            ++i;
        }
        array[i] = new EnumerationObject("Not Set");
    }

    private void initComponents() {
        this.resetBoxes();
        this.fieldsGeneral = new LinkedHashMap<String, DataComponent>();
        this.detectorPane = new DetectorComponent(this.parent, this.model);
        this.lightPane = new LightSourceComponent(this.parent, this.model);
        this.unsetGeneral = null;
        this.unsetGeneralShown = false;
        this.generalPane = new JPanel();
        this.generalPane.setBorder(BorderFactory.createTitledBorder("Info"));
        this.generalPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.generalPane.setLayout(new GridBagLayout());
        this.exposureTask = EditorUtil.createTaskPane("Exposure Time");
        this.exposureTask.addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void displayUnsetGeneralFields() {
        this.unsetGeneralShown = !this.unsetGeneralShown;
        String s = "Show unset fields";
        if (this.unsetGeneralShown) {
            s = "Hide unset fields";
        }
        this.unsetGeneral.setText(s);
        this.parent.layoutFields(this.generalPane, this.unsetGeneral, this.fieldsGeneral, this.unsetGeneralShown);
    }

    private void transformGeneralSource(Map<String, Object> details) {
        JLabel label = new JLabel();
        Font font = label.getFont();
        int sizeLabel = font.getSize() - 2;
        List notSet = (List)details.get("NotSet");
        details.remove("NotSet");
        if (notSet.size() > 0 && this.unsetGeneral == null) {
            this.unsetGeneral = this.parent.formatUnsetFieldsControl();
            this.unsetGeneral.setActionID(0L);
            this.unsetGeneral.addPropertyChangeListener(this);
        }
        Set<Map.Entry<String, Object>> entrySet = details.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            JComponent area;
            Object selected;
            String key = entry.getKey();
            boolean set = !notSet.contains(key);
            Object value = entry.getValue();
            label = UIUtilities.setTextFont(key, 1, sizeLabel);
            label.setBackground(UIUtilities.BACKGROUND_COLOR);
            if ("Illumination".equals(key)) {
                selected = this.model.getChannelEnumerationSelected(Editor.ILLUMINATION_TYPE, (String)value);
                if (selected != null) {
                    this.illuminationBox.setSelectedItem(selected);
                } else {
                    set = false;
                    this.illuminationBox.setSelectedIndex(this.illuminationBox.getItemCount() - 1);
                }
                this.illuminationBox.setEditedColor(UIUtilities.EDITED_COLOR);
                area = this.illuminationBox;
            } else if ("Contrast Method".equals(key)) {
                selected = this.model.getChannelEnumerationSelected(Editor.ILLUMINATION_TYPE, (String)value);
                if (selected != null) {
                    this.contrastMethodBox.setSelectedItem(selected);
                } else {
                    set = false;
                    this.contrastMethodBox.setSelectedIndex(this.contrastMethodBox.getItemCount() - 1);
                }
                this.contrastMethodBox.setEditedColor(UIUtilities.EDITED_COLOR);
                area = this.contrastMethodBox;
            } else if ("Mode".equals(key)) {
                selected = this.model.getChannelEnumerationSelected(Editor.MODE, (String)value);
                if (selected != null) {
                    this.modeBox.setSelectedItem(selected);
                } else {
                    set = false;
                    this.modeBox.setSelectedIndex(this.modeBox.getItemCount() - 1);
                }
                this.modeBox.setEditedColor(UIUtilities.EDITED_COLOR);
                area = this.modeBox;
            } else if (value instanceof Number) {
                area = UIUtilities.createComponent(NumericalTextField.class, null);
                String v = "";
                if (value instanceof Double) {
                    v = "" + UIUtilities.roundTwoDecimals(((Number)value).doubleValue());
                    ((NumericalTextField)area).setNumberType(Double.class);
                } else if (value instanceof Float) {
                    v = "" + UIUtilities.roundTwoDecimals(((Number)value).doubleValue());
                    ((NumericalTextField)area).setNumberType(Float.class);
                } else {
                    v = "" + value;
                }
                ((NumericalTextField)area).setText(v);
                ((NumericalTextField)area).setEditedColor(UIUtilities.EDITED_COLOR);
            } else {
                area = UIUtilities.createComponent(OMETextArea.class, null);
                if (value == null || value.equals("")) {
                    set = false;
                    value = "None";
                }
                ((OMETextArea)area).setEditable(false);
                ((OMETextArea)area).setText((String)value);
                ((OMETextArea)area).setEditedColor(UIUtilities.EDITED_COLOR);
            }
            area.setEnabled(!set);
            DataComponent comp = new DataComponent(label, area);
            comp.setEnabled(false);
            comp.setSetField(!notSet.contains(key));
            this.fieldsGeneral.put(key, comp);
        }
    }

    private void buildGUI() {
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.parent.layoutFields(this.generalPane, this.unsetGeneral, this.fieldsGeneral, this.unsetGeneralShown);
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 2, 2, 0);
        constraints.weightx = 1.0;
        constraints.gridy = 0;
        if (this.generalPane.isVisible()) {
            this.add((Component)this.generalPane, constraints);
            ++constraints.gridy;
        }
        if (this.detectorPane.isVisible()) {
            this.add((Component)this.detectorPane, constraints);
            ++constraints.gridy;
        }
        if (this.lightPane.isVisible()) {
            this.add((Component)this.lightPane, constraints);
            ++constraints.gridy;
        }
        if (this.lightPathPane != null) {
            this.add((Component)this.lightPathPane, constraints);
            ++constraints.gridy;
        }
        if (this.filterSetPane != null) {
            this.add((Component)this.filterSetPane, constraints);
            ++constraints.gridy;
        }
        constraints.fill = 2;
        this.add((Component)this.exposureTask, constraints);
        this.parent.attachListener(this.fieldsGeneral);
    }

    ChannelAcquisitionComponent(AcquisitionDataUI parent, EditorModel model, ChannelData channel) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (parent == null) {
            throw new IllegalArgumentException("No parent.");
        }
        if (channel == null) {
            throw new IllegalArgumentException("No channel.");
        }
        this.model = model;
        this.channel = channel;
        this.parent = parent;
        this.initComponents();
    }

    int getChannelIndex() {
        return this.channel.getIndex();
    }

    void setChannelColor(Color color) {
        if (color == null) {
            return;
        }
        if (this.icon == null) {
            this.icon = new ColourIcon(color);
            this.icon.paintLineBorder(true);
        } else {
            this.icon.setColour(color);
        }
    }

    void setLookupTable(String lut) {
        if (lut == null) {
            return;
        }
        if (this.icon == null) {
            this.icon = new ColourIcon(lut);
            this.icon.paintLineBorder(true);
        } else {
            this.icon.setLookupTable(lut);
        }
    }

    Icon getIcon() {
        return this.icon;
    }

    void setChannelAcquisitionData(int index) {
        if (this.channel.getIndex() != index) {
            return;
        }
        if (!this.init) {
            FilterSetData set;
            this.init = true;
            this.resetBoxes();
            this.removeAll();
            this.fieldsGeneral.clear();
            ChannelAcquisitionData data = this.model.getChannelAcquisitionData(this.channel.getIndex());
            Map<String, Object> details = EditorUtil.transformChannelData(this.channel);
            List notSet = (List)details.get("NotSet");
            this.generalPane.setVisible(false);
            if (notSet.size() != 10) {
                this.transformGeneralSource(details);
                this.generalPane.setVisible(true);
            }
            details = EditorUtil.transformDetectorAndSettings(data);
            notSet = (List)details.get("NotSet");
            this.detectorPane.setVisible(false);
            if (notSet.size() != 12) {
                this.detectorPane.displayDetector(details);
                this.detectorPane.setVisible(true);
            }
            details = EditorUtil.transformLightSourceAndSetting(data);
            String kind = (String)details.get("Light");
            details.remove("Light");
            notSet = (List)details.get("NotSet");
            this.lightPane.setVisible(false);
            int n = 9;
            if (LightSourceData.LASER.equals(kind)) {
                n = 15;
            }
            if (notSet.size() != n) {
                this.lightPane.displayLightSource(kind, details);
                this.lightPane.setVisible(true);
            }
            if ((set = data.getFilterSet()) != null) {
                this.filterSetPane = new FilterGroupComponent(this.parent, this.model, (DataObject)set);
            }
            if ((set = data.getLightPath()) != null) {
                this.lightPathPane = new FilterGroupComponent(this.parent, this.model, (DataObject)set);
            }
            this.buildGUI();
            this.exposureTask.setCollapsed(false);
        }
    }

    private String getReadableTime(double tInS) {
        if (tInS == 0.0) {
            return "0 s";
        }
        Calendar date = Calendar.getInstance();
        date = DateUtils.truncate((Calendar)date, (int)1);
        date.add(14, (int)(tInS * 1000.0));
        if (tInS > 82800.0) {
            date = DateUtils.round((Calendar)date, (int)12);
            int d = date.get(6) - 1;
            int h = date.get(11);
            int m = date.get(12);
            return d + " d " + h + " h " + (m > 0 ? m + " min " : "");
        }
        if (tInS > 3540.0) {
            date = DateUtils.round((Calendar)date, (int)12);
            int h = date.get(11);
            int m = date.get(12);
            return h + " h " + m + " min";
        }
        if (tInS > 59.0) {
            date = DateUtils.round((Calendar)date, (int)13);
            int m = date.get(12);
            int s = date.get(13);
            return m + " min " + s + " s";
        }
        if (tInS > 0.9) {
            return sFormat.format(tInS);
        }
        return msFormat.format(tInS * 1000.0);
    }

    void setPlaneInfo(int index) {
        if (this.channel.getIndex() != index) {
            return;
        }
        Collection result = this.model.getChannelPlaneInfo(index);
        Object[][] values = new String[2][result.size() + 1];
        Object[] names = new String[result.size() + 1];
        int i = 0;
        Iterator j = result.iterator();
        names[0] = "t";
        values[0][i] = "Delta T";
        values[1][i] = "Exposure";
        ++i;
        while (j.hasNext()) {
            double tInS;
            PlaneInfo info = (PlaneInfo)j.next();
            Map<String, Object> details = EditorUtil.transformPlaneInfo(info);
            List notSet = (List)details.get("NotSet");
            if (!notSet.contains("DeltaT")) {
                if (details.get("DeltaT") instanceof BigResult) {
                    MetadataViewerAgent.logBigResultExeption(this, details.get("DeltaT"), "DeltaT");
                    values[0][i] = "N/A";
                } else {
                    tInS = (Double)details.get("DeltaT");
                    values[0][i] = this.getReadableTime(tInS);
                }
            } else {
                values[0][i] = "--";
            }
            if (!notSet.contains("Exposure Time")) {
                if (details.get("Exposure Time") instanceof BigResult) {
                    MetadataViewerAgent.logBigResultExeption(this, details.get("Exposure Time"), "Exposure Time");
                    values[1][i] = "N/A";
                } else {
                    tInS = (Double)details.get("Exposure Time");
                    values[1][i] = this.getReadableTime(tInS);
                }
            } else {
                values[1][i] = "--";
            }
            names[i] = "t=" + i;
            ++i;
        }
        if (i > 1) {
            JTable table = new JTable(values, names);
            table.setAutoResizeMode(0);
            table.setShowGrid(true);
            table.setGridColor(Color.LIGHT_GRAY);
            JScrollPane pane = new JScrollPane(table);
            Dimension d = table.getPreferredSize();
            Dimension de = this.exposureTask.getPreferredSize();
            pane.setPreferredSize(new Dimension(de.width - 10, 4 * d.height));
            this.exposureTask.add((Component)pane);
            this.exposureTask.setVisible(true);
        } else {
            this.exposureTask.setVisible(false);
        }
    }

    boolean hasDataToSave() {
        boolean b = this.parent.hasDataToSave(this.fieldsGeneral);
        if (b) {
            return true;
        }
        b = this.detectorPane.hasDataToSave();
        if (b) {
            return true;
        }
        b = this.lightPane.hasDataToSave();
        if (b) {
            return true;
        }
        if (this.lightPathPane != null && (b = this.lightPathPane.hasDataToSave())) {
            return true;
        }
        return this.filterSetPane != null && (b = this.filterSetPane.hasDataToSave());
    }

    List<Object> prepareDataToSave() {
        ArrayList<Object> data = new ArrayList<Object>();
        if (!this.hasDataToSave()) {
            return data;
        }
        if (this.channel.isDirty()) {
            for (Map.Entry<String, DataComponent> entry : this.fieldsGeneral.entrySet()) {
                EnumerationObject enumObject;
                Number number;
                String key = entry.getKey();
                DataComponent comp = entry.getValue();
                if (!comp.isDirty()) continue;
                Object value = comp.getAreaValue();
                if ("Name".equals(key)) {
                    this.channel.setName((String)value);
                    continue;
                }
                if ("Pinhole size".equals(key)) {
                    number = UIUtilities.extractNumber((String)value, Float.class);
                    if (number == null) continue;
                    this.channel.setPinholeSize((Length)new LengthI((double)((Float)number).floatValue(), UnitsFactory.Channel_PinholeSize));
                    continue;
                }
                if ("NDFilter (%)".equals(key)) {
                    number = UIUtilities.extractNumber((String)value, Float.class);
                    if (number == null) continue;
                    this.channel.setNDFilter((double)((Float)number).floatValue());
                    continue;
                }
                if ("PockelCell".equals(key)) {
                    number = UIUtilities.extractNumber((String)value, Integer.class);
                    if (number == null) continue;
                    this.channel.setPockelCell(((Integer)value).intValue());
                    continue;
                }
                if ("Emission".equals(key)) {
                    number = UIUtilities.extractNumber((String)value, Double.class);
                    if (number == null) continue;
                    this.channel.setEmissionWavelength((Length)new LengthI(((Double)number).doubleValue(), UnitsFactory.Channel_EmissionWavelength));
                    continue;
                }
                if ("Excitation".equals(key)) {
                    number = UIUtilities.extractNumber((String)value, Double.class);
                    if (number == null) continue;
                    this.channel.setExcitationWavelength((Length)new LengthI(((Double)number).doubleValue(), UnitsFactory.Channel_ExcitationWavelength));
                    continue;
                }
                if ("Illumination".equals(key)) {
                    enumObject = (EnumerationObject)value;
                    if (!(enumObject.getObject() instanceof Illumination)) continue;
                    this.channel.setIllumination((Illumination)enumObject.getObject());
                    continue;
                }
                if ("Mode".equals(key)) {
                    enumObject = (EnumerationObject)value;
                    if (!(enumObject.getObject() instanceof AcquisitionMode)) continue;
                    this.channel.setMode((AcquisitionMode)enumObject.getObject());
                    continue;
                }
                if (!"Contrast Method".equals(key) || !((enumObject = (EnumerationObject)value).getObject() instanceof ContrastMethod)) continue;
                this.channel.setContrastMethod((ContrastMethod)enumObject.getObject());
            }
            data.add(this.channel);
        }
        return data;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("selected".equals(name)) {
            this.displayUnsetGeneralFields();
        } else if ("collapsed".equals(name)) {
            this.parent.loadPlaneInfo(this.channel.getIndex());
        }
    }
}

