/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.DataObject;
import omero.gateway.model.TextualAnnotationData;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.agents.metadata.editor.AnnotationTaskPaneUI;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorUI;
import org.openmicroscopy.shoola.agents.metadata.editor.TextualAnnotationComponent;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.border.SeparatorOneLineBorder;
import org.openmicroscopy.shoola.util.ui.omeeditpane.OMEWikiComponent;

public class CommentsTaskPaneUI
extends AnnotationTaskPaneUI
implements DocumentListener {
    static final Border EDIT_BORDER = BorderFactory.createLineBorder(Color.LIGHT_GRAY);
    private OMEWikiComponent commentArea;
    private GridBagConstraints constraints;
    private Color bgColor;
    private List annotationToDisplay;
    private List annotationToRemove;
    private JScrollPane pane;
    private JButton addButton;

    CommentsTaskPaneUI(EditorModel model, EditorUI view, EditorControl controller) {
        super(model, view, controller);
        this.initComponents();
    }

    @Override
    List<AnnotationData> getAnnotationsToSave() {
        ArrayList<AnnotationData> l = new ArrayList<AnnotationData>();
        String text = this.commentArea.getText();
        if (CommonsLangUtils.isNotBlank(text)) {
            l.add((AnnotationData)new TextualAnnotationData(text));
        }
        return l;
    }

    @Override
    List<Object> getAnnotationsToRemove() {
        ArrayList<Object> l = new ArrayList<Object>();
        if (this.annotationToRemove != null) {
            l.addAll(this.annotationToRemove);
        }
        return l;
    }

    @Override
    void refreshUI() {
        this.clearDisplay();
        this.buildGUI();
        this.displayAnnotations(this.model.getTextualAnnotationsByDate());
    }

    private void initComponents() {
        this.commentArea = new OMEWikiComponent(false);
        this.commentArea.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.commentArea.addPropertyChangeListener(this.controller);
        this.commentArea.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        this.commentArea.setComponentBorder(EDIT_BORDER);
        this.commentArea.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent arg0) {
                if (CommonsLangUtils.isBlank(CommentsTaskPaneUI.this.commentArea.getText())) {
                    CommentsTaskPaneUI.this.pane.getViewport().setPreferredSize(null);
                    CommentsTaskPaneUI.this.revalidate();
                    CommentsTaskPaneUI.this.pane.revalidate();
                }
            }

            @Override
            public void focusGained(FocusEvent arg0) {
                Dimension d = CommentsTaskPaneUI.this.commentArea.getSize();
                CommentsTaskPaneUI.this.pane.getViewport().setPreferredSize(new Dimension(d.width, 60));
                CommentsTaskPaneUI.this.revalidate();
                CommentsTaskPaneUI.this.pane.revalidate();
            }
        });
        this.setBorder(new SeparatorOneLineBorder());
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.addButton = new JButton("Add comment");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommentsTaskPaneUI.this.saveComment();
            }
        });
        this.addButton.setEnabled(false);
        this.pane = new JScrollPane(this.commentArea);
        this.pane.setBorder(null);
        this.setLayout(new GridBagLayout());
        this.buildGUI();
    }

    private void setAreaText(String text) {
        this.commentArea.removeDocumentListener(this);
        this.commentArea.setText(text);
        this.commentArea.addDocumentListener(this);
    }

    private void buildGUI() {
        this.removeAll();
        this.bgColor = UIUtilities.BACKGROUND_COLOUR_ODD;
        this.constraints = new GridBagConstraints();
        this.constraints.insets = new Insets(2, 0, 2, 0);
        this.constraints.fill = 1;
        this.constraints.anchor = 18;
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.add((Component)this.pane, this.constraints);
        ++this.constraints.gridy;
        this.constraints.weightx = 0.0;
        this.constraints.weighty = 0.0;
        this.constraints.fill = 0;
        this.constraints.anchor = 17;
        this.add((Component)this.addButton, this.constraints);
        ++this.constraints.gridy;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.fill = 2;
        this.constraints.anchor = 18;
    }

    private void displayAnnotations(List list) {
        this.annotationToDisplay = list;
        boolean enabled = this.model.canAnnotate();
        if (enabled && this.model.isMultiSelection()) {
            enabled = !this.model.isAcrossGroups();
        }
        this.commentArea.setEnabled(enabled);
        this.buildGUI();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (Object obj : this.annotationToDisplay) {
                TextualAnnotationData data = (TextualAnnotationData)obj;
                if (this.filter != AnnotationTaskPaneUI.Filter.SHOW_ALL && (this.filter != AnnotationTaskPaneUI.Filter.ADDED_BY_ME || !this.model.isLinkOwner(data)) && (this.filter != AnnotationTaskPaneUI.Filter.ADDED_BY_OTHERS || !this.model.isAnnotatedByOther((DataObject)data))) continue;
                TextualAnnotationComponent comp = new TextualAnnotationComponent(this.model, data);
                comp.addPropertyChangeListener(this.controller);
                comp.setAreaColor(this.bgColor);
                this.add((Component)comp, this.constraints);
                ++this.constraints.gridy;
                if (this.bgColor == UIUtilities.BACKGROUND_COLOUR_ODD) {
                    this.bgColor = UIUtilities.BACKGROUND_COLOUR_EVEN;
                    continue;
                }
                this.bgColor = UIUtilities.BACKGROUND_COLOUR_ODD;
            }
        }
        this.revalidate();
        this.repaint();
    }

    void removeTextualAnnotation(TextualAnnotationData annotation) {
        if (this.annotationToRemove == null) {
            this.annotationToRemove = new ArrayList();
        }
        this.annotationToRemove.clear();
        this.annotationToRemove.add(annotation);
        List l = this.model.getTextualAnnotationsByDate();
        ArrayList<TextualAnnotationData> toKeep = new ArrayList<TextualAnnotationData>();
        if (l != null) {
            for (Object o : l) {
                TextualAnnotationData data;
                if (!(o instanceof TextualAnnotationData) || (data = (TextualAnnotationData)o).getId() == annotation.getId()) continue;
                toKeep.add(data);
            }
        }
        this.displayAnnotations(toKeep);
        this.revalidate();
        this.repaint();
        this.firePropertyChange("save", (Object)false, (Object)true);
    }

    protected void buildUI() {
        this.buildGUI();
        if (this.model.isMultiSelection()) {
            this.displayAnnotations(null);
        } else {
            this.displayAnnotations(this.model.getTextualAnnotationsByDate());
        }
    }

    protected List<Object> getAnnotationToRemove() {
        ArrayList<Object> l = new ArrayList<Object>();
        if (this.annotationToRemove != null) {
            l.addAll(this.annotationToRemove);
        }
        return l;
    }

    protected List<AnnotationData> getAnnotationToSave() {
        ArrayList<AnnotationData> l = new ArrayList<AnnotationData>();
        String text = this.commentArea.getText();
        if (CommonsLangUtils.isNotBlank(text)) {
            l.add((AnnotationData)new TextualAnnotationData(text));
        }
        return l;
    }

    protected boolean hasDataToSave() {
        String text = this.commentArea.getText();
        return CommonsLangUtils.isNotBlank(text);
    }

    @Override
    protected void clearDisplay() {
        if (this.annotationToRemove != null) {
            this.annotationToRemove.clear();
        }
        this.annotationToDisplay = null;
        this.setAreaText("");
        this.addButton.setEnabled(this.model.canAddAnnotationLink());
    }

    private void saveComment() {
        List<AnnotationData> comments = this.getAnnotationToSave();
        if (!comments.isEmpty()) {
            this.view.saveData(true);
            this.commentArea.setText("");
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.addButton.setEnabled(this.hasDataToSave());
        this.firePropertyChange("save", Boolean.FALSE, Boolean.TRUE);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.addButton.setEnabled(this.hasDataToSave());
        this.firePropertyChange("save", Boolean.FALSE, Boolean.TRUE);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    void onRelatedNodesSet() {
        this.addButton.setEnabled(this.model.canAddAnnotationLink());
        this.refreshUI();
    }

    @Override
    int getUnfilteredAnnotationCount() {
        return this.model.getTextualAnnotationCount();
    }
}

