/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.BooleanAnnotationData;
import omero.gateway.model.DataObject;
import omero.gateway.model.DoubleAnnotationData;
import omero.gateway.model.LongAnnotationData;
import omero.gateway.model.TermAnnotationData;
import omero.gateway.model.TimeAnnotationData;
import omero.gateway.model.XMLAnnotationData;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.editor.AnnotationTaskPaneUI;
import org.openmicroscopy.shoola.agents.metadata.editor.DocComponent;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorUI;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class OtherTaskPaneUI
extends AnnotationTaskPaneUI {
    private List<DocComponent> otherList = new ArrayList<DocComponent>();
    private JButton removeButton;

    OtherTaskPaneUI(EditorModel model, EditorUI view, EditorControl controller) {
        super(model, view, controller);
        this.setLayout(new GridBagLayout());
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
    }

    @Override
    void clearDisplay() {
        this.removeAll();
        this.otherList.clear();
    }

    @Override
    void refreshUI() {
        this.clearDisplay();
        Collection<AnnotationData> l = !this.model.isMultiSelection() ? this.model.getOtherAnnotations() : this.model.getAllOtherAnnotations();
        this.layoutOthers(l);
    }

    List<AnnotationData> removeOtherAnnotation() {
        ArrayList<AnnotationData> list = new ArrayList<AnnotationData>();
        if (this.otherList.size() == 0) {
            return list;
        }
        ArrayList<AnnotationData> toKeep = new ArrayList<AnnotationData>();
        for (DocComponent doc : this.otherList) {
            Object object = doc.getData();
            if (doc.canUnlink()) {
                AnnotationData data;
                if (!(object instanceof AnnotationData) || (data = (AnnotationData)object).getId() <= 0L) continue;
                list.add(data);
                continue;
            }
            toKeep.add((AnnotationData)object);
        }
        this.handleObjectsSelection(AnnotationData.class, toKeep, false);
        return list;
    }

    void handleObjectsSelection(Class<?> type, Collection objects, boolean fire) {
        this.layoutOthers(objects);
    }

    private void layoutOthers(Collection list) {
        this.clearDisplay();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets = new Insets(1, 2, 1, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        if (!CollectionUtils.isEmpty((Collection)list)) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                c.gridx = 0;
                c.weightx = 0.0;
                c.fill = 0;
                DataObject item = (DataObject)i.next();
                if (this.filter != AnnotationTaskPaneUI.Filter.SHOW_ALL && (this.filter != AnnotationTaskPaneUI.Filter.ADDED_BY_ME || !this.model.isLinkOwner(item)) && (this.filter != AnnotationTaskPaneUI.Filter.ADDED_BY_OTHERS || !this.model.isAnnotatedByOther(item))) continue;
                DocComponent doc = new DocComponent(item, this.model);
                doc.addPropertyChangeListener(this.controller);
                this.otherList.add(doc);
                this.add((Component)new JLabel(this.getType((AnnotationData)item) + ":"), c);
                c.gridx = 1;
                c.weightx = 1.0;
                c.fill = 2;
                this.add((Component)doc, c);
                ++c.gridy;
            }
        }
    }

    private String getType(AnnotationData d) {
        if (d instanceof XMLAnnotationData) {
            return "XML";
        }
        if (d instanceof BooleanAnnotationData) {
            return "Boolean";
        }
        if (d instanceof DoubleAnnotationData) {
            return "Double";
        }
        if (d instanceof LongAnnotationData) {
            return "Long";
        }
        if (d instanceof TermAnnotationData) {
            return "Term";
        }
        if (d instanceof TimeAnnotationData) {
            return "Time";
        }
        return "";
    }

    @Override
    List<AnnotationData> getAnnotationsToSave() {
        return Collections.emptyList();
    }

    @Override
    List<Object> getAnnotationsToRemove() {
        long id;
        ArrayList<Object> l = new ArrayList<Object>();
        HashSet<Long> idsToKeep = new HashSet<Long>();
        for (DocComponent doc : this.otherList) {
            AnnotationData annotation;
            Object object = doc.getData();
            if (!(object instanceof AnnotationData) || (id = (annotation = (AnnotationData)object).getId()) <= 0L) continue;
            idsToKeep.add(id);
        }
        Collection<AnnotationData> original = this.model.getAllOtherAnnotations();
        for (AnnotationData annotation : original) {
            id = annotation.getId();
            if (idsToKeep.contains(id)) continue;
            l.add(annotation);
        }
        return l;
    }

    List<AnnotationData> getCurrentSelection() {
        ArrayList<AnnotationData> result = new ArrayList<AnnotationData>();
        for (DocComponent c : this.otherList) {
            result.add((AnnotationData)c.getData());
        }
        return result;
    }

    boolean hasOtherAnnotationsToUnlink() {
        if (this.otherList.size() == 0) {
            return false;
        }
        for (DocComponent doc : this.otherList) {
            Object object = doc.getData();
            if (!doc.canUnlink() || !(object instanceof AnnotationData)) continue;
            return true;
        }
        return false;
    }

    @Override
    List<JButton> getToolbarButtons() {
        ArrayList<JButton> l = new ArrayList<JButton>();
        IconManager icons = IconManager.getInstance();
        this.removeButton = new JButton(icons.getIcon(57));
        UIUtilities.unifiedButtonLookAndFeel(this.removeButton);
        this.removeButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.removeButton.setToolTipText("Remove Annotations");
        this.removeButton.addMouseListener(this.controller);
        this.removeButton.setActionCommand("25");
        l.add(this.removeButton);
        return l;
    }

    @Override
    void onRelatedNodesSet() {
        this.removeButton.setEnabled(this.model.canAddAnnotationLink());
    }

    @Override
    int getUnfilteredAnnotationCount() {
        if (this.model.isMultiSelection()) {
            return this.model.getAllOtherAnnotations().size();
        }
        return this.model.getOtherAnnotations().size();
    }
}

