/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import omero.gateway.model.DataObject;
import omero.gateway.model.TextualAnnotationData;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImage;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImageObject;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.omeeditpane.OMEWikiComponent;
import org.openmicroscopy.shoola.util.ui.omeeditpane.WikiDataObject;

class TextualAnnotationComponent
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private static final int EDIT = 0;
    private static final int DELETE = 1;
    private OMEWikiComponent area;
    private TextualAnnotationData data;
    private EditorModel model;
    private JMenuItem editButton;
    private JMenuItem deleteButton;
    private JButton menuButton;
    private JPopupMenu popMenu;
    private JPanel controlsBar;

    private void editComment() {
    }

    private void initialize() {
        this.area = new OMEWikiComponent(false);
        this.area.setEnabled(false);
        this.area.setOpaque(true);
        this.area.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        this.area.setText(this.data.getText());
        this.area.setAllowOneClick(true);
        this.area.addPropertyChangeListener(this);
        this.area.setWrapWord(true);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TextualAnnotationComponent.this.area.wrapText(TextualAnnotationComponent.this.getSize().width, null);
            }
        });
        IconManager icons = IconManager.getInstance();
        if (this.model.canEdit(this.data)) {
            this.editButton = new JMenuItem(icons.getIcon(54));
            this.editButton.setText("Edit");
            this.editButton.setActionCommand("0");
            this.editButton.addActionListener(this);
        }
        if (this.model.canDelete(this.data)) {
            this.menuButton = new JButton(icons.getIcon(96));
            UIUtilities.unifiedButtonLookAndFeel(this.menuButton);
            this.menuButton.setBackground(UIUtilities.BACKGROUND_COLOR);
            this.menuButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    TextualAnnotationComponent.this.showMenu(TextualAnnotationComponent.this.menuButton, e.getPoint());
                }
            });
            this.deleteButton = new JMenuItem(icons.getIcon(82));
            this.deleteButton.setText("Delete");
            this.deleteButton.addActionListener(this);
            this.deleteButton.setActionCommand("1");
        }
    }

    private void showMenu(JComponent invoker, Point p) {
        if (this.popMenu == null) {
            this.popMenu = new JPopupMenu();
            if (this.deleteButton != null) {
                this.popMenu.add(this.deleteButton);
            }
        }
        this.popMenu.show(invoker, p.x, p.y);
    }

    private JPanel buildToolBar() {
        this.controlsBar = new JPanel();
        this.controlsBar.setLayout(new FlowLayout(0, 0, 0));
        String owner = this.model.formatOwner((DataObject)this.data);
        String date = this.model.formatDate((DataObject)this.data);
        JLabel l = new JLabel(owner + " " + date);
        l.setFont(l.getFont().deriveFont(1));
        if (this.menuButton != null) {
            this.controlsBar.add(this.menuButton);
        }
        this.controlsBar.add(l);
        return this.controlsBar;
    }

    private void buildGUI() {
        this.setLayout(new FlowLayout(0, 0, 0));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(this.buildToolBar());
        p.add(this.area);
        this.add(p);
    }

    TextualAnnotationComponent(EditorModel model, TextualAnnotationData data) {
        this.data = data;
        this.model = model;
        this.initialize();
        this.buildGUI();
    }

    TextualAnnotationData getData() {
        return this.data;
    }

    void setAreaColor(Color color) {
        this.setBackground(color);
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            components[i].setBackground(color);
        }
        this.controlsBar.setBackground(color);
        if (this.menuButton != null) {
            this.menuButton.setBackground(color);
        }
        this.area.setBackground(color);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 1: {
                this.firePropertyChange("removeAnnotation", null, this);
                break;
            }
            case 0: {
                this.editComment();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        EventBus bus = MetadataViewerAgent.getRegistry().getEventBus();
        if ("wikiDataObject".equals(name)) {
            WikiDataObject object = (WikiDataObject)evt.getNewValue();
            long id = object.getId();
            switch (object.getIndex()) {
                case 2: {
                    if (id <= 0L) break;
                    ViewImage event = new ViewImage(this.model.getSecurityContext(), new ViewImageObject(id), null);
                    event.setPlugin(MetadataViewerAgent.runAsPlugin());
                    bus.post(event);
                }
            }
        }
    }
}

