/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.swingx.JXBusyLabel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.util.Rotation;
import org.openmicroscopy.shoola.agents.metadata.editor.UserUI;
import org.openmicroscopy.shoola.env.data.model.DiskQuota;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class UserDiskSpace
extends JScrollPane {
    private UserUI view;
    private JPanel data;

    private void buildChartNotAvailable() {
        JLabel l = UIUtilities.setTextFont("Unable to create chart");
        this.data.add((Component)UIUtilities.buildComponentPanelCenter(l), "Center");
    }

    UserDiskSpace(UserUI view) {
        this.view = view;
        this.data = new JPanel();
        this.data.setLayout(new BorderLayout());
        this.data.setPreferredSize(new Dimension(280, 270));
        this.data.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setPreferredSize(new Dimension(300, 270));
        this.getViewport().add(this.data);
    }

    void buildGUI() {
        this.data.removeAll();
        DiskQuota quota = this.view.isDiskSpaceLoaded();
        if (quota != null) {
            DefaultPieDataset dataset = new DefaultPieDataset();
            long free = quota.getAvailableSpace();
            long used = quota.getUsedSpace();
            if (free < 0L || used < 0L) {
                this.buildChartNotAvailable();
                return;
            }
            dataset.setValue((Comparable)((Object)("Free " + UIUtilities.formatFileSize(free))), (double)free);
            dataset.setValue((Comparable)((Object)("Used " + UIUtilities.formatFileSize(used))), (double)used);
            try {
                JFreeChart chart = ChartFactory.createPieChart3D((String)"", (PieDataset)dataset, (boolean)false, (boolean)true, (boolean)false);
                PiePlot3D plot = (PiePlot3D)chart.getPlot();
                plot.setDirection(Rotation.CLOCKWISE);
                plot.setForegroundAlpha(0.55f);
                this.data.add((Component)new ChartPanel(chart), "Center");
            }
            catch (Exception e) {
                this.buildChartNotAvailable();
            }
        } else {
            JXBusyLabel busyLabel = new JXBusyLabel();
            busyLabel.setBackground(UIUtilities.BACKGROUND_COLOR);
            busyLabel.setEnabled(true);
            busyLabel.setBusy(true);
            JPanel p = UIUtilities.buildComponentPanelCenter((JComponent)busyLabel);
            p.setBackground(UIUtilities.BACKGROUND_COLOR);
            this.data.add((Component)p, "Center");
        }
        this.revalidate();
        this.repaint();
    }

    void clearDisplay() {
        this.data.removeAll();
    }
}

