/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.ExperimenterData;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.jdesktop.swingx.VerticalLayout;
import org.openmicroscopy.shoola.agents.metadata.editor.AnnotationUI;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorUI;
import org.openmicroscopy.shoola.agents.metadata.editor.UserDiskSpace;
import org.openmicroscopy.shoola.agents.metadata.editor.UserProfile;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.env.data.model.DiskQuota;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class UserUI
extends AnnotationUI
implements PropertyChangeListener {
    static final String TITLE = "Disk Space";
    private static final String TITLE_DETAILS = "User settings";
    private UserProfile profile;
    private UserDiskSpace diskSpace;
    private JXTaskPane diskTask;
    private DiskQuota quota;

    private void initComponents(EditorControl control, EditorUI view) {
        this.profile = new UserProfile(this.model, view);
        this.profile.addPropertyChangeListener(control);
        JXTaskPane pane = EditorUtil.createTaskPane(TITLE_DETAILS);
        pane.setCollapsed(false);
        this.diskSpace = new UserDiskSpace(this);
        this.diskTask = EditorUtil.createTaskPane(TITLE);
        this.diskTask.add((Component)this.diskSpace, null, 0);
        this.diskTask.addPropertyChangeListener("collapsed", (PropertyChangeListener)this);
        JXTaskPaneContainer container = new JXTaskPaneContainer();
        container.setBackground(UIUtilities.BACKGROUND);
        if (container.getLayout() instanceof VerticalLayout) {
            VerticalLayout vl = (VerticalLayout)container.getLayout();
            vl.setGap(0);
        }
        container.add(pane);
        this.setLayout(new BorderLayout());
        this.add((Component)this.profile, "North");
    }

    UserUI(EditorModel model, EditorControl control, EditorUI view) {
        super(model);
        if (control == null) {
            throw new IllegalArgumentException("No control.");
        }
        this.initComponents(control, view);
    }

    void passwordChanged() {
        this.profile.passwordChanged();
    }

    Object getExperimenterToSave() {
        return this.profile.getExperimenterToSave();
    }

    void setDiskSpace(DiskQuota quota) {
        this.quota = quota;
    }

    DiskQuota isDiskSpaceLoaded() {
        return this.quota;
    }

    void setUserPhoto(BufferedImage photo) {
        this.profile.setUserPhoto(photo);
    }

    void setParentRootObject() {
        this.profile.setParentRootObject();
    }

    void setLDAPDetails(String result) {
        this.profile.setLDAPDetails(result);
    }

    @Override
    protected void buildUI() {
        this.profile.buildGUI();
        this.diskSpace.buildGUI();
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void clearData(Object oldObject) {
        this.quota = null;
        this.clearDisplay();
    }

    @Override
    protected void clearDisplay() {
        this.diskSpace.clearDisplay();
        this.diskSpace.revalidate();
    }

    @Override
    protected List<Object> getAnnotationToRemove() {
        return new ArrayList<Object>();
    }

    @Override
    protected List<AnnotationData> getAnnotationToSave() {
        return new ArrayList<AnnotationData>();
    }

    @Override
    protected String getComponentTitle() {
        return "";
    }

    @Override
    protected boolean hasDataToSave() {
        return this.profile.hasDataToSave();
    }

    @Override
    protected void setComponentTitle() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!(this.model.getRefObject() instanceof ExperimenterData)) {
            return;
        }
        if (this.diskTask.isCollapsed()) {
            this.model.cancelDiskSpaceLoading();
        } else {
            this.model.loadDiskSpace(this.model.getRefObject().getClass(), this.model.getRefObjectID());
        }
    }
}

