/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import omero.gateway.model.DataObject;
import omero.gateway.model.FileAnnotationData;
import org.jdesktop.swingx.JXBusyLabel;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.env.data.model.DownloadAndZipParam;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;
import org.openmicroscopy.shoola.util.ui.tdialog.TinyDialog;

public class AnalysisResultsItem
extends JPanel
implements ActionListener,
PropertyChangeListener {
    public static final String ANALYSIS_RESULTS_VIEW = "analysisResultsView";
    public static final String ANALYSIS_RESULTS_DELETE = "analysisResultsDelete";
    public static final String ANALYSIS_RESULTS_CANCEL = "analysisResultsCancel";
    private static final Dimension SIZE = new Dimension(14, 14);
    private static final String DEFAULT = "Results";
    private static final int DELETE = 0;
    private static final int VIEW = 1;
    private static final int CANCEL = 2;
    private static final int DOWNLOAD = 3;
    private List<FileAnnotationData> attachments;
    private DataObject data;
    private String nameSpace;
    private JButton resultsButton;
    private JMenuItem deleteButton;
    private JButton cancelButton;
    private JButton menuButton;
    private JMenuItem downloadButton;
    private JMenuItem infoButton;
    private JPopupMenu popMenu;
    private Map<FileAnnotationData, File> results;
    private Timestamp time;

    private void download() {
        String name = null;
        if (this.data instanceof FileAnnotationData) {
            name = ((FileAnnotationData)this.data).getFileName();
        }
        JFrame f = MetadataViewerAgent.getRegistry().getTaskBar().getFrame();
        FileChooser chooser = new FileChooser(f, 1, "Download", "Select where to download the files.", null, true);
        if (name != null && name.trim().length() > 0) {
            chooser.setSelectedFileFull(name);
        }
        IconManager icons = IconManager.getInstance();
        chooser.setTitleIcon(icons.getIcon(77));
        chooser.setApproveButtonText("Download");
        chooser.addPropertyChangeListener(this);
        chooser.centerDialog();
    }

    private void displayInformation(Point p) {
        StringBuffer buf = new StringBuffer();
        buf.append("<html><body>");
        buf.append("<b>Analysis Run: </b>" + UIUtilities.formatTime(this.time));
        buf.append("<br>");
        buf.append("<b>Number of files: </b>" + this.attachments.size());
        buf.append("<br>");
        Iterator<FileAnnotationData> i = this.attachments.iterator();
        while (i.hasNext()) {
            buf.append(i.next().getFileName());
            buf.append("<br>");
        }
        buf.append("</body></html>");
        JLabel l = new JLabel();
        l.setText(buf.toString());
        TinyDialog d = new TinyDialog(null, (JComponent)l, 1);
        d.setModal(true);
        d.getContentPane().setBackground(UIUtilities.BACKGROUND_COLOUR_EVEN);
        SwingUtilities.convertPointToScreen(p, this);
        d.pack();
        d.setLocation(p);
        d.setVisible(true);
    }

    private void showMenu(JComponent invoker, Point p) {
        if (this.popMenu == null) {
            this.popMenu = new JPopupMenu();
            this.popMenu.add(this.deleteButton);
            this.popMenu.add(this.downloadButton);
            this.popMenu.add(this.infoButton);
        }
        this.popMenu.show(invoker, p.x, p.y);
    }

    private String convertNameSpace(String nameSpace) {
        if (nameSpace == null || nameSpace.trim().length() == 0) {
            return DEFAULT;
        }
        String[] values = UIUtilities.splitString(nameSpace);
        return values[values.length - 1].toUpperCase();
    }

    private void buildGUI() {
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add(this.resultsButton);
        this.add(this.menuButton);
    }

    private void initComponents(String nameSpace, int index) {
        this.attachments = new ArrayList<FileAnnotationData>();
        this.nameSpace = nameSpace;
        this.resultsButton = new JButton();
        this.resultsButton.setText(this.convertNameSpace(nameSpace) + " #" + index);
        this.resultsButton.setOpaque(false);
        this.resultsButton.setForeground(UIUtilities.HYPERLINK_COLOR);
        this.resultsButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        UIUtilities.unifiedButtonLookAndFeel(this.resultsButton);
        this.resultsButton.setActionCommand("1");
        this.resultsButton.addActionListener(this);
        this.cancelButton = new JButton();
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText("Cancel results loading.");
        this.cancelButton.setOpaque(false);
        this.cancelButton.setForeground(UIUtilities.HYPERLINK_COLOR);
        this.cancelButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        UIUtilities.unifiedButtonLookAndFeel(this.cancelButton);
        this.cancelButton.setActionCommand("2");
        this.cancelButton.addActionListener(this);
        IconManager icons = IconManager.getInstance();
        this.deleteButton = new JMenuItem(icons.getIcon(82));
        this.deleteButton.setText("Delete");
        this.deleteButton.setToolTipText("Delete the results.");
        this.deleteButton.setActionCommand("0");
        this.deleteButton.addActionListener(this);
        this.downloadButton = new JMenuItem(icons.getIcon(59));
        this.downloadButton.setText("Download...");
        this.downloadButton.setToolTipText("Download the selected file.");
        this.downloadButton.setActionCommand("3");
        this.downloadButton.addActionListener(this);
        this.menuButton = new JButton(icons.getIcon(96));
        UIUtilities.unifiedButtonLookAndFeel(this.menuButton);
        this.menuButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.menuButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point p = e.getPoint();
                AnalysisResultsItem.this.showMenu(AnalysisResultsItem.this.menuButton, p);
            }
        });
        this.infoButton = new JMenuItem(icons.getIcon(19));
        this.infoButton.setText("Info...");
        this.infoButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point p = e.getPoint();
                AnalysisResultsItem.this.displayInformation(p);
            }
        });
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
    }

    public AnalysisResultsItem(DataObject data, String nameSpace, int index) {
        if (data == null) {
            throw new IllegalArgumentException("Object cannot be null.");
        }
        this.data = data;
        this.initComponents(nameSpace, index);
        this.buildGUI();
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public void addAttachment(FileAnnotationData file) {
        long userID = MetadataViewerAgent.getUserDetails().getId();
        if (this.time == null) {
            this.time = file.getLastModified();
            this.resultsButton.setToolTipText("Analysis run " + UIUtilities.formatTime(this.time));
        }
        if (file.getOwner().getId() == userID) {
            this.deleteButton.setVisible(true);
        }
        if (!this.attachments.contains(file)) {
            this.attachments.add(file);
        }
    }

    public DataObject getData() {
        return this.data;
    }

    public List<FileAnnotationData> getAttachments() {
        return this.attachments;
    }

    public void setLoadedFiles(Map<FileAnnotationData, File> results) {
        this.results = results;
    }

    public Map<FileAnnotationData, File> getResults() {
        return this.results;
    }

    public void notifyLoading(boolean load) {
        this.removeAll();
        if (load) {
            JXBusyLabel label = new JXBusyLabel(SIZE);
            label.setBusy(true);
            label.setEnabled(true);
            this.add((Component)label);
            this.add(this.cancelButton);
        } else {
            this.add(this.resultsButton);
            this.add(this.menuButton);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.firePropertyChange(ANALYSIS_RESULTS_DELETE, null, this);
                break;
            }
            case 1: {
                this.firePropertyChange(ANALYSIS_RESULTS_VIEW, null, this);
                break;
            }
            case 2: {
                this.firePropertyChange(ANALYSIS_RESULTS_CANCEL, null, this);
                break;
            }
            case 3: {
                this.download();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("approveSelection".equals(name)) {
            File[] files = (File[])evt.getNewValue();
            File folder = files[0];
            if (folder == null) {
                folder = UIUtilities.getDefaultFolder();
            }
            UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
            if (this.attachments == null || this.attachments.size() == 0) {
                return;
            }
            IconManager icons = IconManager.getInstance();
            DownloadAndZipParam downloadAndZipParam = new DownloadAndZipParam(this.attachments, folder, icons.getIcon(76));
        }
    }

    @Override
    public String toString() {
        return this.resultsButton.getText();
    }
}

