/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import omero.gateway.model.FilesetData;
import omero.model.Fileset;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.agents.metadata.editor.ImportType;
import org.openmicroscopy.shoola.agents.metadata.util.ExpandableTextPane;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.tdialog.TinyDialog;

public class FilesetInfoDialog
extends TinyDialog {
    public static final int DEFAULT_WIDTH = 400;
    public static final int DEFAULT_HEIGHT = 300;

    public FilesetInfoDialog() {
        super(null, null, 1, "");
    }

    public void setData(Collection<FilesetData> set, ImportType importType) {
        if (set == null) {
            return;
        }
        JPanel content = new JPanel();
        content.setLayout(new GridBagLayout());
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 12;
        if (CollectionUtils.isEmpty(set)) {
            JLabel l = new JLabel("No information available.");
            l.setBackground(UIUtilities.BACKGROUND_COLOR);
            content.add((Component)l, c);
        } else {
            int size = 0;
            FilesetData fsd = set.iterator().next();
            if (Fileset.class.isAssignableFrom(fsd.asIObject().getClass())) {
                size = ((Fileset)fsd.asIObject()).sizeOfUsedFiles();
            }
            String txt = size <= 1 ? "Image file" : "Image files";
            JLabel l = new JLabel(size + " " + txt);
            l.setBackground(UIUtilities.BACKGROUND_COLOR);
            content.add((Component)l, c);
            ++c.gridy;
            JSeparator sep = new JSeparator(0);
            sep.setBackground(UIUtilities.BACKGROUND_COLOR);
            content.add((Component)sep, c);
            ++c.gridy;
            String header = importType == ImportType.HARDLINK || importType == ImportType.SOFTLINK ? "Imported with <b>--transfer=" + importType.getSymbol() + "</b> from:" : "Imported from:";
            ExpandableTextPane t1 = new ExpandableTextPane();
            t1.setBackground(UIUtilities.BACKGROUND_COLOR);
            t1.setText(header + "<br/>" + this.getOriginPaths(set));
            content.add((Component)t1, c);
            ++c.gridy;
            JSeparator sep2 = new JSeparator(0);
            sep2.setBackground(UIUtilities.BACKGROUND_COLOR);
            content.add((Component)sep2, c);
            ++c.gridy;
            ExpandableTextPane t2 = new ExpandableTextPane();
            t2.setBackground(UIUtilities.BACKGROUND_COLOR);
            t2.setText("Path on server:<br/>" + this.getServerPaths(set));
            content.add((Component)t2, c);
        }
        this.setCanvas(new JScrollPane(content));
    }

    private String getOriginPaths(Collection<FilesetData> set) {
        StringBuilder sb = new StringBuilder();
        for (FilesetData data : set) {
            List paths = data.getUsedFilePaths();
            Iterator j = paths.iterator();
            while (j.hasNext()) {
                sb.append((String)j.next());
                sb.append("<br/>");
            }
        }
        return sb.toString();
    }

    private String getServerPaths(Collection<FilesetData> set) {
        StringBuilder sb = new StringBuilder();
        for (FilesetData data : set) {
            List paths = data.getAbsolutePaths();
            Iterator j = paths.iterator();
            while (j.hasNext()) {
                sb.append((String)j.next());
                sb.append("<br/>");
            }
        }
        return sb.toString();
    }

    public void open() {
        this.open(null);
    }

    public void open(Point location) {
        this.setResizable(true);
        this.getContentPane().setBackground(UIUtilities.BACKGROUND_COLOUR_EVEN);
        this.pack();
        Dimension size = this.getPreferredSize();
        if (size.width > 400) {
            size.width = 400;
        }
        if (size.height > 300) {
            size.height = 300;
        }
        size.height += 20;
        this.setSize(size);
        if (location != null) {
            this.setLocation(location);
            this.setVisible(true);
        } else {
            UIUtilities.centerAndShow(this);
        }
    }
}

