/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.filter.file.CustomizedFileFilter;
import org.openmicroscopy.shoola.util.filter.file.GIFFilter;
import org.openmicroscopy.shoola.util.filter.file.JPEGFilter;
import org.openmicroscopy.shoola.util.filter.file.PNGFilter;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.GenericFileChooser;

public class UploadPictureDialog
extends JDialog
implements ActionListener,
DocumentListener {
    public static final String UPLOAD_PHOTO_PROPERTY = "uploadPhoto";
    private static final Dimension H_SPACER_SIZE = new Dimension(3, 10);
    private static final int MAX_SIZE_BYTES = 204800;
    private static final String MAX_SIZE_STRING = UIUtilities.formatFileSize(204800L);
    private static final String TITLE = "Upload Photo";
    private static final String TEXT = "Select the photo (JPEG, GIF or PNG) to upload. Maximum size " + MAX_SIZE_STRING + ".";
    private static final int SAVE = 0;
    private static final int CANCEL = 1;
    private static final List<CustomizedFileFilter> FILTERS = new ArrayList<CustomizedFileFilter>();
    private GenericFileChooser chooser;
    private JButton saveButton;
    private JButton cancelButton;
    private JTextField scriptArea;

    private void setProperties() {
        this.setTitle(TITLE);
        this.setModal(true);
    }

    private void initComponents() {
        JLabel label;
        this.chooser = new GenericFileChooser();
        this.chooser.setAcceptAllFileFilterUsed(false);
        this.chooser.setDialogType(1);
        Iterator<CustomizedFileFilter> i = FILTERS.iterator();
        while (i.hasNext()) {
            this.chooser.addChoosableFileFilter(i.next());
        }
        this.chooser.setControlButtonsAreShown(false);
        this.saveButton = new JButton("Upload");
        this.saveButton.setToolTipText(UIUtilities.formatToolTipText("Upload the selected photo to the server."));
        this.saveButton.addActionListener(this);
        this.saveButton.setActionCommand("0");
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setToolTipText(UIUtilities.formatToolTipText("Closes the dialog."));
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand("1");
        this.scriptArea = (JTextField)UIUtilities.findComponent(this.chooser, JTextField.class);
        if (this.scriptArea != null) {
            this.scriptArea.getDocument().addDocumentListener(this);
            this.saveButton.setEnabled(false);
        }
        if ((label = (JLabel)UIUtilities.findComponent(this.chooser, JLabel.class)) != null) {
            label.setText("Photo to Upload:");
        }
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void handleTextUpdate() {
        if (this.scriptArea == null) {
            return;
        }
        String text = this.scriptArea.getText();
        boolean b = false;
        if (text != null && text.trim().length() > 0) {
            b = true;
            Iterator<CustomizedFileFilter> i = FILTERS.iterator();
            boolean supported = false;
            while (i.hasNext()) {
                CustomizedFileFilter filter = i.next();
                if (!filter.accept(text)) continue;
                supported = true;
                break;
            }
            if (!supported) {
                this.saveButton.setEnabled(false);
                return;
            }
        }
        this.saveButton.setEnabled(b);
    }

    private void upload() {
        UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
        File f = this.scriptArea != null ? new File(this.chooser.getCurrentDirectory().toString(), this.scriptArea.getText()) : this.chooser.getSelectedFile();
        if (f == null) {
            un.notifyInfo(TITLE, "Please select a photo.");
            return;
        }
        Iterator<CustomizedFileFilter> i = FILTERS.iterator();
        boolean supported = false;
        String format = "";
        while (i.hasNext()) {
            CustomizedFileFilter filter = i.next();
            if (!filter.accept(f)) continue;
            format = filter.getMIMEType();
            supported = true;
            break;
        }
        if (!supported) {
            un.notifyInfo(TITLE, "Only JPEG, GIF or PNG files can be uploaded.");
            return;
        }
        if (f.length() > 204800L) {
            un.notifyInfo(TITLE, "The file is too big, maximum size " + MAX_SIZE_STRING);
            return;
        }
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(f);
        l.add(format);
        this.firePropertyChange(UPLOAD_PHOTO_PROPERTY, null, l);
        this.setVisible(false);
        this.dispose();
    }

    private JPanel buildToolbar() {
        JPanel bar = new JPanel();
        bar.setBorder(null);
        bar.add(this.cancelButton);
        bar.add(Box.createRigidArea(H_SPACER_SIZE));
        bar.add(this.saveButton);
        JPanel p = UIUtilities.buildComponentPanelRight(bar);
        p.setOpaque(true);
        return p;
    }

    private JPanel buildControls() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout(0, 0));
        p.add((Component)this.chooser, "Center");
        p.add((Component)this.buildToolbar(), "South");
        return p;
    }

    private void buildGUI() {
        boolean supportsWindowDecorations;
        IconManager icons = IconManager.getInstance();
        TitlePanel tp = new TitlePanel(TITLE, TEXT, icons.getIcon(100));
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(0, 0));
        c.add((Component)((Object)tp), "North");
        c.add((Component)this.buildControls(), "Center");
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            this.getRootPane().setWindowDecorationStyle(6);
        }
    }

    public UploadPictureDialog(JFrame owner) {
        super(owner);
        this.setProperties();
        this.initComponents();
        this.buildGUI();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 1: {
                this.close();
                break;
            }
            case 0: {
                this.upload();
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.handleTextUpdate();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.handleTextUpdate();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    static {
        FILTERS.add(new GIFFilter());
        FILTERS.add(new JPEGFilter());
        FILTERS.add(new PNGFilter());
    }
}

