/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.ImageData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.CreateCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class CreateAction
extends TreeViewerAction {
    private static final String NAME = "New...";
    private static final String NAME_DATASET = "New Dataset...";
    private static final String NAME_TAG = "New Tag...";
    private static final String NAME_IMAGE = "New...";
    private static final String DESCRIPTION_TAG = "Create a new Tag and add it to the selected Tag Set.";
    private static final String DESCRIPTION_DATASET = "Create a new Dataset and add it to the selected Project.";
    private static final String DESCRIPTION_IMAGE = "Import the selected images.";
    private static final String DESCRIPTION = "Create a new element.";
    private int nodeType;

    @Override
    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        switch (browser.getState()) {
            case 11: 
            case 12: {
                this.setEnabled(false);
                break;
            }
            default: {
                this.onDisplayChange(browser.getLastSelectedDisplay());
            }
        }
    }

    @Override
    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (!TreeViewerAgent.canCreate()) {
            this.setEnabled(false);
            return;
        }
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(11));
        Browser browser = this.model.getSelectedBrowser();
        if (selectedDisplay == null || browser == null) {
            this.setEnabled(false);
            this.name = "New...";
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
            return;
        }
        TreeImageDisplay[] nodes = browser.getSelectedDisplays();
        if (nodes.length > 1) {
            this.setEnabled(false);
            this.name = "New...";
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        if (ho instanceof String || ho instanceof ExperimenterData) {
            this.setEnabled(false);
            this.name = "New...";
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        } else if (ho instanceof ProjectData) {
            this.setEnabled(this.model.canLink(ho));
            this.name = NAME_DATASET;
            this.nodeType = 1;
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_DATASET));
        } else if (ho instanceof ScreenData || ho instanceof DatasetData) {
            this.setEnabled(false);
            this.name = "New...";
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        } else if (ho instanceof TagAnnotationData) {
            String ns = ((TagAnnotationData)ho).getNameSpace();
            if ("openmicroscopy.org/omero/insight/tagset".equals(ns)) {
                this.setEnabled(this.model.canAnnotate(ho));
                this.nodeType = 2;
                this.putValue("SmallIcon", im.getIcon(69));
                this.name = NAME_TAG;
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_TAG));
            } else {
                this.setEnabled(false);
                this.name = "New...";
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
            }
        } else if (ho instanceof ImageData) {
            this.setEnabled(false);
            this.nodeType = 5;
            this.putValue("SmallIcon", im.getIcon(90));
            this.name = "New...";
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_IMAGE));
        } else {
            this.setEnabled(false);
            this.name = "New...";
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        }
        this.description = (String)this.getValue("ShortDescription");
    }

    public CreateAction(TreeViewer model) {
        super(model);
        this.name = "New...";
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        this.description = (String)this.getValue("ShortDescription");
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(11));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CreateCmd cmd = new CreateCmd(this.model, this.nodeType);
        cmd.execute();
    }
}

