/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import omero.gateway.SecurityContext;
import omero.gateway.model.GroupData;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.LogOff;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class LogOffAction
extends TreeViewerAction {
    public static final String NAME = "Switch User...";
    public static final String DESCRIPTION = "Reconnect as another user.";

    @Override
    protected void onBrowserStateChange(Browser browser) {
        if (this.model.isImporting()) {
            this.setEnabled(false);
            return;
        }
        if (browser != null) {
            this.setEnabled(browser.getState() == 15);
        }
    }

    public LogOffAction(TreeViewer model) {
        super(model);
        this.name = NAME;
        this.putValue("Name", NAME);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(156));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Registry reg = TreeViewerAgent.getRegistry();
        GroupData group = this.model.getSingleGroupDisplayed();
        LogOff evt = new LogOff();
        if (group != null) {
            evt.setSecurityContext(new SecurityContext(group.getId()));
        }
        reg.getEventBus().post(evt);
        reg.getUserNotifier().clearActivities();
    }
}

