/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import omero.gateway.model.ExperimenterData;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class RefreshExperimenterData
extends TreeViewerAction {
    private static final String NAME = "Refresh User";
    private static final String DESCRIPTION = "Refresh User's data.";

    @Override
    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        Browser b = this.model.getSelectedBrowser();
        if (b != null && b.getSelectedDisplays().length > 1) {
            this.setEnabled(false);
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        this.setEnabled(ho instanceof ExperimenterData);
    }

    public RefreshExperimenterData(TreeViewer model) {
        super(model);
        this.putValue("Name", NAME);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(10));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Browser b = this.model.getSelectedBrowser();
        if (b != null) {
            b.refreshExperimenterData();
        }
    }
}

