/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.view;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.FileData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PermissionData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.SearchResultCollection;
import omero.gateway.model.TagAnnotationData;
import omero.gateway.model.WellSampleData;
import omero.model.OriginalFile;
import omero.model.PlateAcquisition;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserFactory;
import org.openmicroscopy.shoola.agents.events.SaveData;
import org.openmicroscopy.shoola.agents.events.iviewer.CopyRndSettings;
import org.openmicroscopy.shoola.agents.events.iviewer.RndSettingsCopied;
import org.openmicroscopy.shoola.agents.events.treeviewer.ActivitiesEvent;
import org.openmicroscopy.shoola.agents.events.treeviewer.BrowserSelectionEvent;
import org.openmicroscopy.shoola.agents.events.treeviewer.ChangeUserGroupEvent;
import org.openmicroscopy.shoola.agents.events.treeviewer.CopyItems;
import org.openmicroscopy.shoola.agents.events.treeviewer.DeleteObjectEvent;
import org.openmicroscopy.shoola.agents.events.treeviewer.DisplayModeEvent;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.rnd.Renderer;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerFactory;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.ImageChecker;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ActionCmd;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ExperimenterVisitor;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.UpdateVisitor;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ViewCmd;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ViewInPluginCmd;
import org.openmicroscopy.shoola.agents.treeviewer.finder.ClearVisitor;
import org.openmicroscopy.shoola.agents.treeviewer.finder.Finder;
import org.openmicroscopy.shoola.agents.treeviewer.util.AdminDialog;
import org.openmicroscopy.shoola.agents.treeviewer.util.ChgrpObject;
import org.openmicroscopy.shoola.agents.treeviewer.util.GenericDialog;
import org.openmicroscopy.shoola.agents.treeviewer.util.LinkNotificationDialog;
import org.openmicroscopy.shoola.agents.treeviewer.util.MIFNotificationDialog;
import org.openmicroscopy.shoola.agents.treeviewer.util.MoveGroupSelectionDialog;
import org.openmicroscopy.shoola.agents.treeviewer.util.NotDeletedObjectDialog;
import org.openmicroscopy.shoola.agents.treeviewer.util.OpenWithDialog;
import org.openmicroscopy.shoola.agents.treeviewer.view.DeleteBox;
import org.openmicroscopy.shoola.agents.treeviewer.view.SearchEvent;
import org.openmicroscopy.shoola.agents.treeviewer.view.SearchSelectionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerControl;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerFactory;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerModel;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerWin;
import org.openmicroscopy.shoola.agents.util.DataObjectRegistration;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.SelectionWizard;
import org.openmicroscopy.shoola.agents.util.browser.ContainerFinder;
import org.openmicroscopy.shoola.agents.util.browser.NodesFinder;
import org.openmicroscopy.shoola.agents.util.browser.TreeFileSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeViewerTranslator;
import org.openmicroscopy.shoola.agents.util.finder.AdvancedFinder;
import org.openmicroscopy.shoola.agents.util.ui.EditorDialog;
import org.openmicroscopy.shoola.agents.util.ui.GroupManagerDialog;
import org.openmicroscopy.shoola.agents.util.ui.ScriptingDialog;
import org.openmicroscopy.shoola.agents.util.ui.UserManagerDialog;
import org.openmicroscopy.shoola.env.Environment;
import org.openmicroscopy.shoola.env.data.events.ExitApplication;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.data.model.AdminObject;
import org.openmicroscopy.shoola.env.data.model.ApplicationData;
import org.openmicroscopy.shoola.env.data.model.DeletableObject;
import org.openmicroscopy.shoola.env.data.model.DeleteActivityParam;
import org.openmicroscopy.shoola.env.data.model.DownloadActivityParam;
import org.openmicroscopy.shoola.env.data.model.DownloadArchivedActivityParam;
import org.openmicroscopy.shoola.env.data.model.ImageCheckerResult;
import org.openmicroscopy.shoola.env.data.model.OpenActivityParam;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.data.model.TimeRefObject;
import org.openmicroscopy.shoola.env.data.model.TransferableActivityParam;
import org.openmicroscopy.shoola.env.data.model.TransferableObject;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.PojosUtil;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;
import org.openmicroscopy.shoola.util.ui.component.ObservableComponent;

class TreeViewerComponent
extends AbstractComponent
implements TreeViewer {
    public static final String RENDERINGSETTINGS_WARNING = "This will change the rendering settings of all images\nin the dataset/plate and cannot be undone.\nProceed?";
    private TreeViewerModel model;
    private TreeViewerControl controller;
    private TreeViewerWin view;
    private UserManagerDialog switchUserDialog;
    private ScriptingDialog scriptDialog;

    private void moveObject(ChgrpObject object) {
        GroupData group = object.getGroupData();
        SecurityContext ctx = new SecurityContext(group.getId());
        long userID = object.getUserID();
        if (userID >= 0L) {
            ExperimenterData exp = this.model.getExperimenter();
            if (userID == exp.getId()) {
                Class<Object> type = object.getDataType();
                if (ImageData.class.equals(type) || DatasetData.class.equals(type)) {
                    type = ProjectData.class;
                } else if (ProjectData.class.equals(type)) {
                    type = null;
                } else if (PlateData.class.equals(type)) {
                    type = ScreenData.class;
                } else if (ScreenData.class.equals(type)) {
                    type = null;
                } else if (GroupData.class.equals(type) || ExperimenterData.class.equals(type)) {
                    type = null;
                }
                if (type != null) {
                    MoveGroupSelectionDialog dialog = new MoveGroupSelectionDialog(this.view, userID, object, true);
                    dialog.addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            String name = evt.getPropertyName();
                            if ("transfer".equals(name)) {
                                ChgrpObject v = (ChgrpObject)evt.getNewValue();
                                GroupData group = v.getGroupData();
                                SecurityContext ctx = new SecurityContext(group.getId());
                                TreeViewerComponent.this.moveData(ctx, v.getTarget(), v.getTransferable());
                            }
                        }
                    });
                    this.model.fireMoveDataLoading(ctx, dialog, type, userID);
                    UIUtilities.centerAndShow(dialog);
                }
            } else {
                this.moveData(ctx, object.getTarget(), object.getTransferable());
            }
        } else {
            this.moveData(ctx, object.getTarget(), object.getTransferable());
        }
    }

    private void delete(List nodes) {
        DeleteBox dialog;
        TreeImageDisplay node;
        if (nodes == null) {
            return;
        }
        Iterator i = nodes.iterator();
        Class<?> type = null;
        Boolean ann = null;
        Boolean leader = null;
        String ns = null;
        long userID = this.model.getExperimenter().getId();
        boolean notOwner = false;
        while (i.hasNext()) {
            node = (TreeImageDisplay)i.next();
            if (node.isAnnotated() && ann == null) {
                ann = true;
            }
            Object uo = node.getUserObject();
            type = uo.getClass();
            if (uo instanceof DataObject) {
                GroupData group;
                if (leader == null && EditorUtil.isUserGroupOwner(group = this.model.getGroup(((DataObject)uo).getGroupId()), userID)) {
                    leader = true;
                }
                if (((DataObject)uo).getOwner().getId() != userID) {
                    notOwner = true;
                }
            }
            if (!(uo instanceof TagAnnotationData)) continue;
            ns = ((TagAnnotationData)uo).getNameSpace();
        }
        boolean b = false;
        if (ann != null) {
            b = ann;
        }
        boolean le = false;
        if (leader != null) {
            le = leader;
        }
        if ((dialog = new DeleteBox(this.view, type, b, nodes.size(), ns, le, notOwner)).centerMsgBox() == 1) {
            boolean content = dialog.deleteContents();
            List<Class> types = dialog.getAnnotationTypes();
            i = nodes.iterator();
            ArrayList<DeletableObject> l = new ArrayList<DeletableObject>();
            ArrayList<DataObject> objects = new ArrayList<DataObject>();
            ArrayList<DataObject> values = null;
            ArrayList<Long> ids = new ArrayList<Long>();
            Class<?> klass = null;
            while (i.hasNext()) {
                node = (TreeImageDisplay)i.next();
                Object obj = node.getUserObject();
                if (obj instanceof GroupData || obj instanceof ExperimenterData) {
                    if (values == null) {
                        values = new ArrayList<DataObject>();
                    }
                    values.add((DataObject)obj);
                } else if (obj instanceof DataObject) {
                    DeletableObject d = new DeletableObject((DataObject)obj, content);
                    if (!(obj instanceof TagAnnotationData) && !(obj instanceof FileAnnotationData)) {
                        d.setAttachmentTypes(types);
                    }
                    this.checkForImages(node, objects, content);
                    l.add(d);
                }
                klass = obj.getClass();
                ids.add(((DataObject)obj).getId());
            }
            if (l.size() > 0) {
                this.model.setNodesToCopy(null, -1);
                EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
                bus.post(new DeleteObjectEvent(objects));
                NodesFinder finder = new NodesFinder(klass, ids);
                Browser browser = this.model.getSelectedBrowser();
                browser.accept(finder);
                browser.removeTreeNodes(finder.getNodes());
                this.view.removeAllFromWorkingPane();
                DataBrowserFactory.discardAll();
                this.model.getMetadataViewer().setRootObject(null, -1L, null);
                IconManager icons = IconManager.getInstance();
                DeleteActivityParam p = new DeleteActivityParam(icons.getIcon(142), l);
                p.setFailureIcon(icons.getIcon(141));
                UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
                un.notifyActivity(this.model.getSecurityContext(), p);
            }
            if (values != null) {
                NodesFinder finder = new NodesFinder(klass, ids);
                Browser browser = this.model.getSelectedBrowser();
                browser.accept(finder);
                browser.removeTreeNodes(finder.getNodes());
                this.view.removeAllFromWorkingPane();
                DataBrowserFactory.discardAll();
                this.model.getMetadataViewer().setRootObject(null, -1L, null);
                this.model.fireObjectsDeletion(values);
                this.fireStateChange();
            }
        }
    }

    private void checkForImages(TreeImageDisplay object, List<DataObject> objects, boolean content) {
        block8: {
            DataObject ho;
            List list;
            block10: {
                block9: {
                    block7: {
                        list = object.getChildrenDisplay();
                        ho = (DataObject)object.getUserObject();
                        if (!(ho instanceof ImageData)) break block7;
                        objects.add(ho);
                        break block8;
                    }
                    if (!(ho instanceof DatasetData) || !content) break block9;
                    if (!object.isChildrenLoaded()) break block8;
                    objects.add(ho);
                    break block8;
                }
                if (!(ho instanceof ProjectData) || !content) break block10;
                if (!object.isChildrenLoaded()) break block8;
                for (TreeImageDisplay child : list) {
                    if (!(child.getUserObject() instanceof DatasetData) || !child.isChildrenLoaded()) continue;
                    objects.add((DataObject)child.getUserObject());
                }
                break block8;
            }
            if (ho instanceof PlateData) {
                objects.add(ho);
            } else if (ho instanceof PlateAcquisitionData) {
                TreeImageDisplay parent = object.getParentDisplay();
                objects.add((DataObject)parent.getUserObject());
            } else if (ho instanceof ScreenData && content && object.isChildrenLoaded()) {
                for (TreeImageDisplay child : list) {
                    if (!(child.getUserObject() instanceof PlateData) || !child.isChildrenLoaded()) continue;
                    objects.add((DataObject)child.getUserObject());
                }
            }
        }
    }

    private String getGroupName(long groupId) {
        Collection groups = TreeViewerAgent.getAvailableUserGroups();
        for (GroupData group : groups) {
            if (group.getId() != groupId) continue;
            return group.getName();
        }
        return "";
    }

    private void removeNodes(Map<SecurityContext, List<DataObject>> trans) {
        EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
        ArrayList<DataObject> objects = new ArrayList<DataObject>();
        for (List<DataObject> l : trans.values()) {
            if (l == null) continue;
            objects.addAll(l);
        }
        bus.post(new DeleteObjectEvent(objects));
        NodesFinder finder = new NodesFinder(objects);
        Browser browser = this.model.getSelectedBrowser();
        browser.accept(finder);
        browser.removeTreeNodes(finder.getNodes());
        this.view.removeAllFromWorkingPane();
        DataBrowserFactory.discardAll();
        this.model.getMetadataViewer().setRootObject(null, -1L, null);
    }

    private void moveData(SecurityContext ctx, DataObject target, Map<SecurityContext, List<DataObject>> trans) {
        this.removeNodes(trans);
        TransferableObject t = new TransferableObject(ctx, target, trans);
        t.setGroupName(this.getGroupName(ctx.getGroupID()));
        IconManager icons = IconManager.getInstance();
        TransferableActivityParam param = new TransferableActivityParam(icons.getIcon(160), t);
        param.setFailureIcon(icons.getIcon(161));
        UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
        un.notifyActivity(this.model.getSecurityContext(), param);
    }

    private void notifyChangeGroup(long oldId) {
        long id = this.model.getSelectedGroupId();
        ChangeUserGroupEvent evt = new ChangeUserGroupEvent(id, oldId);
        TreeViewerAgent.getRegistry().getEventBus().post(evt);
        this.firePropertyChange("groupChanged", oldId, id);
    }

    private GroupData getContext(TreeImageDisplay node) {
        if (node == null) {
            return null;
        }
        if (node.getUserObject() instanceof GroupData) {
            return (GroupData)node.getUserObject();
        }
        TreeImageDisplay parent = node.getParentDisplay();
        if (parent == null) {
            Object ho = node.getUserObject();
            if (ho instanceof GroupData) {
                return (GroupData)ho;
            }
            return null;
        }
        Object ho = parent.getUserObject();
        if (ho instanceof GroupData) {
            return (GroupData)ho;
        }
        return this.getContext(parent);
    }

    private String getObjectType(Object object) {
        if (object instanceof DatasetData) {
            return "dataset";
        }
        if (object instanceof ProjectData) {
            return "project";
        }
        if (object instanceof GroupData) {
            return "group";
        }
        if (object instanceof ScreenData) {
            return "screen";
        }
        if (object instanceof PlateData) {
            return "plate";
        }
        if (object instanceof ImageData) {
            return "image";
        }
        if (object instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)object;
            if ("openmicroscopy.org/omero/insight/tagset".equals(tag.getNameSpace())) {
                return "tagSet";
            }
            return "tag";
        }
        return "item";
    }

    private void downloadFile(File folder, boolean override, FileAnnotationData fa, ApplicationData data) {
        UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
        OriginalFile f = (OriginalFile)fa.getContent();
        IconManager icons = IconManager.getInstance();
        DownloadActivityParam activity = new DownloadActivityParam(f, folder, icons.getIcon(110));
        activity.setFileName(fa.getFileName());
        un.notifyActivity(this.model.getSecurityContext(), activity);
    }

    private SecurityContext getKey(Map<SecurityContext, List<DataObject>> map, long id) {
        for (SecurityContext ctx : map.keySet()) {
            if (ctx.getGroupID() != id) continue;
            return ctx;
        }
        return null;
    }

    private DataBrowser handleDiscardedBrowser(TreeImageDisplay display) {
        List l;
        if (!DataBrowserFactory.hasBeenDiscarded(display)) {
            return null;
        }
        DataBrowser db = null;
        Browser browser = this.model.getSelectedBrowser();
        List<ApplicationData> app = null;
        if (display.isChildrenLoaded() && display.containsImages() && (l = display.getChildrenDisplay()) != null) {
            HashSet<Object> s = new HashSet<Object>();
            for (TreeImageDisplay child : l) {
                s.add(child.getUserObject());
            }
            this.setLeaves((TreeImageSet)display, s);
            db = DataBrowserFactory.getDataBrowser(display);
            List list = browser.getSelectedDataObjects();
            if (list != null && list.size() == 1) {
                app = TreeViewerFactory.getApplications(this.model.getObjectMimeType(list.get(0)));
            }
            db.setSelectedNodes(list, app);
        }
        return db;
    }

    private void showDataBrowser(Object object, TreeImageDisplay display, boolean visible) {
        Browser b;
        DataBrowser db = null;
        TreeImageDisplay parent = null;
        Browser browser = this.model.getSelectedBrowser();
        if (display != null) {
            parent = display.getParentDisplay();
        }
        List<ApplicationData> app = null;
        if (display instanceof TreeImageTimeSet || display instanceof TreeFileSet && ((TreeFileSet)display).getType() == 5) {
            db = DataBrowserFactory.getDataBrowser(display);
            if (db != null) {
                db.setComponentTitle("");
                if (visible) {
                    this.view.removeAllFromWorkingPane();
                    this.view.displayBrowser(db);
                }
            } else {
                db = this.handleDiscardedBrowser(display);
                if (visible) {
                    this.view.removeAllFromWorkingPane();
                }
            }
            if (db != null) {
                db.setSelectedNodes(null, null);
            }
            return;
        }
        if (object instanceof ImageData) {
            TreeImageDisplay displayParent = null;
            if (display != null) {
                displayParent = display.getParentDisplay();
            }
            if (displayParent instanceof TreeImageTimeSet || displayParent instanceof TreeFileSet && ((TreeFileSet)displayParent).getType() == 5) {
                db = DataBrowserFactory.getDataBrowser(displayParent);
                if (db != null) {
                    db.setComponentTitle("");
                    if (visible) {
                        this.view.removeAllFromWorkingPane();
                        this.view.displayBrowser(db);
                    }
                    ArrayList<DataObject> nodes = new ArrayList();
                    nodes = browser.getSelectedDataObjects();
                    db.setSelectedNodes(nodes, TreeViewerFactory.getApplications(this.model.getObjectMimeType(object)));
                } else {
                    db = this.handleDiscardedBrowser(displayParent);
                }
                this.model.setDataViewer(db);
                return;
            }
            if (parent != null) {
                DataBrowser gdb;
                Object ho = parent.getUserObject();
                db = DataBrowserFactory.getDataBrowser(ho);
                DataBrowser mdb = this.model.getDataViewer();
                if (mdb != db && (gdb = DataBrowserFactory.getDataBrowser(parent.getParentDisplay().getUserObject())) != null) {
                    db = gdb;
                }
                if (db != null) {
                    List list;
                    db.setComponentTitle("");
                    if (visible) {
                        this.view.removeAllFromWorkingPane();
                        this.view.displayBrowser(db);
                    }
                    if ((list = browser.getSelectedDataObjects()) != null && list.size() == 1) {
                        app = TreeViewerFactory.getApplications(this.model.getObjectMimeType(list.get(0)));
                    }
                    db.setSelectedNodes(list, app);
                } else if (DataBrowserFactory.hasBeenDiscarded(ho)) {
                    List l;
                    if (parent.isChildrenLoaded() && (l = parent.getChildrenDisplay()) != null) {
                        TagAnnotationData tag;
                        HashSet<Object> s = new HashSet<Object>();
                        Iterator i = l.iterator();
                        if (ho instanceof DatasetData) {
                            while (i.hasNext()) {
                                TreeImageDisplay child = (TreeImageDisplay)i.next();
                                s.add(child.getUserObject());
                            }
                            this.setLeaves((TreeImageSet)parent, s);
                            db = DataBrowserFactory.getDataBrowser(ho);
                            List list = browser.getSelectedDataObjects();
                            if (list != null && list.size() == 1) {
                                app = TreeViewerFactory.getApplications(this.model.getObjectMimeType(list.get(0)));
                            }
                            db.setSelectedNodes(list, app);
                        } else if (ho instanceof GroupData) {
                            while (i.hasNext()) {
                                TreeImageDisplay child = (TreeImageDisplay)i.next();
                                s.add(child.getUserObject());
                            }
                            this.setLeaves((TreeImageSet)parent, s);
                            db = DataBrowserFactory.getDataBrowser(ho);
                            List list = browser.getSelectedDataObjects();
                            db.setSelectedNodes(list, app);
                        } else if (ho instanceof TagAnnotationData && (tag = (TagAnnotationData)ho).getTags() == null) {
                            while (i.hasNext()) {
                                TreeImageDisplay child = (TreeImageDisplay)i.next();
                                s.add(child.getUserObject());
                            }
                            this.setLeaves((TreeImageSet)parent, s);
                            db = DataBrowserFactory.getDataBrowser(ho);
                            List list = browser.getSelectedDataObjects();
                            if (list != null && list.size() == 1) {
                                app = TreeViewerFactory.getApplications(this.model.getObjectMimeType(list.get(0)));
                            }
                            db.setSelectedNodes(list, app);
                        }
                    }
                } else {
                    this.showDataBrowser(object, parent.getParentDisplay(), visible);
                }
            } else {
                this.view.removeAllFromWorkingPane();
            }
        } else if (object instanceof ExperimenterData && browser.getBrowserType() == 6) {
            Object ho = null;
            if (display.getParentDisplay() != null) {
                ho = display.getParentDisplay().getUserObject();
                db = DataBrowserFactory.getDataBrowser(ho);
            } else {
                db = null;
            }
            if (db != null) {
                db.setComponentTitle("");
                if (visible) {
                    this.view.removeAllFromWorkingPane();
                    this.view.addComponent(db.getUI(this.model.isFullScreen()));
                }
                ArrayList<DataObject> nodes = new ArrayList<DataObject>();
                nodes.add((DataObject)object);
                db.setSelectedNodes(nodes, TreeViewerFactory.getApplications(this.model.getObjectMimeType(object)));
            }
        } else {
            PlateData plate;
            Set set;
            TreeImageDisplay[] displayedNodes = browser.getSelectedDisplays();
            if (displayedNodes != null && displayedNodes.length > 1 && (object instanceof DatasetData || object instanceof PlateAcquisitionData || object instanceof PlateData)) {
                this.view.removeAllFromWorkingPane();
                this.model.setDataViewer(null);
                return;
            }
            Object p2 = object;
            if (object instanceof PlateData && (set = (plate = (PlateData)object).getPlateAcquisitions()) != null && set.size() == 1) {
                for (Object p2 : set) {
                }
            }
            if ((db = DataBrowserFactory.getDataBrowser(p2)) != null) {
                db.setComponentTitle("");
                if (visible) {
                    this.view.removeAllFromWorkingPane();
                    this.view.addComponent(db.getUI(this.model.isFullScreen()));
                }
                if (object instanceof DataObject) {
                    ArrayList<DataObject> nodes = new ArrayList<DataObject>();
                    nodes.add((DataObject)object);
                    db.setSelectedNodes(nodes, TreeViewerFactory.getApplications(this.model.getObjectMimeType(object)));
                }
            } else {
                List l;
                this.view.removeAllFromWorkingPane();
                if (display != null && display.isChildrenLoaded() && (l = display.getChildrenDisplay()) != null) {
                    TagAnnotationData tag;
                    HashSet<Object> s = new HashSet<Object>();
                    Iterator i = l.iterator();
                    if (object instanceof DatasetData) {
                        while (i.hasNext()) {
                            TreeImageDisplay child = (TreeImageDisplay)i.next();
                            s.add(child.getUserObject());
                        }
                        this.setLeaves((TreeImageSet)display, s);
                        db = DataBrowserFactory.getDataBrowser(display.getUserObject());
                        List list = browser.getSelectedDataObjects();
                        if (list != null && list.size() == 1) {
                            app = TreeViewerFactory.getApplications(this.model.getObjectMimeType(list.get(0)));
                        }
                        db.setSelectedNodes(list, app);
                    } else if (object instanceof GroupData) {
                        if (browser.getBrowserType() == 6) {
                            while (i.hasNext()) {
                                TreeImageDisplay child = (TreeImageDisplay)i.next();
                                s.add(child.getUserObject());
                            }
                            this.setLeaves((TreeImageSet)display, s);
                            db = DataBrowserFactory.getDataBrowser(display.getUserObject());
                            List list = browser.getSelectedDataObjects();
                            db.setSelectedNodes(list, app);
                        }
                    } else if (object instanceof TagAnnotationData && (tag = (TagAnnotationData)object).getTags() == null) {
                        while (i.hasNext()) {
                            TreeImageDisplay child = (TreeImageDisplay)i.next();
                            s.add(child.getUserObject());
                        }
                        this.setLeaves((TreeImageSet)display, s);
                        db = DataBrowserFactory.getDataBrowser(display.getUserObject());
                        List list = browser.getSelectedDataObjects();
                        db.setSelectedNodes(list, null);
                    }
                }
            }
        }
        this.model.setDataViewer(db);
        if (db != null && (b = this.getSelectedBrowser()) != null) {
            b.addComponent(db.getGridUI());
        }
    }

    TreeViewerComponent(TreeViewerModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new TreeViewerControl(this);
        this.view = new TreeViewerWin();
        Finder f = new Finder(this);
        model.setFinder(f);
        f.addPropertyChangeListener(this.controller);
    }

    void initialize(Rectangle bounds) {
        this.controller.initialize(this.view);
        this.view.initialize(this.controller, this.model, bounds);
        this.model.getMetadataViewer().addPropertyChangeListener(this.controller);
    }

    void onAnnotated(List<DataObject> containers, int count) {
        Browser browser = this.model.getSelectedBrowser();
        if (containers != null && containers.size() > 0) {
            NodesFinder finder = new NodesFinder(containers);
            if (browser != null) {
                browser.accept(finder);
            }
            Set<TreeImageDisplay> nodes = finder.getNodes();
            if (browser != null && nodes != null && nodes.size() > 0) {
                Iterator<TreeImageDisplay> i = nodes.iterator();
                while (i.hasNext()) {
                    i.next().setAnnotationCount(count);
                }
                browser.getUI().repaint();
            }
        }
    }

    void setRndSettings(ImageData image, RndProxyDef rndProxyDef) {
        if (this.model.getState() == 2) {
            return;
        }
        this.model.setRndSettings(image, rndProxyDef);
    }

    void onRndSettingsCopied(Collection<Long> imageIds) {
        if (this.model.getState() == 2) {
            return;
        }
        MetadataViewer mv = this.model.getMetadataViewer();
        if (mv != null) {
            mv.onRndSettingsCopied(imageIds);
        }
    }

    void shutDown() {
        this.view.setVisible(false);
        this.view.dispose();
        this.discard();
        this.model.setState(1);
    }

    TreeViewerModel getModel() {
        return this.model;
    }

    void setRecycled(boolean b) {
        this.model.setRecycled(b);
    }

    void saveOnClose(SaveData evt) {
    }

    @Override
    public int getState() {
        return this.model.getState();
    }

    @Override
    public void activate() {
        switch (this.model.getState()) {
            case 1: {
                this.view.setVisible(true);
                this.view.setOnScreen();
                this.view.selectFirstPane();
                this.model.getSelectedBrowser().activate();
                this.model.setState(7);
            }
        }
    }

    @Override
    public Map<Integer, Browser> getBrowsers() {
        return this.model.getBrowsers();
    }

    @Override
    public void discard() {
        Map<Integer, Browser> browsers = this.getBrowsers();
        Iterator<Browser> i = browsers.values().iterator();
        while (i.hasNext()) {
            i.next().discard();
        }
        this.model.discard();
        this.fireStateChange();
    }

    @Override
    public Browser getSelectedBrowser() {
        return this.model.getSelectedBrowser();
    }

    @Override
    public Browser getDefaultBrowser() {
        Map<Integer, Browser> browsers = this.model.getBrowsers();
        return browsers.get(TreeViewerAgent.getDefaultHierarchy());
    }

    @Override
    public void setSelectedBrowser(Browser browser, boolean activate) {
        Browser oldBrowser;
        switch (this.model.getState()) {
            case 2: 
            case 3: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED or SAVE state.");
            }
        }
        if (this.view.getDisplayMode() == 101) {
            this.view.showAdvancedFinder();
            this.view.removeAllFromWorkingPane();
        }
        if ((oldBrowser = this.model.getSelectedBrowser()) == null || !oldBrowser.equals(browser)) {
            if (!activate) {
                this.view.selectPane(browser.getBrowserType());
            }
            this.model.setSelectedBrowser(browser);
            if (browser != null && activate) {
                browser.activate();
                if (browser.getBrowserType() == 6) {
                    ExperimenterData exp = this.model.getUserDetails();
                    this.model.getMetadataViewer().setRootObject(null, exp.getId(), null);
                }
            }
            this.removeEditor();
            this.model.getMetadataViewer().setSelectionMode(true);
            this.firePropertyChange("selectedBrowser", oldBrowser, browser);
        }
        Browser b = this.model.getSelectedBrowser();
        int t = -1;
        if (b != null) {
            t = b.getBrowserType();
        }
        EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
        bus.post(new BrowserSelectionEvent(t));
        this.view.updateMenuItems();
        this.fireStateChange();
    }

    @Override
    public void displayBrowser(int browserType) {
        switch (this.model.getState()) {
            case 2: 
            case 3: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED or SAVE state.");
            }
        }
        Map<Integer, Browser> browsers = this.model.getBrowsers();
        Browser browser = browsers.get(browserType);
        if (browser.isDisplayed()) {
            this.view.removeBrowser(browser);
        } else {
            this.model.setSelectedBrowser(browser);
            this.view.addBrowser(browser);
        }
        browser.setDisplayed(!browser.isDisplayed());
        this.removeEditor();
    }

    @Override
    public void createDataObject(DataObject object, boolean withParent) {
        switch (this.model.getState()) {
            case 2: 
            case 3: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED or SAVE state.");
            }
        }
        if (object == null) {
            return;
        }
        JDialog d = null;
        if (object instanceof ProjectData || object instanceof DatasetData || object instanceof ScreenData || object instanceof TagAnnotationData) {
            d = new EditorDialog((JFrame)this.view, object, withParent);
        } else if (object instanceof GroupData || object instanceof ExperimenterData) {
            Object uo = null;
            Set<DataObject> nodes = null;
            if (object instanceof ExperimenterData) {
                Browser browser = this.getSelectedBrowser();
                TreeImageDisplay node = null;
                if (browser != null) {
                    node = browser.getLastSelectedDisplay();
                }
                if (node != null) {
                    uo = node.getUserObject();
                }
                ContainerFinder finder = new ContainerFinder(GroupData.class);
                this.getSelectedBrowser().accept(finder, 1);
                nodes = finder.getContainers();
                if (nodes.size() == 0) {
                    UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
                    un.notifyInfo("User Creation", "No group available. Please create a group first.");
                    return;
                }
            }
            d = new AdminDialog(this.view, this.model.getAdminContext(), object.getClass(), uo, nodes);
        }
        if (d != null) {
            d.addPropertyChangeListener(this.controller);
            UIUtilities.centerAndShow(d);
        }
    }

    @Override
    public void cancel() {
        if (this.model.getState() != 2) {
            this.model.cancel();
            this.fireStateChange();
        }
    }

    @Override
    public void removeEditor() {
        switch (this.model.getState()) {
            case 2: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED, SAVE state.");
            }
        }
        this.view.removeAllFromWorkingPane();
        this.model.getMetadataViewer().setRootObject(null, -1L, null);
        this.firePropertyChange("removeEditor", false, true);
    }

    @Override
    public ExperimenterData getUserDetails() {
        return this.model.getUserDetails();
    }

    @Override
    public void showFinder(boolean b) {
        switch (this.model.getState()) {
            case 2: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
            }
        }
        if (this.model.getSelectedBrowser() == null) {
            return;
        }
        Finder finder = this.model.getFinder();
        if (b == finder.isDisplay()) {
            return;
        }
        Boolean oldValue = finder.isDisplay() ? Boolean.TRUE : Boolean.FALSE;
        Boolean newValue = b ? Boolean.TRUE : Boolean.FALSE;
        this.view.showFinder(b);
        this.firePropertyChange("finderVisible", oldValue, newValue);
    }

    @Override
    public void closeWindow() {
        this.cancel();
        if (TreeViewerFactory.isLastViewer()) {
            EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
            ExitApplication a = new ExitApplication(!TreeViewerAgent.isRunAsPlugin());
            GroupData group = this.model.getSelectedGroup();
            if (group != null) {
                a.setSecurityContext(new SecurityContext(group.getId()));
            }
            bus.post(a);
        } else {
            this.discard();
        }
    }

    @Override
    public void onSelectedDisplay() {
        Browser b;
        boolean single;
        switch (this.model.getState()) {
            case 2: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED, SAVE state.");
            }
        }
        this.view.initializeDisplay();
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            return;
        }
        TreeImageDisplay display = browser.getLastSelectedDisplay();
        GroupData group = this.getContext(display);
        if (group != null) {
            long oldId = this.model.getSelectedGroupId();
            this.model.setSelectedGroupId(group.getId());
            this.notifyChangeGroup(oldId);
        }
        this.model.setDataViewer(null);
        MetadataViewer metadata = this.model.getMetadataViewer();
        TreeImageDisplay[] selection = browser.getSelectedDisplays();
        boolean bl = single = selection.length == 1;
        if (display instanceof TreeImageTimeSet) {
            single = false;
            TreeImageTimeSet time = (TreeImageTimeSet)display;
            this.view.removeAllFromWorkingPane();
            if (!time.containsImages()) {
                metadata.setRootObject(null, -1L, null);
            }
            this.showDataBrowser(display.getUserObject(), display, true);
            return;
        }
        if (display != null) {
            Object object = display.getUserObject();
            metadata.setSelectionMode(single);
            if (single) {
                ExperimenterData exp = browser.getNodeOwner(display);
                if (exp == null) {
                    exp = this.model.getUserDetails();
                }
                metadata.setRootObject(object, exp.getId(), browser.getSecurityContext(display));
                TreeImageDisplay p = display.getParentDisplay();
                if (p != null) {
                    TreeImageDisplay pp = p.getParentDisplay();
                    Object gpp = null;
                    if (pp != null) {
                        gpp = pp.getUserObject();
                    }
                    metadata.setParentRootObject(p.getUserObject(), gpp);
                }
            } else {
                ArrayList<Object> l = new ArrayList<Object>(selection.length);
                for (int i = 0; i < selection.length; ++i) {
                    l.add(selection[i].getUserObject());
                }
                if (l.size() > 0) {
                    metadata.setRelatedNodes(l);
                }
            }
            if (!this.model.isFullScreen()) {
                this.showDataBrowser(object, display, false);
                this.browse(display, null, true);
            } else {
                this.showDataBrowser(object, display, true);
            }
        } else {
            DataBrowser db = this.model.getDataViewer();
            if (db != null) {
                db.setSelectedNodes(new ArrayList<DataObject>(), null);
            }
            metadata.setRootObject(null, -1L, null);
        }
        if (display != null && display.getUserObject() instanceof ExperimenterData && display.isToRefresh()) {
            this.refreshTree();
        }
        if ((b = this.model.getSelectedBrowser()) != null && display != null) {
            if (this.model.getDataViewer() != null) {
                b.addComponent(this.model.getDataViewer().getGridUI());
            } else {
                b.addComponent(null);
            }
        }
    }

    @Override
    public void setSelectedNodes(Object nodes) {
        int size;
        if (nodes == null) {
            return;
        }
        if (!(nodes instanceof List)) {
            return;
        }
        List l = (List)nodes;
        int n = l.size();
        List selection = (List)l.get(0);
        Object parent = null;
        if (n == 2) {
            parent = l.get(1);
        }
        if (CollectionUtils.isEmpty((Collection)selection)) {
            return;
        }
        Object selected = selection.get(0);
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            if (it.next().getClass().equals(selected.getClass())) continue;
            it.remove();
        }
        MetadataViewer mv = this.model.getMetadataViewer();
        if (this.hasDataToSave()) {
            mv.saveData();
        }
        boolean sameSelection = false;
        if (this.view.getDisplayMode() != 101) {
            Browser browser = this.model.getSelectedBrowser();
            List oldSelection = browser.getSelectedDataObjects();
            browser.onSelectedNode(parent, selection, selection.size() > 0);
            List newSelection = browser.getSelectedDataObjects();
            sameSelection = this.isSameSelection(oldSelection, newSelection);
        }
        if ((size = selection.size()) == 1 && this.model.getSelectedBrowser() != null) {
            Browser browser = this.model.getSelectedBrowser();
            ExperimenterData exp = null;
            TreeImageDisplay last = null;
            if (browser != null) {
                last = browser.getLastSelectedDisplay();
            }
            if (last != null) {
                exp = browser.getNodeOwner(last);
            }
            if (exp == null) {
                exp = this.model.getUserDetails();
            }
            mv.setSelectionMode(true);
            mv.setRootObject(selected, exp.getId(), browser.getSecurityContext(last));
            mv.setParentRootObject(parent, null);
            if (this.model.getDataViewer() != null) {
                this.model.getDataViewer().setApplications(TreeViewerFactory.getApplications(this.model.getObjectMimeType(selected)));
            }
            if (!this.model.isFullScreen()) {
                this.browse(browser.getLastSelectedDisplay(), null, false);
            }
            this.firePropertyChange("selection", false, true);
            return;
        }
        ArrayList result = new ArrayList();
        selection.remove(0);
        result.add(selection);
        result.add(selected);
        result.add(parent);
        this.setSelectedNode(result, sameSelection);
    }

    private void setSelectedNode(Object object, boolean sameSelection) {
        Browser browser;
        WellSampleData ws;
        if (object == null) {
            return;
        }
        if (!(object instanceof List)) {
            return;
        }
        List l = (List)object;
        int n = l.size();
        if (n > 3) {
            return;
        }
        Object selected = l.get(1);
        Object parent = null;
        if (n == 3) {
            parent = l.get(2);
        }
        if (selected instanceof ImageData) {
            ImageData img = (ImageData)selected;
            try {
                img.getDefaultPixels();
            }
            catch (Exception e) {
                UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
                un.notifyInfo("Image Not Valid", "The selected image is not valid.");
                return;
            }
        } else if (selected instanceof WellSampleData && (ws = (WellSampleData)selected).getId() < 0L) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Well Not Valid", "The selected well is not valid.");
            return;
        }
        MetadataViewer mv = this.model.getMetadataViewer();
        if (this.hasDataToSave()) {
            mv.saveData();
        }
        List siblings = (List)l.get(0);
        int size = siblings.size();
        if (this.view.getDisplayMode() != 101) {
            browser = this.model.getSelectedBrowser();
            browser.onSelectedNode(parent, selected, size > 0);
        }
        mv.setSelectionMode(size == 0);
        browser = this.model.getSelectedBrowser();
        ExperimenterData exp = null;
        TreeImageDisplay last = null;
        if (browser != null) {
            last = browser.getLastSelectedDisplay();
        }
        if (last != null) {
            exp = browser.getNodeOwner(last);
        }
        if (exp == null) {
            exp = this.model.getUserDetails();
        }
        Object grandParent = null;
        if (!sameSelection) {
            if (browser == null) {
                if (selected instanceof DataObject) {
                    SecurityContext ctx = new SecurityContext(((DataObject)selected).getGroupId());
                    mv.setRootObject(selected, exp.getId(), ctx);
                }
            } else {
                mv.setRootObject(selected, exp.getId(), browser.getSecurityContext(last));
            }
            mv.setParentRootObject(parent, grandParent);
        }
        siblings.add(selected);
        mv.setRelatedNodes(siblings);
        if (this.model.getDataViewer() != null) {
            this.model.getDataViewer().setApplications(TreeViewerFactory.getApplications(this.model.getObjectMimeType(selected)));
        }
        if (!this.model.isFullScreen()) {
            this.browse(browser.getLastSelectedDisplay(), null, false);
        }
        this.firePropertyChange("selection", false, true);
    }

    private boolean isSameSelection(List<Object> oldSelection, List<Object> newSelection) {
        DataObject data;
        int s2;
        if (oldSelection == null || newSelection == null) {
            return false;
        }
        int s1 = oldSelection.size();
        if (s1 != (s2 = newSelection.size()) || s1 == 0 && s2 > 0 || s1 > 0 && s2 == 0) {
            return false;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        Class<?> klass = null;
        for (Object object : oldSelection) {
            klass = object.getClass();
            if (!(object instanceof DataObject) || ids.contains((data = (DataObject)object).getId())) continue;
            ids.add(data.getId());
        }
        int count = 0;
        for (Object object : newSelection) {
            if (!klass.equals(object.getClass())) {
                return false;
            }
            if (!(object instanceof DataObject) || !ids.contains((data = (DataObject)object).getId())) continue;
            ++count;
        }
        return count == ids.size();
    }

    @Override
    public void handleSearchSelectionEvent(SearchSelectionEvent evt) {
        this.view.forceShowMetaDataView();
        ArrayList<List<DataObject>> tmp = new ArrayList<List<DataObject>>();
        tmp.add(evt.getDataObjects());
        this.setSelectedNodes(tmp);
    }

    @Override
    public void setSelectedNode(Object object) {
        if (object == null) {
            return;
        }
        if (!(object instanceof List)) {
            return;
        }
        List l = (List)object;
        int n = l.size();
        if (n > 3) {
            return;
        }
        Object selected = l.get(1);
        Object parent = null;
        if (n == 3) {
            parent = l.get(2);
        }
        List siblings = (List)l.get(0);
        boolean sameSelection = true;
        if (this.view.getDisplayMode() != 101) {
            Browser browser = this.model.getSelectedBrowser();
            List oldSelection = browser.getSelectedDataObjects();
            ArrayList<Object> newSelection = new ArrayList<Object>();
            newSelection.add(selected);
            sameSelection = this.isSameSelection(oldSelection, newSelection);
        }
        this.setSelectedNode(object, sameSelection);
    }

    @Override
    public void setSelectedField(Object object) {
        WellSampleData ws;
        if (object == null) {
            return;
        }
        if (!(object instanceof List)) {
            return;
        }
        List l = (List)object;
        int n = l.size();
        if (n != 2) {
            return;
        }
        Object selected = l.get(0);
        Object parent = l.get(1);
        if (selected instanceof WellSampleData && (ws = (WellSampleData)selected).getId() < 0L) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Well Not valid", "The selected well is not valid.");
            return;
        }
        MetadataViewer mv = this.model.getMetadataViewer();
        if (this.hasDataToSave()) {
            mv.saveData();
        }
        Browser browser = this.model.getSelectedBrowser();
        ExperimenterData exp = null;
        TreeImageDisplay last = browser.getLastSelectedDisplay();
        if (last != null) {
            exp = browser.getNodeOwner(last);
        }
        if (exp == null) {
            exp = this.model.getUserDetails();
        }
        mv.setSelectionMode(true);
        mv.setRootObject(selected, exp.getId(), browser.getSecurityContext(last));
        mv.setParentRootObject(parent, null);
    }

    @Override
    public void onDataObjectSave(DataObject data, int operation) {
        this.onDataObjectSave(data, null, operation);
    }

    @Override
    public void onDataObjectSave(DataObject data, DataObject parent, int operation) {
        int state = this.model.getState();
        if (operation == 302 && state != 3) {
            throw new IllegalStateException("This method can only be invoked in the SAVE state");
        }
        switch (state) {
            case 2: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED state");
            }
        }
        if (data == null) {
            throw new IllegalArgumentException("No data object. ");
        }
        switch (operation) {
            case 300: 
            case 301: 
            case 302: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Save operation not supported.");
            }
        }
        if (operation == 302) {
            this.model.setState(7);
            this.fireStateChange();
        }
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        Browser browser = null;
        if (operation == 300) {
            if (parent == null) {
                if (data instanceof ProjectData || data instanceof DatasetData) {
                    browser = this.model.getBrowser(0);
                } else if (data instanceof ScreenData) {
                    browser = this.model.getBrowser(1);
                } else if (data instanceof TagAnnotationData) {
                    browser = this.model.getBrowser(2);
                }
            }
            if (browser != null) {
                this.model.setSelectedBrowser(browser);
                this.view.addBrowser(browser);
                this.removeEditor();
            }
        }
        if ((browser = this.model.getSelectedBrowser()) != null && operation != 301) {
            browser.refreshTree(null, null);
        }
        if (operation == 302 || operation == 300) {
            DataBrowserFactory.discardAll();
            this.view.removeAllFromWorkingPane();
        }
        if (operation == 301 && browser != null) {
            browser.accept(new UpdateVisitor(browser, data));
            browser.getUI().repaint();
        }
        this.setStatus(false, "", true);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void onOrphanDataObjectCreated(DataObject data) {
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        Browser browser = this.model.getSelectedBrowser();
        if (browser != null) {
            browser.onOrphanDataObjectCreated(data);
        }
        this.setStatus(false, "", true);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void onDataObjectSave(List data, int operation) {
        int state = this.model.getState();
        if (operation == 302 && state != 3) {
            throw new IllegalStateException("This method can only be invoked in the SAVE state");
        }
        switch (state) {
            case 2: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED state");
            }
        }
        if (data == null) {
            throw new IllegalArgumentException("No data object. ");
        }
        switch (operation) {
            case 300: 
            case 301: 
            case 302: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Save operation not supported.");
            }
        }
        if (operation == 302) {
            this.model.setState(7);
            this.fireStateChange();
        }
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        this.setStatus(false, "", true);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void clearFoundResults() {
        switch (this.model.getState()) {
            case 2: 
            case 3: {
                return;
            }
        }
        Browser browser = this.model.getSelectedBrowser();
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        if (browser != null) {
            browser.accept(new ClearVisitor());
            browser.setFoundInBrowser(null);
        }
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void moveToBack() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        this.view.toBack();
    }

    @Override
    public void moveToFront() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        this.view.toFront();
    }

    @Override
    public void setHierarchyRoot(long userGroupID, List<ExperimenterData> experimenters) {
        List<TreeImageDisplay> nodes;
        ExperimenterVisitor visitor;
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (experimenters == null) {
            return;
        }
        Browser browser = this.model.getBrowser(0);
        Collection groups = TreeViewerAgent.getAvailableUserGroups();
        if (groups == null) {
            return;
        }
        TreeImageDisplay refNode = null;
        if (groups.size() > 1) {
            visitor = new ExperimenterVisitor(browser, userGroupID);
            browser.accept(visitor);
            nodes = visitor.getNodes();
            if (nodes.size() == 0) {
                UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
                un.notifyInfo("Add User", "The group is not displayed.");
                return;
            }
            refNode = nodes.get(0);
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        Iterator<ExperimenterData> ii = experimenters.iterator();
        while (ii.hasNext()) {
            ids.add(ii.next().getId());
        }
        Map<Integer, Browser> browsers = this.model.getBrowsers();
        visitor = new ExperimenterVisitor(browser, -1L, -1L);
        if (refNode != null) {
            refNode.accept(visitor);
        } else {
            browser.accept(visitor);
        }
        nodes = visitor.getNodes();
        ArrayList<ExperimenterData> users = new ArrayList<ExperimenterData>();
        for (TreeImageDisplay n : nodes) {
            ExperimenterData exp;
            if (!(n.getUserObject() instanceof ExperimenterData) || ids.contains((exp = (ExperimenterData)n.getUserObject()).getId())) continue;
            users.add(exp);
        }
        this.model.setSelectedGroupId(userGroupID);
        this.view.setPermissions();
        userGroupID = this.model.getSelectedGroupId();
        for (ExperimenterData exp : users) {
            for (Map.Entry<Integer, Browser> entry : browsers.entrySet()) {
                browser = entry.getValue();
                browser.removeExperimenter(exp, userGroupID);
            }
        }
        for (ExperimenterData exp : experimenters) {
            for (Map.Entry<Integer, Browser> entry : browsers.entrySet()) {
                browser = entry.getValue();
                browser.addExperimenter(exp, userGroupID);
            }
        }
        if (users.size() > 0) {
            DataBrowserFactory.discardAll();
            this.view.removeAllFromWorkingPane();
        }
    }

    @Override
    public boolean canEdit(Object ho) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        long id = this.model.getUserDetails().getId();
        boolean b = false;
        if (ho instanceof TreeImageTimeSet) {
            Browser browser = this.model.getSelectedBrowser();
            if (browser == null) {
                return false;
            }
            ExperimenterData exp = browser.getNodeOwner((TreeImageDisplay)ho);
            if (exp.getId() == id) {
                b = true;
            }
        } else {
            b = EditorUtil.isUserOwner(ho, id);
        }
        if (b) {
            return b;
        }
        GroupData group = null;
        if (ho instanceof DataObject) {
            DataObject data = (DataObject)ho;
            return data.canEdit();
        }
        if (ho instanceof TreeImageTimeSet) {
            Browser browser = this.model.getSelectedBrowser();
            if (browser == null) {
                return false;
            }
            group = browser.getNodeGroup((TreeImageDisplay)ho);
            switch (group.getPermissions().getPermissionsLevel()) {
                case 3: 
                case 5: {
                    return true;
                }
            }
            return EditorUtil.isUserGroupOwner(group, id);
        }
        return false;
    }

    @Override
    public boolean canLink(Object ho) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        boolean b = false;
        if (ho instanceof TreeImageTimeSet) {
            Browser browser = this.model.getSelectedBrowser();
            if (browser == null) {
                return false;
            }
            GroupData g = browser.getNodeGroup((TreeImageDisplay)ho);
            return g.canLink();
        }
        if (ho instanceof DataObject) {
            b = ((DataObject)ho).canLink();
        }
        return b;
    }

    @Override
    public boolean canChgrp(Object ho) {
        if (TreeViewerAgent.isMoveGroup()) {
            return true;
        }
        long id = this.model.getUserDetails().getId();
        boolean b = false;
        if (ho instanceof TreeImageTimeSet) {
            Browser browser = this.model.getSelectedBrowser();
            ExperimenterData exp = browser.getNodeOwner((TreeImageDisplay)ho);
            if (exp.getId() == id) {
                b = true;
            }
        } else {
            b = EditorUtil.isUserOwner(ho, id);
        }
        return b;
    }

    @Override
    public boolean canDelete(Object ho) {
        Browser browser;
        long id = this.model.getUserDetails().getId();
        boolean b = false;
        if (ho instanceof TreeImageTimeSet) {
            Browser browser2 = this.model.getSelectedBrowser();
            ExperimenterData exp = browser2.getNodeOwner((TreeImageDisplay)ho);
            if (exp.getId() == id) {
                b = true;
            }
        } else {
            b = EditorUtil.isUserOwner(ho, id);
        }
        if (b) {
            return b;
        }
        GroupData group = null;
        if (ho instanceof ExperimenterData || ho instanceof GroupData) {
            return false;
        }
        if (ho instanceof DataObject) {
            DataObject data = (DataObject)ho;
            return data.canDelete();
        }
        if (ho instanceof TreeImageTimeSet) {
            browser = this.model.getSelectedBrowser();
            if (browser == null) {
                return false;
            }
        } else {
            return false;
        }
        group = browser.getNodeGroup((TreeImageDisplay)ho);
        if (group.getPermissions() == null) {
            return false;
        }
        switch (group.getPermissions().getPermissionsLevel()) {
            case 3: 
            case 5: {
                return true;
            }
        }
        return EditorUtil.isUserGroupOwner(group, id);
    }

    @Override
    public boolean canAnnotate(Object ho) {
        Browser browser;
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        long id = this.model.getUserDetails().getId();
        boolean b = false;
        if (ho instanceof TreeImageTimeSet) {
            browser = this.model.getSelectedBrowser();
            ExperimenterData exp = browser.getNodeOwner((TreeImageDisplay)ho);
            if (exp.getId() == id) {
                b = true;
            }
        } else {
            b = EditorUtil.isUserOwner(ho, id);
        }
        if (b) {
            return b;
        }
        if (ho instanceof DataObject) {
            DataObject data = (DataObject)ho;
            return data.canAnnotate();
        }
        if (ho instanceof TreeImageTimeSet) {
            browser = this.model.getSelectedBrowser();
            if (browser == null) {
                return false;
            }
            GroupData group = browser.getNodeGroup((TreeImageDisplay)ho);
            switch (group.getPermissions().getPermissionsLevel()) {
                case 3: 
                case 5: {
                    return true;
                }
            }
            return EditorUtil.isUserGroupOwner(group, id);
        }
        return false;
    }

    @Override
    public void addExistingObjects(DataObject ho) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (ho == null) {
            throw new IllegalArgumentException("No object.");
        }
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        this.model.fireDataExistingObjectsLoader(ho);
        this.fireStateChange();
    }

    @Override
    public void setExistingObjects(List objects) {
        if (this.model.getState() != 5) {
            throw new IllegalStateException("This method cannot be invoked in the LOADING_DATA state.");
        }
        this.setStatus(false, "", true);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
        this.model.setState(7);
        if (CollectionUtils.isEmpty((Collection)objects)) {
            return;
        }
        Browser b = this.model.getSelectedBrowser();
        ArrayList<Object> available = new ArrayList<Object>();
        ArrayList<ExperimenterData> immutable = new ArrayList<ExperimenterData>();
        HashSet<ExperimenterData> selected = null;
        if (b != null) {
            TreeImageDisplay[] values = b.getSelectedDisplays();
            if (values != null && values.length > 0) {
                Object value = values[0].getUserObject();
                if (value instanceof GroupData) {
                    long groupId = ((GroupData)value).getId();
                    ExperimenterData currentUser = this.model.getExperimenter();
                    selected = new HashSet<ExperimenterData>();
                    long userID = currentUser.getId();
                    ArrayList<Long> ids = new ArrayList<Long>();
                    for (ExperimenterData experimenter : objects) {
                        long id = experimenter.getId();
                        if (experimenter.isMemberOfGroup(groupId)) {
                            ids.add(id);
                            selected.add(experimenter);
                            if (this.model.isSystemUser(id, "guest") && this.model.isSystemGroup(groupId, "guest")) {
                                immutable.add(experimenter);
                            } else if (this.model.isSystemGroup(groupId, "system") && (this.model.isSystemUser(id, "system") || id == userID)) {
                                immutable.add(experimenter);
                            }
                        }
                        if (ids.contains(experimenter.getId())) continue;
                        available.add(experimenter);
                    }
                }
            } else {
                available.addAll(objects);
            }
        }
        this.fireStateChange();
        SelectionWizard d = new SelectionWizard((JFrame)this.view, available, selected, objects.get(0).getClass(), TreeViewerAgent.getUserDetails());
        d.setImmutableElements(immutable);
        IconManager icons = IconManager.getInstance();
        String title = "User Selection";
        String text = "Select the Users who should be in the selected group.";
        Icon icon = icons.getIcon(56);
        d.setTitle(title, text, icon);
        d.addPropertyChangeListener(this.controller);
        UIUtilities.centerAndShow(d);
    }

    @Override
    public void addExistingObjects(Set set) {
        if (this.model.getState() != 6) {
            throw new IllegalStateException("This method cannot be invoked in the LOADING_DATA state.");
        }
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        if (set == null || set.size() == 0) {
            this.model.setState(7);
        } else {
            this.model.fireAddExistingObjects(set);
        }
        this.fireStateChange();
    }

    @Override
    public void showMenu(int menuID, Component c, Point p) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        switch (menuID) {
            case 0: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                if (this.model.getAvailableScripts() != null) break;
                this.model.loadScripts(p, c);
                this.firePropertyChange("scriptsLoading", false, true);
                return;
            }
            default: {
                throw new IllegalArgumentException("Menu not supported.");
            }
        }
        this.view.showMenu(menuID, c, p);
    }

    @Override
    public void setStatus(boolean enable, String text, boolean hide) {
        this.view.setStatus(text, hide);
        this.view.setStatusIcon(enable);
    }

    @Override
    public void onComponentStateChange(boolean b) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        Browser browser = this.model.getSelectedBrowser();
        if (browser != null) {
            browser.onComponentStateChange(b);
        }
        this.view.onStateChanged(b);
        this.firePropertyChange("onComponentStateChanged", !b, b);
    }

    @Override
    public void setNodesToCopy(TreeImageDisplay[] nodes, int index) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (nodes == null || nodes.length == 0) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Copy action", "You first need to select the nodes to copy.");
            return;
        }
        switch (index) {
            case 400: 
            case 401: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not supported.");
            }
        }
        this.model.setNodesToCopy(nodes, index);
        EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
        bus.post(new CopyItems(this.model.getDataToCopyType()));
        if (index == 401 && this.model.cut()) {
            this.fireStateChange();
        }
    }

    @Override
    public void paste(TreeImageDisplay[] parents) {
        MessageBox box;
        long gid;
        Object os;
        TreeImageDisplay n;
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
        if (parents == null || parents.length == 0) {
            un.notifyInfo("Paste action", "You first need to select the nodes to copy into.");
            return;
        }
        TreeImageDisplay[] nodes = this.model.getNodesToCopy();
        if (nodes == null || nodes.length == 0) {
            return;
        }
        HashMap elements = new HashMap();
        List<DataObject> l = new ArrayList<DataObject>();
        boolean admin = false;
        Browser browser = this.model.getSelectedBrowser();
        if (browser != null) {
            admin = browser.getBrowserType() == 6;
        }
        for (int j = 0; j < nodes.length; ++j) {
            n = nodes[j];
            os = n.getUserObject();
            if (!(os instanceof DataObject)) continue;
            if (!(os instanceof ExperimenterData) && !(os instanceof GroupData)) {
                gid = ((DataObject)os).getGroupId();
                if (!elements.containsKey(gid)) {
                    elements.put(gid, new ArrayList());
                }
                l = (List)elements.get(gid);
                l.add((DataObject)os);
                continue;
            }
            if (!(os instanceof ExperimenterData)) continue;
            l.add((DataObject)os);
        }
        if (admin && l.size() > 0) {
            boolean b = this.model.paste(parents);
            if (!b) {
                un.notifyInfo("Paste", "The Users to copy cannot be added to the selected Groups.");
            } else {
                this.fireStateChange();
            }
            return;
        }
        if (elements.size() == 0) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        HashMap parentMap = new HashMap();
        if (elements.size() == 1) {
            for (int j = 0; j < parents.length; ++j) {
                n = parents[j];
                os = n.getUserObject();
                if (os instanceof ExperimenterData) {
                    TreeImageDisplay parent = n.getParentDisplay();
                    if (!(parent.getUserObject() instanceof GroupData)) continue;
                    gid = parent.getUserObjectId();
                    if (!parentMap.containsKey(gid)) {
                        parentMap.put(gid, new ArrayList());
                    }
                    if (ids.contains(gid)) continue;
                    ids.add(gid);
                    continue;
                }
                if (!(os instanceof DataObject)) continue;
                gid = ((DataObject)os).getGroupId();
                if (!parentMap.containsKey(gid)) {
                    parentMap.put(gid, new ArrayList());
                }
                List list = (List)parentMap.get(gid);
                if (!(os instanceof GroupData)) {
                    list.add((DataObject)os);
                }
                if (ids.contains(gid)) continue;
                ids.add(gid);
            }
            if (ids.size() == 1) {
                Iterator i = elements.keySet().iterator();
                while (i.hasNext()) {
                    if (((Long)i.next()).longValue() != ((Long)ids.get(0)).longValue()) continue;
                    boolean b = this.model.paste(parents);
                    if (!b) {
                        un.notifyInfo("Paste", "The nodes to copy cannot be added to the selected nodes.");
                    } else {
                        this.fireStateChange();
                    }
                    return;
                }
            }
        }
        if ((box = new MessageBox(this.view, "Copy data", "Copying between groups is not yet supported.\nTo continue and move the data to the new group, click 'Yes'.\nTo leave the data in the current group, click 'No'.")).centerMsgBox() != 1) {
            return;
        }
        Iterator i = elements.keySet().iterator();
        HashMap<SecurityContext, List<DataObject>> trans = new HashMap<SecurityContext, List<DataObject>>();
        while (i.hasNext()) {
            gid = (Long)i.next();
            trans.put(new SecurityContext(gid), (List<DataObject>)elements.get(gid));
        }
        IconManager icons = IconManager.getInstance();
        for (Map.Entry entry : parentMap.entrySet()) {
            Long id = (Long)entry.getKey();
            this.removeNodes(trans);
            TransferableObject t = new TransferableObject(new SecurityContext(id.longValue()), (List)entry.getValue(), trans);
            t.setGroupName(this.getGroupName(id));
            TransferableActivityParam param = new TransferableActivityParam(icons.getIcon(160), t);
            param.setFailureIcon(icons.getIcon(161));
            un.notifyActivity(this.model.getSecurityContext(), param);
        }
    }

    @Override
    public JFrame getUI() {
        return this.view;
    }

    @Override
    public boolean hasDataToSave() {
        MetadataViewer metadata = this.model.getMetadataViewer();
        if (metadata == null) {
            return false;
        }
        return metadata.hasDataToSave();
    }

    @Override
    public void showPreSavingDialog() {
        MetadataViewer metadata = this.model.getMetadataViewer();
        if (metadata == null) {
            return;
        }
        if (!metadata.hasDataToSave()) {
            return;
        }
        MessageBox dialog = new MessageBox(this.view, "Save data", "Do you want to save the modified \ndata before selecting a new item?");
        if (dialog.centerMsgBox() == 1) {
            this.model.getMetadataViewer().saveData();
        } else {
            this.model.getMetadataViewer().clearDataToSave();
            Browser browser = this.model.getSelectedBrowser();
            if (browser != null) {
                browser.setSelectedNode();
            }
        }
    }

    @Override
    public void saveMetadata() {
        MetadataViewer metadata = this.model.getMetadataViewer();
        if (metadata == null) {
            return;
        }
        if (!metadata.hasDataToSave()) {
            return;
        }
        this.model.getMetadataViewer().saveData();
    }

    @Override
    public void retrieveUserGroups(Point location, GroupData group) {
        List<TreeImageDisplay> nodes;
        ExperimenterVisitor visitor;
        Set experimenters;
        int level;
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        JFrame f = (JFrame)((Object)TreeViewerAgent.getRegistry().getTaskBar());
        IconManager icons = IconManager.getInstance();
        Collection groups = TreeViewerAgent.getAvailableUserGroups();
        if (group == null) {
            group = this.model.getSelectedGroup();
        }
        if ((level = group.getPermissions().getPermissionsLevel()) == 0) {
            boolean owner = false;
            if (TreeViewerAgent.isAdministrator()) {
                owner = true;
            } else {
                ExperimenterData currentUser = this.model.getExperimenter();
                Set leaders = group.getLeaders();
                for (ExperimenterData exp : leaders) {
                    if (exp.getId() != currentUser.getId()) continue;
                    owner = true;
                    break;
                }
            }
            if (!owner) {
                return;
            }
        }
        if ((experimenters = group.getExperimenters()) == null || experimenters.size() == 0) {
            return;
        }
        Browser browser = this.model.getBrowser(0);
        TreeImageDisplay refNode = null;
        if (groups.size() > 1) {
            visitor = new ExperimenterVisitor(browser, group.getId());
            browser.accept(visitor);
            nodes = visitor.getNodes();
            if (nodes.size() != 1) {
                return;
            }
            refNode = nodes.get(0);
        }
        visitor = new ExperimenterVisitor(browser, -1L, -1L);
        if (refNode != null) {
            refNode.accept(visitor);
        } else {
            browser.accept(visitor);
        }
        nodes = visitor.getNodes();
        ArrayList<ExperimenterData> users = new ArrayList<ExperimenterData>();
        for (TreeImageDisplay n : nodes) {
            if (!(n.getUserObject() instanceof ExperimenterData)) continue;
            users.add((ExperimenterData)n.getUserObject());
        }
        this.switchUserDialog = new UserManagerDialog(f, this.model.getUserDetails(), group, users, icons.getIcon(23), icons.getIcon(56));
        this.switchUserDialog.addPropertyChangeListener(this.controller);
        this.switchUserDialog.setDefaultSize();
        UIUtilities.showOnScreen(this.switchUserDialog, location);
    }

    @Override
    public String getExperimenterNames() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.getExperimenterNames();
    }

    @Override
    public ExperimenterData getSelectedExperimenter() {
        TreeImageDisplay node;
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        Browser b = this.model.getSelectedBrowser();
        ExperimenterData exp = this.model.getExperimenter();
        if (b != null && (node = b.getLastSelectedDisplay()) != null) {
            exp = b.getNodeOwner(node);
        }
        return exp;
    }

    @Override
    public boolean isRecycled() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.isRecycled();
    }

    @Override
    public boolean isRollOver() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.isRollOver();
    }

    @Override
    public void setRollOver(boolean rollOver) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        this.model.setRollOver(rollOver);
    }

    @Override
    public void removeExperimenterData() {
        Object uo;
        if (this.model.getState() == 2) {
            return;
        }
        Browser browser = this.model.getSelectedBrowser();
        TreeImageDisplay expNode = browser.getLastSelectedDisplay();
        TreeImageDisplay parent = expNode.getParentDisplay();
        long groupID = -1L;
        if (parent != null && parent.getUserObject() instanceof GroupData) {
            GroupData g = (GroupData)parent.getUserObject();
            groupID = g.getId();
        }
        if ((uo = expNode.getUserObject()) == null || !(uo instanceof ExperimenterData)) {
            return;
        }
        ExperimenterData exp = (ExperimenterData)uo;
        Map<Integer, Browser> browsers = this.model.getBrowsers();
        for (Map.Entry<Integer, Browser> entry : browsers.entrySet()) {
            browser = entry.getValue();
            browser.removeExperimenter(exp, groupID);
        }
        DataBrowserFactory.discardAll();
        this.view.removeAllFromWorkingPane();
    }

    @Override
    public boolean hasRndSettings() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.hasRndSettingsToPaste();
    }

    @Override
    public boolean areSettingsCompatible(long groupID) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.areSettingsCompatible(groupID);
    }

    @Override
    public void pasteRndSettings(List<Long> ids, Class klass) {
        MessageBox box;
        if (!this.hasRndSettings()) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Paste settings", "No rendering settings topaste. \n Please first copy settings.");
            return;
        }
        if (CollectionUtils.isEmpty(ids)) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Paste settings", "Please select the nodes \nyou wish to apply the settings to.");
            return;
        }
        if (PojosUtil.isContainerClass(klass) && (box = new MessageBox(this.getUI(), "Save rendering settings", RENDERINGSETTINGS_WARNING)).centerMsgBox() != 1) {
            return;
        }
        this.model.firePasteRenderingSettings(ids, klass);
        this.fireStateChange();
    }

    @Override
    public void pasteRndSettings(TimeRefObject ref) {
        if (this.model.getState() == 2) {
            return;
        }
        if (!this.hasRndSettings()) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Paste settings", "No rendering settings topaste. Please first copy settings.");
            return;
        }
        if (ref == null) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Paste settings", "Please select the nodesyou wish to apply the settings to.");
            return;
        }
        this.model.firePasteRenderingSettings(ref);
        this.fireStateChange();
    }

    @Override
    public void rndSettingsPasted(Map map) {
        if (map == null || map.size() != 2) {
            return;
        }
        Collection failure = (Collection)map.get(false);
        Collection success = (Collection)map.get(true);
        EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
        bus.post(new RndSettingsCopied(success, -1L));
        this.model.setState(7);
        this.fireStateChange();
    }

    @Override
    public void resetRndSettings(List<Long> ids, Class klass) {
        MessageBox box;
        if (ids == null || ids.size() == 0) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Reset settings", "Please select at one element.");
            return;
        }
        if (PojosUtil.isContainerClass(klass) && (box = new MessageBox(this.getUI(), "Save rendering settings", RENDERINGSETTINGS_WARNING)).centerMsgBox() != 1) {
            return;
        }
        this.model.fireResetRenderingSettings(ids, klass);
        this.fireStateChange();
    }

    @Override
    public void resetRndSettings(TimeRefObject ref) {
        if (ref == null) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Reset settings", "Please select at one element.");
            return;
        }
        this.model.fireResetRenderingSettings(ref);
        this.fireStateChange();
    }

    @Override
    public void createObject(DataObject object, boolean withParent) {
        if (this.model.getState() == 2) {
            return;
        }
        if (object == null) {
            return;
        }
        Browser browser = null;
        if (object instanceof DatasetData || object instanceof ProjectData) {
            browser = this.model.getBrowser(0);
        } else if (object instanceof ScreenData) {
            browser = this.model.getBrowser(1);
        }
        if (browser != null) {
            browser.expandUser();
        }
        this.model.fireDataObjectCreation(object, withParent);
        this.fireStateChange();
    }

    @Override
    public void setLeaves(TreeImageSet parent, Collection leaves) {
        if (parent instanceof TreeFileSet && ((TreeFileSet)parent).getType() != 5) {
            this.view.removeAllFromWorkingPane();
            return;
        }
        Browser browser = this.model.getSelectedBrowser();
        Object parentObject = parent.getUserObject();
        TreeImageDisplay display = parent.getParentDisplay();
        Object grandParentObject = null;
        if (display != null) {
            grandParentObject = display.getUserObject();
        }
        DataBrowser db = null;
        if (parentObject instanceof TagAnnotationData) {
            db = DataBrowserFactory.getTagsBrowser(this.model.getSecurityContext(parent), (TagAnnotationData)parentObject, leaves, false);
        } else if (parentObject instanceof GroupData) {
            if (browser != null && browser.getBrowserType() == 6) {
                db = DataBrowserFactory.getGroupsBrowser(this.model.getSecurityContext(parent), (GroupData)parentObject, leaves);
            }
        } else if (parentObject instanceof FileData) {
            FileData f = (FileData)parentObject;
            if (f.isDirectory()) {
                db = DataBrowserFactory.getFSFolderBrowser(this.model.getSecurityContext(parent), (FileData)parentObject, leaves);
            }
        } else {
            db = DataBrowserFactory.getDataBrowser(this.model.getSecurityContext(parent), grandParentObject, parentObject, leaves, parent);
            if (parent instanceof TreeImageTimeSet) {
                ExperimenterData exp = browser.getNodeOwner(parent);
                db.setExperimenter(exp);
            }
        }
        if (db != null) {
            db.addPropertyChangeListener(this.controller);
            this.view.displayBrowser(db);
            db.setDisplayMode(this.model.getDisplayMode());
            db.activate();
        }
        this.model.setDataViewer(db);
    }

    @Override
    public Collection getDisplayedImages() {
        DataBrowser db = this.model.getDataViewer();
        if (db == null) {
            return null;
        }
        return db.getBrowser().getVisibleImages();
    }

    @Override
    public void browseHierarchyRoots(Object parent, Collection roots) {
        TreeImageDisplay display;
        List l;
        if (roots == null) {
            return;
        }
        Iterator i = roots.iterator();
        ObservableComponent db = null;
        if (roots.size() != 1) {
            return;
        }
        HashMap<Long, TreeImageDisplay> m = new HashMap<Long, TreeImageDisplay>();
        if (parent instanceof TreeImageDisplay && (l = (display = (TreeImageDisplay)parent).getChildrenDisplay()) != null) {
            for (TreeImageDisplay child : l) {
                long id = child.getUserObjectId();
                if (id < 0L) continue;
                m.put(id, child);
            }
        }
        while (i.hasNext()) {
            Iterator k;
            Set dataObjects;
            TreeImageDisplay value;
            Set set;
            DataObject node = (DataObject)i.next();
            if (node instanceof ProjectData) {
                ProjectData project = (ProjectData)node;
                set = project.getDatasets();
                for (DatasetData d : set) {
                    value = (TreeImageDisplay)m.get(d.getId());
                    if (value == null) continue;
                    dataObjects = d.getImages();
                    if (dataObjects != null && !value.isChildrenLoaded()) {
                        value.removeAllChildrenDisplay();
                        k = dataObjects.iterator();
                        while (k.hasNext()) {
                            value.addChildDisplay(TreeViewerTranslator.transformDataObject((DataObject)((ImageData)k.next())));
                        }
                    }
                    value.setChildrenLoaded(true);
                }
                this.model.setState(7);
                this.fireStateChange();
                db = DataBrowserFactory.getDataBrowser(this.model.getSecurityContext(), project, set);
                continue;
            }
            if (!(node instanceof TagAnnotationData)) continue;
            TagAnnotationData tag = (TagAnnotationData)node;
            set = tag.getDataObjects();
            Iterator j = set.iterator();
            while (j.hasNext()) {
                DataObject object = (DataObject)j.next();
                value = (TreeImageDisplay)m.get(object.getId());
                if (value == null) continue;
                if (object instanceof DatasetData) {
                    dataObjects = ((DatasetData)object).getImages();
                    if (dataObjects != null) {
                        value.removeAllChildrenDisplay();
                        k = dataObjects.iterator();
                        while (k.hasNext()) {
                            value.addChildDisplay(TreeViewerTranslator.transformDataObject((DataObject)((ImageData)k.next())));
                        }
                    }
                    value.setChildrenLoaded(true);
                    continue;
                }
                if (!(object instanceof ProjectData)) continue;
                Set datasets = ((ProjectData)object).getDatasets();
                Iterator l2 = datasets.iterator();
                while (l2.hasNext()) {
                    DatasetData d;
                    d = (DatasetData)j.next();
                    dataObjects = d.getImages();
                    if (dataObjects != null) {
                        value.removeAllChildrenDisplay();
                        k = dataObjects.iterator();
                        while (k.hasNext()) {
                            value.addChildDisplay(TreeViewerTranslator.transformDataObject((DataObject)((ImageData)k.next())));
                        }
                    }
                    value.setChildrenLoaded(true);
                }
            }
            this.model.setState(7);
            this.fireStateChange();
            db = DataBrowserFactory.getTagsBrowser(this.model.getSecurityContext(), tag, set, true);
        }
        if (db != null) {
            db.addPropertyChangeListener(this.controller);
            this.view.removeAllFromWorkingPane();
            this.view.displayBrowser((DataBrowser)db);
            db.setDisplayMode(this.model.getDisplayMode());
            db.activate();
        }
        this.model.setDataViewer((DataBrowser)db);
    }

    @Override
    public void setUnselectedNode(Object object) {
        Browser browser;
        if (object == null) {
            return;
        }
        if (!(object instanceof List)) {
            return;
        }
        List l = (List)object;
        int n = l.size();
        if (n > 3 || n <= 1) {
            return;
        }
        Object multiSelection = l.get(0);
        Object selected = l.get(1);
        Object parent = null;
        if (n == 3) {
            parent = l.get(2);
        }
        if (selected instanceof ImageData) {
            ImageData img = (ImageData)selected;
            try {
                img.getDefaultPixels();
            }
            catch (Exception e) {
                UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
                un.notifyInfo("Image Not valid", "The selected image is not valid");
                return;
            }
        }
        if ((browser = this.model.getSelectedBrowser()) == null) {
            return;
        }
        browser.onDeselectedNode(parent, selected, (Boolean)multiSelection);
        this.onSelectedDisplay();
    }

    @Override
    public void copyRndSettings(ImageData image) {
        if (image == null) {
            Browser browser = this.model.getSelectedBrowser();
            if (browser == null) {
                return;
            }
            TreeImageDisplay node = browser.getLastSelectedDisplay();
            if (node == null) {
                return;
            }
            Object o = node.getUserObject();
            if (!(o instanceof ImageData)) {
                return;
            }
            image = (ImageData)o;
        }
        EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
        bus.post(new CopyRndSettings(image));
    }

    @Override
    public void setMinMax(List<Long> ids, Class klass) {
        if (ids == null || ids.size() == 0) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Set settings", "Please select at least one element.");
            return;
        }
        this.model.fireSetMinMax(ids, klass);
        this.fireStateChange();
    }

    @Override
    public void setOriginalRndSettings(TimeRefObject ref) {
        if (ref == null) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Set settings", "Please select at least one element.");
            return;
        }
        this.model.fireSetOwnerRenderingSettings(ref);
        this.fireStateChange();
    }

    @Override
    public void setOwnerRndSettings(List<Long> ids, Class klass) {
        MessageBox box;
        if (ids == null || ids.size() == 0) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Set settings", "Please select at least one element.");
            return;
        }
        if (PojosUtil.isContainerClass(klass) && (box = new MessageBox(this.getUI(), "Save rendering settings", RENDERINGSETTINGS_WARNING)).centerMsgBox() != 1) {
            return;
        }
        this.model.fireSetOwnerRenderingSettings(ids, klass);
        this.fireStateChange();
    }

    @Override
    public void setOwnerRndSettings(TimeRefObject ref) {
        if (ref == null) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Set settings", "Please select at least one element.");
            return;
        }
        this.model.fireSetOriginalRenderingSettings(ref);
        this.fireStateChange();
    }

    @Override
    public void showSearch() {
        int oldMode = this.view.getDisplayMode();
        this.view.showAdvancedFinder();
        DataBrowser db = DataBrowserFactory.getSearchBrowser();
        int newMode = this.view.getDisplayMode();
        this.view.removeAllFromWorkingPane();
        switch (newMode) {
            case 100: {
                this.onSelectedDisplay();
                break;
            }
            case 101: {
                ExperimenterData exp = this.model.getUserDetails();
                this.model.getMetadataViewer().setRootObject(null, exp.getId(), null);
                if (db == null) break;
                this.view.displayBrowser(db);
                this.model.setDataViewer(db);
            }
        }
        this.firePropertyChange("searchMode", oldMode, newMode);
    }

    @Override
    public void handleSearchEvent(SearchEvent evt) {
        this.view.selectSearchPane();
        AdvancedFinder finder = this.model.getAdvancedFinder();
        finder.handleSearchEvent(evt);
    }

    @Override
    public void setSearchResult(Object result) {
        SearchResultCollection results = (SearchResultCollection)result;
        MetadataViewer metadata = this.model.getMetadataViewer();
        if (metadata != null) {
            metadata.setRootObject(null, -1L, null);
        }
        if (results == null) {
            this.view.removeAllFromWorkingPane();
            return;
        }
        DataBrowser db = DataBrowserFactory.getSearchBrowser(results);
        if (db != null && this.view.getDisplayMode() == 101) {
            db.setExperimenter(TreeViewerAgent.getUserDetails());
            db.addPropertyChangeListener(this.controller);
            this.view.removeAllFromWorkingPane();
            this.view.displayBrowser(db);
            db.setDisplayMode(this.model.getDisplayMode());
            db.activate();
            this.model.setDataViewer(db);
        }
    }

    @Override
    public void addMetadata() {
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            return;
        }
        TreeImageDisplay[] nodes = browser.getSelectedDisplays();
        if (nodes == null || nodes.length == 0) {
            return;
        }
        ArrayList<Object> data = new ArrayList<Object>();
        Class type = null;
        String text = "Add metadata to ";
        if (nodes.length == 1) {
            TreeImageDisplay n = nodes[0];
            Object uo = n.getUserObject();
            if (uo instanceof TagAnnotationData) {
                data.add(uo);
                type = TagAnnotationData.class;
                text = text + "images linked to the selected tag.";
            } else if (uo instanceof DatasetData) {
                data.add(uo);
                type = DatasetData.class;
                text = text + "images linked to the selected dataset.";
            } else if (n instanceof TreeImageTimeSet) {
                TreeImageTimeSet time = (TreeImageTimeSet)n;
                ExperimenterData exp = this.model.getUserDetails();
                TimeRefObject ref = new TimeRefObject(exp.getId(), 0);
                ref.setTimeInterval(time.getStartTime(), time.getEndTime());
                data.add(ref);
                type = TimeRefObject.class;
                text = text + "images imported during the selected period.";
            }
        } else {
            for (int i = 0; i < nodes.length; ++i) {
                TreeImageDisplay n = nodes[i];
                Object uo = n.getUserObject();
                if (!(uo instanceof ImageData)) continue;
                data.add(uo);
            }
            text = text + "the selected images.";
        }
        if (data.size() > 0) {
            IconManager icons = IconManager.getInstance();
            MetadataViewer viewer = MetadataViewerFactory.getViewer(data, type);
            GenericDialog dialog = new GenericDialog(this.view, "Add Metadata...");
            dialog.initialize("Add Metadata...", text, icons.getIcon(73), viewer.getEditorUI());
            dialog.setParent(viewer);
            viewer.setSelectionMode(true);
            dialog.addPropertyChangeListener(this.controller);
            UIUtilities.centerAndShow(dialog);
        }
    }

    @Override
    public void refreshTree() {
        int state = this.model.getState();
        if (state == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state");
        }
        Browser b = this.model.getSelectedBrowser();
        DataBrowserFactory.discardAll();
        this.view.removeAllFromWorkingPane();
        if (b != null) {
            b.refreshTree(null, null);
        }
        ExperimenterData exp = this.model.getUserDetails();
        this.model.getMetadataViewer().setRootObject(null, exp.getId(), null);
    }

    @Override
    public void browseTimeInterval(TreeImageTimeSet parent, Collection leaves) {
        Browser browser;
        if (leaves == null) {
            return;
        }
        if (parent == null) {
            return;
        }
        Object parentObject = null;
        ExperimenterData exp = null;
        Object grandParentObject = null;
        parentObject = parent.getUserObject();
        TreeImageDisplay display = parent.getParentDisplay();
        if (display != null) {
            grandParentObject = display.getUserObject();
        }
        if ((browser = this.model.getSelectedBrowser()) != null) {
            exp = browser.getNodeOwner(parent);
        }
        DataBrowser db = DataBrowserFactory.getDataBrowser(this.model.getSecurityContext(parent), grandParentObject, parentObject, leaves, parent);
        db.setExperimenter(exp);
        db.addPropertyChangeListener(this.controller);
        this.view.removeAllFromWorkingPane();
        this.view.displayBrowser(db);
        db.setDisplayMode(this.model.getDisplayMode());
        db.activate();
        this.model.setDataViewer(db);
        this.model.setState(7);
        this.fireStateChange();
    }

    @Override
    public void setPlates(Map<TreeImageSet, Collection> plates, boolean withThumbnails) {
        if (plates == null || plates.size() == 0) {
            return;
        }
        int n = plates.size();
        Iterator<Map.Entry<TreeImageSet, Collection>> i = plates.entrySet().iterator();
        Object gpo = null;
        ObservableComponent db = null;
        if (n == 1) {
            HashMap<Class, Object> m = new HashMap<Class, Object>();
            while (i.hasNext()) {
                Map.Entry<TreeImageSet, Collection> entry = i.next();
                TreeImageSet parent = entry.getKey();
                Object parentObject = parent.getUserObject();
                TreeImageDisplay display = parent.getParentDisplay();
                if (display != null) {
                    gpo = display.getUserObject();
                    if (gpo != null) {
                        m.put(gpo.getClass(), gpo);
                    }
                    if (gpo instanceof PlateData && (display = display.getParentDisplay()) != null && (gpo = display.getUserObject()) != null) {
                        m.put(gpo.getClass(), gpo);
                    }
                }
                db = DataBrowserFactory.getWellsDataBrowser(this.model.getSecurityContext(parent), m, parentObject, entry.getValue(), withThumbnails);
            }
        }
        if (db != null) {
            db.addPropertyChangeListener(this.controller);
            this.view.removeAllFromWorkingPane();
            db.setDisplayMode(this.model.getDisplayMode());
            db.activate();
            this.view.displayBrowser((DataBrowser)db);
            this.model.setDataViewer((DataBrowser)db);
            this.getSelectedBrowser().addComponent(db.getGridUI());
        }
        this.model.setState(7);
        this.fireStateChange();
    }

    @Override
    public void browse(TreeImageDisplay node, DataObject data, boolean withThumbnails) {
        FileData fa;
        Browser browser;
        block48: {
            block50: {
                block49: {
                    TreeImageDisplay parent;
                    browser = this.model.getSelectedBrowser();
                    if (node != null) break block48;
                    if (browser == null) {
                        return;
                    }
                    if (!(data instanceof DatasetData)) break block49;
                    NodesFinder finder = new NodesFinder(data);
                    browser.accept(finder);
                    Set<TreeImageDisplay> nodes = finder.getNodes();
                    ExperimenterData exp = null;
                    MetadataViewer mv = this.model.getMetadataViewer();
                    int size = nodes.size();
                    if (size != 1) break block50;
                    Iterator<TreeImageDisplay> i = nodes.iterator();
                    mv.setSelectionMode(size == 1);
                    int mode = this.model.getDisplayMode();
                    if (!i.hasNext()) break block50;
                    node = i.next();
                    if (mode == 1) {
                        parent = BrowserFactory.getDataOwner(node);
                        exp = (ExperimenterData)parent.getUserObject();
                    } else {
                        parent = EditorUtil.getDataGroup(node);
                    }
                    browser.loadExperimenterData(parent, node);
                    if (exp == null) {
                        exp = this.model.getUserDetails();
                    }
                    node.setExpanded(true);
                    mv.setRootObject(node.getUserObject(), exp.getId(), browser.getSecurityContext(node));
                    browser.onSelectedNode(null, node, false);
                    break block50;
                }
                if (data instanceof PlateData) {
                    NodesFinder finder = new NodesFinder(data);
                    browser.accept(finder);
                    Set<TreeImageDisplay> nodes = finder.getNodes();
                    if (nodes.size() > 0) {
                        this.model.browsePlates(nodes, withThumbnails);
                    }
                } else if (data instanceof ImageData) {
                    NodesFinder finder = new NodesFinder(data);
                    browser.accept(finder);
                    Set<TreeImageDisplay> nodes = finder.getNodes();
                    MetadataViewer mv = this.model.getMetadataViewer();
                    int size = nodes.size();
                    if (size == 1) {
                        Iterator<TreeImageDisplay> i = nodes.iterator();
                        mv.setSelectionMode(size == 1);
                        while (i.hasNext()) {
                            ExperimenterData exp;
                            node = i.next();
                            TreeImageDisplay parent = node.getParentDisplay();
                            TreeImageDisplay expNode = BrowserFactory.getDataOwner(node);
                            ExperimenterData experimenterData = exp = expNode == null ? null : (ExperimenterData)expNode.getUserObject();
                            if (exp == null) {
                                exp = this.model.getUserDetails();
                            }
                            node.setExpanded(true);
                            List l = parent.getChildrenDisplay();
                            Iterator j = l.iterator();
                            ArrayList<ImageData> leaves = new ArrayList<ImageData>();
                            while (j.hasNext()) {
                                TreeImageDisplay o = (TreeImageDisplay)j.next();
                                leaves.add((ImageData)o.getUserObject());
                            }
                            DataBrowser db = DataBrowserFactory.getDataBrowser(this.model.getSecurityContext(node), null, parent.getUserObject(), leaves, parent);
                            if (db == null) {
                                return;
                            }
                            db.addPropertyChangeListener(this.controller);
                            db.setDisplayMode(this.model.getDisplayMode());
                            this.view.displayBrowser(db);
                            db.activate();
                            this.model.setDataViewer(db);
                            browser.setSelectedDisplay(node);
                        }
                    }
                }
            }
            return;
        }
        if (!node.isExpanded()) {
            node.setExpanded(true);
        }
        ActionCmd actionCmd = null;
        Object uo = node.getUserObject();
        if (uo instanceof ProjectData) {
            this.model.browseProject(node);
        } else if (uo instanceof DatasetData) {
            if (browser != null) {
                browser.loadExperimenterData(BrowserFactory.getDataOwner(node), node);
            }
        } else if (uo instanceof ScreenData) {
            if (data instanceof PlateData) {
                NodesFinder finder = new NodesFinder(data);
                browser.accept(finder);
                Set<TreeImageDisplay> nodes = finder.getNodes();
                if (nodes.size() > 0) {
                    TreeImageDisplay[] values = new TreeImageDisplay[nodes.size()];
                    Iterator<TreeImageDisplay> i = nodes.iterator();
                    int index = 0;
                    while (i.hasNext()) {
                        TreeImageDisplay n = i.next();
                        node = n.getParentDisplay();
                        values[index] = n;
                        ++index;
                    }
                    browser.setSelectedDisplays(values, true);
                    this.model.browsePlates(nodes, withThumbnails);
                }
            } else if (data instanceof ScreenData) {
                NodesFinder finder = new NodesFinder(data);
                browser.accept(finder);
                Set<TreeImageDisplay> nodes = finder.getNodes();
                if (nodes.size() > 0) {
                    TreeImageDisplay[] values = new TreeImageDisplay[nodes.size()];
                    Iterator<TreeImageDisplay> i = nodes.iterator();
                    int index = 0;
                    while (i.hasNext()) {
                        TreeImageDisplay n = i.next();
                        node = n.getParentDisplay();
                        values[index] = n;
                        ++index;
                    }
                    browser.setSelectedDisplays(values, true);
                }
            }
        } else if (uo instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)uo;
            if (!"openmicroscopy.org/omero/insight/tagset".equals(tag.getNameSpace())) {
                this.model.browseTag(node);
            }
        } else if (uo instanceof ImageData) {
            actionCmd = TreeViewerAgent.runAsPlugin() == 1 || TreeViewerAgent.runAsPlugin() == 3 ? new ViewInPluginCmd(this, 1) : new ViewCmd(this, true);
        } else if (node instanceof TreeImageTimeSet) {
            this.model.browseTimeInterval((TreeImageTimeSet)node);
        } else if (uo instanceof PlateData) {
            ArrayList<TreeImageDisplay> plates = new ArrayList<TreeImageDisplay>();
            List l = node.getChildrenDisplay();
            if (l == null || l.size() == 0) {
                plates.add(node);
            }
            if (l.size() == 1) {
                plates.add((TreeImageDisplay)l.get(0));
            }
            this.model.browsePlates(plates, withThumbnails);
        } else if (uo instanceof PlateAcquisitionData) {
            ArrayList<TreeImageDisplay> plates = new ArrayList<TreeImageDisplay>();
            plates.add(node);
            this.model.browsePlates(plates, withThumbnails);
        } else if (uo instanceof File) {
            List l;
            File f = (File)uo;
            if (f.isDirectory() && (l = node.getChildrenDisplay()) != null && l.size() > 0) {
                HashSet<Object> leaves = new HashSet<Object>();
                for (TreeImageDisplay child : l) {
                    Object object = child.getUserObject();
                    if (!(object instanceof ImageData)) continue;
                    leaves.add(object);
                }
                if (leaves.size() > 0) {
                    this.setLeaves((TreeImageSet)node, leaves);
                }
            }
        } else if (uo instanceof FileData && (fa = (FileData)uo).isDirectory()) {
            this.model.getSelectedBrowser().loadExperimenterData(BrowserFactory.getDataOwner(node), node);
        }
        this.fireStateChange();
        if (actionCmd != null) {
            actionCmd.execute();
        }
    }

    @Override
    public void deleteObjects(List nodes) {
        if (nodes == null) {
            return;
        }
        Iterator i = nodes.iterator();
        Object klass = null;
        ArrayList ids = new ArrayList();
        HashMap<SecurityContext, List<DataObject>> objects = new HashMap<SecurityContext, List<DataObject>>();
        while (i.hasNext()) {
            TreeImageDisplay node = (TreeImageDisplay)i.next();
            Object uo = node.getUserObject();
            SecurityContext ctx = this.model.getSecurityContext(node);
            if (!(uo instanceof ProjectData) && !(uo instanceof DatasetData) && !(uo instanceof ImageData)) continue;
            ArrayList<DataObject> l = (ArrayList<DataObject>)objects.get(ctx);
            if (l == null) {
                l = new ArrayList<DataObject>();
                objects.put(ctx, l);
            }
            l.add((DataObject)uo);
        }
        if (objects.size() == 0) {
            this.delete(nodes);
        } else {
            this.model.fireImageChecking(objects, nodes, ImageChecker.ImageCheckerType.DELETE);
        }
    }

    @Override
    public List<DataObject> getDataToCopy() {
        if (this.model.getState() == 2) {
            return null;
        }
        return this.model.getDataToCopy();
    }

    @Override
    public void onNodesMoved(DataObject target) {
        if (this.model.getState() != 3) {
            return;
        }
        this.model.setState(7);
        this.fireStateChange();
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        this.view.removeAllFromWorkingPane();
        DataBrowserFactory.discardAll();
        Browser browser = this.model.getSelectedBrowser();
        browser.refreshTree(null, target);
        this.model.getMetadataViewer().setRootObject(null, -1L, null);
        this.setStatus(false, "", true);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void onNodesDeleted(Collection<DataObject> deleted) {
        if (this.model.getState() == 2) {
            return;
        }
        if (CollectionUtils.isEmpty(deleted)) {
            this.onNodesMoved(null);
            return;
        }
        NotDeletedObjectDialog nd = new NotDeletedObjectDialog(this.view, deleted);
        if (nd.centerAndShow() == 0) {
            this.onNodesMoved(null);
        }
    }

    @Override
    public void showTagWizard() {
        if (this.model.getState() == 2) {
            return;
        }
        this.model.getMetadataViewer().showTagWizard();
    }

    @Override
    public void setInspectorVisibility() {
        if (this.model.getState() == 2) {
            return;
        }
        this.view.setInspectorVisibility();
    }

    @Override
    public void onActivityProcessed(ActivityComponent activity, boolean finished) {
        if (this.model.getState() == 2) {
            return;
        }
        if (finished) {
            this.view.onActivityTerminated(activity);
        }
        this.firePropertyChange("imported", !finished, finished);
    }

    @Override
    public void download(File folder, boolean override, List<DataObject> selection) {
        List l;
        if (this.model.getState() == 2) {
            return;
        }
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            return;
        }
        List list = l = selection == null ? browser.getSelectedDataObjects() : selection;
        if (l == null) {
            return;
        }
        Iterator i = l.iterator();
        ArrayList<DataObject> archived = new ArrayList<DataObject>();
        ArrayList<Long> filesetIds = new ArrayList<Long>();
        while (i.hasNext()) {
            long id;
            ImageData image;
            Object object = i.next();
            if (object instanceof ImageData) {
                image = (ImageData)object;
                if (!image.isArchived()) continue;
                id = image.getFilesetId();
                if (id < 0L) {
                    archived.add((DataObject)image);
                    continue;
                }
                if (filesetIds.contains(id)) continue;
                archived.add((DataObject)image);
                filesetIds.add(id);
                continue;
            }
            if (object instanceof FileAnnotationData) {
                this.downloadFile(folder, override, (FileAnnotationData)object, null);
                continue;
            }
            if (object instanceof PlateAcquisitionData && PojosUtil.isDownloadable((DataObject)object)) {
                PlateData p = new PlateData(((PlateAcquisition)((DataObject)object).asIObject()).getPlate());
                archived.add((DataObject)p);
                continue;
            }
            if (object instanceof PlateData && PojosUtil.isDownloadable((DataObject)object)) {
                archived.add((DataObject)((PlateData)object));
                continue;
            }
            if (!(object instanceof WellSampleData) || !PojosUtil.isDownloadable((DataObject)object) || !(image = ((WellSampleData)object).getImage()).isArchived()) continue;
            id = image.getFilesetId();
            if (id < 0L) {
                archived.add((DataObject)image);
                continue;
            }
            if (filesetIds.contains(id)) continue;
            archived.add((DataObject)image);
            filesetIds.add(id);
        }
        if (archived.size() > 0) {
            UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
            IconManager icons = IconManager.getInstance();
            Icon icon = icons.getIcon(110);
            SecurityContext ctx = this.getSecurityContext();
            DownloadArchivedActivityParam p = new DownloadArchivedActivityParam(folder, archived, icon);
            p.setOverride(override);
            p.setZip(false);
            p.setKeepOriginalPaths(true);
            un.notifyActivity(ctx, p);
        }
    }

    @Override
    public void setDownloadedFiles(File folder, ApplicationData data, Collection files) {
        if (files == null || files.size() == 0) {
            return;
        }
        UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
        IconManager icons = IconManager.getInstance();
        for (OriginalFile file : files) {
            DownloadActivityParam activity = new DownloadActivityParam(file, folder, icons.getIcon(110));
            un.notifyActivity(this.model.getSecurityContext(), activity);
        }
    }

    @Override
    public void openWith(ApplicationData data) {
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            return;
        }
        if (data != null) {
            Environment env = (Environment)TreeViewerAgent.getRegistry().lookup("/env");
            String dir = env.getTmpDir();
            List l = browser.getSelectedDataObjects();
            if (l == null) {
                return;
            }
            Iterator i = l.iterator();
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            SecurityContext ctx = this.model.getSecurityContext();
            while (i.hasNext()) {
                Object object = i.next();
                if (!(object instanceof ImageData) && !(object instanceof FileAnnotationData)) continue;
                OpenActivityParam activity = new OpenActivityParam(data, (DataObject)object, dir);
                un.notifyActivity(ctx, activity);
            }
            return;
        }
        TreeImageDisplay d = browser.getLastSelectedDisplay();
        if (d == null) {
            return;
        }
        Object uo = d.getUserObject();
        String name = null;
        if (uo instanceof ImageData) {
            ImageData img = (ImageData)uo;
            name = EditorUtil.getObjectName(img.getName());
        } else if (uo instanceof FileAnnotationData) {
            FileAnnotationData fa = (FileAnnotationData)uo;
            name = EditorUtil.getObjectName(fa.getFileName());
        }
        if (name == null) {
            return;
        }
        OpenWithDialog dialog = new OpenWithDialog(this.view, ApplicationData.getDefaultLocation(), name);
        dialog.addPropertyChangeListener(this.controller);
        UIUtilities.centerAndShow(dialog);
    }

    @Override
    public void setUserGroup(List<GroupData> groups) {
        GroupData group;
        if (this.model.getState() != 7) {
            return;
        }
        if (groups == null || groups.size() == 0) {
            return;
        }
        ExperimenterData exp = TreeViewerAgent.getUserDetails();
        Browser browser = this.model.getBrowser(0);
        if (browser == null) {
            return;
        }
        ExperimenterVisitor v = new ExperimenterVisitor(browser, -1L);
        browser.accept(v, 1);
        List<TreeImageDisplay> nodes = v.getNodes();
        Iterator<TreeImageDisplay> i = nodes.iterator();
        Iterator<GroupData> k = groups.iterator();
        ArrayList<Long> already = new ArrayList<Long>();
        while (i.hasNext()) {
            Object o = i.next().getUserObject();
            if (!(o instanceof GroupData)) continue;
            group = (GroupData)o;
            already.add(group.getId());
        }
        Map<Integer, Browser> browsers = this.model.getBrowsers();
        Iterator<Browser> j = browsers.values().iterator();
        boolean displayed = false;
        while (j.hasNext()) {
            browser = j.next();
            k = groups.iterator();
            boolean set = false;
            while (k.hasNext()) {
                group = k.next();
                if (already.contains(group.getId())) continue;
                browser.setUserGroup(group);
                this.model.setSelectedGroupId(group.getId());
                this.notifyChangeGroup(group.getId());
                set = true;
            }
            if (!set) {
                group = groups.get(0);
                this.model.setSelectedGroupId(group.getId());
                this.notifyChangeGroup(group.getId());
            }
            this.view.setPermissions();
        }
    }

    @Override
    public void setFullScreen() {
    }

    @Override
    public void setMetadataVisibility() {
        if (this.model.getState() == 2) {
            return;
        }
        this.view.setMetadataVisibility();
    }

    @Override
    public boolean isLeaderOfGroup(GroupData group) {
        if (this.model.getState() == 2 || group == null) {
            return false;
        }
        Set groups = TreeViewerAgent.getGroupsLeaderOf();
        if (groups.size() == 0) {
            return false;
        }
        for (GroupData g : groups) {
            if (g.getId() != group.getId()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void administrate(AdminObject object) {
        if (this.model.getState() == 2) {
            return;
        }
        if (object == null) {
            throw new IllegalArgumentException("Object not valid.");
        }
        this.model.fireAdmin(object);
        this.fireStateChange();
    }

    @Override
    public void register(DataObjectRegistration file) {
        if (this.model.getState() == 2) {
            return;
        }
        if (file == null) {
            throw new IllegalArgumentException("No file to register.");
        }
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null || browser.getBrowserType() != 4) {
            return;
        }
        if (browser.register(file.getData())) {
            // empty if block
        }
    }

    @Override
    public int getGroupPermissions(GroupData group) {
        if (group == null) {
            return 0;
        }
        PermissionData data = group.getPermissions();
        if (data.isGroupRead()) {
            if (data.isGroupWrite()) {
                return 3;
            }
            if (data.isGroupAnnotate()) {
                return 2;
            }
            return 1;
        }
        if (data.isWorldRead()) {
            if (data.isWorldWrite()) {
                return 5;
            }
            return 4;
        }
        return 0;
    }

    @Override
    public void resetPassword(String password) {
        if (password == null) {
            throw new IllegalArgumentException("No password specified.");
        }
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            return;
        }
        List l = browser.getSelectedDataObjects();
        if (l == null) {
            return;
        }
        HashMap<ExperimenterData, UserCredentials> map = new HashMap<ExperimenterData, UserCredentials>();
        for (Object o : l) {
            if (!(o instanceof ExperimenterData)) continue;
            ExperimenterData exp = (ExperimenterData)o;
            UserCredentials uc = new UserCredentials(exp.getUserName(), password);
            map.put(exp, uc);
        }
        if (map.size() == 0) {
            return;
        }
        AdminObject admin = new AdminObject(null, map, 4);
        this.model.fireAdmin(admin);
        this.fireStateChange();
    }

    @Override
    public void onGroupSwitched(boolean success) {
        this.model.setRndSettings(null, null);
        this.model.setNodesToCopy(null, -1);
        this.view.removeAllFromWorkingPane();
        this.model.setDataViewer(null);
        MetadataViewer mv = this.view.resetMetadataViewer();
        this.clearFoundResults();
    }

    void onReconnected() {
        this.model.setRndSettings(null, null);
        this.model.setNodesToCopy(null, -1);
        this.view.removeAllFromWorkingPane();
        this.model.setDataViewer(null);
        this.model.setAvailableScripts(null);
        this.model.clearImportResult();
        this.view.onImport();
        this.view.clearMenus();
        MetadataViewer mv = this.view.resetMetadataViewer();
        this.clearFoundResults();
        this.model.getAdvancedFinder().reset(TreeViewerAgent.getAvailableUserGroups());
        ExperimenterData exp = this.model.getUserDetails();
        this.model.setSelectedGroupId(exp.getDefaultGroup().getId());
        this.view.createTitle();
        this.view.setPermissions();
        Browser b = this.view.resetLayout();
        if (b != null) {
            Browser old = this.model.getSelectedBrowser();
            this.model.setSelectedBrowser(b);
            this.model.getMetadataViewer().setSelectionMode(false);
            this.firePropertyChange("selectedBrowser", old, b);
            int t = b.getBrowserType();
            EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
            bus.post(new BrowserSelectionEvent(t));
            this.view.updateMenuItems();
        }
        Map<Integer, Browser> browsers = this.model.getBrowsers();
        for (Map.Entry<Integer, Browser> entry : browsers.entrySet()) {
            Browser browser = entry.getValue();
            browser.reActivate();
        }
    }

    @Override
    public void findDataObject(Class type, long id, boolean selectTab) {
        Browser browser = null;
        if (selectTab) {
            if (ProjectData.class.equals((Object)type) || DatasetData.class.equals((Object)type)) {
                this.view.selectPane(0);
                browser = this.model.getBrowser(0);
                this.model.setSelectedBrowser(browser);
            } else if (ScreenData.class.equals((Object)type) || PlateData.class.equals((Object)type)) {
                this.view.selectPane(1);
                browser = this.model.getBrowser(1);
                this.model.setSelectedBrowser(browser);
            }
        }
        if (browser != null) {
            NodesFinder finder = new NodesFinder(type, id);
            browser.accept(finder);
            Set<TreeImageDisplay> nodes = finder.getNodes();
            if (nodes.size() == 0) {
                if (ProjectData.class.equals((Object)type) || DatasetData.class.equals((Object)type) || ScreenData.class.equals((Object)type)) {
                    DataBrowserFactory.discardAll();
                    this.view.removeAllFromWorkingPane();
                    browser.refreshBrowser(type, id);
                    ExperimenterData exp = this.model.getUserDetails();
                    this.model.getMetadataViewer().setRootObject(null, exp.getId(), null);
                }
            } else {
                Iterator<TreeImageDisplay> i = nodes.iterator();
                if (i.hasNext()) {
                    TreeImageDisplay node = i.next();
                    browser.setSelectedDisplay(node);
                    browser.onSelectedNode(null, node, false);
                    this.browseContainer(node, null);
                }
            }
        }
    }

    @Override
    public boolean isImporting() {
        if (this.model.getState() == 2) {
            return false;
        }
        return this.model.isImporting();
    }

    @Override
    public void indicateToRefresh(List<DataObject> containers, boolean refreshTree) {
        Browser browser = null;
        HashSet<Long> groupIds = new HashSet<Long>();
        if (containers != null && containers.size() > 0) {
            NodesFinder finder = new NodesFinder(containers);
            DataObject ho = containers.get(0);
            if (ho instanceof DatasetData || ho instanceof ProjectData) {
                browser = this.model.getBrowser(0);
                browser.accept(finder);
            } else if (ho instanceof ScreenData) {
                browser = this.model.getBrowser(1);
                browser.accept(finder);
            }
            Set<TreeImageDisplay> nodes = finder.getNodes();
            if (browser != null && nodes != null && nodes.size() > 0) {
                for (TreeImageDisplay node : nodes) {
                    TreeImageDisplay parent;
                    node.setToRefresh(true);
                    Object object = node.getUserObject();
                    if (object instanceof DataObject) {
                        groupIds.add(((DataObject)object).getGroupId());
                    }
                    if ((parent = node.getParentDisplay()) == null || parent.isExpanded()) continue;
                    browser.expand(parent);
                }
                ExperimenterData exp = TreeViewerAgent.getUserDetails();
                ExperimenterVisitor v = new ExperimenterVisitor(browser, exp.getId(), groupIds);
                browser.accept(v, 1);
                List<TreeImageDisplay> l = v.getNodes();
                if (l != null) {
                    for (TreeImageDisplay node : l) {
                        node.setExpanded(true);
                        node.setToRefresh(refreshTree);
                    }
                }
                browser.getUI().repaint();
            }
        }
    }

    @Override
    public void setImporting(boolean importing, List<DataObject> containers, boolean refreshTree, Object importResult) {
        if (this.model.getState() == 2) {
            return;
        }
        this.model.setImporting(importing, importResult);
        this.view.onImport();
        if (!importing) {
            this.indicateToRefresh(containers, refreshTree);
        }
        this.firePropertyChange("importImages", importing, !importing);
    }

    @Override
    public void browseContainer(Object data, Object refNode) {
        if (this.model.getState() == 2) {
            return;
        }
        if (data == null) {
            return;
        }
        Browser browser = null;
        this.moveToFront();
        if (data instanceof TreeImageDisplay) {
            TreeImageDisplay node = (TreeImageDisplay)data;
            Object ho = node.getUserObject();
            if (ho instanceof DatasetData || ho instanceof ProjectData) {
                browser = this.model.getBrowser(0);
                if (browser != null) {
                    this.setSelectedBrowser(browser, false);
                    NodesFinder finder = new NodesFinder((DataObject)ho);
                    browser.accept(finder);
                    Set<TreeImageDisplay> nodes = finder.getNodes();
                    if (nodes.size() > 0) {
                        for (TreeImageDisplay n : nodes) {
                            if (n != node) continue;
                            this.browse(node, null, true);
                            node.setToRefresh(false);
                        }
                    }
                }
            } else if (ho instanceof ScreenData) {
                browser = this.model.getBrowser(1);
                DataBrowserFactory.discardAll();
                this.setSelectedBrowser(browser, false);
                browser.refreshTree(refNode, (DataObject)ho);
            }
        } else if (data instanceof DataObject) {
            if (data instanceof DatasetData || data instanceof ProjectData || data instanceof ImageData) {
                browser = this.model.getBrowser(0);
            } else if (data instanceof PlateData || data instanceof ScreenData) {
                browser = this.model.getBrowser(1);
            } else if (data instanceof FileAnnotationData) {
                this.model.loadParentOf((FileAnnotationData)data);
                return;
            }
            if (browser != null) {
                DataBrowserFactory.discardAll();
                if (data instanceof ImageData) {
                    this.view.removeAllFromWorkingPane();
                }
                this.setSelectedBrowser(browser, false);
                browser.refreshTree(refNode, (DataObject)data);
            }
        }
    }

    @Override
    public void activateUser(ExperimenterData exp) {
        if (exp == null) {
            throw new IllegalArgumentException("No password specified.");
        }
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            return;
        }
        List l = browser.getSelectedDataObjects();
        if (l == null) {
            return;
        }
        HashMap<ExperimenterData, UserCredentials> map = new HashMap<ExperimenterData, UserCredentials>();
        UserCredentials uc = new UserCredentials(exp.getUserName(), "");
        uc.setActive(!exp.isActive());
        map.put(exp, uc);
        if (map.size() == 0) {
            return;
        }
        AdminObject admin = new AdminObject(null, map, 6);
        this.model.fireAdmin(admin);
        this.fireStateChange();
    }

    @Override
    public void createDataObjectWithChildren(DataObject data) {
        if (data == null) {
            return;
        }
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            return;
        }
        TreeImageDisplay[] selection = browser.getSelectedDisplays();
        if (selection.length == 0) {
            return;
        }
        if (data instanceof DatasetData) {
            HashSet<Object> images = new HashSet<Object>();
            for (int i = 0; i < selection.length; ++i) {
                Object ho = selection[i].getUserObject();
                if (!(ho instanceof ImageData) || !this.canLink(ho)) continue;
                images.add(ho);
            }
            if (images.size() == 0) {
                UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
                un.notifyInfo("Dataset Creation", "No images to add to the dataset.");
            }
            this.model.fireDataSaving(data, images);
        }
    }

    @Override
    public void setAvailableScripts(List scripts, Point location) {
        if (this.model.getState() == 2) {
            return;
        }
        this.model.setAvailableScripts(scripts);
        this.firePropertyChange("scriptsLoaded", false, true);
        if (location != null) {
            this.view.showMenu(10, null, location);
        }
    }

    @Override
    public void loadScript(long scriptID) {
        if (scriptID < 0L) {
            return;
        }
        this.model.loadScript(scriptID);
        this.firePropertyChange("scriptsLoading", false, true);
    }

    @Override
    public void setScript(ScriptObject script) {
        this.firePropertyChange("scriptsLoaded", false, true);
        if (script == null) {
            return;
        }
        this.model.setScript(script);
        Browser browser = this.model.getSelectedBrowser();
        ArrayList<DataObject> objects = browser == null ? new ArrayList<DataObject>() : browser.getSelectedDataObjects();
        if (CollectionUtils.isEmpty(objects)) {
            DataBrowser db = this.model.getDataViewer();
            objects = new ArrayList();
            if (db != null && db.getBrowser() != null) {
                objects.addAll(db.getBrowser().getSelectedDataObjects());
            }
        }
        ArrayListMultimap addObjects = null;
        Pattern p = Pattern.compile("file.?annotation.*", 2);
        for (String paramName : script.getInputs().keySet()) {
            Matcher m = p.matcher(paramName);
            if (!m.matches()) continue;
            addObjects = ArrayListMultimap.create();
            if (this.model.getMetadataViewer() == null) continue;
            addObjects.putAll((Object)paramName, this.model.getMetadataViewer().getEditor().getSelectedFileAnnotations());
        }
        Iterator i = objects.iterator();
        ArrayList<Long> ids = new ArrayList<Long>();
        long id = -1L;
        while (i.hasNext()) {
            DataObject object = (DataObject)i.next();
            if (object instanceof ExperimenterData || object instanceof GroupData || ids.contains(id = object.getGroupId()) || id == -1L) continue;
            ids.add(id);
        }
        if (ids.size() > 1) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Run Script", "This script can only run on data from the same group.\nPlease perform a separate run of the script for each group,\nselecting only data from a single group to run the script on each time.");
            return;
        }
        if (this.scriptDialog == null) {
            this.scriptDialog = new ScriptingDialog(this.view, this.model.getScript(script.getScriptID()), objects, (ListMultimap<String, DataObject>)addObjects, TreeViewerAgent.isBinaryAvailable());
            this.scriptDialog.addPropertyChangeListener(this.controller);
            UIUtilities.centerAndShow(this.scriptDialog);
        } else {
            this.scriptDialog.reset(this.model.getScript(script.getScriptID()), objects, (ListMultimap<String, DataObject>)addObjects);
            if (!this.scriptDialog.isVisible()) {
                UIUtilities.centerAndShow(this.scriptDialog);
            }
        }
    }

    @Override
    public void transfer(TreeImageDisplay target, List<TreeImageDisplay> nodes, int transferAction) {
        GroupData group;
        DataObject otData;
        ArrayList<Long> groupIds;
        Object os;
        ArrayList<TreeImageDisplay> list;
        Object ot;
        Browser browser;
        block35: {
            block34: {
                TreeImageDisplay src;
                if (target == null || CollectionUtils.isEmpty(nodes)) {
                    return;
                }
                browser = this.model.getSelectedBrowser();
                if (browser == null) {
                    return;
                }
                ot = target.getUserObject();
                if (nodes.size() == 1 && (src = nodes.get(0)) == target) {
                    browser.rejectTransfer();
                    return;
                }
                UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
                if (browser.getBrowserType() == 6) {
                    if (!(ot instanceof GroupData) || !TreeViewerAgent.isAdministrator()) {
                        un.notifyInfo("DnD", "Only administrator can performsuch action.");
                        browser.rejectTransfer();
                        return;
                    }
                    Iterator<TreeImageDisplay> i = nodes.iterator();
                    long id = this.model.getUserDetails().getId();
                    String message = null;
                    while (i.hasNext()) {
                        TreeImageDisplay n = i.next();
                        if (!(n.getUserObject() instanceof ExperimenterData)) continue;
                        ExperimenterData exp = (ExperimenterData)n.getUserObject();
                        TreeImageDisplay p = n.getParentDisplay();
                        if (p == null || !(p.getUserObject() instanceof GroupData)) continue;
                        GroupData g = (GroupData)p.getUserObject();
                        if (this.model.isSystemGroup(g.getId(), "system")) {
                            if (exp.getId() == id) {
                                message = "An administrator cannot remove himself/herself from " + g.getName() + " Group.";
                                break;
                            }
                            if (!this.model.isSystemUser(exp.getId(), "system")) continue;
                            message = "An administrator cannot remove " + exp.getUserName() + " from " + g.getName() + " Group.";
                            break;
                        }
                        if (!this.model.isSystemGroup(g.getId(), "guest") || !this.model.isSystemUser(exp.getId(), "guest")) continue;
                        message = "An administrator cannot remove " + exp.getUserName() + " from " + g.getName() + " Group.";
                        break;
                    }
                    if (message != null) {
                        un.notifyInfo("DnD", message);
                        browser.rejectTransfer();
                        return;
                    }
                }
                if (!(this.canLink(ot) || ot instanceof ExperimenterData || ot instanceof GroupData)) {
                    un.notifyInfo("DnD", "You must be the owner of the container.");
                    browser.rejectTransfer();
                    return;
                }
                TreeImageDisplay p = target.getParentDisplay();
                list = new ArrayList<TreeImageDisplay>();
                Iterator<TreeImageDisplay> i = nodes.iterator();
                int count = 0;
                os = null;
                int childCount = 0;
                long userID = TreeViewerAgent.getUserDetails().getId();
                boolean administrator = TreeViewerAgent.isAdministrator();
                groupIds = new ArrayList<Long>();
                while (i.hasNext()) {
                    DataObject data;
                    TreeImageDisplay n = i.next();
                    os = n.getUserObject();
                    if (target.contains(n)) {
                        ++childCount;
                        continue;
                    }
                    if (!EditorUtil.isTransferable(ot, os, userID)) continue;
                    ++count;
                    if (ot instanceof GroupData) {
                        if (os instanceof ExperimenterData && administrator) {
                            list.add(n);
                            continue;
                        }
                        if (!this.canEdit(os)) continue;
                        data = (DataObject)os;
                        if (!groupIds.contains(data.getGroupId())) {
                            groupIds.add(data.getGroupId());
                        }
                        list.add(n);
                        continue;
                    }
                    if (ot instanceof ExperimenterData) {
                        ExperimenterData exp = (ExperimenterData)ot;
                        if (exp.getId() != userID) continue;
                        target = null;
                        list.add(n);
                        data = (DataObject)os;
                        if (groupIds.contains(data.getGroupId())) continue;
                        groupIds.add(data.getGroupId());
                        continue;
                    }
                    if (!this.canEdit(os)) continue;
                    list.add(n);
                    data = (DataObject)os;
                    if (groupIds.contains(data.getGroupId())) continue;
                    groupIds.add(data.getGroupId());
                }
                if (childCount == nodes.size()) {
                    browser.rejectTransfer();
                    return;
                }
                if (list.size() == 0) {
                    String s = "";
                    if (nodes.size() > 1) {
                        s = "s";
                    }
                    un.notifyInfo("DnD", "The " + this.getObjectType(os) + s + " cannot be moved to the selected " + this.getObjectType(ot) + ".");
                    browser.rejectTransfer();
                    return;
                }
                otData = (DataObject)ot;
                group = null;
                if (!(ot instanceof ExperimenterData)) break block34;
                Iterator po = p.getUserObject();
                if (!(po instanceof GroupData)) break block35;
                group = (GroupData)po;
                break block35;
            }
            if (ot instanceof GroupData) {
                group = (GroupData)ot;
            } else {
                for (Object gd : TreeViewerAgent.getAvailableUserGroups()) {
                    if (((GroupData)gd).getId() != otData.getGroupId()) continue;
                    group = (GroupData)gd;
                    break;
                }
            }
        }
        if (browser.getBrowserType() == 6) {
            this.model.transfer(target, list);
        } else if (groupIds.size() == 1 && ((Long)groupIds.get(0)).longValue() == group.getId()) {
            this.model.transfer(target, list);
        } else {
            long gid;
            if (group == null) {
                return;
            }
            MessageBox box = new MessageBox(this.view, "Change group", "Are you sure you want to move the selected items to another group?");
            if (box.centerMsgBox() != 1) {
                return;
            }
            otData = null;
            if (target != null && !(ot instanceof GroupData)) {
                otData = (DataObject)ot;
            }
            HashMap elements = new HashMap();
            for (TreeImageDisplay n : list) {
                os = n.getUserObject();
                if (!(os instanceof DataObject) || os instanceof ExperimenterData || os instanceof GroupData) continue;
                gid = ((DataObject)os).getGroupId();
                if (!elements.containsKey(gid)) {
                    elements.put(gid, new ArrayList());
                }
                List l = (List)elements.get(gid);
                l.add((DataObject)os);
            }
            if (elements.size() == 0) {
                return;
            }
            Iterator j = elements.keySet().iterator();
            HashMap<SecurityContext, List<DataObject>> trans = new HashMap<SecurityContext, List<DataObject>>();
            while (j.hasNext()) {
                gid = (Long)j.next();
                trans.put(new SecurityContext(gid), (List<DataObject>)elements.get(gid));
            }
            if (target == null) {
                otData = null;
            }
            ChgrpObject object = new ChgrpObject(group, otData, trans);
            this.model.fireImageChecking(trans, object, ImageChecker.ImageCheckerType.CHGRP);
        }
    }

    @Override
    public GroupData getSelectedGroup() {
        if (this.model.getState() == 2) {
            return null;
        }
        return this.model.getSelectedGroup();
    }

    @Override
    public GroupData getSingleGroupDisplayed() {
        if (this.model.getState() == 2) {
            return null;
        }
        Collection<GroupData> groups = this.model.getAvailableGroups();
        if (groups != null && groups.size() == 1) {
            return null;
        }
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            return null;
        }
        Object node = null;
        ExperimenterVisitor v = new ExperimenterVisitor(browser, -1L);
        browser.accept(v, 1);
        List<TreeImageDisplay> nodes = v.getNodes();
        if (nodes.size() == 1) {
            return (GroupData)nodes.get(0).getUserObject();
        }
        return null;
    }

    @Override
    public void removeGroup(long groupId) {
        if (this.model.getState() == 2) {
            return;
        }
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            return;
        }
        TreeImageDisplay node = null;
        ExperimenterVisitor v = new ExperimenterVisitor(browser, -1L);
        browser.accept(v, 1);
        List<TreeImageDisplay> groups = v.getNodes();
        for (TreeImageDisplay n : groups) {
            if (n.getUserObjectId() != groupId) continue;
            node = n;
            break;
        }
        if (node == null) {
            return;
        }
        TreeViewerAgent.getRegistry().getEventBus().post(new ActivitiesEvent(this.model.getSecurityContext(node)));
        GroupData group = (GroupData)node.getUserObject();
        Map<Integer, Browser> browsers = this.model.getBrowsers();
        for (Map.Entry<Integer, Browser> entry : browsers.entrySet()) {
            browser = entry.getValue();
            browser.removeGroup(group);
        }
        Iterator<TreeImageDisplay> j = groups.iterator();
        while (j.hasNext()) {
            GroupData g = (GroupData)j.next().getUserObject();
            if (g.getId() == group.getId()) continue;
            long gid = this.model.getSelectedGroupId();
            this.model.setSelectedGroupId(g.getId());
            this.notifyChangeGroup(gid);
            break;
        }
        DataBrowserFactory.discardAll();
        this.view.removeAllFromWorkingPane();
    }

    @Override
    public void moveTo(GroupData group, List<DataObject> nodes) {
        if (group == null) {
            throw new IllegalArgumentException("No group to move data to.");
        }
        if (nodes == null || nodes.size() == 0) {
            return;
        }
        HashMap<SecurityContext, List<DataObject>> map = new HashMap<SecurityContext, List<DataObject>>();
        Iterator<DataObject> i = nodes.iterator();
        Class<?> b = null;
        long refgid = group.getId();
        ArrayList<Long> userIDs = new ArrayList<Long>();
        while (i.hasNext()) {
            List<DataObject> l;
            DataObject data = i.next();
            if (!this.canChgrp(data)) continue;
            if (data instanceof ProjectData || data instanceof ScreenData) {
                b = data.getClass();
            }
            long gid = data.getGroupId();
            if (!userIDs.contains(data.getOwner().getId())) {
                userIDs.add(data.getOwner().getId());
            }
            if (gid == refgid) continue;
            SecurityContext ctx = this.getKey(map, gid);
            if (ctx == null) {
                l = new ArrayList();
                ctx = new SecurityContext(gid);
                map.put(ctx, l);
            }
            l = (List)map.get(ctx);
            l.add(data);
        }
        if (userIDs.size() != 1) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Move Data ", "You can only move the data of one member at a time.");
            return;
        }
        if (map.size() == 0) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Move Data ", "No data to move to " + group.getName());
            return;
        }
        long userID = -1L;
        if (b == null) {
            userID = (Long)userIDs.get(0);
        }
        ChgrpObject object = new ChgrpObject(group, null, map);
        object.setUserID(userID);
        this.model.fireImageChecking(map, object, ImageChecker.ImageCheckerType.CHGRP);
    }

    @Override
    public void displayUserGroups(Point location) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        JFrame f = (JFrame)((Object)TreeViewerAgent.getRegistry().getTaskBar());
        IconManager icons = IconManager.getInstance();
        Collection groups = TreeViewerAgent.getAvailableUserGroups();
        if (groups.size() <= 1) {
            return;
        }
        Browser browser = this.model.getBrowser(0);
        ExperimenterVisitor visitor = new ExperimenterVisitor(browser, -1L);
        browser.accept(visitor);
        List<TreeImageDisplay> nodes = visitor.getNodes();
        ArrayList<GroupData> selected = new ArrayList<GroupData>();
        for (TreeImageDisplay n : nodes) {
            if (!(n.getUserObject() instanceof GroupData)) continue;
            selected.add((GroupData)n.getUserObject());
        }
        GroupManagerDialog dialog = new GroupManagerDialog(f, groups, selected, icons.getIcon(153));
        dialog.addPropertyChangeListener(this.controller);
        dialog.setDefaultSize();
        UIUtilities.showOnScreen(dialog, location);
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.model.getSecurityContext();
    }

    @Override
    public Collection getGroups() {
        return this.model.getGroups();
    }

    @Override
    public int getDisplayMode() {
        return this.model.getDisplayMode();
    }

    @Override
    public void setDisplayMode(int index) {
        if (this.model.getState() != 7 || this.model.getDisplayMode() == index) {
            return;
        }
        this.model.setRndSettings(null, null);
        this.model.setNodesToCopy(null, -1);
        this.view.removeAllFromWorkingPane();
        this.model.setDataViewer(null);
        this.clearFoundResults();
        this.model.setDisplayMode(index);
        Map<Integer, Browser> browsers = this.model.getBrowsers();
        for (Map.Entry<Integer, Browser> entry : browsers.entrySet()) {
            Browser browser = entry.getValue();
            browser.changeDisplayMode();
        }
        TreeViewerAgent.getRegistry().getEventBus().post(new DisplayModeEvent(this.model.getDisplayMode()));
    }

    @Override
    public void handleSplitImage(ImageCheckerResult result, final Object action, ImageChecker.ImageCheckerType index) {
        if (!CollectionUtils.isEmpty(result.getMifResults())) {
            MIFNotificationDialog dialog = new MIFNotificationDialog(this.view, result.getMifResults(), action, index, TreeViewerAgent.getAvailableUserGroups());
            dialog.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String name = evt.getPropertyName();
                    if ("moveAll".equals(name)) {
                        TreeViewerComponent.this.moveObject((ChgrpObject)evt.getNewValue());
                    }
                }
            });
            UIUtilities.centerAndShow(dialog);
            return;
        }
        if (ImageChecker.ImageCheckerType.DELETE.equals((Object)index) && !result.getMultiLinkedImages().isEmpty()) {
            LinkNotificationDialog dialog = new LinkNotificationDialog(this.view, result);
            dialog.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String name = evt.getPropertyName();
                    if ("delete".equals(name)) {
                        TreeViewerComponent.this.delete((List)action);
                    }
                }
            });
            UIUtilities.centerAndShow(dialog);
            return;
        }
        if (ImageChecker.ImageCheckerType.DELETE.equals((Object)index)) {
            this.delete((List)action);
        } else if (ImageChecker.ImageCheckerType.CHGRP.equals((Object)index)) {
            this.moveObject((ChgrpObject)action);
        }
    }

    @Override
    public boolean isSystemUser(long userID) {
        return this.model.isSystemUser(userID);
    }

    @Override
    public boolean isSystemUser(long userID, String key) {
        return this.model.isSystemUser(userID, key);
    }

    @Override
    public boolean isSystemGroup(long groupID, String key) {
        return this.model.isSystemGroup(groupID, key);
    }

    @Override
    public Collection<DataObject> getSelectedObjectsFromBrowser() {
        DataBrowser db = this.model.getDataViewer();
        if (db != null && db.getBrowser() != null) {
            return db.getBrowser().getSelectedDataObjects();
        }
        return null;
    }

    @Override
    public void resetRndSettings(long imageID, RndProxyDef settings) {
        MetadataViewer viewer = this.model.getMetadataViewer();
        if (viewer == null) {
            return;
        }
        Object ho = viewer.getRefObject();
        ImageData img = null;
        if (ho instanceof ImageData) {
            img = (ImageData)ho;
        } else if (ho instanceof WellSampleData) {
            img = ((WellSampleData)ho).getImage();
        }
        if (img == null || img.getId() != imageID) {
            return;
        }
        Renderer rnd = viewer.getRenderer();
        if (rnd != null) {
            rnd.resetSettings(settings, true);
        }
    }

    @Override
    public RndProxyDef getSelectedViewedBy() {
        MetadataViewer viewer = this.model.getMetadataViewer();
        if (viewer == null) {
            return null;
        }
        Object ho = viewer.getRefObject();
        ImageData img = null;
        if (ho instanceof ImageData) {
            img = (ImageData)ho;
        } else if (ho instanceof WellSampleData) {
            img = ((WellSampleData)ho).getImage();
        }
        if (img == null) {
            return null;
        }
        Renderer rnd = viewer.getRenderer();
        if (rnd == null) {
            return null;
        }
        return rnd.getSelectedDef();
    }
}

