/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.view;

import java.awt.Component;
import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.FileDataSource;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PixelsData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import omero.log.LogMessage;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.agents.metadata.rnd.Renderer;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerFactory;
import org.openmicroscopy.shoola.agents.treeviewer.AdminCreator;
import org.openmicroscopy.shoola.agents.treeviewer.DataObjectCreator;
import org.openmicroscopy.shoola.agents.treeviewer.DataObjectRemover;
import org.openmicroscopy.shoola.agents.treeviewer.DataObjectUpdater;
import org.openmicroscopy.shoola.agents.treeviewer.DataTreeViewerLoader;
import org.openmicroscopy.shoola.agents.treeviewer.ExistingObjectsLoader;
import org.openmicroscopy.shoola.agents.treeviewer.ExistingObjectsSaver;
import org.openmicroscopy.shoola.agents.treeviewer.ImageChecker;
import org.openmicroscopy.shoola.agents.treeviewer.MoveDataLoader;
import org.openmicroscopy.shoola.agents.treeviewer.OriginalFileLoader;
import org.openmicroscopy.shoola.agents.treeviewer.ParentLoader;
import org.openmicroscopy.shoola.agents.treeviewer.PlateWellsLoader;
import org.openmicroscopy.shoola.agents.treeviewer.ProjectsLoader;
import org.openmicroscopy.shoola.agents.treeviewer.RndSettingsSaver;
import org.openmicroscopy.shoola.agents.treeviewer.ScriptLoader;
import org.openmicroscopy.shoola.agents.treeviewer.ScriptsLoader;
import org.openmicroscopy.shoola.agents.treeviewer.TagHierarchyLoader;
import org.openmicroscopy.shoola.agents.treeviewer.TimeIntervalsLoader;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.treeviewer.finder.Finder;
import org.openmicroscopy.shoola.agents.treeviewer.util.MoveGroupSelectionDialog;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.agents.util.finder.AdvancedFinder;
import org.openmicroscopy.shoola.agents.util.finder.FinderFactory;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.model.AdminObject;
import org.openmicroscopy.shoola.env.data.model.ApplicationData;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.data.model.TimeRefObject;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.util.file.ImportErrorObject;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class TreeViewerModel {
    private int state;
    private DataTreeViewerLoader currentLoader;
    private Map<Integer, Browser> browsers;
    private Browser selectedBrowser;
    private ExperimenterData experimenter;
    private Finder finder;
    private TreeImageDisplay[] nodesToCopy;
    private int copyIndex;
    private boolean recycled;
    private boolean rollOver;
    private ImageData refImage;
    private RndProxyDef refRndSettings;
    private MetadataViewer metadataViewer;
    private DataBrowser dataViewer;
    private AdvancedFinder advancedFinder;
    protected TreeViewer component;
    private boolean importing;
    private Map<Long, ScriptObject> scripts;
    private ViewerSorter sorter;
    private List<ScriptObject> scriptsWithUI;
    private SecurityContext adminContext;
    private long selectedGroupId;
    private int displayMode;
    private int importFailureCount;
    private int importSuccessCount;

    private List<ScriptObject> getScriptsWithUI() {
        if (this.scriptsWithUI != null) {
            return this.scriptsWithUI;
        }
        try {
            OmeroImageService svc = TreeViewerAgent.getRegistry().getImageService();
            this.scriptsWithUI = svc.loadAvailableScriptsWithUI(this.getSecurityContext(null));
            return this.scriptsWithUI;
        }
        catch (Exception e) {
            LogMessage msg = new LogMessage();
            msg.print("Scripts with UI");
            msg.print((Throwable)e);
            TreeViewerAgent.getRegistry().getLogger().error((Object)this, msg);
            return new ArrayList<ScriptObject>();
        }
    }

    private Map buildCopyMap(TreeImageDisplay[] parents) {
        Object uo = this.nodesToCopy[0].getUserObject();
        Object uoParent = parents[0].getUserObject();
        if (!(uo instanceof DataObject)) {
            return null;
        }
        if (!(uoParent instanceof DataObject)) {
            return null;
        }
        DataObject obj = (DataObject)uo;
        DataObject objParent = (DataObject)uoParent;
        if (objParent instanceof ProjectData && obj instanceof DatasetData || objParent instanceof DatasetData && obj instanceof ImageData || objParent instanceof ScreenData && obj instanceof PlateData || objParent instanceof GroupData && obj instanceof ExperimenterData) {
            HashMap map = new HashMap(parents.length);
            for (int i = 0; i < parents.length; ++i) {
                HashSet<Object> children = new HashSet<Object>(this.nodesToCopy.length);
                for (int j = 0; j < this.nodesToCopy.length; ++j) {
                    children.add(this.nodesToCopy[j].getUserObject());
                }
                map.put(parents[i].getUserObject(), children);
            }
            return map;
        }
        if (obj instanceof TagAnnotationData && objParent instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)obj;
            TagAnnotationData tagSet = (TagAnnotationData)objParent;
            String nsSet = tagSet.getNameSpace();
            String ns = tag.getNameSpace();
            if ("openmicroscopy.org/omero/insight/tagset".equals(nsSet) && ns == null) {
                HashMap map = new HashMap(parents.length);
                for (int i = 0; i < parents.length; ++i) {
                    HashSet<Object> children = new HashSet<Object>(this.nodesToCopy.length);
                    for (int j = 0; j < this.nodesToCopy.length; ++j) {
                        children.add(this.nodesToCopy[j].getUserObject());
                    }
                    map.put(parents[i].getUserObject(), children);
                }
                return map;
            }
        }
        return null;
    }

    private Map buildCutMap(TreeImageDisplay[] nodes) {
        HashMap<Object, HashSet<Object>> map = new HashMap<Object, HashSet<Object>>();
        for (int i = 0; i < nodes.length; ++i) {
            TreeImageDisplay child = nodes[i];
            TreeImageDisplay parent = child.getParentDisplay();
            if (parent == null) continue;
            Object po = parent.getUserObject();
            HashSet<Object> children = (HashSet<Object>)map.get(po);
            if (children == null) {
                children = new HashSet<Object>();
                map.put(po, children);
            }
            children.add(nodes[i].getUserObject());
        }
        return map;
    }

    private void createBrowsers() {
        Browser browser;
        this.selectedBrowser = browser = BrowserFactory.createBrowser(0, this.component, this.experimenter, true);
        browser.setSelected(true);
        this.browsers.put(0, browser);
        browser = BrowserFactory.createBrowser(1, this.component, this.experimenter, true);
        this.browsers.put(1, browser);
        browser = BrowserFactory.createBrowser(2, this.component, this.experimenter, true);
        this.browsers.put(2, browser);
        browser = BrowserFactory.createBrowser(5, this.component, this.experimenter, true);
        this.browsers.put(5, browser);
        browser = BrowserFactory.createBrowser(3, this.component, this.experimenter, true);
        this.browsers.put(3, browser);
        browser = BrowserFactory.createBrowser(4, this.component, this.experimenter, true);
        this.browsers.put(4, browser);
        browser = BrowserFactory.createBrowser(6, this.component, this.experimenter, true);
        this.browsers.put(6, browser);
    }

    private void initialize() {
        this.importFailureCount = 0;
        this.importSuccessCount = 0;
        this.state = 1;
        this.browsers = new HashMap<Integer, Browser>();
        this.recycled = false;
        this.refImage = null;
        this.refRndSettings = null;
        this.importing = false;
        this.sorter = new ViewerSorter();
        Integer value = (Integer)TreeViewerAgent.getRegistry().lookup("DataDisplay");
        if (value == null) {
            value = 1;
        }
        this.setDisplayMode(value);
    }

    protected TreeViewerModel(ExperimenterData exp) {
        this.initialize();
        this.experimenter = exp;
        this.selectedGroupId = exp.getDefaultGroup().getId();
    }

    void initialize(TreeViewer component) {
        this.component = component;
        this.createBrowsers();
    }

    boolean isRecycled() {
        return this.recycled;
    }

    void setRecycled(boolean b) {
        this.recycled = b;
    }

    void setSelectedBrowser(Browser browser) {
        this.selectedBrowser = browser;
    }

    Browser getSelectedBrowser() {
        return this.selectedBrowser;
    }

    Map<Integer, Browser> getBrowsers() {
        return this.browsers;
    }

    int getState() {
        return this.state;
    }

    void discard() {
        this.cancel();
        this.state = 2;
    }

    void cancel() {
        if (this.currentLoader != null) {
            this.currentLoader.cancel();
            this.currentLoader = null;
        }
        this.state = 7;
    }

    void fireObjectsDeletion(List<DataObject> values) {
        this.state = 3;
        SecurityContext ctx = this.getSecurityContext();
        this.currentLoader = new DataObjectRemover(this.component, ctx, values);
        this.currentLoader.load();
    }

    Finder getFinder() {
        return this.finder;
    }

    void setFinder(Finder finder) {
        this.finder = finder;
    }

    ExperimenterData getUserDetails() {
        return (ExperimenterData)TreeViewerAgent.getRegistry().lookup("/current_user/details");
    }

    void setState(int state) {
        this.state = state;
    }

    void fireDataExistingObjectsLoader(DataObject ho) {
        this.state = 5;
        SecurityContext ctx = this.getSecurityContext();
        if (TreeViewerAgent.isAdministrator()) {
            ctx = this.getAdminContext();
        }
        this.currentLoader = new ExistingObjectsLoader(this.component, ctx, ho);
        this.currentLoader.load();
    }

    void fireAddExistingObjects(Set children) {
        TreeImageDisplay parent = this.selectedBrowser.getLastSelectedDisplay();
        if (parent == null) {
            return;
        }
        Object po = parent.getUserObject();
        SecurityContext ctx = this.getSecurityContext();
        if (po instanceof ProjectData || po instanceof DatasetData) {
            this.currentLoader = new ExistingObjectsSaver(this.component, ctx, (DataObject)po, children);
            this.currentLoader.load();
        }
        this.state = 7;
    }

    void setNodesToCopy(TreeImageDisplay[] nodes, int index) {
        this.copyIndex = index;
        this.nodesToCopy = nodes;
    }

    TreeImageDisplay[] getNodesToCopy() {
        return this.nodesToCopy;
    }

    boolean paste(TreeImageDisplay[] parents) {
        if (parents[0].getUserObject() instanceof ExperimenterData) {
            this.copyIndex = 401;
            return this.cut();
        }
        Map map = this.buildCopyMap(parents);
        SecurityContext ctx = this.getSecurityContext();
        if (map == null) {
            return false;
        }
        if (this.copyIndex == 400) {
            this.currentLoader = new DataObjectUpdater(this.component, ctx, map, 0);
        } else if (this.copyIndex == 401) {
            Map toRemove = this.buildCutMap(this.nodesToCopy);
            this.currentLoader = new DataObjectUpdater(this.component, ctx, map, toRemove, 1);
        }
        this.currentLoader.load();
        this.state = 3;
        this.nodesToCopy = null;
        return true;
    }

    boolean cut() {
        if (this.copyIndex != 401) {
            return false;
        }
        if (this.nodesToCopy == null || this.nodesToCopy.length == 0) {
            return false;
        }
        Map toRemove = this.buildCutMap(this.nodesToCopy);
        SecurityContext ctx = this.getSecurityContext();
        this.currentLoader = new DataObjectUpdater(this.component, ctx, new HashMap(), toRemove, 2);
        this.currentLoader.load();
        this.state = 3;
        return true;
    }

    String getExperimenterNames() {
        return EditorUtil.formatExperimenter(this.getExperimenter());
    }

    ExperimenterData getExperimenter() {
        return this.getUserDetails();
    }

    boolean isRollOver() {
        return this.rollOver;
    }

    void setRollOver(boolean rollOver) {
        this.rollOver = rollOver;
    }

    void setRndSettings(ImageData refImage, RndProxyDef rndProxyDef) {
        this.refImage = refImage;
        this.refRndSettings = rndProxyDef;
    }

    boolean hasRndSettingsToPaste() {
        return this.refRndSettings != null || this.refImage != null;
    }

    void firePasteRenderingSettings(List<Long> ids, Class klass) {
        this.state = 8;
        SecurityContext ctx = this.getSecurityContext();
        if (ctx == null) {
            ctx = new SecurityContext(this.refImage.getGroupId());
        }
        this.currentLoader = new RndSettingsSaver(this.component, ctx, klass, ids, this.refRndSettings, this.refImage);
        this.currentLoader.load();
    }

    void firePasteRenderingSettings(TimeRefObject ref) {
        this.state = 8;
        SecurityContext ctx = this.getSecurityContext();
        this.currentLoader = new RndSettingsSaver(this.component, ctx, ref, this.refImage);
        this.currentLoader.load();
    }

    void fireResetRenderingSettings(List<Long> ids, Class klass) {
        this.state = 8;
        SecurityContext ctx = this.getSecurityContext();
        this.currentLoader = new RndSettingsSaver(this.component, ctx, klass, ids, 1);
        this.currentLoader.load();
    }

    void fireResetRenderingSettings(TimeRefObject ref) {
        this.state = 8;
        SecurityContext ctx = this.getSecurityContext();
        this.currentLoader = new RndSettingsSaver(this.component, ctx, ref, 1);
        this.currentLoader.load();
    }

    void fireSetMinMax(List<Long> ids, Class klass) {
        this.state = 8;
        SecurityContext ctx = this.getSecurityContext();
        this.currentLoader = new RndSettingsSaver(this.component, ctx, klass, ids, 2);
        this.currentLoader.load();
    }

    void fireSetOwnerRenderingSettings(List<Long> ids, Class klass) {
        this.state = 8;
        SecurityContext ctx = this.getSecurityContext();
        this.currentLoader = new RndSettingsSaver(this.component, ctx, klass, ids, 3);
        this.currentLoader.load();
    }

    void fireSetOriginalRenderingSettings(TimeRefObject ref) {
        this.state = 8;
        SecurityContext ctx = this.getSecurityContext();
        this.currentLoader = new RndSettingsSaver(this.component, ctx, ref, 2);
        this.currentLoader.load();
    }

    void fireSetOwnerRenderingSettings(TimeRefObject ref) {
        this.state = 8;
        SecurityContext ctx = this.getSecurityContext();
        this.currentLoader = new RndSettingsSaver(this.component, ctx, ref, 2);
        this.currentLoader.load();
    }

    void fireDataObjectCreation(DataObject object, boolean withParent) {
        Browser browser;
        TreeImageDisplay node;
        DataObject data = null;
        if (withParent && (node = (browser = this.getSelectedBrowser()).getLastSelectedDisplay()) != null) {
            TagAnnotationData tag;
            String ns;
            Object p = node.getUserObject();
            if (object instanceof DatasetData) {
                if (p instanceof ProjectData) {
                    data = (DataObject)p;
                }
            } else if (object instanceof PlateData) {
                if (p instanceof ScreenData) {
                    data = (DataObject)p;
                }
            } else if (object instanceof TagAnnotationData && p instanceof TagAnnotationData && (ns = (tag = (TagAnnotationData)p).getNameSpace()) != null && "openmicroscopy.org/omero/insight/tagset".equals(ns)) {
                data = tag;
            }
        }
        SecurityContext ctx = this.getSecurityContext();
        this.currentLoader = new DataObjectCreator(this.component, ctx, object, data);
        this.currentLoader.load();
    }

    MetadataViewer getMetadataViewer() {
        if (this.metadataViewer == null) {
            this.metadataViewer = MetadataViewerFactory.getViewer("");
        }
        return this.metadataViewer;
    }

    AdvancedFinder getAdvancedFinder() {
        if (this.advancedFinder == null) {
            this.advancedFinder = FinderFactory.getAdvancedFinder(TreeViewerAgent.getRegistry(), TreeViewerAgent.getAvailableUserGroups());
            this.advancedFinder.setDisplayMode(this.getDisplayMode());
        }
        return this.advancedFinder;
    }

    void browseProject(TreeImageDisplay node) {
        this.state = 5;
        ExperimenterData exp = this.getSelectedBrowser().getNodeOwner(node);
        SecurityContext ctx = this.getSecurityContext();
        this.currentLoader = new ProjectsLoader(this.component, ctx, node, exp.getId());
        this.currentLoader.load();
    }

    void browsePlates(Collection<TreeImageDisplay> nodes, boolean withThumbnails) {
        this.state = 5;
        ArrayList<TreeImageSet> plates = new ArrayList<TreeImageSet>();
        Iterator<TreeImageDisplay> i = nodes.iterator();
        while (i.hasNext()) {
            plates.add((TreeImageSet)i.next());
        }
        SecurityContext ctx = this.getSecurityContext();
        this.currentLoader = new PlateWellsLoader(this.component, ctx, plates, withThumbnails);
        this.currentLoader.load();
    }

    void browseTimeInterval(TreeImageTimeSet node) {
        this.state = 5;
        SecurityContext ctx = this.getSecurityContext();
        this.currentLoader = new TimeIntervalsLoader(this.component, ctx, node);
        this.currentLoader.load();
    }

    void browseTag(TreeImageDisplay node) {
        this.state = 5;
        ExperimenterData exp = this.getSelectedBrowser().getNodeOwner(node);
        if (exp == null) {
            exp = TreeViewerAgent.getUserDetails();
        }
        SecurityContext ctx = this.getSecurityContext();
        this.currentLoader = new TagHierarchyLoader(this.component, ctx, node, exp.getId());
        this.currentLoader.load();
    }

    Browser getBrowser(int index) {
        return this.browsers.get(index);
    }

    String getRefImagePartialName() {
        if (this.refImage == null) {
            return null;
        }
        return EditorUtil.getPartialName(this.refImage.getName());
    }

    String getRefImageName() {
        if (this.refImage == null) {
            return null;
        }
        return UIUtilities.removeFileExtension(this.refImage.getName());
    }

    boolean areSettingsCompatible(long groupID) {
        if (this.refImage == null) {
            return false;
        }
        return this.refRndSettings != null || this.refImage.getGroupId() == groupID;
    }

    Class getDataToCopyType() {
        TreeImageDisplay[] nodes = this.getNodesToCopy();
        if (nodes == null || nodes.length == 0) {
            return null;
        }
        Object ho = nodes[0].getUserObject();
        return ho.getClass();
    }

    List<DataObject> getDataToCopy() {
        TreeImageDisplay[] nodes = this.getNodesToCopy();
        if (nodes == null || nodes.length == 0) {
            return null;
        }
        ArrayList<DataObject> l = new ArrayList<DataObject>();
        for (int i = 0; i < nodes.length; ++i) {
            if (!(nodes[i].getUserObject() instanceof DataObject)) continue;
            l.add((DataObject)nodes[i].getUserObject());
        }
        return l;
    }

    void setDataViewer(DataBrowser dataViewer) {
        this.dataViewer = dataViewer;
    }

    DataBrowser getDataViewer() {
        return this.dataViewer;
    }

    void downloadImages(List<ImageData> images, File folder, ApplicationData application) {
        if (images == null || images.isEmpty()) {
            return;
        }
        HashSet<Long> ids = new HashSet<Long>();
        for (ImageData o : images) {
            ImageData img;
            if (!(o instanceof ImageData) || !(img = o).isArchived()) continue;
            PixelsData data = img.getDefaultPixels();
            ids.add(data.getId());
        }
        SecurityContext ctx = this.getSecurityContext();
        OriginalFileLoader loader = new OriginalFileLoader(this.component, ctx, ids, folder, application);
        loader.load();
    }

    void refreshRenderer() {
        if (this.metadataViewer == null) {
            return;
        }
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd != null) {
            rnd.refresh();
            this.metadataViewer.renderPlane();
        }
    }

    MetadataViewer resetMetadataViewer() {
        this.metadataViewer = null;
        return this.getMetadataViewer();
    }

    void reloadThumbnails(List<Long> ids) {
        if (this.dataViewer != null) {
            this.dataViewer.reloadThumbnails(ids);
        }
    }

    String getObjectMimeType(Object object) {
        if (object instanceof ImageData) {
            ImageData img = (ImageData)object;
            if (img.isArchived()) {
                return "imageNotArchived";
            }
            return "imageNotArchived";
        }
        if (object instanceof FileAnnotationData) {
            FileAnnotationData fa = (FileAnnotationData)object;
            FileDataSource fds = new FileDataSource(fa.getFileName());
            String type = fds.getContentType();
            return type;
        }
        return null;
    }

    String getObjectMimeType() {
        Browser browser = this.getSelectedBrowser();
        if (browser == null) {
            return null;
        }
        TreeImageDisplay d = browser.getLastSelectedDisplay();
        if (d == null) {
            return null;
        }
        return this.getObjectMimeType(d.getUserObject());
    }

    boolean isLeader() {
        return TreeViewerAgent.getGroupsLeaderOf().size() > 0;
    }

    boolean isGroupOwner(GroupData g) {
        if (g == null) {
            return false;
        }
        Set leaders = g.getLeaders();
        if (CollectionUtils.isEmpty((Collection)leaders)) {
            return false;
        }
        Iterator i = leaders.iterator();
        ExperimenterData user = this.getExperimenter();
        while (i.hasNext()) {
            ExperimenterData leader = (ExperimenterData)i.next();
            if (user.getId() != leader.getId()) continue;
            return true;
        }
        return false;
    }

    boolean isAdministrator() {
        return TreeViewerAgent.isAdministrator();
    }

    void fireAdmin(AdminObject object) {
        SecurityContext ctx = this.getSecurityContext();
        if (TreeViewerAgent.isAdministrator()) {
            ctx = this.getAdminContext();
        }
        this.currentLoader = new AdminCreator(this.component, ctx, object);
        this.currentLoader.load();
    }

    SecurityContext getAdminContext() {
        if (this.adminContext == null) {
            this.adminContext = TreeViewerAgent.getAdminContext();
        }
        return this.adminContext;
    }

    boolean isImporting() {
        return this.importing;
    }

    void setImporting(boolean importing, Object importResult) {
        this.importing = importing;
        if (importResult == null) {
            return;
        }
        if (importResult instanceof ImportErrorObject) {
            ++this.importFailureCount;
        } else {
            ++this.importSuccessCount;
        }
    }

    void clearImportResult() {
        this.importFailureCount = 0;
        this.importSuccessCount = 0;
    }

    int getImportFailureCount() {
        return this.importFailureCount;
    }

    int getImportSuccessCount() {
        return this.importSuccessCount;
    }

    boolean isFullScreen() {
        return true;
    }

    void loadParentOf(FileAnnotationData data) {
        SecurityContext ctx = new SecurityContext(data.getGroupId());
        ParentLoader loader = new ParentLoader(this.component, ctx, data);
        loader.load();
    }

    void fireDataSaving(DataObject data, Collection children) {
        if (data instanceof DatasetData) {
            SecurityContext ctx = this.getSecurityContext();
            DataObjectCreator loader = new DataObjectCreator(this.component, ctx, data, null, children);
            loader.load();
        }
    }

    ScriptObject getScript(long scriptID) {
        return this.scripts.get(scriptID);
    }

    void loadScripts(Point location, Component invoker) {
        ScriptsLoader loader = new ScriptsLoader(this.component, this.getSecurityContext(null), false, location, invoker);
        loader.load();
    }

    Collection<ScriptObject> getAvailableScripts() {
        if (this.scripts == null) {
            return null;
        }
        return this.scripts.values();
    }

    void setAvailableScripts(List scripts) {
        if (scripts == null) {
            this.scripts = null;
            return;
        }
        LinkedHashMap<Long, ScriptObject> map = new LinkedHashMap<Long, ScriptObject>();
        List l = this.sorter.sort(scripts);
        for (ScriptObject s : l) {
            map.put(s.getScriptID(), s);
        }
        this.scripts = map;
    }

    void loadScript(long scriptID) {
        ScriptLoader loader = new ScriptLoader(this.component, this.getSecurityContext(null), scriptID);
        loader.load();
    }

    void setScript(ScriptObject script) {
        if (this.scripts == null || this.scripts.size() == 0) {
            return;
        }
        ScriptObject sc = this.scripts.get(script.getScriptID());
        if (sc != null) {
            sc.setJobParams(script.getParameters());
        }
    }

    ScriptObject getScriptFromName(String name) {
        List<ScriptObject> scripts = this.getScriptsWithUI();
        for (ScriptObject script : scripts) {
            if (!name.contains(script.getName())) continue;
            return script;
        }
        return null;
    }

    void transfer(TreeImageDisplay target, List<TreeImageDisplay> nodes) {
        this.nodesToCopy = nodes.toArray(new TreeImageDisplay[0]);
        this.copyIndex = 401;
        Map toRemove = this.buildCutMap(this.nodesToCopy);
        Map map = new HashMap();
        if (target != null) {
            TreeImageDisplay[] parents = new TreeImageDisplay[]{target};
            map = this.buildCopyMap(parents);
        }
        SecurityContext ctx = this.getSecurityContext();
        this.currentLoader = new DataObjectUpdater(this.component, ctx, map, toRemove, 1);
        this.currentLoader.load();
        this.state = 3;
    }

    SecurityContext getSecurityContext() {
        return this.getSecurityContext(null);
    }

    SecurityContext getSecurityContext(TreeImageDisplay node) {
        Browser browser = this.getSelectedBrowser();
        if (browser == null) {
            return new SecurityContext(this.selectedGroupId);
        }
        if (node == null) {
            node = browser.getLastSelectedDisplay();
        }
        if (node == null) {
            return new SecurityContext(this.selectedGroupId);
        }
        return browser.getSecurityContext(node);
    }

    GroupData getSelectedGroup() {
        GroupData g2;
        Collection set = TreeViewerAgent.getAvailableUserGroups();
        for (GroupData g2 : set) {
            if (g2.getId() != this.selectedGroupId) continue;
            return g2;
        }
        g2 = TreeViewerAgent.getUserDetails().getDefaultGroup();
        this.selectedGroupId = g2.getGroupId();
        return g2;
    }

    Collection<GroupData> getAvailableGroups() {
        return TreeViewerAgent.getAvailableUserGroups();
    }

    long getSelectedGroupId() {
        return this.selectedGroupId;
    }

    void setSelectedGroupId(long selectedGroupId) {
        this.selectedGroupId = selectedGroupId;
    }

    void fireMoveDataLoading(SecurityContext ctx, MoveGroupSelectionDialog dialog, Class type, long userID) {
        MoveDataLoader loader = new MoveDataLoader(this.component, ctx, type, dialog, userID);
        loader.load();
    }

    GroupData getGroup(long groupId) {
        Collection groups = TreeViewerAgent.getAvailableUserGroups();
        if (groups == null) {
            return null;
        }
        for (GroupData group : groups) {
            if (group.getId() != groupId) continue;
            return group;
        }
        return null;
    }

    Collection getGroups() {
        return TreeViewerAgent.getAvailableUserGroups();
    }

    int getDisplayMode() {
        return this.displayMode;
    }

    void setDisplayMode(int value) {
        switch (value) {
            case 0: 
            case 1: {
                this.displayMode = value;
                break;
            }
            default: {
                this.displayMode = 1;
            }
        }
    }

    void fireImageChecking(Map<SecurityContext, List<DataObject>> objects, Object action, ImageChecker.ImageCheckerType index) {
        ImageChecker loader = new ImageChecker(this.component, this.getSecurityContext(), objects, action, index);
        loader.load();
    }

    String getHostname() {
        return TreeViewerAgent.getRegistry().getAdminService().getServerName();
    }

    boolean isSystemUser(long id) {
        return TreeViewerAgent.getRegistry().getAdminService().isSystemUser(id);
    }

    boolean isSystemUser(long id, String key) {
        return TreeViewerAgent.getRegistry().getAdminService().isSystemUser(id, key);
    }

    boolean isSystemGroup(long id, String key) {
        return TreeViewerAgent.getRegistry().getAdminService().isSecuritySystemGroup(id, key);
    }
}

