/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.GroupData;
import omero.gateway.model.TagAnnotationData;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.TreeCellRenderer;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeViewerTranslator;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.NotificationDialog;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class SelectionWizardUI
extends JPanel
implements ActionListener,
DocumentListener {
    public static final String SELECTION_CHANGE = "selectionChange";
    static final String AVAILABLE_SELECTION_CHANGE = "availableSelectionChange";
    static Integer ALL = 0;
    static int CURRENT = 1;
    static int OTHERS = 2;
    private static final String DEFAULT_FILTER_TEXT = "Filter";
    private static final int ADD = 0;
    private static final int REMOVE = 1;
    private static final int ADD_ALL = 2;
    private static final int REMOVE_ALL = 3;
    private List<TreeImageDisplay> originalItems;
    private List<TreeImageDisplay> originalSelectedItems;
    private List<TreeImageDisplay> availableItems;
    private List<TreeImageDisplay> selectedItems;
    private JTree availableItemsListbox;
    private JTree selectedItemsListbox;
    private JButton addButton;
    private JButton removeButton;
    private JButton addAllButton;
    private JButton removeAllButton;
    private ViewerSorter sorter;
    private Class<?> type;
    private Collection immutable;
    private Collection<GroupData> groups;
    private JTextField filterArea;
    private boolean filterAnywhere;
    private Color originalColor;
    private JDialog view;
    private ExperimenterData user;
    private int ownerFilterIndex;

    private boolean isSelected(Object elt) {
        if (elt instanceof TreeImageDisplay) {
            DataObject n = (DataObject)((TreeImageDisplay)elt).getUserObject();
            for (TreeImageDisplay item : this.selectedItems) {
                DataObject data = (DataObject)item.getUserObject();
                if (n.getId() != data.getId()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean filterItem(String value, String txt, DataObject data) {
        if (!(data instanceof ExperimenterData) && !(data instanceof GroupData)) {
            ExperimenterData exp = data.getOwner();
            if (this.ownerFilterIndex == CURRENT ? exp.getId() != this.user.getId() : this.ownerFilterIndex == OTHERS && exp.getId() == this.user.getId()) {
                return false;
            }
        }
        if (this.filterAnywhere) {
            return value.contains(txt);
        }
        return value.startsWith(txt);
    }

    private void filter(boolean insert) {
        TreeImageDisplay node;
        List<TreeImageDisplay> ref;
        String txt = this.filterArea.getText();
        if (DEFAULT_FILTER_TEXT.equals(txt)) {
            return;
        }
        this.filterArea.setForeground(this.originalColor);
        if (insert) {
            ref = this.availableItems;
        } else {
            ref = new ArrayList<TreeImageDisplay>();
            for (TreeImageDisplay item : this.originalItems) {
                if (this.isSelected(item)) continue;
                ref.add(item);
            }
            for (TreeImageDisplay item : this.originalSelectedItems) {
                if (this.isSelected(item) || this.isChild(item)) continue;
                ref.add(item);
            }
        }
        Iterator<TreeImageDisplay> i = ref.iterator();
        txt = txt.toLowerCase();
        ArrayList<TreeImageDisplay> toKeep = new ArrayList<TreeImageDisplay>();
        while (i.hasNext()) {
            node = i.next();
            Object ho = node.getUserObject();
            String value = null;
            if (ho instanceof TagAnnotationData) {
                TagAnnotationData tag = (TagAnnotationData)ho;
                if (!"openmicroscopy.org/omero/insight/tagset".equals(tag.getNameSpace())) {
                    value = tag.getTagValue();
                } else {
                    List l = node.getChildrenDisplay();
                    for (TreeImageDisplay child : l) {
                        if (this.isSelected(child) || !((ho = child.getUserObject()) instanceof TagAnnotationData)) continue;
                        tag = (TagAnnotationData)ho;
                        value = tag.getTagValue();
                        if (!this.filterItem(value = value.toLowerCase(), txt, (DataObject)ho)) continue;
                        toKeep.add(node);
                        break;
                    }
                    value = null;
                }
            } else if (ho instanceof FileAnnotationData) {
                value = ((FileAnnotationData)ho).getFileName();
            } else if (ho instanceof DataObject) {
                value = node.getNodeName();
            }
            if (value == null || !this.filterItem(value = value.toLowerCase(), txt, (DataObject)ho)) continue;
            toKeep.add(node);
        }
        this.availableItems.clear();
        this.availableItems.addAll(toKeep);
        this.availableItems = this.sorter.sort(this.availableItems);
        this.populateTreeItems(this.availableItemsListbox, this.availableItems);
        if (CollectionUtils.isNotEmpty(this.availableItems) && CommonsLangUtils.isNotBlank(txt)) {
            node = this.availableItems.get(0);
            TreePath path = null;
            if (node.hasChildrenDisplay() && node.getChildCount() > 0) {
                TreeImageDisplay child;
                child = (TreeImageDisplay)node.getFirstChild();
                path = new TreePath(child.getPath());
            } else {
                path = new TreePath(node.getPath());
            }
            if (path != null) {
                this.availableItemsListbox.setSelectionPath(path);
                this.availableItemsListbox.scrollPathToVisible(path);
                this.availableItemsListbox.repaint();
            }
        }
    }

    private TreeImageDisplay doesObjectExist(DataObject object, boolean selected) {
        block11: {
            if (object == null) {
                return null;
            }
            if (!(object instanceof TagAnnotationData)) break block11;
            String value = ((TagAnnotationData)object).getTagValue();
            if (value == null) {
                return null;
            }
            value = value.toLowerCase();
            if (!selected) {
                String v;
                List children;
                TagAnnotationData ob;
                for (TreeImageDisplay node22 : this.originalItems) {
                    ob = (TagAnnotationData)node22.getUserObject();
                    if (ob == null) continue;
                    if ("openmicroscopy.org/omero/insight/tagset".equals(ob.getNameSpace())) {
                        children = node22.getChildrenDisplay();
                        for (TreeImageDisplay node22 : children) {
                            if (this.isSelected(node22) || !value.equals(v = (ob = (TagAnnotationData)node22.getUserObject()).getTagValue().toLowerCase())) continue;
                            return node22;
                        }
                        continue;
                    }
                    if (this.isSelected(node22) || !value.equals(v = ob.getTagValue().toLowerCase())) continue;
                    return node22;
                }
                for (TreeImageDisplay node22 : this.availableItems) {
                    ob = (TagAnnotationData)node22.getUserObject();
                    if (ob == null) continue;
                    if ("openmicroscopy.org/omero/insight/tagset".equals(ob.getNameSpace())) {
                        children = node22.getChildrenDisplay();
                        for (TreeImageDisplay node22 : children) {
                            if (this.isSelected(node22) || !value.equals(v = (ob = (TagAnnotationData)node22.getUserObject()).getTagValue().toLowerCase())) continue;
                            return node22;
                        }
                        continue;
                    }
                    if (this.isSelected(node22) || !value.equals(v = ob.getTagValue().toLowerCase())) continue;
                    return node22;
                }
            } else {
                for (TreeImageDisplay node : this.selectedItems) {
                    String v;
                    TagAnnotationData ob = (TagAnnotationData)node.getUserObject();
                    if (ob == null || !value.equals(v = ob.getTagValue().toLowerCase())) continue;
                    return node;
                }
            }
        }
        return null;
    }

    private void setTextFieldDefault(String text) {
        this.filterArea.getDocument().removeDocumentListener(this);
        if (text == null) {
            this.filterArea.setText("");
            this.filterArea.setForeground(this.originalColor);
        } else {
            this.filterArea.setText(text);
            this.filterArea.setForeground(Color.LIGHT_GRAY);
        }
        this.filterArea.getDocument().addDocumentListener(this);
        this.filterArea.setSelectionStart(0);
        this.filterArea.setSelectionEnd(this.filterArea.getText().length());
    }

    private void initializeTree(JTree tree, ExperimenterData user) {
        tree.setVisible(true);
        tree.setRootVisible(false);
        ToolTipManager.sharedInstance().registerComponent(tree);
        tree.setCellRenderer(new TreeCellRenderer(user, false));
        tree.setShowsRootHandles(true);
        TreeImageSet root = new TreeImageSet("");
        tree.setModel(new DefaultTreeModel(root));
    }

    private void initComponents() {
        this.filterAnywhere = true;
        this.filterArea = new JTextField();
        this.originalColor = this.filterArea.getForeground();
        this.setTextFieldDefault(DEFAULT_FILTER_TEXT);
        StringBuilder builder = new StringBuilder();
        builder.append(DEFAULT_FILTER_TEXT);
        if (TagAnnotationData.class.equals(this.type)) {
            builder.append(" Tags.");
        } else if (FileAnnotationData.class.equals(this.type)) {
            builder.append(" Attachments.");
        } else if (DatasetData.class.equals(this.type)) {
            builder.append(" Datasets.");
        } else {
            builder.append(".");
        }
        this.filterArea.setToolTipText(builder.toString());
        this.filterArea.getDocument().addDocumentListener(this);
        this.filterArea.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent evt) {
                String value = SelectionWizardUI.this.filterArea.getText();
                if (CommonsLangUtils.isBlank(value)) {
                    SelectionWizardUI.this.setTextFieldDefault(SelectionWizardUI.DEFAULT_FILTER_TEXT);
                }
            }

            @Override
            public void focusGained(FocusEvent evt) {
            }
        });
        this.filterArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                String value = SelectionWizardUI.this.filterArea.getText();
                if (SelectionWizardUI.DEFAULT_FILTER_TEXT.equals(value)) {
                    SelectionWizardUI.this.setTextFieldDefault(null);
                }
            }
        });
        this.filterArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && SelectionWizardUI.this.filterArea.isFocusOwner()) {
                    SelectionWizardUI.this.addItem();
                    SelectionWizardUI.this.setTextFieldDefault(SelectionWizardUI.DEFAULT_FILTER_TEXT);
                    SelectionWizardUI.this.availableItemsListbox.requestFocus();
                }
            }
        });
        this.sorter = new ViewerSorter();
        this.availableItemsListbox = new JTree();
        this.initializeTree(this.availableItemsListbox, this.user);
        this.availableItemsListbox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && SelectionWizardUI.this.availableItemsListbox.isFocusOwner()) {
                    SelectionWizardUI.this.addItem();
                }
            }
        });
        this.availableItemsListbox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 2 && SelectionWizardUI.this.availableItemsListbox.isFocusOwner()) {
                    SelectionWizardUI.this.addItem();
                }
            }
        });
        this.availableItemsListbox.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                SelectionWizardUI.this.firePropertyChange(SelectionWizardUI.AVAILABLE_SELECTION_CHANGE, Boolean.TRUE, Boolean.FALSE);
            }
        });
        this.selectedItemsListbox = new JTree();
        this.initializeTree(this.selectedItemsListbox, this.user);
        this.selectedItemsListbox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && SelectionWizardUI.this.selectedItemsListbox.isFocusOwner()) {
                    SelectionWizardUI.this.removeItem();
                }
            }
        });
        this.selectedItemsListbox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 2 && SelectionWizardUI.this.selectedItemsListbox.isFocusOwner()) {
                    SelectionWizardUI.this.removeItem();
                }
            }
        });
        IconManager icons = IconManager.getInstance();
        this.addButton = new JButton(icons.getIcon(86));
        this.removeButton = new JButton(icons.getIcon(87));
        this.addAllButton = new JButton(icons.getIcon(84));
        this.removeAllButton = new JButton(icons.getIcon(85));
        this.addButton.setActionCommand("0");
        this.addButton.addActionListener(this);
        this.addAllButton.setActionCommand("2");
        this.addAllButton.addActionListener(this);
        this.removeButton.setActionCommand("1");
        this.removeButton.addActionListener(this);
        this.removeAllButton.setActionCommand("3");
        this.removeAllButton.addActionListener(this);
        this.setImmutableElements(null);
    }

    public String formatTooltip(AnnotationData data, List<TagAnnotationData> parents, ExperimenterData exp) {
        if (data == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<html><body>");
        String txt = "";
        txt = exp != null ? EditorUtil.formatExperimenter(exp) : EditorUtil.formatExperimenter(data.getOwner());
        if (CommonsLangUtils.isNotBlank(txt)) {
            buf.append("<b>");
            buf.append("Owner: ");
            buf.append("</b>");
            buf.append(txt);
            buf.append("<br>");
        }
        if (data instanceof TagAnnotationData && CommonsLangUtils.isNotBlank(txt = ((TagAnnotationData)data).getTagDescription())) {
            buf.append("<b>");
            buf.append("Description: ");
            buf.append("</b>");
            buf.append(txt);
            buf.append("<br>");
        }
        if (CollectionUtils.isNotEmpty(parents)) {
            buf.append("<b>");
            buf.append("Tag Set: ");
            buf.append("</b>");
            for (TagAnnotationData item : parents) {
                buf.append(item.getTagValue());
                buf.append(" ");
            }
            buf.append("<br>");
        }
        buf.append("</body></html>");
        return buf.toString();
    }

    private List<TagAnnotationData> getParents(TagAnnotationData tag) {
        ArrayList<TagAnnotationData> parents = new ArrayList<TagAnnotationData>();
        for (TreeImageDisplay item : this.originalItems) {
            Set tags;
            TagAnnotationData t = (TagAnnotationData)item.getUserObject();
            if (!"openmicroscopy.org/omero/insight/tagset".equals(t.getNameSpace()) || CollectionUtils.isEmpty((Collection)(tags = t.getTags()))) continue;
            for (TagAnnotationData n : tags) {
                if (n.getId() != tag.getId()) continue;
                parents.add(t);
            }
        }
        return parents;
    }

    private void createOriginalSelections() {
        TagAnnotationData tag;
        Object ho;
        this.originalItems = new ArrayList<TreeImageDisplay>();
        if (this.availableItems != null) {
            for (TreeImageDisplay item : this.availableItems) {
                this.originalItems.add(item);
                ho = item.getUserObject();
                if (ho instanceof TagAnnotationData) {
                    tag = (TagAnnotationData)ho;
                    item.setToolTip(this.formatTooltip((AnnotationData)tag, null, null));
                    List l = item.getChildrenDisplay();
                    List<TagAnnotationData> p = Arrays.asList(tag);
                    for (TreeImageDisplay j : l) {
                        j.setToolTip(this.formatTooltip((AnnotationData)tag, p, null));
                    }
                    continue;
                }
                if (!(ho instanceof AnnotationData)) continue;
                item.setToolTip(this.formatTooltip((AnnotationData)ho, null, null));
            }
        }
        this.originalSelectedItems = new ArrayList<TreeImageDisplay>();
        if (this.selectedItems != null) {
            for (TreeImageDisplay item : this.selectedItems) {
                this.originalSelectedItems.add(item);
                ho = item.getUserObject();
                if (ho instanceof TagAnnotationData) {
                    tag = (TagAnnotationData)item.getUserObject();
                    item.setToolTip(this.formatTooltip((AnnotationData)tag, this.getParents(tag), null));
                    continue;
                }
                if (!(ho instanceof AnnotationData)) continue;
                item.setToolTip(this.formatTooltip((AnnotationData)ho, null, null));
            }
        }
    }

    private void addAllItems() {
        ArrayList<TreeImageDisplay> toKeep = new ArrayList<TreeImageDisplay>();
        for (TreeImageDisplay node : this.availableItems) {
            if (node.hasChildrenDisplay()) {
                toKeep.add(node);
                List l = node.getChildrenDisplay();
                for (TreeImageDisplay child : l) {
                    if (this.isSelected(child)) continue;
                    this.selectedItems.add(child);
                }
                continue;
            }
            Object ho = node.getUserObject();
            if (ho instanceof TagAnnotationData) {
                TagAnnotationData tag = (TagAnnotationData)ho;
                if (!"openmicroscopy.org/omero/insight/tagset".equals(tag.getNameSpace())) {
                    if (this.isSelected(node)) continue;
                    this.selectedItems.add(node);
                    continue;
                }
                toKeep.add(node);
                continue;
            }
            if (this.isSelected(node)) continue;
            this.selectedItems.add(node);
        }
        this.availableItems.retainAll(toKeep);
        this.sortLists();
        this.populateTreeItems(this.availableItemsListbox, this.availableItems);
        this.populateTreeItems(this.selectedItemsListbox, this.selectedItems);
        this.onSelectionChange();
    }

    private boolean isImmutable(DataObject data) {
        for (DataObject o : this.immutable) {
            if (data.getId() != o.getId()) continue;
            return true;
        }
        return false;
    }

    private boolean isChild(TreeImageDisplay node) {
        if (node == null) {
            return false;
        }
        Object uo = node.getUserObject();
        if (!(uo instanceof DataObject)) {
            return false;
        }
        DataObject ref = (DataObject)uo;
        for (TreeImageDisplay n : this.originalItems) {
            Set children;
            TagAnnotationData tag;
            Object data = n.getUserObject();
            if (!(data instanceof TagAnnotationData) || !"openmicroscopy.org/omero/insight/tagset".equals((tag = (TagAnnotationData)data).getNameSpace()) || CollectionUtils.isEmpty((Collection)(children = tag.getTags()))) continue;
            for (DataObject o : children) {
                if (o.getId() != ref.getId()) continue;
                return true;
            }
        }
        return false;
    }

    private void removeItem() {
        TreePath[] paths = this.selectedItemsListbox.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return;
        }
        ArrayList<TreeImageDisplay> toRemove = new ArrayList<TreeImageDisplay>();
        for (int i = 0; i < paths.length; ++i) {
            Object c = paths[i].getLastPathComponent();
            if (!(c instanceof TreeImageDisplay)) continue;
            TreeImageDisplay node = (TreeImageDisplay)c;
            Object ho = node.getUserObject();
            if (ho instanceof DataObject) {
                DataObject data = (DataObject)ho;
                if (this.isImmutable(data)) continue;
                if (data.getId() >= 0L && !this.isChild(node)) {
                    this.availableItems.add(node);
                }
                toRemove.add(node);
                continue;
            }
            toRemove.add(node);
        }
        this.selectedItems.removeAll(toRemove);
        this.sortLists();
        this.populateTreeItems(this.availableItemsListbox, this.availableItems);
        this.populateTreeItems(this.selectedItemsListbox, this.selectedItems);
        this.onSelectionChange();
    }

    private void removeAllItems() {
        ArrayList<TreeImageDisplay> toKeep = new ArrayList<TreeImageDisplay>();
        for (TreeImageDisplay node : this.selectedItems) {
            Object ho = node.getUserObject();
            if (!(ho instanceof DataObject)) continue;
            DataObject data = (DataObject)ho;
            if (this.isImmutable(data)) {
                toKeep.add(node);
                continue;
            }
            if (data.getId() < 0L || this.isChild(node)) continue;
            this.availableItems.add(node);
        }
        this.selectedItems.retainAll(toKeep);
        this.sortLists();
        this.populateTreeItems(this.availableItemsListbox, this.availableItems);
        this.populateTreeItems(this.selectedItemsListbox, this.selectedItems);
        this.onSelectionChange();
    }

    private void addItem() {
        TreePath[] paths = this.availableItemsListbox.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return;
        }
        ArrayList<TreeImageDisplay> toRemove = new ArrayList<TreeImageDisplay>();
        for (int i = 0; i < paths.length; ++i) {
            Object c = paths[i].getLastPathComponent();
            if (!(c instanceof TreeImageDisplay)) continue;
            TreeImageDisplay node = (TreeImageDisplay)c;
            if (node.hasChildrenDisplay()) {
                List l = node.getChildrenDisplay();
                for (TreeImageDisplay child : l) {
                    if (this.isSelected(child)) continue;
                    this.selectedItems.add(child);
                }
                continue;
            }
            if (this.isSelected(node)) continue;
            toRemove.add(node);
            this.selectedItems.add(node);
        }
        this.availableItems.removeAll(toRemove);
        this.sortLists();
        this.populateTreeItems(this.availableItemsListbox, this.availableItems);
        this.populateTreeItems(this.selectedItemsListbox, this.selectedItems);
        this.onSelectionChange();
    }

    private void onSelectionChange() {
        boolean b = false;
        if (this.originalSelectedItems.size() != this.selectedItems.size()) {
            b = true;
        } else {
            int n = 0;
            Iterator<TreeImageDisplay> i = this.selectedItems.iterator();
            block0: while (i.hasNext()) {
                DataObject ref = (DataObject)i.next().getUserObject();
                Iterator<TreeImageDisplay> j = this.originalSelectedItems.iterator();
                while (j.hasNext()) {
                    DataObject original = (DataObject)j.next().getUserObject();
                    if (original.getId() != ref.getId()) continue;
                    ++n;
                    continue block0;
                }
            }
            b = n != this.originalSelectedItems.size();
        }
        this.firePropertyChange(SELECTION_CHANGE, (Object)(!b ? 1 : 0), (Object)b);
    }

    private boolean isFiltered(TreeImageDisplay child) {
        if (child == null) {
            return false;
        }
        String txt = this.filterArea.getText();
        if (CommonsLangUtils.isBlank(txt) || DEFAULT_FILTER_TEXT.equals(txt)) {
            return false;
        }
        txt = txt.toLowerCase();
        Object ho = child.getUserObject();
        if (ho instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)ho;
            String value = tag.getTagValue();
            value = value.toLowerCase();
            if (this.filterAnywhere) {
                return !value.contains(txt);
            }
            return !value.startsWith(txt);
        }
        return true;
    }

    private void populateTreeItems(JTree tree, List<TreeImageDisplay> nodes) {
        DefaultTreeModel dtm = (DefaultTreeModel)tree.getModel();
        TreeImageDisplay parent = (TreeImageDisplay)dtm.getRoot();
        parent.removeAllChildrenDisplay();
        parent.removeAllChildren();
        Iterator<TreeImageDisplay> i = nodes.iterator();
        HashSet<TreeImageDisplay> toExpand = new HashSet<TreeImageDisplay>();
        while (i.hasNext()) {
            TreeImageDisplay node = i.next();
            node.setDisplayItems(false);
            Object ho = node.getUserObject();
            if (ho instanceof TagAnnotationData) {
                TagAnnotationData tag = (TagAnnotationData)ho;
                if (!"openmicroscopy.org/omero/insight/tagset".equals(tag.getNameSpace()) || node.hasChildrenDisplay()) {
                    dtm.insertNodeInto(node, parent, parent.getChildCount());
                }
            } else {
                dtm.insertNodeInto(node, parent, parent.getChildCount());
            }
            if (!node.hasChildrenDisplay()) continue;
            node.removeAllChildren();
            tree.expandPath(new TreePath(node.getPath()));
            List l = node.getChildrenDisplay();
            l = this.sorter.sort(l);
            for (TreeImageDisplay child : l) {
                child.setDisplayItems(false);
                if (this.isSelected(child) || this.isFiltered(child)) continue;
                dtm.insertNodeInto(child, node, node.getChildCount());
                toExpand.add(node);
                tree.expandPath(new TreePath(node.getPath()));
            }
        }
        dtm.reload();
        i = toExpand.iterator();
        while (i.hasNext()) {
            tree.expandPath(new TreePath(i.next().getPath()));
        }
    }

    private void sortLists() {
        if (this.availableItems != null) {
            this.availableItems = this.sorter.sort(this.availableItems);
        }
        if (this.selectedItems != null) {
            this.selectedItems = this.sorter.sort(this.selectedItems);
        }
    }

    private void buildGUI() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        double[][] size = new double[][]{{-1.0, 40.0, -1.0}, {-1.0}};
        this.setLayout(new TableLayout(size));
        this.add((Component)this.createAvailableItemsPane(), "0, 0");
        this.add((Component)this.createSelectionPane(), "1, 0, CENTER, CENTER");
        this.add((Component)this.createSelectedItemsPane(), "2, 0");
    }

    private JPanel createAvailableItemsPane() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(UIUtilities.setTextFont(this.createText("Available")));
        panel.add(this.filterArea);
        panel.add(Box.createVerticalStrut(2));
        p.add((Component)panel, "North");
        p.add((Component)new JScrollPane(this.availableItemsListbox), "Center");
        this.populateTreeItems(this.availableItemsListbox, this.availableItems);
        return p;
    }

    private JPanel createSelectionPane() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        buttonPanel.add(Box.createVerticalStrut(30));
        buttonPanel.add(this.addButton);
        buttonPanel.add(Box.createVerticalStrut(10));
        buttonPanel.add(this.removeButton);
        buttonPanel.add(Box.createVerticalStrut(10));
        buttonPanel.add(this.addAllButton);
        buttonPanel.add(Box.createVerticalStrut(10));
        buttonPanel.add(this.removeAllButton);
        buttonPanel.add(Box.createVerticalStrut(10));
        return buttonPanel;
    }

    private JPanel createSelectedItemsPane() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)UIUtilities.setTextFont(this.createText("Selected")), "North");
        p.add((Component)new JScrollPane(this.selectedItemsListbox), "Center");
        this.populateTreeItems(this.selectedItemsListbox, this.selectedItems);
        return p;
    }

    private String createText(String txt) {
        StringBuilder b = new StringBuilder();
        b.append(txt);
        if (TagAnnotationData.class.equals(this.type)) {
            b.append(" tags");
        } else if (FileAnnotationData.class.equals(this.type)) {
            b.append(" attachments");
        }
        b.append(":");
        return b.toString();
    }

    public SelectionWizardUI(JDialog view, Collection<Object> available, Class<?> type, ExperimenterData user) {
        this(view, available, null, type, user);
    }

    public SelectionWizardUI(JDialog view, Collection<Object> available, Collection<Object> selected, Class<?> type, ExperimenterData user) {
        if (selected == null) {
            selected = new ArrayList<Object>();
        }
        if (available == null) {
            available = new ArrayList<Object>();
        }
        this.view = view;
        this.user = user;
        this.availableItems = new ArrayList<TreeImageDisplay>(TreeViewerTranslator.transformHierarchy(available));
        this.selectedItems = new ArrayList<TreeImageDisplay>(TreeViewerTranslator.transformHierarchy(selected));
        this.type = type;
        this.createOriginalSelections();
        this.initComponents();
        this.sortLists();
        this.buildGUI();
    }

    public void setAvailableItems(Collection<Object> data) {
        this.availableItems = new ArrayList<TreeImageDisplay>(TreeViewerTranslator.transformHierarchy(data));
        this.createOriginalSelections();
        this.sortLists();
        this.populateTreeItems(this.availableItemsListbox, this.availableItems);
        this.filter(true);
    }

    void reset() {
        this.availableItems.clear();
        this.selectedItems.clear();
        for (TreeImageDisplay item : this.originalItems) {
            this.availableItems.add(item);
        }
        for (TreeImageDisplay item : this.originalSelectedItems) {
            this.selectedItems.add(item);
        }
        this.sortLists();
        this.populateTreeItems(this.availableItemsListbox, this.availableItems);
        this.populateTreeItems(this.selectedItemsListbox, this.selectedItems);
        this.onSelectionChange();
    }

    boolean addObjects(List<DataObject> toAdd) {
        DataObject data2;
        if (CollectionUtils.isEmpty(toAdd)) {
            return true;
        }
        Iterator<DataObject> i = toAdd.iterator();
        DefaultMutableTreeNode node = null;
        String desc = "";
        String s = "";
        while (i.hasNext()) {
            data2 = i.next();
            node = this.doesObjectExist(data2, true);
            if (node == null) continue;
            if (!(data2 instanceof TagAnnotationData)) break;
            desc = ((TagAnnotationData)data2).getTagDescription();
            break;
        }
        if (node != null) {
            String value;
            data2 = (DataObject)node.getUserObject();
            if (data2 instanceof TagAnnotationData && !desc.equals(value = ((TagAnnotationData)data2).getTagDescription())) {
                s = " a different";
            }
            NotificationDialog msg = new NotificationDialog(this.view, "Add new tag", String.format("A tag with the same name and%s description already exists\nand is selected.", s), null);
            UIUtilities.centerAndShow(msg);
            return false;
        }
        if (node == null) {
            for (DataObject data2 : toAdd) {
                node = this.doesObjectExist(data2, false);
                if (node == null) continue;
                if (!(data2 instanceof TagAnnotationData)) break;
                desc = ((TagAnnotationData)data2).getTagDescription();
                break;
            }
            if (node != null) {
                MessageBox msg;
                int option;
                String value;
                data2 = (DataObject)node.getUserObject();
                if (data2 instanceof TagAnnotationData && !desc.equals(value = ((TagAnnotationData)data2).getTagDescription())) {
                    s = " a different";
                }
                if ((option = (msg = new MessageBox(this.view, "Add new tag", String.format("A tag with the same name and%s description already exists.\nWould you like to select the existing tag?", s))).centerMsgBox()) == 1) {
                    this.availableItemsListbox.setSelectionPath(new TreePath(node.getPath()));
                    this.addItem();
                    this.availableItemsListbox.requestFocus();
                    return true;
                }
                return false;
            }
        }
        for (DataObject ho : toAdd) {
            node = TreeViewerTranslator.transformDataObject(ho);
            if (ho instanceof TagAnnotationData) {
                TagAnnotationData tag = (TagAnnotationData)ho;
                Set set = tag.getDataObjects();
                ArrayList<TagAnnotationData> p = new ArrayList<TagAnnotationData>();
                if (CollectionUtils.isNotEmpty((Collection)set)) {
                    for (DataObject d : set) {
                        if (!(d instanceof TagAnnotationData)) continue;
                        p.add((TagAnnotationData)d);
                    }
                }
                String txt = this.formatTooltip((AnnotationData)tag, p, this.user);
                ((TreeImageDisplay)node).setToolTip(txt);
            }
            this.selectedItems.add((TreeImageDisplay)node);
        }
        this.sortLists();
        this.populateTreeItems(this.selectedItemsListbox, this.selectedItems);
        this.onSelectionChange();
        return true;
    }

    void setImmutableElements(Collection immutable) {
        if (immutable == null) {
            immutable = new ArrayList();
        }
        this.immutable = immutable;
    }

    Collection getImmutableElements() {
        return this.immutable;
    }

    boolean isAddedNode(Object value) {
        return !this.originalSelectedItems.contains(value);
    }

    String getGroupName(long groupId) {
        if (this.groups == null) {
            return null;
        }
        for (GroupData g : this.groups) {
            if (g.getId() != groupId) continue;
            return g.getName();
        }
        return null;
    }

    void setGroups(Collection<GroupData> groups) {
        this.groups = groups;
    }

    boolean isFilterAnywhere() {
        return this.filterAnywhere;
    }

    void setFilterAnywhere(boolean filterAnywhere) {
        this.filterAnywhere = filterAnywhere;
        String text = this.filterArea.getText();
        if (!DEFAULT_FILTER_TEXT.equals(text)) {
            this.filter(false);
        }
    }

    void setOwnerIndex(int index) {
        this.ownerFilterIndex = index;
        String text = this.filterArea.getText();
        boolean reset = false;
        if (DEFAULT_FILTER_TEXT.equals(text)) {
            this.setTextFieldDefault(null);
            reset = true;
        }
        this.filter(false);
        if (reset) {
            this.setTextFieldDefault(DEFAULT_FILTER_TEXT);
        }
    }

    Set<DataObject> getAvailableSelectedNodes() {
        TreePath[] paths = this.availableItemsListbox.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return null;
        }
        HashSet<DataObject> nodes = new HashSet<DataObject>();
        for (int i = 0; i < paths.length; ++i) {
            Object c = paths[i].getLastPathComponent();
            if (!(c instanceof TreeImageDisplay)) continue;
            TreeImageDisplay node = (TreeImageDisplay)c;
            if (node.hasChildrenDisplay()) {
                nodes.add((DataObject)node.getUserObject());
                continue;
            }
            if (!this.isChild(node)) continue;
            nodes.add((DataObject)node.getParentDisplay().getUserObject());
        }
        return nodes;
    }

    public Collection<Object> getSelection() {
        Iterator<TreeImageDisplay> i = this.selectedItems.iterator();
        ArrayList<Object> results = new ArrayList<Object>();
        while (i.hasNext()) {
            TreeImageDisplay object = i.next();
            Object uo = object.getUserObject();
            if (this.isAddedNode(object)) {
                results.add(uo);
                continue;
            }
            if (uo instanceof DataObject) {
                if (this.isImmutable((DataObject)uo)) continue;
                results.add(uo);
                continue;
            }
            results.add(uo);
        }
        return results;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int id = Integer.parseInt(evt.getActionCommand());
        switch (id) {
            case 0: {
                this.addItem();
                break;
            }
            case 2: {
                this.addAllItems();
                break;
            }
            case 1: {
                this.removeItem();
                break;
            }
            case 3: {
                this.removeAllItems();
            }
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.filter(false);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.filter(true);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }
}

