/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.browser;

import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageSet;
import org.openmicroscopy.shoola.env.data.model.TimeRefObject;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class TreeImageTimeSet
extends TreeImageSet {
    public static final int TODAY = 99;
    public static final int WEEK = 100;
    public static final int TWO_WEEK = 101;
    public static final int OTHER = 102;
    public static final int YEAR = 103;
    public static final int YEAR_BEFORE = 104;
    public static final int MONTH = 105;
    static final int JANUARY = 0;
    static final int FEBRUARY = 1;
    static final int MARCH = 2;
    static final int APRIL = 3;
    static final int MAY = 4;
    static final int JUNE = 5;
    static final int JULY = 6;
    static final int AUGUST = 7;
    static final int SEPTEMBER = 8;
    static final int OCTOBER = 9;
    static final int NOVEMBER = 10;
    static final int DECEMBER = 11;
    private static final String TODAY_OLD = "Today";
    private static final String WEEK_OLD = "Last 7 days";
    private static final String TWO_WEEK_OLD = "Last 2 weeks";
    private static final String PRIOR_TO = "Before ";
    private static final String TODAY_TOOLTIP = "Contains the data imported today.";
    private static final String WEEK_TOOLTIP = "Contains the data imported in the last 7 days.";
    private static final String TWO_WEEK_TOOLTIP = "Contains the data imported in the last 2 weeks.";
    private static final String YEAR_TOOLTIP = "Contains the data imported in this year.";
    private static final String OTHER_TOOLTIP = "Contains the data imported before this year.";
    private static final String YEAR_BEFORE_TOOLTIP = "Contains the data imported during the period ";
    private static final String MONTH_TOOLTIP = "Contains the data imported in selected month.";
    private static final long DAY = 86400000L;
    private static final String TEXT = "_";
    private int type;
    private Timestamp endTime;
    private Timestamp startTime;
    private int index;
    private TimeRefObject ref;

    private String getMonth(int month) {
        switch (month) {
            case 0: {
                return "January";
            }
            case 1: {
                return "February";
            }
            case 2: {
                return "March";
            }
            case 3: {
                return "April";
            }
            case 4: {
                return "May";
            }
            case 5: {
                return "June";
            }
            case 6: {
                return "July";
            }
            case 7: {
                return "August";
            }
            case 8: {
                return "September";
            }
            case 9: {
                return "October";
            }
            case 10: {
                return "November";
            }
            case 11: {
                return "December";
            }
        }
        throw new IllegalArgumentException("Month not valid.");
    }

    private int getLastDayOfMonth(int month, int year) {
        switch (month) {
            case 0: {
                return 31;
            }
            case 1: {
                if (year % 4 == 0) {
                    return 29;
                }
                if (year % 100 == 0) {
                    return 28;
                }
                if (year % 400 == 0) {
                    return 29;
                }
                return 28;
            }
            case 2: {
                return 31;
            }
            case 3: {
                return 30;
            }
            case 4: {
                return 31;
            }
            case 5: {
                return 30;
            }
            case 6: {
                return 31;
            }
            case 7: {
                return 31;
            }
            case 8: {
                return 30;
            }
            case 9: {
                return 31;
            }
            case 10: {
                return 30;
            }
            case 11: {
                return 31;
            }
        }
        throw new IllegalArgumentException("Month not valid.");
    }

    private boolean containTime(Timestamp t) {
        if (t == null) {
            return false;
        }
        if (this.startTime == null && this.endTime == null) {
            return false;
        }
        if (this.startTime == null && this.endTime != null) {
            return t.before(this.endTime);
        }
        if (this.startTime != null && this.endTime == null) {
            return t.after(this.startTime);
        }
        if (this.startTime != null && this.endTime != null) {
            return t.after(this.startTime) && t.before(this.endTime);
        }
        return false;
    }

    public static int getCurrentMonth() {
        GregorianCalendar gc = new GregorianCalendar();
        return gc.get(2);
    }

    public static String createPath(TreeImageDisplay node, String path) {
        if (node == null) {
            return path;
        }
        TreeImageDisplay parent = node.getParentDisplay();
        if (parent == null) {
            Object ho = node.getUserObject();
            if (ho instanceof ExperimenterData) {
                ExperimenterData exp = (ExperimenterData)ho;
                path = "gid" + exp.getGroupId() + TEXT + "eid" + exp.getId() + TEXT + path;
                return path;
            }
            if (ho instanceof GroupData) {
                GroupData group = (GroupData)ho;
                path = "gid" + group.getId() + TEXT + path;
                return path;
            }
            path = ho.toString() + TEXT + path;
            return path;
        }
        Object ho = parent.getUserObject();
        if (ho instanceof ExperimenterData) {
            ExperimenterData exp = (ExperimenterData)ho;
            TreeImageDisplay gp = parent.getParentDisplay();
            if (gp != null && gp.getUserObject() instanceof GroupData) {
                GroupData group = (GroupData)gp.getUserObject();
                path = "gid" + group.getId() + TEXT + "eid" + exp.getId() + TEXT + path;
            }
            return path;
        }
        if (ho instanceof GroupData) {
            GroupData group = (GroupData)ho;
            path = "gid" + group.getId() + TEXT + path;
            return path;
        }
        path = ho.toString() + TEXT + path;
        return TreeImageTimeSet.createPath(parent, path);
    }

    public TreeImageTimeSet(int type) {
        super("");
        this.type = type;
        this.index = type;
        GregorianCalendar gc = new GregorianCalendar();
        this.endTime = null;
        switch (type) {
            case 99: {
                this.setUserObject(TODAY_OLD);
                this.setToolTip(TODAY_TOOLTIP);
                gc = new GregorianCalendar(gc.get(1), gc.get(2), gc.get(5), 0, 0, 0);
                this.startTime = new Timestamp(gc.getTime().getTime());
                break;
            }
            case 100: {
                this.setUserObject(WEEK_OLD);
                this.setToolTip(WEEK_TOOLTIP);
                gc = new GregorianCalendar(gc.get(1), gc.get(2), gc.get(5), 23, 59, 0);
                this.startTime = new Timestamp(gc.getTime().getTime() - 604800000L);
                break;
            }
            case 101: {
                this.setUserObject(TWO_WEEK_OLD);
                this.setToolTip(TWO_WEEK_TOOLTIP);
                gc = new GregorianCalendar(gc.get(1), gc.get(2), gc.get(5), 23, 59, 0);
                this.startTime = new Timestamp(gc.getTime().getTime() - 1209600000L);
                break;
            }
            case 103: {
                this.setToolTip(YEAR_TOOLTIP);
                int year = gc.get(1);
                this.setUserObject("" + year);
                gc = new GregorianCalendar(year, 0, 1, 0, 0, 0);
                this.startTime = new Timestamp(gc.getTime().getTime());
                this.endTime = UIUtilities.getDefaultTimestamp();
                break;
            }
            case 104: {
                this.setToolTip(YEAR_BEFORE_TOOLTIP);
                int year = gc.get(1);
                this.setUserObject("" + (year - 1));
                gc = new GregorianCalendar(year, 0, 1, 0, 0, 0);
                this.endTime = new Timestamp(gc.getTime().getTime());
                gc = new GregorianCalendar(year - 1, 0, 1, 0, 0, 0);
                this.startTime = new Timestamp(gc.getTime().getTime());
                break;
            }
            case 102: {
                this.setToolTip(OTHER_TOOLTIP);
                int year = gc.get(1) - 1;
                this.setUserObject(PRIOR_TO + year);
                gc = new GregorianCalendar(year, 0, 1, 0, 0, 0);
                this.startTime = null;
                this.endTime = new Timestamp(gc.getTime().getTime());
                break;
            }
            default: {
                throw new IllegalArgumentException("Node index not valid.");
            }
        }
    }

    public TreeImageTimeSet(int type, int monthIndex) {
        super("");
        this.type = 105;
        this.index = type + 12 * (monthIndex + 1);
        GregorianCalendar gc = new GregorianCalendar();
        switch (type) {
            case 103: {
                this.setToolTip(MONTH_TOOLTIP);
                int year = gc.get(1);
                int month = gc.get(2);
                this.setUserObject("" + this.getMonth(monthIndex));
                int lastDay = monthIndex == month ? gc.get(5) : this.getLastDayOfMonth(monthIndex, year);
                gc = new GregorianCalendar(year, monthIndex, lastDay, 23, 59, 0);
                this.endTime = new Timestamp(gc.getTime().getTime());
                gc = new GregorianCalendar(year, monthIndex, 1, 0, 0, 0);
                this.startTime = new Timestamp(gc.getTime().getTime());
                break;
            }
            case 104: {
                this.setToolTip(MONTH_TOOLTIP);
                int year = gc.get(1) - 1;
                this.setUserObject("" + this.getMonth(monthIndex));
                gc = new GregorianCalendar(year, monthIndex, this.getLastDayOfMonth(monthIndex, year), 23, 59, 0);
                this.endTime = new Timestamp(gc.getTime().getTime());
                gc = new GregorianCalendar(year, monthIndex, 1, 0, 0, 0);
                this.startTime = new Timestamp(gc.getTime().getTime());
                break;
            }
            default: {
                throw new IllegalArgumentException("Node index not valid.");
            }
        }
    }

    public int countTime(List times) {
        if (times == null) {
            return -1;
        }
        Iterator i = times.iterator();
        int number = 0;
        while (i.hasNext()) {
            if (!this.containTime((Timestamp)i.next())) continue;
            ++number;
        }
        return number;
    }

    public int getIndex() {
        return this.index;
    }

    public int getType() {
        return this.type;
    }

    public Timestamp getEndTime() {
        return this.endTime;
    }

    public Timestamp getStartTime() {
        return this.startTime;
    }

    public TimeRefObject getTimeObject(long id) {
        if (this.ref == null) {
            this.ref = new TimeRefObject(id, 0);
            this.ref.setTimeInterval(this.startTime, this.endTime);
        }
        return this.ref;
    }
}

