/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.finder;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.SearchParameters;
import omero.gateway.model.SearchResultCollection;
import omero.gateway.model.SearchScope;
import omero.gateway.model.TagAnnotationData;
import omero.gateway.model.WellData;
import org.openmicroscopy.shoola.agents.dataBrowser.view.SearchComponent;
import org.openmicroscopy.shoola.agents.util.SelectionWizard;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.agents.util.finder.AdvancedFinderLoader;
import org.openmicroscopy.shoola.agents.util.finder.Finder;
import org.openmicroscopy.shoola.agents.util.finder.FinderFactory;
import org.openmicroscopy.shoola.agents.util.finder.FinderLoader;
import org.openmicroscopy.shoola.agents.util.finder.TagsLoader;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.search.SearchContext;
import org.openmicroscopy.shoola.util.ui.search.SearchHelp;

public class AdvancedFinder
extends SearchComponent
implements Finder,
PropertyChangeListener {
    private static final String TITLE = "Search";
    private FinderLoader loader;
    private int state;
    private Map<Long, ExperimenterData> users;
    private Collection tags;
    private SearchResultCollection results = new SearchResultCollection();
    private long groupId;
    private ViewerSorter sorter = new ViewerSorter();
    private int displayMode = 1;

    private SearchScope convertScope(int value) {
        switch (value) {
            case 6: {
                return SearchScope.ANNOTATION;
            }
            case 7: {
                return SearchScope.ANNOTATION;
            }
            case 11: {
                return SearchScope.ANNOTATION;
            }
            case 10: {
                return SearchScope.ANNOTATION;
            }
            case 9: {
                return SearchScope.NAME;
            }
            case 12: {
                return SearchScope.DESCRIPTION;
            }
            case 14: {
                return SearchScope.ANNOTATION;
            }
        }
        return null;
    }

    private Class<? extends DataObject> convertType(int value) {
        switch (value) {
            case 1: {
                return DatasetData.class;
            }
            case 2: {
                return ProjectData.class;
            }
            case 0: {
                return ImageData.class;
            }
            case 3: {
                return ScreenData.class;
            }
            case 4: {
                return PlateData.class;
            }
            case 5: {
                return WellData.class;
            }
        }
        return null;
    }

    private void handleSearchContext(SearchContext ctx) {
        SecurityContext secCtx;
        String query = ctx.getQuery();
        UserNotifier un = FinderFactory.getRegistry().getUserNotifier();
        Timestamp start = ctx.getStartTime();
        Timestamp end = ctx.getEndTime();
        if (start != null && end != null && start.after(end)) {
            un.notifyInfo(TITLE, "The selected time interval is not valid.");
            return;
        }
        if (CommonsLangUtils.isEmpty(query) && start == null && end == null) {
            un.notifyInfo(TITLE, "Please enter a term to search for or a valid time interval.");
            return;
        }
        List<Integer> context = ctx.getContext();
        if (context == null || context.size() == 0) {
            context = new ArrayList<Integer>();
            context.add(13);
        }
        HashSet<SearchScope> scope = new HashSet<SearchScope>();
        Iterator<Integer> i = context.iterator();
        while (i.hasNext()) {
            SearchScope v = this.convertScope(i.next());
            if (v == null) continue;
            scope.add(v);
        }
        ArrayList<Class<? extends DataObject>> types = new ArrayList<Class<? extends DataObject>>();
        i = ctx.getType().iterator();
        while (i.hasNext()) {
            Class<? extends DataObject> k = this.convertType(i.next());
            if (k == null) continue;
            types.add(k);
        }
        SearchParameters searchContext = new SearchParameters(scope, types, query);
        searchContext.setTimeInterval(start, end, ctx.getTimeType());
        searchContext.setUserId(ctx.getSelectedOwner());
        if (ctx.getSelectedGroup() == Integer.MAX_VALUE) {
            secCtx = new SecurityContext(FinderFactory.getUserDetails().getGroupId());
            searchContext.setGroupId(-1L);
        } else {
            secCtx = new SecurityContext(ctx.getSelectedGroup());
            searchContext.setGroupId(ctx.getSelectedGroup());
        }
        this.loader = new AdvancedFinderLoader(this, secCtx, searchContext);
        this.loader.load();
        this.state = 101;
        this.setSearchEnabled(-1);
    }

    private void loadTags() {
        if (this.tags == null) {
            ArrayList<SecurityContext> l = new ArrayList<SecurityContext>();
            Iterator i = this.groups.iterator();
            while (i.hasNext()) {
                l.add(new SecurityContext(((GroupData)i.next()).getId()));
            }
            TagsLoader loader = new TagsLoader(this, l);
            loader.load();
        } else {
            this.setExistingTags(this.tags);
        }
    }

    private void handleTagsSelection(Collection selected) {
        ArrayList<String> toAdd = new ArrayList<String>();
        if (selected == null || selected.size() == 0) {
            this.setTerms(toAdd);
            return;
        }
        for (TagAnnotationData tag : selected) {
            String value = tag.getTagValue();
            if (value.contains(" ")) {
                toAdd.add("\"" + value + "\"");
                continue;
            }
            toAdd.add(value);
        }
        this.setTerms(toAdd);
    }

    AdvancedFinder(Collection<GroupData> groups) {
        List l = this.sorter.sort(groups);
        this.initialize(l);
        this.addPropertyChangeListener("search", this);
        this.addPropertyChangeListener("cancelSearch", this);
        this.users = new HashMap<Long, ExperimenterData>();
    }

    @Override
    protected void help(String url) {
        if (CommonsLangUtils.isBlank(url)) {
            return;
        }
        SearchHelp help = new SearchHelp(FinderFactory.getRefFrame(), url);
        UIUtilities.centerAndShow(help);
        if (help.hasError()) {
            FinderFactory.getRegistry().getUserNotifier().notifyError("Could not open web browser", "Please open your web browser and go to page: " + url);
        }
    }

    @Override
    public void cancel() {
        if (this.loader != null) {
            this.loader.cancel();
        }
        this.results.clear();
        this.state = 100;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public void dispose() {
        this.setSearchEnabled(-1);
        this.setVisible(false);
        this.cancel();
    }

    @Override
    public void setStatus(String text, boolean status) {
        if (text == null) {
            text = "";
        }
        this.setSearchEnabled(text, status);
    }

    @Override
    public void setResult(SearchResultCollection result) {
        if (result.isError()) {
            String msg = "";
            switch (result.getError()) {
                case 1: {
                    msg = "Invalid search expression";
                    break;
                }
                case 2: {
                    msg = "Too many results, please refine your search criteria.";
                    break;
                }
                case 3: {
                    msg = "Please try to narrow down your query. The wildcard matched too many terms.";
                }
            }
            UserNotifier un = FinderFactory.getRegistry().getUserNotifier();
            un.notifyError("Search error", msg);
            this.setSearchEnabled(-1);
            return;
        }
        this.results = result;
        this.setSearchEnabled(result.size());
        this.firePropertyChange("resultsFound", null, this.results);
    }

    @Override
    public void setExistingTags(Collection tags) {
        this.tags = tags;
        if (tags == null || tags.size() == 0) {
            UserNotifier un = FinderFactory.getRegistry().getUserNotifier();
            un.notifyInfo("Existing Tags", "No existing tags to search by.");
            return;
        }
        IconManager icons = IconManager.getInstance();
        String title = "Filter By Tags";
        String text = "Select the Tags to filter by.";
        ArrayList<Object> selected = new ArrayList<Object>();
        Iterator i = tags.iterator();
        List<String> l = this.getTerms();
        ArrayList<Object> available = new ArrayList<Object>();
        while (i.hasNext()) {
            TagAnnotationData tag = (TagAnnotationData)i.next();
            if (l.contains(tag.getTagValue())) {
                selected.add(tag);
                continue;
            }
            available.add(tag);
        }
        SelectionWizard wizard = new SelectionWizard(FinderFactory.getRefFrame(), available, selected, TagAnnotationData.class, false, FinderFactory.getUserDetails());
        wizard.setGroups(this.groups);
        wizard.setTitle(title, text, icons.getIcon(66));
        wizard.addPropertyChangeListener(this);
        UIUtilities.centerAndShow(wizard);
    }

    public void setCurrentGroup(long groupId) {
        if (this.groupId == groupId) {
            return;
        }
        this.groupId = groupId;
        this.tags = null;
    }

    public void reset(Collection<GroupData> groups) {
        this.sorter = new ViewerSorter();
        this.groups = this.sorter.sort(groups);
        this.users.clear();
        this.results.clear();
        if (this.tags != null) {
            this.tags.clear();
        }
        this.tags = null;
        this.groupsContext.clear();
        this.addResult(null, true);
        this.uiDelegate.reset();
    }

    public void setDisplayMode(int displayMode) {
        this.displayMode = displayMode;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        block7: {
            String name;
            block9: {
                block8: {
                    block6: {
                        name = evt.getPropertyName();
                        if (!"search".equals(name)) break block6;
                        SearchContext ctx = (SearchContext)evt.getNewValue();
                        if (ctx == null) {
                            return;
                        }
                        this.handleSearchContext(ctx);
                        break block7;
                    }
                    if (!"cancelSearch".equals(name)) break block8;
                    this.cancel();
                    break block7;
                }
                if (!"userSwitch".equals(name)) break block9;
                Map m = (Map)evt.getNewValue();
                if (m == null) {
                    return;
                }
                Iterator i = m.keySet().iterator();
                while (i.hasNext()) {
                    List l = (List)m.get(i.next());
                    for (ExperimenterData exp : l) {
                        this.users.put(exp.getId(), exp);
                    }
                }
                break block7;
            }
            if (!"selectedItems".equals(name)) break block7;
            Map m = (Map)evt.getNewValue();
            if (m == null || m.size() != 1) {
                return;
            }
            Set set = m.entrySet();
            for (Map.Entry entry : set) {
                Class type = (Class)entry.getKey();
                this.handleTagsSelection((Collection)entry.getValue());
            }
        }
    }
}

