/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.swing.JDialog;
import org.openmicroscopy.shoola.agents.util.ui.RollOverThumbnailCanvas;
import org.openmicroscopy.shoola.util.image.geom.Factory;

public class RollOverThumbnail
extends JDialog {
    private static final int MINIMUM_ZOOM = 1;
    private static final int MAXIMUM_ZOOM = 2;
    private BufferedImage image;
    private BufferedImage originalImage;
    private RollOverThumbnailCanvas canvas = new RollOverThumbnailCanvas(this);
    private float zoomFactor;

    private void setProperties() {
        this.setModal(false);
        this.setResizable(false);
        this.setUndecorated(true);
        this.zoomFactor = 1.0f;
    }

    private void makeComponentsSize(int w, int h) {
        if (this.canvas == null) {
            return;
        }
        Insets i = this.canvas.getInsets();
        Dimension d = new Dimension(w + i.right + i.left, h + i.top + i.bottom);
        this.canvas.setPreferredSize(d);
        this.canvas.setSize(d);
    }

    private void buildUI() {
        Container container = this.getContentPane();
        container.add((Component)this.canvas, "Center");
    }

    public RollOverThumbnail() {
        this.setProperties();
        this.buildUI();
    }

    void magnifyImage(int tick) {
        this.zoomFactor -= 0.1f * (float)tick;
        this.zoomFactor = (float)Math.round(this.zoomFactor * 10.0f) / 10.0f;
        if (this.zoomFactor < 1.0f) {
            this.zoomFactor = 1.0f;
        }
        if (this.zoomFactor > 2.0f) {
            this.zoomFactor = 2.0f;
        }
        this.image = Factory.magnifyImage(this.zoomFactor, this.originalImage);
        this.makeComponentsSize(this.image.getWidth(), this.image.getHeight());
        this.pack();
    }

    BufferedImage getImage() {
        return this.image;
    }

    public void setThumbnail(BufferedImage full, String toolTip) {
        this.canvas.setToolTipText(toolTip);
        if (full != null) {
            this.image = full;
            this.originalImage = full;
            this.makeComponentsSize(this.image.getWidth(), this.image.getHeight());
            this.canvas.repaint();
        }
    }

    public void close() {
        this.setVisible(true);
        this.dispose();
    }

    public void moveToFront(Point p) {
        this.moveToFront(p.x, p.y);
    }

    public void moveToFront(int x, int y) {
        this.setLocation(x, y);
        this.setVisible(true);
    }
}

