/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.ui;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.border.Border;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateData;
import org.openmicroscopy.shoola.env.data.model.ThumbnailData;
import org.openmicroscopy.shoola.util.image.geom.Factory;

public class ThumbnailLabel
extends JLabel {
    public static final String BROWSE_PLATE_PROPERTY = "browsePlate";
    public static final String VIEW_IMAGE_PROPERTY = "viewImage";
    private static final Border LABEL_BORDER = BorderFactory.createLineBorder(Color.black, 1);
    static final String IMAGE_LABEL_TOOLTIP = "Click to view the image.";
    static final String PLATE_LABEL_TOOLTIP = "Click to browse the plate.";
    private Object data;

    private void view() {
        if (this.data instanceof ThumbnailData) {
            ThumbnailData thumbnail = (ThumbnailData)this.data;
            this.firePropertyChange(VIEW_IMAGE_PROPERTY, null, (Object)thumbnail.getImageID());
        } else if (this.data instanceof ImageData) {
            this.firePropertyChange(VIEW_IMAGE_PROPERTY, null, (Object)((ImageData)this.data).getId());
        } else if (this.data instanceof PlateData) {
            this.firePropertyChange(BROWSE_PLATE_PROPERTY, null, this.data);
        }
    }

    private void setThumbnail(ThumbnailData data) {
        if (data == null) {
            return;
        }
        BufferedImage img = Factory.magnifyImage(0.25, data.getThumbnail());
        ImageIcon icon = null;
        if (img != null) {
            icon = new ImageIcon(img);
        }
        this.data = data;
        this.setToolTipText(IMAGE_LABEL_TOOLTIP);
        this.setBorder(LABEL_BORDER);
        this.setIcon(icon);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    ThumbnailLabel.this.view();
                }
            }
        });
    }

    public ThumbnailLabel() {
    }

    public ThumbnailLabel(Icon icon) {
        super(icon);
    }

    public void setData(Object data) {
        if (data == null) {
            return;
        }
        this.data = data;
        if (data instanceof ImageData) {
            this.setToolTipText(IMAGE_LABEL_TOOLTIP);
        } else if (data instanceof PlateData) {
            this.setToolTipText(PLATE_LABEL_TOOLTIP);
        } else if (data instanceof ThumbnailData) {
            this.setThumbnail((ThumbnailData)data);
            return;
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    ThumbnailLabel.this.view();
                }
            }
        });
    }
}

