/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env;

import java.io.File;
import org.openmicroscopy.shoola.env.Container;

public class Environment {
    private Container container;

    Environment(Container c) {
        this.container = c;
    }

    public String getHomeDir() {
        return this.container.getHomeDir();
    }

    public String getTmpDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public String resolvePathName(String relPathName) {
        File f = new File(this.getHomeDir(), relPathName);
        return f.getAbsolutePath();
    }

    public int runAsPlugin() {
        Integer v = (Integer)this.container.getRegistry().lookup("Plugin");
        if (v == null) {
            return -1;
        }
        return v;
    }

    public boolean isRunAsPlugin() {
        return this.runAsPlugin() > 0;
    }

    public int getDefaultHierarchy() {
        Integer v = (Integer)this.container.getRegistry().lookup("/application/entryPointHierarchy");
        if (v == null) {
            return 0;
        }
        int value = v;
        switch (value) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return value;
            }
        }
        return 0;
    }

    public String getOmeroHome() {
        return (String)this.container.getRegistry().lookup("/user/home/omero");
    }

    public String getOmeroFilesHome() {
        String home = (String)this.container.getRegistry().lookup("/user/home/omero");
        String name = (String)this.container.getRegistry().lookup("/services/OMERO/files/home");
        return home + File.separator + name;
    }
}

