/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.formats.model.UnitsFactory;
import ome.model.units.BigResult;
import omero.cmd.OriginalMetadataRequest;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSAccessException;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.BooleanAnnotationData;
import omero.gateway.model.ChannelAcquisitionData;
import omero.gateway.model.ChannelData;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.DoubleAnnotationData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.FilesetData;
import omero.gateway.model.ImageAcquisitionData;
import omero.gateway.model.ImageData;
import omero.gateway.model.LongAnnotationData;
import omero.gateway.model.MapAnnotationData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ROIData;
import omero.gateway.model.ROIResult;
import omero.gateway.model.RatingAnnotationData;
import omero.gateway.model.TableResult;
import omero.gateway.model.TagAnnotationData;
import omero.gateway.model.TermAnnotationData;
import omero.gateway.model.TextualAnnotationData;
import omero.gateway.model.XMLAnnotationData;
import omero.gateway.util.PojoMapper;
import omero.model.Annotation;
import omero.model.AnnotationAnnotationLink;
import omero.model.BooleanAnnotation;
import omero.model.Channel;
import omero.model.DatasetAnnotationLink;
import omero.model.DoubleAnnotation;
import omero.model.FileAnnotation;
import omero.model.FileAnnotationI;
import omero.model.IObject;
import omero.model.Image;
import omero.model.ImageAnnotationLink;
import omero.model.ImagingEnvironment;
import omero.model.ImagingEnvironmentI;
import omero.model.Length;
import omero.model.LogicalChannel;
import omero.model.LongAnnotation;
import omero.model.MapAnnotation;
import omero.model.Medium;
import omero.model.Objective;
import omero.model.ObjectiveSettings;
import omero.model.ObjectiveSettingsI;
import omero.model.OriginalFile;
import omero.model.Pixels;
import omero.model.PlateAcquisitionAnnotationLink;
import omero.model.PlateAnnotationLink;
import omero.model.Pressure;
import omero.model.ProjectAnnotationLink;
import omero.model.ScreenAnnotationLink;
import omero.model.StageLabel;
import omero.model.StageLabelI;
import omero.model.TagAnnotation;
import omero.model.TagAnnotationI;
import omero.model.Temperature;
import omero.model.TermAnnotation;
import omero.model.WellAnnotationLink;
import omero.model.XmlAnnotation;
import omero.rtypes;
import omero.sys.Parameters;
import omero.sys.ParametersI;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.collections.MapUtils;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.OMEROGateway;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.OmeroMetadataService;
import org.openmicroscopy.shoola.env.data.ProcessException;
import org.openmicroscopy.shoola.env.data.RequestCallback;
import org.openmicroscopy.shoola.env.data.model.AnnotationLinkData;
import org.openmicroscopy.shoola.env.data.model.TableParameters;
import org.openmicroscopy.shoola.env.data.model.TimeRefObject;
import org.openmicroscopy.shoola.env.data.util.FilterContext;
import org.openmicroscopy.shoola.env.data.util.ModelMapper;
import org.openmicroscopy.shoola.env.data.util.StructuredDataResults;

class OmeroMetadataServiceImpl
implements OmeroMetadataService {
    private Registry context;
    private OMEROGateway gateway;

    private void updateChannels(List<ChannelData> ref, List<Channel> list) {
        Iterator<Channel> i = list.iterator();
        int index = 0;
        int n = ref.size();
        while (i.hasNext()) {
            Channel channel = i.next();
            if (index == n) break;
            ChannelData data = ref.get(index);
            channel.getLogicalChannel().setName(rtypes.rstring((String)data.getName()));
            ++index;
        }
    }

    private boolean containTerms(List<String> terms, String value) {
        if (terms == null || terms.size() == 0 || value == null) {
            return false;
        }
        Iterator<String> i = terms.iterator();
        while (i.hasNext()) {
            if (!value.contains(i.next())) continue;
            return true;
        }
        return false;
    }

    private boolean isAnnotationShared(SecurityContext ctx, AnnotationData annotation, DataObject object) throws DSOutOfServiceException, DSAccessException {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(annotation.getId());
        List l = this.gateway.findAnnotationLinks(ctx, object.getClass(), -1L, ids);
        if (l == null) {
            return false;
        }
        return l.size() > 0;
    }

    private List<IObject> getRemoveAnnotation(SecurityContext ctx, Object annotation, DataObject object) throws DSOutOfServiceException, DSAccessException {
        if (annotation == null || object == null || !(annotation instanceof IObject) && !(annotation instanceof DataObject)) {
            return Collections.emptyList();
        }
        IObject o = null;
        o = annotation instanceof IObject ? (IObject)annotation : ((DataObject)annotation).asIObject();
        IObject ho = this.gateway.findIObject(ctx, o);
        if (ho == null) {
            return Collections.emptyList();
        }
        long id = -1L;
        ArrayList<IObject> toDelete = new ArrayList<IObject>();
        if (ho instanceof Annotation) {
            List links = this.gateway.findAnnotationLinks(ctx, object.getClass(), object.getId(), Arrays.asList(ho.getId().getValue()), id);
            for (IObject link : links) {
                if (link == null || !this.gateway.canDelete(link)) continue;
                toDelete.add(link);
            }
        } else if (this.gateway.canDelete(o)) {
            toDelete.add(ho);
        }
        return toDelete;
    }

    private void saveChannelData(SecurityContext ctx, ChannelData data) throws DSOutOfServiceException, DSAccessException {
        LogicalChannel lc = data.asChannel().getLogicalChannel();
        ModelMapper.unloadCollections((IObject)lc);
        this.gateway.saveAndReturnObject(ctx, (IObject)lc, null);
    }

    private void saveChannelAcquisitionData(SecurityContext ctx, ChannelAcquisitionData data) {
    }

    private void saveImageAcquisitionData(SecurityContext ctx, ImageAcquisitionData data) throws DSOutOfServiceException, DSAccessException {
        Iterator<IObject> i;
        List<IObject> l;
        Medium object;
        Length o;
        long id;
        Image image = data.asImage();
        ArrayList<IObject> toCreate = new ArrayList<IObject>();
        ArrayList<IObject> toUpdate = new ArrayList<IObject>();
        if (data.isStageLabelDirty()) {
            StageLabelI label;
            id = data.getStageLabelId();
            if (id < 0L) {
                label = new StageLabelI();
                toCreate.add((IObject)label);
            } else {
                label = (StageLabel)this.gateway.findIObject(ctx, StageLabel.class.getName(), id);
                toUpdate.add((IObject)label);
            }
            label.setName(rtypes.rstring((String)data.getLabelName()));
            o = null;
            try {
                o = data.getPositionX(UnitsFactory.StageLabel_X);
            }
            catch (BigResult e) {
                this.context.getLogger().warn((Object)this, "Could not get X position in " + UnitsFactory.StageLabel_X);
            }
            if (o != null) {
                label.setPositionX(o);
            }
            try {
                o = data.getPositionY(UnitsFactory.StageLabel_Y);
            }
            catch (BigResult e) {
                this.context.getLogger().warn((Object)this, "Could not get Y position in " + UnitsFactory.StageLabel_Y);
            }
            if (o != null) {
                label.setPositionY(o);
            }
            try {
                o = data.getPositionZ(UnitsFactory.StageLabel_Z);
            }
            catch (BigResult e) {
                this.context.getLogger().warn((Object)this, "Could not get Z position in " + UnitsFactory.StageLabel_Z);
            }
            if (o != null) {
                label.setPositionZ(o);
            }
        }
        if (data.isImagingEnvironmentDirty()) {
            ImagingEnvironmentI condition;
            id = data.getImagingEnvironmentId();
            if (id < 0L) {
                condition = new ImagingEnvironmentI();
                toCreate.add((IObject)condition);
            } else {
                condition = (ImagingEnvironment)this.gateway.findIObject(ctx, ImagingEnvironment.class.getName(), id);
                toUpdate.add((IObject)condition);
            }
            try {
                Pressure press = data.getAirPressure(UnitsFactory.ImagingEnvironment_AirPressure);
                if (press != null) {
                    condition.setAirPressure(press);
                }
            }
            catch (BigResult e) {
                this.context.getLogger().warn((Object)this, "Could not get pressure in " + UnitsFactory.ImagingEnvironment_AirPressure);
            }
            condition.setHumidity(rtypes.rdouble((double)data.getHumidity()));
            try {
                o = data.getTemperature(UnitsFactory.ImagingEnvironment_Temperature);
                if (o != null) {
                    condition.setTemperature((Temperature)o);
                }
            }
            catch (BigResult e) {
                this.context.getLogger().warn((Object)this, "Could not get temperature in " + UnitsFactory.ImagingEnvironment_Temperature);
            }
            condition.setCo2percent(rtypes.rdouble((double)data.getCo2Percent()));
        }
        if (data.isObjectiveSettingsDirty()) {
            ObjectiveSettingsI settings;
            id = data.getObjectiveSettingsId();
            if (id < 0L) {
                settings = new ObjectiveSettingsI();
                toCreate.add((IObject)settings);
            } else {
                settings = (ObjectiveSettings)this.gateway.findIObject(ctx, ObjectiveSettings.class.getName(), id);
                toUpdate.add((IObject)settings);
            }
            settings.setCorrectionCollar(rtypes.rdouble((double)data.getCorrectionCollar()));
            settings.setRefractiveIndex(rtypes.rdouble((double)data.getRefractiveIndex()));
            object = data.getMediumAsEnum();
            if (object != null) {
                settings.setMedium(object);
            }
        }
        long objectiveSettingsID = data.getObjectiveSettingsId();
        if (toUpdate.size() > 0) {
            this.gateway.updateObjects(ctx, toUpdate, new Parameters());
        }
        if (toCreate.size() > 0) {
            l = this.gateway.createObjects(ctx, toCreate);
            i = l.iterator();
            image = (Image)this.gateway.findIObject(ctx, data.asIObject());
            while (i.hasNext()) {
                object = i.next();
                if (object instanceof StageLabel) {
                    image.setStageLabel((StageLabel)object);
                    continue;
                }
                if (object instanceof ImagingEnvironment) {
                    image.setImagingEnvironment((ImagingEnvironment)object);
                    continue;
                }
                if (!(object instanceof ObjectiveSettings)) continue;
                objectiveSettingsID = object.getId().getValue();
                image.setObjectiveSettings((ObjectiveSettings)object);
            }
            ModelMapper.unloadCollections((IObject)image);
            this.gateway.updateObject(ctx, (IObject)image, new Parameters());
        }
        toUpdate.clear();
        toCreate.clear();
        if (toUpdate.size() > 0) {
            this.gateway.updateObjects(ctx, toUpdate, new Parameters());
        } else {
            l = this.gateway.createObjects(ctx, toCreate);
            i = l.iterator();
            ObjectiveSettings settings = (ObjectiveSettings)this.gateway.findIObject(ctx, ObjectiveSettings.class.getName(), objectiveSettingsID);
            while (i.hasNext()) {
                object = i.next();
                if (!(object instanceof Objective)) continue;
                settings.setObjective((Objective)object);
            }
            ModelMapper.unloadCollections((IObject)settings);
            this.gateway.updateObject(ctx, (IObject)settings, new Parameters());
        }
    }

    private ExperimenterData getUserDetails() {
        return (ExperimenterData)this.context.lookup("/current_user/details");
    }

    private List<AnnotationData> prepareAnnotationToAdd(SecurityContext ctx, List<AnnotationData> toAdd) throws DSOutOfServiceException, DSAccessException {
        ArrayList<AnnotationData> annotations = new ArrayList<AnnotationData>();
        if (toAdd == null || toAdd.size() == 0) {
            return annotations;
        }
        Iterator<Object> i = toAdd.iterator();
        Annotation iobject = null;
        ArrayList<Object> toCreate = new ArrayList<Object>();
        while (i.hasNext()) {
            AnnotationData ann = i.next();
            if (ann.getId() < 0L) {
                TagAnnotationData t;
                Set set;
                if (ann instanceof FileAnnotationData) {
                    FileAnnotationData fileAnn = (FileAnnotationData)ann;
                    OriginalFile of = this.gateway.uploadFile(ctx, fileAnn.getAttachedFile(), fileAnn.getServerFileMimetype(), -1L);
                    FileAnnotationI fa = new FileAnnotationI();
                    fa.setFile(of);
                    iobject = fa;
                } else {
                    iobject = ModelMapper.createAnnotation(ann);
                }
                if (iobject == null) continue;
                boolean added = false;
                if (ann instanceof TagAnnotationData && CollectionUtils.isNotEmpty((Collection)(set = (t = (TagAnnotationData)ann).getDataObjects()))) {
                    for (DataObject d : set) {
                        IObject link;
                        if (!(d instanceof TagAnnotationData) || (link = ModelMapper.linkParentToChild(t.asIObject(), d.asIObject())) == null) continue;
                        toCreate.add(link);
                        added = true;
                    }
                }
                if (added) continue;
                toCreate.add(iobject);
                continue;
            }
            if (ann instanceof TagAnnotationData || ann instanceof TermAnnotationData || ann instanceof XMLAnnotationData || ann instanceof MapAnnotationData) {
                AnnotationData tag = ann;
                ann = (AnnotationData)this.updateAnnotationData(ctx, (DataObject)tag);
            }
            annotations.add(ann);
        }
        if (toCreate.size() > 0) {
            i = toCreate.iterator();
            ArrayList<IObject> l = new ArrayList<IObject>(toCreate.size());
            while (i.hasNext()) {
                l.add((IObject)i.next());
            }
            List<IObject> r = this.gateway.createObjects(ctx, l);
            toCreate.clear();
            for (Object object : r) {
                if (!(object instanceof AnnotationAnnotationLink)) continue;
                AnnotationAnnotationLink link = (AnnotationAnnotationLink)object;
                annotations.add((AnnotationData)PojoMapper.asDataObject((IObject)link.getChild()));
            }
            annotations.addAll(PojoMapper.convertToDataObjects(r));
        }
        return annotations;
    }

    private synchronized void linkAnnotation(SecurityContext ctx, DataObject data, AnnotationData annotation) throws DSOutOfServiceException, DSAccessException {
        String ioType = PojoMapper.getModelType(data.getClass()).getName();
        IObject ho = this.gateway.findIObject(ctx, ioType, data.getId());
        if (ho == null) {
            return;
        }
        ModelMapper.unloadCollections(ho);
        IObject link = null;
        boolean exist = false;
        Annotation an = annotation.asAnnotation();
        long[] expIds = new long[]{data.getOwner().getId(), this.getUserDetails().getId()};
        if (annotation instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)annotation;
            if (TagAnnotationData.class.equals(data.getClass())) {
                link = this.findAnnotationLink(ctx, AnnotationData.class, tag.getId(), ho.getId().getValue(), expIds);
                if (link == null) {
                    link = ModelMapper.linkAnnotation((IObject)an, (Annotation)ho);
                } else {
                    exist = true;
                }
            } else {
                link = this.findAnnotationLink(ctx, ho.getClass(), ho.getId().getValue(), tag.getId(), expIds);
                if (link == null) {
                    link = ModelMapper.linkAnnotation(ho, an);
                } else {
                    this.updateAnnotationData(ctx, (DataObject)tag);
                    exist = true;
                }
            }
        } else if (annotation instanceof MapAnnotationData) {
            MapAnnotationData map = (MapAnnotationData)annotation;
            link = this.findAnnotationLink(ctx, ho.getClass(), ho.getId().getValue(), map.getId(), expIds);
            if (link == null) {
                link = ModelMapper.linkAnnotation(ho, an);
            } else {
                this.updateAnnotationData(ctx, (DataObject)map);
                exist = true;
            }
        } else if (annotation instanceof RatingAnnotationData) {
            RatingAnnotationData ra = (RatingAnnotationData)annotation;
            link = this.findAnnotationLink(ctx, ho.getClass(), ho.getId().getValue(), ra.getId(), expIds);
            if (link == null) {
                link = ModelMapper.linkAnnotation(ho, an);
            } else {
                this.updateAnnotationData(ctx, (DataObject)ra);
                exist = true;
            }
        } else if (annotation instanceof LongAnnotationData) {
            LongAnnotationData ra = (LongAnnotationData)annotation;
            link = this.findAnnotationLink(ctx, ho.getClass(), ho.getId().getValue(), ra.getId(), expIds);
            if (link == null) {
                link = ModelMapper.linkAnnotation(ho, an);
            } else {
                this.updateAnnotationData(ctx, (DataObject)ra);
                exist = true;
            }
        } else {
            link = ModelMapper.linkAnnotation(ho, an);
        }
        if (link != null && !exist) {
            this.gateway.createObject(ctx, link);
        }
    }

    private IObject findAnnotationLink(SecurityContext ctx, Class type, long parentID, long childID, long[] userIDs) throws DSOutOfServiceException, DSAccessException {
        for (long userID : userIDs) {
            IObject obj = this.gateway.findAnnotationLink(ctx, type, parentID, childID, userID);
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    private DataObject updateAnnotationData(SecurityContext ctx, DataObject ann) throws DSOutOfServiceException, DSAccessException {
        if (ann instanceof TagAnnotationData && ann.isDirty()) {
            TagAnnotationData tag = (TagAnnotationData)ann;
            long id = tag.getId();
            String ioType = PojoMapper.getModelType(TagAnnotationData.class).getName();
            TagAnnotation ho = (TagAnnotation)this.gateway.findIObject(ctx, ioType, id);
            ho.setTextValue(rtypes.rstring((String)tag.getTagValue()));
            ho.setDescription(rtypes.rstring((String)tag.getTagDescription()));
            IObject object = this.gateway.updateObject(ctx, (IObject)ho, new Parameters());
            return PojoMapper.asDataObject((IObject)object);
        }
        if (ann instanceof TermAnnotationData && ann.isDirty()) {
            TermAnnotationData tag = (TermAnnotationData)ann;
            long id = tag.getId();
            String ioType = PojoMapper.getModelType(TermAnnotationData.class).getName();
            TermAnnotation ho = (TermAnnotation)this.gateway.findIObject(ctx, ioType, id);
            ho.setTermValue(rtypes.rstring((String)tag.getTerm()));
            ho.setDescription(rtypes.rstring((String)tag.getTermDescription()));
            IObject object = this.gateway.updateObject(ctx, (IObject)ho, new Parameters());
            return PojoMapper.asDataObject((IObject)object);
        }
        if (ann instanceof XMLAnnotationData && ann.isDirty()) {
            XMLAnnotationData tag = (XMLAnnotationData)ann;
            long id = tag.getId();
            String ioType = PojoMapper.getModelType(XMLAnnotationData.class).getName();
            XmlAnnotation ho = (XmlAnnotation)this.gateway.findIObject(ctx, ioType, id);
            ho.setTextValue(rtypes.rstring((String)tag.getText()));
            ho.setDescription(rtypes.rstring((String)tag.getDescription()));
            IObject object = this.gateway.updateObject(ctx, (IObject)ho, new Parameters());
            return PojoMapper.asDataObject((IObject)object);
        }
        if (ann instanceof RatingAnnotationData && ann.isDirty()) {
            RatingAnnotationData tag = (RatingAnnotationData)ann;
            long id = tag.getId();
            String ioType = PojoMapper.getModelType(LongAnnotationData.class).getName();
            LongAnnotation ho = (LongAnnotation)this.gateway.findIObject(ctx, ioType, id);
            ho.setLongValue(rtypes.rlong((long)tag.getRating()));
            IObject object = this.gateway.updateObject(ctx, (IObject)ho, new Parameters());
            return PojoMapper.asDataObject((IObject)object);
        }
        if (ann instanceof LongAnnotationData && ann.isDirty()) {
            LongAnnotationData tag = (LongAnnotationData)ann;
            long id = tag.getId();
            String ioType = PojoMapper.getModelType(LongAnnotationData.class).getName();
            LongAnnotation ho = (LongAnnotation)this.gateway.findIObject(ctx, ioType, id);
            ho.setLongValue(rtypes.rlong((long)tag.getDataValue()));
            IObject object = this.gateway.updateObject(ctx, (IObject)ho, new Parameters());
            return PojoMapper.asDataObject((IObject)object);
        }
        if (ann instanceof DoubleAnnotationData && ann.isDirty()) {
            DoubleAnnotationData tag = (DoubleAnnotationData)ann;
            long id = tag.getId();
            String ioType = PojoMapper.getModelType(DoubleAnnotationData.class).getName();
            DoubleAnnotation ho = (DoubleAnnotation)this.gateway.findIObject(ctx, ioType, id);
            ho.setDoubleValue(rtypes.rdouble((double)tag.getDataValue()));
            IObject object = this.gateway.updateObject(ctx, (IObject)ho, new Parameters());
            return PojoMapper.asDataObject((IObject)object);
        }
        if (ann instanceof BooleanAnnotationData && ann.isDirty()) {
            BooleanAnnotationData tag = (BooleanAnnotationData)ann;
            long id = tag.getId();
            String ioType = PojoMapper.getModelType(BooleanAnnotationData.class).getName();
            BooleanAnnotation ho = (BooleanAnnotation)this.gateway.findIObject(ctx, ioType, id);
            ho.setBoolValue(rtypes.rbool((boolean)tag.getValue()));
            IObject object = this.gateway.updateObject(ctx, (IObject)ho, new Parameters());
            return PojoMapper.asDataObject((IObject)object);
        }
        if (ann instanceof MapAnnotationData && ann.isDirty()) {
            MapAnnotationData map = (MapAnnotationData)ann;
            long id = map.getId();
            String ioType = PojoMapper.getModelType(MapAnnotationData.class).getName();
            MapAnnotation m = (MapAnnotation)this.gateway.findIObject(ctx, ioType, id);
            m.setMapValue((List)map.getContent());
            IObject object = this.gateway.updateObject(ctx, (IObject)m, new Parameters());
            return PojoMapper.asDataObject((IObject)object);
        }
        return ann;
    }

    private void convert(List<DataObject> all, Collection l) {
        if (l == null || l.size() == 0) {
            return;
        }
        for (IObject object : l) {
            if (object instanceof ProjectAnnotationLink) {
                all.add(PojoMapper.asDataObject((IObject)((ProjectAnnotationLink)object).getChild()));
                continue;
            }
            if (object instanceof DatasetAnnotationLink) {
                all.add(PojoMapper.asDataObject((IObject)((DatasetAnnotationLink)object).getChild()));
                continue;
            }
            if (!(object instanceof ImageAnnotationLink)) continue;
            all.add(PojoMapper.asDataObject((IObject)((ImageAnnotationLink)object).getChild()));
        }
    }

    private Collection loadAllAttachments(SecurityContext ctx, Class type, long userID) throws DSOutOfServiceException, DSAccessException {
        ArrayList<DataObject> all = new ArrayList<DataObject>();
        if (type == null) {
            Collection l = this.gateway.findAllAnnotations(ctx, ProjectData.class, userID);
            if (l != null && l.size() > 0) {
                this.convert(all, l);
            }
            if ((l = this.gateway.findAllAnnotations(ctx, DatasetData.class, userID)) != null && l.size() > 0) {
                this.convert(all, l);
            }
            if ((l = this.gateway.findAllAnnotations(ctx, ImageData.class, userID)) != null && l.size() > 0) {
                this.convert(all, l);
            }
            return this.getFileAnnotations(ctx, all);
        }
        this.convert(all, this.gateway.findAllAnnotations(ctx, type, userID));
        return this.getFileAnnotations(ctx, all);
    }

    private List<AnnotationData> getFileAnnotations(SecurityContext ctx, Collection annotations) throws DSOutOfServiceException, DSAccessException {
        ArrayList<AnnotationData> result = new ArrayList<AnnotationData>();
        if (annotations == null || annotations.size() == 0) {
            return result;
        }
        for (AnnotationData data : annotations) {
            if (!(data instanceof FileAnnotationData)) continue;
            FileAnnotation fa = (FileAnnotation)data.asAnnotation();
            long fileID = fa.getFile().getId().getValue();
            OriginalFile of = this.gateway.getOriginalFile(ctx, fileID);
            if (of != null) {
                ((FileAnnotationData)data).setContent((Object)of);
            }
            result.add(data);
        }
        return result;
    }

    OmeroMetadataServiceImpl(OMEROGateway gateway, Registry registry) {
        if (registry == null) {
            throw new IllegalArgumentException("No registry.");
        }
        if (gateway == null) {
            throw new IllegalArgumentException("No gateway.");
        }
        this.context = registry;
        this.gateway = gateway;
    }

    @Override
    public Collection loadRatings(SecurityContext ctx, Class type, long id, long userID) throws DSOutOfServiceException, DSAccessException {
        ArrayList<Long> ids = null;
        if (userID != -1L) {
            ids = new ArrayList<Long>(1);
            ids.add(userID);
        }
        ArrayList<Long> nodeIds = new ArrayList<Long>(1);
        nodeIds.add(id);
        ArrayList<Class> types = new ArrayList<Class>();
        types.add(RatingAnnotationData.class);
        Map map = this.gateway.loadAnnotations(ctx, type, nodeIds, types, ids, new Parameters());
        if (map == null || map.size() == 0) {
            return new ArrayList();
        }
        return (Collection)map.get(id);
    }

    private void loadStructuredData(SecurityContext ctx, long userID, Collection annotations, StructuredDataResults results, boolean loadLinks) throws DSOutOfServiceException, DSAccessException {
        Object object = results.getRelatedObject();
        if (CollectionUtils.isNotEmpty((Collection)annotations)) {
            ArrayList<TextualAnnotationData> texts = new ArrayList<TextualAnnotationData>();
            ArrayList<TagAnnotationData> tags = new ArrayList<TagAnnotationData>();
            ArrayList<TermAnnotationData> terms = new ArrayList<TermAnnotationData>();
            ArrayList<FileAnnotationData> attachments = new ArrayList<FileAnnotationData>();
            ArrayList<RatingAnnotationData> ratings = new ArrayList<RatingAnnotationData>();
            ArrayList<XMLAnnotationData> xml = new ArrayList<XMLAnnotationData>();
            ArrayList<MapAnnotationData> maps = new ArrayList<MapAnnotationData>();
            ArrayList<AnnotationData> other = new ArrayList<AnnotationData>();
            Iterator i = annotations.iterator();
            HashMap<Long, AnnotationData> map = new HashMap<Long, AnnotationData>();
            ArrayList<Long> annotationIds = new ArrayList<Long>();
            while (i.hasNext()) {
                AnnotationData data = (AnnotationData)i.next();
                if (data instanceof TermAnnotationData) {
                    annotationIds.add(data.getId());
                    terms.add((TermAnnotationData)data);
                    continue;
                }
                if (data instanceof TextualAnnotationData) {
                    texts.add((TextualAnnotationData)data);
                    continue;
                }
                if (data instanceof TagAnnotationData) {
                    annotationIds.add(data.getId());
                    map.put(data.getId(), data);
                    tags.add((TagAnnotationData)data);
                    continue;
                }
                if (data instanceof RatingAnnotationData) {
                    ratings.add((RatingAnnotationData)data);
                    continue;
                }
                if (data instanceof FileAnnotationData) {
                    annotationIds.add(data.getId());
                    map.put(data.getId(), data);
                    attachments.add((FileAnnotationData)data);
                    continue;
                }
                if (data instanceof XMLAnnotationData) {
                    annotationIds.add(data.getId());
                    xml.add((XMLAnnotationData)data);
                    continue;
                }
                if (data instanceof MapAnnotationData) {
                    annotationIds.add(data.getId());
                    maps.add((MapAnnotationData)data);
                    continue;
                }
                annotationIds.add(data.getId());
                other.add(data);
            }
            if (loadLinks && annotationIds.size() > 0 && !(object instanceof TagAnnotationData) && !(object instanceof FileAnnotationData)) {
                List links = this.gateway.findAnnotationLinks(ctx, object.getClass(), results.getObjectId(), annotationIds, -1L);
                this.formatAnnotationLinks(links, results);
            }
            results.getOtherAnnotations().addAll(other);
            results.getXMLAnnotations().addAll(xml);
            results.getTextualAnnotations().addAll(texts);
            results.getTerms().addAll(terms);
            results.getTags().addAll(tags);
            results.getRatings().addAll(ratings);
            results.getAttachments().addAll(attachments);
            results.getMapAnnotations().addAll(maps);
        }
    }

    @Override
    public StructuredDataResults loadStructuredData(SecurityContext ctx, Object object, long userID, boolean viewed) throws DSOutOfServiceException, DSAccessException {
        ImageData img;
        long fID;
        if (object == null) {
            throw new IllegalArgumentException("Object not valid.");
        }
        StructuredDataResults results = null;
        DataObject r = null;
        if (object instanceof File) {
            File f = (File)object;
            DataObject fd = this.gateway.loadFolder(f.getAbsolutePath());
            return new StructuredDataResults(fd);
        }
        if (object instanceof DataObject) {
            r = (DataObject)object;
            results = new StructuredDataResults(r);
        }
        if (r == null) {
            throw new IllegalArgumentException("Data Object not initialized.");
        }
        Collection annotations = this.loadStructuredAnnotations(ctx, object.getClass(), r.getId(), userID);
        this.loadStructuredData(ctx, userID, annotations, results, true);
        if (object instanceof ImageData && (fID = (img = (ImageData)object).getFilesetId()) >= 0L) {
            Map<Long, Collection<AnnotationData>> map = this.loadAnnotations(ctx, FilesetData.class, Arrays.asList(fID), TextualAnnotationData.class, Arrays.asList("openmicroscopy.org/omero/import/fileTransfer"), null);
            results.getTransferLinks().addAll(map.get(fID));
        }
        return results;
    }

    @Override
    public Map<DataObject, StructuredDataResults> loadStructuredData(SecurityContext ctx, List<DataObject> data, long userID, boolean viewed) throws DSOutOfServiceException, DSAccessException {
        if (data == null) {
            throw new IllegalArgumentException("Object not valid.");
        }
        HashMap<DataObject, StructuredDataResults> results = new HashMap<DataObject, StructuredDataResults>();
        Iterator<DataObject> i = data.iterator();
        ArrayList<Long> ids = new ArrayList<Long>();
        Object klass = null;
        ArrayList<Long> fids = new ArrayList<Long>();
        ArrayListMultimap mm = ArrayListMultimap.create();
        while (i.hasNext()) {
            ImageData img;
            long fID;
            DataObject n = i.next();
            if (n == null) continue;
            ids.add(n.getId());
            mm.put(n.getClass(), (Object)n.getId());
            if (!(n instanceof ImageData) || (fID = (img = (ImageData)n).getFilesetId()) < 0L || fids.contains(fID)) continue;
            fids.add(fID);
        }
        HashMap<Long, Collection<AnnotationData>> filesetMap = new HashMap();
        if (!fids.isEmpty()) {
            filesetMap = this.loadAnnotations(ctx, FilesetData.class, fids, TextualAnnotationData.class, Arrays.asList("openmicroscopy.org/omero/import/fileTransfer"), null);
        }
        ArrayList<Long> usersIDs = null;
        if (userID != -1L) {
            usersIDs = new ArrayList<Long>(1);
            usersIDs.add(userID);
        }
        for (Class k : mm.keySet()) {
            this.loadAnnotations(ctx, k, (List)mm.get((Object)k), userID, data, filesetMap, results);
        }
        return results;
    }

    private void loadAnnotations(SecurityContext ctx, Class<?> klass, List<Long> ids, long userID, List<DataObject> data, Map<Long, Collection<AnnotationData>> filesetMap, Map<DataObject, StructuredDataResults> results) throws DSOutOfServiceException, DSAccessException {
        ArrayList<Long> usersIDs = null;
        if (userID != -1L) {
            usersIDs = new ArrayList<Long>(1);
            usersIDs.add(userID);
        }
        Map map = this.gateway.loadAnnotations(ctx, klass, ids, null, usersIDs, new Parameters());
        Multimap<Long, IObject> linkMap = ArrayListMultimap.create();
        if (!klass.equals(TagAnnotationData.class) && !klass.equals(FileAnnotationData.class)) {
            Collection values = map.values();
            Iterator k = values.iterator();
            ArrayList<Long> annotationIds = new ArrayList<Long>();
            while (k.hasNext()) {
                Collection l = (Collection)k.next();
                for (AnnotationData object : l) {
                    if (annotationIds.contains(object.getId())) continue;
                    annotationIds.add(object.getId());
                }
            }
            if (CollectionUtils.isNotEmpty(annotationIds)) {
                linkMap = this.gateway.findAnnotationLinks(ctx, klass, ids, annotationIds, userID);
            }
        }
        for (DataObject n : data) {
            ImageData img;
            if (n == null || !ids.contains(n.getId())) continue;
            StructuredDataResults r = new StructuredDataResults(n);
            this.loadStructuredData(ctx, userID, (Collection)map.get(n.getId()), r, false);
            results.put(n, r);
            if (n instanceof ImageData && filesetMap.get((img = (ImageData)n).getFilesetId()) != null) {
                r.getTransferLinks().addAll(filesetMap.get(img.getFilesetId()));
            }
            this.formatAnnotationLinks(linkMap.get((Object)n.getId()), r);
        }
    }

    private void formatAnnotationLinks(Collection<IObject> links, StructuredDataResults results) {
        if (CollectionUtils.isEmpty(links)) {
            return;
        }
        HashMap<DataObject, ExperimenterData> m = new HashMap<DataObject, ExperimenterData>();
        Iterator<IObject> j = links.iterator();
        ArrayList<AnnotationLinkData> l = new ArrayList<AnnotationLinkData>();
        while (j.hasNext()) {
            IObject link = j.next();
            IObject ho = ModelMapper.getChildFromLink(link);
            DataObject d = PojoMapper.asDataObject((IObject)ho);
            l.add(new AnnotationLinkData(link, d, PojoMapper.asDataObject((IObject)ModelMapper.getParentFromLink(link))));
            if (d == null) continue;
            m.put(d, (ExperimenterData)PojoMapper.asDataObject((IObject)link.getDetails().getOwner()));
        }
        results.getLinks().putAll(m);
        results.getAnnotationLinks().addAll(l);
    }

    @Override
    public DataObject annotate(SecurityContext ctx, DataObject toAnnotate, AnnotationData annotation) throws DSOutOfServiceException, DSAccessException {
        if (toAnnotate == null) {
            throw new IllegalArgumentException("DataObject cannot be null");
        }
        ctx = this.gateway.checkContext(ctx, toAnnotate);
        return this.annotate(ctx, toAnnotate.getClass(), toAnnotate.getId(), annotation);
    }

    @Override
    public DataObject annotate(SecurityContext ctx, Class type, long id, AnnotationData annotation) throws DSOutOfServiceException, DSAccessException {
        if (annotation == null) {
            throw new IllegalArgumentException("DataObject cannot be null");
        }
        String ioType = PojoMapper.getModelType((Class)type).getName();
        IObject ho = this.gateway.findIObject(ctx, ioType, id);
        ModelMapper.unloadCollections(ho);
        IObject link = null;
        boolean exist = false;
        ExperimenterData exp = this.getUserDetails();
        if (annotation instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)annotation;
            if (TagAnnotationData.class.equals((Object)type)) {
                if (tag.getId() <= 0L) {
                    TagAnnotationI ann = new TagAnnotationI();
                    ann.setTextValue(rtypes.rstring((String)tag.getContentAsString()));
                    ann.setDescription(rtypes.rstring((String)tag.getTagDescription()));
                    link = ModelMapper.linkAnnotation((IObject)ann, (Annotation)ho);
                } else {
                    IObject annObject = tag.asIObject();
                    ModelMapper.unloadCollections(annObject);
                    link = this.gateway.findAnnotationLink(ctx, AnnotationData.class, tag.getId(), ho.getId().getValue(), exp.getId());
                    if (link == null) {
                        link = ModelMapper.linkAnnotation(annObject, (Annotation)ho);
                    }
                }
            } else if (tag.getId() <= 0L) {
                link = ModelMapper.createAnnotationAndLink(ho, annotation);
            } else {
                IObject annObject = tag.asIObject();
                ModelMapper.unloadCollections(annObject);
                link = this.gateway.findAnnotationLink(ctx, ho.getClass(), ho.getId().getValue(), tag.getId(), exp.getId());
                if (link == null) {
                    link = ModelMapper.linkAnnotation(ho, (Annotation)annObject);
                } else {
                    exist = true;
                }
            }
        } else if (annotation instanceof RatingAnnotationData) {
            this.clearAnnotation(ctx, type, id, RatingAnnotationData.class);
            link = ModelMapper.createAnnotationAndLink(ho, annotation);
        } else if (annotation instanceof FileAnnotationData) {
            FileAnnotationData ann = (FileAnnotationData)annotation;
            if (ann.getId() < 0L) {
                OriginalFile of = this.gateway.uploadFile(ctx, ann.getAttachedFile(), ann.getServerFileMimetype(), -1L);
                FileAnnotationI fa = new FileAnnotationI();
                fa.setFile(of);
                link = ModelMapper.linkAnnotation(ho, (Annotation)fa);
            } else {
                IObject annObject = ann.asIObject();
                ModelMapper.unloadCollections(annObject);
                OriginalFile of = ((FileAnnotation)annObject).getFile();
                link = ModelMapper.linkAnnotation(ho, (Annotation)annObject);
            }
        } else {
            link = ModelMapper.createAnnotationAndLink(ho, annotation);
        }
        if (link != null) {
            IObject object = exist ? link : this.gateway.createObject(ctx, link);
            return PojoMapper.asDataObject((IObject)ModelMapper.getAnnotatedObject(object));
        }
        return null;
    }

    @Override
    public void clearAnnotation(SecurityContext ctx, Class type, long id, Class annotationType) throws DSOutOfServiceException, DSAccessException {
        if (type == null) {
            throw new IllegalArgumentException("No object specified.");
        }
        long userID = this.getUserDetails().getId();
        Collection annotations = this.loadStructuredAnnotations(ctx, type, id, userID);
        if (annotations == null || annotations.size() == 0) {
            return;
        }
        ArrayList<IObject> toRemove = new ArrayList<IObject>();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (AnnotationData data : annotations) {
            if (annotationType != null && !data.getClass().equals(annotationType)) continue;
            toRemove.add(data.asIObject());
            ids.add(data.getId());
        }
        List l = null;
        Class klass = PojoMapper.getModelType((Class)type);
        if (ids.size() != 0) {
            l = this.gateway.findAnnotationLinks(ctx, klass, id, ids);
        }
        if (l != null) {
            for (IObject o : l) {
                if (!this.gateway.canDelete(o)) continue;
                this.gateway.deleteObject(ctx, o);
            }
            for (IObject obj : toRemove) {
                ids = new ArrayList();
                ids.add(obj.getId().getValue());
                l = this.gateway.findAnnotationLinks(ctx, klass, -1L, ids);
                if (l != null && l.size() != 0 || !this.gateway.canDelete(obj)) continue;
                this.gateway.deleteObject(ctx, obj);
            }
        }
    }

    @Override
    public void clearAnnotation(SecurityContext ctx, DataObject object, Class annotationType) throws DSOutOfServiceException, DSAccessException {
        if (object == null) {
            throw new IllegalArgumentException("No object specified.");
        }
        ctx = this.gateway.checkContext(ctx, object);
        this.clearAnnotation(ctx, object.getClass(), object.getId(), annotationType);
    }

    @Override
    public void clearAnnotation(SecurityContext ctx, DataObject object) throws DSOutOfServiceException, DSAccessException {
        if (object == null) {
            throw new IllegalArgumentException("No object specified.");
        }
        ctx = this.gateway.checkContext(ctx, object);
        this.clearAnnotation(ctx, object.getClass(), object.getId(), null);
    }

    @Override
    public Collection loadStructuredAnnotations(SecurityContext ctx, Class type, long id, long userID) throws DSOutOfServiceException, DSAccessException {
        if (id < 0L) {
            new ArrayList();
        }
        if (type == null) {
            throw new IllegalArgumentException("No type specified.");
        }
        ArrayList<Long> ids = null;
        if (userID != -1L) {
            ids = new ArrayList<Long>(1);
            ids.add(userID);
        }
        ArrayList<Long> objects = new ArrayList<Long>(1);
        objects.add(id);
        Map map = this.gateway.loadAnnotations(ctx, type, objects, null, ids, new Parameters());
        return (Collection)map.get(id);
    }

    @Override
    public Collection loadAnnotations(SecurityContext ctx, Class annotationType, String nameSpace, long userID) throws DSOutOfServiceException, DSAccessException {
        ParametersI po = new ParametersI();
        if (userID >= 0L) {
            po.exp(rtypes.rlong((long)userID));
        }
        ArrayList<String> toInclude = new ArrayList<String>();
        ArrayList<String> toExclude = new ArrayList<String>();
        if (nameSpace != null) {
            toInclude.add(nameSpace);
        }
        if (TagAnnotationData.class.equals((Object)annotationType)) {
            po.orphan();
            return this.gateway.loadTagSets(ctx, (Parameters)po);
        }
        if (FileAnnotationData.class.equals((Object)annotationType)) {
            if (!"openmicroscopy.org/omero/import/companionFile".equals(nameSpace)) {
                toExclude.add("openmicroscopy.org/omero/import/companionFile");
            }
            if (!"openmicroscopy.org/omero/measurement".equals(nameSpace)) {
                toExclude.add("openmicroscopy.org/omero/measurement");
            }
            if (!"openmicroscopy.org/omero/experimenter/photo".equals(nameSpace)) {
                toExclude.add("openmicroscopy.org/omero/experimenter/photo");
            }
            if (!"openmicroscopy.org/omero/import/logFile".equals(nameSpace)) {
                toExclude.add("openmicroscopy.org/omero/import/logFile");
            }
        }
        return this.gateway.loadSpecificAnnotation(ctx, annotationType, toInclude, toExclude, (Parameters)po);
    }

    @Override
    public Object saveData(SecurityContext ctx, Collection<DataObject> data, List<AnnotationData> toAdd, List<Object> toRemove, long userID) throws DSOutOfServiceException, DSAccessException {
        if (data == null) {
            throw new IllegalArgumentException("No data to save");
        }
        Iterator<DataObject> j = data.iterator();
        OmeroDataService service = this.context.getDataService();
        List<AnnotationData> annotations = this.prepareAnnotationToAdd(ctx, toAdd);
        j = data.iterator();
        ArrayList<DataObject> updated = new ArrayList<DataObject>();
        ArrayList<Long> ids = new ArrayList<Long>();
        ArrayList<IObject> toDelete = new ArrayList<IObject>();
        while (j.hasNext()) {
            DataObject object = j.next();
            if (ids.contains(object.getId())) continue;
            ids.add(object.getId());
            if (object instanceof AnnotationData) {
                this.updateAnnotationData(ctx, object);
            } else if (object.isLoaded() && object.isDirty()) {
                updated.add(service.updateDataObject(ctx, object));
            } else {
                updated.add(object);
            }
            if (annotations.size() > 0) {
                for (AnnotationData ann : annotations) {
                    if (ann == null) continue;
                    this.linkAnnotation(ctx, object, ann);
                }
            }
            if (toRemove == null) continue;
            for (Object o : toRemove) {
                AnnotationData ann;
                if (o == null) continue;
                toDelete.addAll(this.getRemoveAnnotation(ctx, o, object));
                if (!(o instanceof TextualAnnotationData) || this.isAnnotationShared(ctx, ann = (AnnotationData)o, object)) continue;
                toDelete.add(ann.asIObject());
            }
        }
        if (!toDelete.isEmpty()) {
            this.gateway.deleteObjects(ctx, toDelete);
        }
        return updated;
    }

    @Override
    public Object saveBatchData(SecurityContext ctx, Collection<DataObject> data, List<AnnotationData> toAdd, List<Object> toRemove, long userID) throws DSOutOfServiceException, DSAccessException {
        if (data == null) {
            throw new IllegalArgumentException("No data to save");
        }
        OmeroDataService service = this.context.getDataService();
        Iterator<DataObject> j = data.iterator();
        Collection<Object> images = null;
        Parameters po = new Parameters();
        ArrayList<DataObject> result = null;
        List<AnnotationData> annotations = this.prepareAnnotationToAdd(ctx, toAdd);
        ArrayList<Long> childrenIds = new ArrayList<Long>();
        ArrayList<IObject> toDelete = new ArrayList<IObject>();
        while (j.hasNext()) {
            Iterator<Object> i;
            DataObject object = j.next();
            if (result == null) {
                result = new ArrayList<DataObject>();
            }
            if (object instanceof DatasetData) {
                ArrayList<Long> ids = new ArrayList<Long>(1);
                ids.add(object.getId());
                images = this.gateway.getContainerImages(ctx, DatasetData.class, ids, po);
                if (images == null) continue;
                for (DataObject dataObject : images) {
                    if (childrenIds.contains(dataObject.getId())) continue;
                    result.add(dataObject);
                    childrenIds.add(dataObject.getId());
                    if (annotations != null) {
                        i = annotations.iterator();
                        while (i.hasNext()) {
                            this.linkAnnotation(ctx, dataObject, (AnnotationData)i.next());
                        }
                    }
                    if (toRemove == null) continue;
                    i = toRemove.iterator();
                    while (i.hasNext()) {
                        toDelete.addAll(this.getRemoveAnnotation(ctx, i.next(), dataObject));
                    }
                }
                continue;
            }
            if (object instanceof PlateData) {
                images = this.gateway.loadPlateWells(ctx, object.getId(), -1L);
                if (images == null) continue;
                for (DataObject dataObject : images) {
                    if (childrenIds.contains(dataObject.getId())) continue;
                    result.add(dataObject);
                    childrenIds.add(dataObject.getId());
                    if (annotations != null) {
                        i = annotations.iterator();
                        while (i.hasNext()) {
                            this.linkAnnotation(ctx, dataObject, (AnnotationData)i.next());
                        }
                    }
                    if (toRemove == null) continue;
                    i = toRemove.iterator();
                    while (i.hasNext()) {
                        toDelete.addAll(this.getRemoveAnnotation(ctx, (AnnotationData)i.next(), dataObject));
                    }
                }
                continue;
            }
            if (!(object instanceof ImageData)) continue;
            service.updateDataObject(ctx, object);
            if (annotations != null) {
                i = annotations.iterator();
                while (i.hasNext()) {
                    this.linkAnnotation(ctx, object, (AnnotationData)i.next());
                }
            }
            if (toRemove == null) continue;
            i = toRemove.iterator();
            while (i.hasNext()) {
                toDelete.addAll(this.getRemoveAnnotation(ctx, (AnnotationData)i.next(), object));
            }
        }
        try {
            this.gateway.deleteObjects(ctx, toDelete);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null) {
            return data;
        }
        return result;
    }

    @Override
    public Object saveBatchData(SecurityContext ctx, TimeRefObject data, List<AnnotationData> toAdd, List<Object> toRemove, long userID) throws DSOutOfServiceException, DSAccessException {
        if (data == null) {
            throw new IllegalArgumentException("No data to save");
        }
        OmeroDataService service = this.context.getDataService();
        Collection images = service.getImagesPeriod(ctx, data.getStartTime(), data.getEndTime(), userID, true);
        ArrayList<DataObject> r = new ArrayList<DataObject>();
        if (images == null) {
            return r;
        }
        Iterator i = images.iterator();
        List<AnnotationData> annotations = this.prepareAnnotationToAdd(ctx, toAdd);
        ArrayList<IObject> toDelete = new ArrayList<IObject>();
        while (i.hasNext()) {
            Iterator<Object> j;
            DataObject child = (DataObject)i.next();
            r.add(child);
            if (annotations != null) {
                j = annotations.iterator();
                while (j.hasNext()) {
                    this.linkAnnotation(ctx, child, (AnnotationData)i.next());
                }
            }
            if (toRemove == null) continue;
            j = toRemove.iterator();
            while (j.hasNext()) {
                toDelete.addAll(this.getRemoveAnnotation(ctx, j.next(), child));
            }
        }
        if (!toDelete.isEmpty()) {
            try {
                this.gateway.deleteObjects(ctx, toDelete);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return r;
    }

    @Override
    public File downloadFile(SecurityContext ctx, File file, long fileID) throws DSOutOfServiceException, DSAccessException {
        if (fileID < 0L) {
            throw new IllegalArgumentException("File ID not valid");
        }
        if (file == null) {
            throw new IllegalArgumentException("File path not valid");
        }
        return this.gateway.downloadFile(ctx, file, fileID);
    }

    @Override
    public Map<Long, Collection> loadRatings(SecurityContext ctx, Class nodeType, List<Long> nodeIds, long userID) throws DSOutOfServiceException, DSAccessException {
        ArrayList<Long> ids = null;
        if (userID != -1L) {
            ids = new ArrayList<Long>(1);
            ids.add(userID);
        }
        ArrayList<Class> types = new ArrayList<Class>();
        types.add(RatingAnnotationData.class);
        Map map = this.gateway.loadAnnotations(ctx, nodeType, nodeIds, types, ids, new Parameters());
        HashMap<Long, Collection> results = new HashMap<Long, Collection>();
        if (map == null) {
            return results;
        }
        for (Map.Entry entry : map.entrySet()) {
            Long id = (Long)entry.getKey();
            Collection l = (Collection)entry.getValue();
            ArrayList<AnnotationData> result = new ArrayList<AnnotationData>();
            for (AnnotationData data : l) {
                if (!(data instanceof RatingAnnotationData)) continue;
                result.add(data);
            }
            if (result.size() <= 0) continue;
            results.put(id, result);
        }
        return results;
    }

    @Override
    public Collection filterByAnnotation(SecurityContext ctx, Class nodeType, List<Long> nodeIds, Class annotationType, List<String> terms, long userID) throws DSOutOfServiceException, DSAccessException {
        List<Long> nodes;
        long id;
        HashSet results = new HashSet();
        ArrayList<Long> ids = null;
        if (userID != -1L) {
            ids = new ArrayList<Long>(1);
            ids.add(userID);
        }
        ArrayList<Class> types = new ArrayList<Class>();
        types.add(annotationType);
        Map map = this.gateway.loadAnnotations(ctx, nodeType, nodeIds, types, ids, new Parameters());
        if (map == null || map.size() == 0) {
            return results;
        }
        HashMap m = new HashMap();
        if (terms != null && terms.size() > 0) {
            for (Map.Entry entry : map.entrySet()) {
                id = (Long)entry.getKey();
                Collection l = (Collection)entry.getValue();
                for (AnnotationData data : l) {
                    if (annotationType.equals(TagAnnotationData.class)) {
                        if (!(data instanceof TagAnnotationData) || !terms.contains(((TagAnnotationData)data).getTagValue())) continue;
                        nodes = (List)m.get(data.getId());
                        if (nodes == null) {
                            nodes = new ArrayList<Long>();
                            nodes.add(id);
                        }
                        if (!nodes.contains(id)) {
                            nodes.add(id);
                        }
                        m.put(data.getId(), nodes);
                        continue;
                    }
                    if (!annotationType.equals(TextualAnnotationData.class) || !(data instanceof TextualAnnotationData) || !this.containTerms(terms, ((TextualAnnotationData)data).getText())) continue;
                    nodes = (List)m.get(data.getId());
                    if (nodes == null) {
                        nodes = new ArrayList();
                        nodes.add(id);
                    }
                    if (!nodes.contains(id)) {
                        nodes.add(id);
                    }
                    m.put(data.getId(), nodes);
                }
            }
        } else {
            return this.filterByAnnotated(ctx, nodeType, nodeIds, annotationType, true, userID);
        }
        for (Map.Entry entry : m.entrySet()) {
            id = (Long)entry.getKey();
            nodes = (ArrayList<Long>)entry.getValue();
            results.addAll(nodes);
        }
        return results;
    }

    @Override
    public Collection filterByAnnotated(SecurityContext ctx, Class nodeType, List<Long> nodeIds, Class annotationType, boolean annotated, long userID) throws DSOutOfServiceException, DSAccessException {
        ArrayList<Long> results = new ArrayList<Long>();
        ArrayList<Long> ids = null;
        if (userID != -1L) {
            ids = new ArrayList<Long>(1);
            ids.add(userID);
        }
        ArrayList<Class> types = new ArrayList<Class>();
        types.add(annotationType);
        Map map = this.gateway.loadAnnotations(ctx, nodeType, nodeIds, types, ids, new Parameters());
        if (map == null || map.size() == 0) {
            return results;
        }
        Iterator i = map.entrySet().iterator();
        if (annotated) {
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                long id = (Long)entry.getKey();
                Collection l = (Collection)entry.getValue();
                for (AnnotationData data : l) {
                    if (annotationType.equals(TagAnnotationData.class)) {
                        if (!(data instanceof TagAnnotationData) || results.contains(id)) continue;
                        results.add(id);
                        continue;
                    }
                    if (!annotationType.equals(TextualAnnotationData.class) || data instanceof TagAnnotationData || results.contains(id)) continue;
                    results.add(id);
                }
            }
        } else {
            ArrayList<Long> toExclude = new ArrayList<Long>();
            results.addAll(nodeIds);
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                long id = (Long)entry.getKey();
                Collection l = (Collection)entry.getValue();
                for (AnnotationData data : l) {
                    if (annotationType.equals(TagAnnotationData.class)) {
                        if (!(data instanceof TagAnnotationData) || toExclude.contains(id)) continue;
                        toExclude.add(id);
                        continue;
                    }
                    if (!annotationType.equals(TextualAnnotationData.class) || data instanceof TagAnnotationData || toExclude.contains(id)) continue;
                    toExclude.add(id);
                }
            }
            results.removeAll(toExclude);
        }
        return results;
    }

    @Override
    public Collection filterByAnnotation(SecurityContext ctx, Class nodeType, List<Long> ids, FilterContext filter, long userID) throws DSOutOfServiceException, DSAccessException {
        Collection l;
        Long id;
        List<Long> found;
        Class<Object> type;
        Object m;
        Iterator<Map.Entry<Class<Object>, List<String>>> i;
        ArrayList<Class> annotationTypes;
        Map map;
        if (filter == null) {
            throw new IllegalArgumentException("No filtering context.");
        }
        int rateIndex = filter.getRateIndex();
        int roiIndex = filter.getRoiIndex();
        List<Long> filteredNodes = new ArrayList();
        ArrayList<Long> userIDs = null;
        if (userID != -1L) {
            userIDs = new ArrayList<Long>(1);
            userIDs.add(userID);
        }
        if (((map = this.gateway.loadAnnotations(ctx, nodeType, ids, annotationTypes = new ArrayList<Class>(), userIDs, new Parameters())) == null || map.size() == 0) && rateIndex == 2 && filter.getRate() == 0) {
            return ids;
        }
        ExperimenterData exp = this.getUserDetails();
        Timestamp start = filter.getFromDate();
        Timestamp end = filter.getToDate();
        HashSet<Long> annotationsIds = new HashSet<Long>();
        int resultType = filter.getResultType();
        Map<Class, List<String>> types = filter.getAnnotationType();
        HashMap<Class<Object>, List<Long>> r = new HashMap<Class<Object>, List<Long>>();
        if (types != null && types.size() > 0) {
            List annotations;
            i = types.entrySet().iterator();
            m = new HashMap();
            if (resultType == 101) {
                while (i.hasNext()) {
                    List<Long> nodes;
                    Map.Entry<Class<Object>, List<String>> entry = i.next();
                    type = entry.getKey();
                    found = new ArrayList();
                    annotations = this.gateway.filterBy(ctx, type, entry.getValue(), start, end, exp);
                    Iterator<Object> j = annotations.iterator();
                    while (j.hasNext()) {
                        annotationsIds.add((Long)j.next());
                    }
                    for (Map.Entry entry2 : map.entrySet()) {
                        id = (Long)entry2.getKey();
                        l = (Collection)entry2.getValue();
                        if (l.size() < annotations.size()) continue;
                        for (AnnotationData data : l) {
                            if (!annotations.contains(data.getId())) continue;
                            nodes = (List)m.get(data.getId());
                            if (nodes == null) {
                                nodes = new ArrayList<Long>();
                                nodes.add(id);
                            }
                            if (!nodes.contains(id)) {
                                nodes.add(id);
                            }
                            m.put(data.getId(), nodes);
                        }
                    }
                    for (Map.Entry entry3 : m.entrySet()) {
                        id = (Long)entry3.getKey();
                        nodes = (ArrayList<Long>)entry3.getValue();
                        if (found.size() == 0) {
                            found.addAll(nodes);
                            continue;
                        }
                        found = ListUtils.intersection(found, (List)nodes);
                    }
                    r.put(type, found);
                }
            } else if (resultType == 100) {
                while (i.hasNext()) {
                    type = (Class<Object>)((Object)i.next());
                    annotations = this.gateway.filterBy(ctx, type, types.get(type), start, end, exp);
                    i = annotations.iterator();
                    while (i.hasNext()) {
                        annotationsIds.add((Long)((Object)i.next()));
                    }
                }
                for (Map.Entry<Class<Object>, List<String>> entry : map.entrySet()) {
                    id = (Long)((Object)entry.getKey());
                    l = entry.getValue();
                    for (AnnotationData data : l) {
                        if (!annotationsIds.contains(data.getId())) continue;
                        filteredNodes.add(id);
                    }
                }
            }
        }
        if (roiIndex != -1) {
            found = new ArrayList<Long>();
            m = ids.iterator();
            while (m.hasNext()) {
                long imgId = (Long)m.next();
                List<ROIResult> roiResults = this.gateway.loadROI(ctx, imgId, null, userID);
                ArrayList rois = new ArrayList();
                for (ROIResult tmp : roiResults) {
                    rois.addAll(tmp.getROIs());
                }
                int numberOfRois = filter.getROIs();
                switch (roiIndex) {
                    case 2: {
                        if (rois.size() != numberOfRois) break;
                        found.add(imgId);
                        break;
                    }
                    case 1: {
                        if (rois.size() > numberOfRois) break;
                        found.add(imgId);
                        break;
                    }
                    case 0: {
                        if (rois.size() < numberOfRois) break;
                        found.add(imgId);
                    }
                }
            }
            if (resultType == 100) {
                filteredNodes.addAll(found);
            } else if (resultType == 101) {
                r.put(ROIData.class, found);
            }
        }
        if (rateIndex != -1) {
            int rate = filter.getRate();
            i = map.keySet().iterator();
            found = new ArrayList();
            switch (rateIndex) {
                case 2: {
                    if (rate == 0) {
                        found.addAll(ids);
                        while (i.hasNext()) {
                            found.remove(i.next());
                        }
                    } else {
                        while (i.hasNext()) {
                            id = (Long)((Object)i.next());
                            l = (Collection)map.get(id);
                            for (AnnotationData data : l) {
                                int value;
                                if (!(data instanceof RatingAnnotationData) || rate != (value = ((RatingAnnotationData)data).getRating())) continue;
                                found.add(id);
                            }
                        }
                    }
                    break;
                }
                case 1: {
                    if (rate == 0) {
                        found.addAll(ids);
                        while (i.hasNext()) {
                            found.remove(i.next());
                        }
                    } else {
                        while (i.hasNext()) {
                            id = (Long)((Object)i.next());
                            l = (Collection)map.get(id);
                            for (AnnotationData data : l) {
                                int value;
                                if (!(data instanceof RatingAnnotationData) || (value = ((RatingAnnotationData)data).getRating()) > rate) continue;
                                found.add(id);
                            }
                        }
                    }
                    break;
                }
                case 0: {
                    while (i.hasNext()) {
                        id = (Long)((Object)i.next());
                        l = (Collection)map.get(id);
                        for (AnnotationData data : l) {
                            int value;
                            if (!(data instanceof RatingAnnotationData) || (value = ((RatingAnnotationData)data).getRating()) < rate) continue;
                            found.add(id);
                        }
                    }
                    break;
                }
            }
            if (resultType == 100) {
                filteredNodes.addAll(found);
            } else if (resultType == 101) {
                r.put(RatingAnnotationData.class, found);
            }
        }
        if (resultType == 100) {
            return filteredNodes;
        }
        filteredNodes.clear();
        if (r.size() == 0) {
            return filteredNodes;
        }
        boolean index = false;
        type = null;
        i = r.values().iterator();
        if (!i.hasNext()) {
            return filteredNodes;
        }
        found = (List)((Object)i.next());
        filteredNodes.addAll(found);
        while (i.hasNext()) {
            found = (List)((Object)i.next());
            filteredNodes = ListUtils.intersection(filteredNodes, found);
        }
        return filteredNodes;
    }

    @Override
    public Collection getEnumeration(SecurityContext ctx, String type) throws DSOutOfServiceException, DSAccessException {
        return this.gateway.getEnumerations(ctx, type);
    }

    @Override
    public Object loadAcquisitionData(SecurityContext ctx, Object refObject) throws DSOutOfServiceException, DSAccessException {
        if (refObject instanceof ImageData) {
            ctx = this.gateway.checkContext(ctx, (DataObject)((ImageData)refObject));
            return this.gateway.loadImageAcquisitionData(ctx, ((ImageData)refObject).getId());
        }
        if (refObject instanceof ChannelData) {
            ctx = this.gateway.checkContext(ctx, (DataObject)((ChannelData)refObject));
            Channel c = ((ChannelData)refObject).asChannel();
            if (c.getLogicalChannel() == null) {
                return null;
            }
            long id = c.getLogicalChannel().getId().getValue();
            return this.gateway.loadChannelAcquisitionData(ctx, id);
        }
        return null;
    }

    @Override
    public Object loadInstrument(SecurityContext ctx, long instrumentID) throws DSOutOfServiceException, DSAccessException {
        if (instrumentID <= 0L) {
            return null;
        }
        return this.gateway.loadInstrument(ctx, instrumentID);
    }

    @Override
    public Object saveAcquisitionData(SecurityContext ctx, Object refObject) throws DSOutOfServiceException, DSAccessException {
        if (refObject instanceof ImageAcquisitionData) {
            ImageAcquisitionData data = (ImageAcquisitionData)refObject;
            ctx = this.gateway.checkContext(ctx, (DataObject)data);
            this.saveImageAcquisitionData(ctx, data);
            return null;
        }
        if (refObject instanceof ChannelData) {
            ChannelData data = (ChannelData)refObject;
            ctx = this.gateway.checkContext(ctx, (DataObject)data);
            this.saveChannelData(ctx, data);
        } else if (refObject instanceof ChannelAcquisitionData) {
            ChannelAcquisitionData data = (ChannelAcquisitionData)refObject;
            ctx = this.gateway.checkContext(ctx, (DataObject)data);
            this.saveChannelAcquisitionData(ctx, data);
        }
        return null;
    }

    @Override
    public Object archivedFile(SecurityContext ctx, FileAnnotationData fileAnnotation, File file, int index, DataObject linkTo) throws DSOutOfServiceException, DSAccessException {
        FileAnnotationI fa;
        if (file == null) {
            throw new IllegalArgumentException("No file to save.");
        }
        if (fileAnnotation == null) {
            return null;
        }
        ctx = this.gateway.checkContext(ctx, (DataObject)fileAnnotation);
        long id = fileAnnotation.getId();
        long originalID = fileAnnotation.getFileID();
        OriginalFile of = this.gateway.uploadFile(ctx, file, fileAnnotation.getServerFileMimetype(), originalID);
        String desc = fileAnnotation.getDescription();
        if (id < 0L) {
            fa = new FileAnnotationI();
            fa.setFile(of);
            if (desc != null) {
                fa.setDescription(rtypes.rstring((String)desc));
            }
            IObject object = this.gateway.createObject(ctx, (IObject)fa);
            id = object.getId().getValue();
        } else {
            fa = (FileAnnotation)this.gateway.findIObject(ctx, FileAnnotation.class.getName(), id);
            fa.setFile(of);
            if (desc != null) {
                fa.setDescription(rtypes.rstring((String)desc));
            }
            this.gateway.updateObject(ctx, (IObject)fa, new Parameters());
        }
        fa = (FileAnnotation)this.gateway.findIObject(ctx, FileAnnotation.class.getName(), id);
        FileAnnotationData data = (FileAnnotationData)PojoMapper.asDataObject((IObject)fa);
        if (of != null) {
            data.setContent((Object)of);
        }
        if (linkTo != null && linkTo.getId() > 0L) {
            this.annotate(ctx, linkTo, (AnnotationData)data);
        }
        return data;
    }

    @Override
    public Collection loadTags(SecurityContext ctx, Long id, boolean topLevel, long userID, long groupID) throws DSOutOfServiceException, DSAccessException {
        ParametersI po = new ParametersI();
        if (userID >= 0L) {
            po.exp(rtypes.rlong((long)userID));
        }
        if (groupID >= 0L) {
            po.grp(rtypes.rlong((long)groupID));
        }
        if (topLevel) {
            po.orphan();
            return this.gateway.loadTagSets(ctx, (Parameters)po);
        }
        return this.gateway.loadTags(ctx, id, (Parameters)po);
    }

    @Override
    public long countFileType(SecurityContext ctx, long userID, int fileType) throws DSOutOfServiceException, DSAccessException {
        ArrayList<String> include = new ArrayList<String>();
        ArrayList<String> exclude = new ArrayList<String>();
        switch (fileType) {
            case 2: {
                include.add("openmicroscopy.org/omero/movie");
                break;
            }
            case 4: {
                return this.gateway.countAnnotationsUsedNotOwned(ctx, TagAnnotationData.class, userID);
            }
            default: {
                exclude.add("openmicroscopy.org/omero/movie");
                exclude.add("openmicroscopy.org/omero/import/companionFile");
                exclude.add("openmicroscopy.org/omero/measurement");
                exclude.add("openmicroscopy.org/omero/experimenter/photo");
                exclude.add("openmicroscopy.org/omero/import/logFile");
            }
        }
        ParametersI po = new ParametersI();
        if (userID >= 0L) {
            po.exp(rtypes.rlong((long)userID));
        }
        return this.gateway.countSpecificAnnotation(ctx, FileAnnotationData.class, include, exclude, (Parameters)po);
    }

    @Override
    public Collection loadFiles(SecurityContext ctx, int fileType, long userID) throws DSOutOfServiceException, DSAccessException {
        ArrayList<String> include = new ArrayList<String>();
        ArrayList<String> exclude = new ArrayList<String>();
        ParametersI po = new ParametersI();
        if (userID >= 0L) {
            po.exp(rtypes.rlong((long)userID));
        }
        switch (fileType) {
            case 2: {
                include.add("openmicroscopy.org/omero/movie");
                break;
            }
            case 4: {
                return this.gateway.loadAnnotationsUsedNotOwned(ctx, TagAnnotationData.class, userID);
            }
            default: {
                exclude.add("openmicroscopy.org/omero/movie");
                exclude.add("openmicroscopy.org/omero/import/companionFile");
                exclude.add("openmicroscopy.org/omero/measurement");
                exclude.add("openmicroscopy.org/omero/experimenter/photo");
                exclude.add("openmicroscopy.org/omero/import/logFile");
            }
        }
        return this.gateway.loadSpecificAnnotation(ctx, FileAnnotationData.class, include, exclude, (Parameters)po);
    }

    @Override
    public DataObject loadAnnotation(SecurityContext ctx, long annotationID) throws DSOutOfServiceException, DSAccessException {
        Collection<DataObject> set = this.gateway.loadAnnotation(ctx, Arrays.asList(annotationID));
        if (set.size() != 1) {
            return null;
        }
        Iterator<DataObject> i = set.iterator();
        if (i.hasNext()) {
            return i.next();
        }
        return null;
    }

    @Override
    public List<TableResult> loadTabularData(SecurityContext ctx, TableParameters parameters, long userID) throws DSOutOfServiceException, DSAccessException {
        if (parameters == null) {
            throw new IllegalArgumentException("No parameters specified.");
        }
        return this.gateway.loadTabularData(ctx, parameters, userID);
    }

    @Override
    public List<DataObject> loadParentsOfAnnotations(SecurityContext ctx, long annotationId) throws DSOutOfServiceException, DSAccessException {
        ExperimenterData exp = (ExperimenterData)this.context.lookup("/current_user/details");
        long userId = exp.getId();
        return this.loadParentsOfAnnotations(ctx, annotationId, userId);
    }

    @Override
    public List<DataObject> loadParentsOfAnnotations(SecurityContext ctx, long annotationId, long userId) throws DSOutOfServiceException, DSAccessException {
        if (annotationId < 0L) {
            throw new IllegalArgumentException("Annotation id not valid.");
        }
        List links = this.gateway.findLinks(ctx, FileAnnotation.class, annotationId, userId);
        ArrayList<DataObject> nodes = new ArrayList<DataObject>();
        if (links != null) {
            for (Object o : links) {
                if (o instanceof ProjectAnnotationLink) {
                    nodes.add(PojoMapper.asDataObject((IObject)((ProjectAnnotationLink)o).getParent()));
                    continue;
                }
                if (o instanceof DatasetAnnotationLink) {
                    nodes.add(PojoMapper.asDataObject((IObject)((DatasetAnnotationLink)o).getParent()));
                    continue;
                }
                if (o instanceof ImageAnnotationLink) {
                    nodes.add(PojoMapper.asDataObject((IObject)((ImageAnnotationLink)o).getParent()));
                    continue;
                }
                if (o instanceof PlateAnnotationLink) {
                    nodes.add(PojoMapper.asDataObject((IObject)((PlateAnnotationLink)o).getParent()));
                    continue;
                }
                if (o instanceof ScreenAnnotationLink) {
                    nodes.add(PojoMapper.asDataObject((IObject)((ScreenAnnotationLink)o).getParent()));
                    continue;
                }
                if (o instanceof WellAnnotationLink) {
                    nodes.add(PojoMapper.asDataObject((IObject)((WellAnnotationLink)o).getParent()));
                    continue;
                }
                if (!(o instanceof PlateAcquisitionAnnotationLink)) continue;
                nodes.add(PojoMapper.asDataObject((IObject)((PlateAcquisitionAnnotationLink)o).getParent()));
            }
        }
        return nodes;
    }

    @Override
    public List<Long> saveChannelData(SecurityContext ctx, List<ChannelData> channels, List<DataObject> objects) throws DSOutOfServiceException, DSAccessException {
        ArrayList<Long> images = new ArrayList<Long>();
        if (channels == null || channels.size() == 0) {
            return images;
        }
        if (objects == null || objects.size() == 0) {
            return images;
        }
        List<IObject> pixels = this.gateway.getPixels(ctx, objects);
        if (pixels == null) {
            return images;
        }
        Iterator<IObject> i = pixels.iterator();
        int n = channels.size();
        ArrayList<IObject> toUpdate = new ArrayList<IObject>();
        while (i.hasNext()) {
            Pixels p = (Pixels)i.next();
            int sizeC = p.getSizeC().getValue();
            if (sizeC != n) continue;
            List l = p.copyChannels();
            this.updateChannels(channels, l);
            toUpdate.addAll(l);
            images.add(p.getImage().getId().getValue());
        }
        this.gateway.saveAndReturnObject(ctx, toUpdate, null, null);
        return images;
    }

    @Override
    public List<ChannelData> getChannelsMetadata(SecurityContext ctx, long pixelsID) throws DSOutOfServiceException, DSAccessException {
        Pixels pixels = this.gateway.getPixels(ctx, pixelsID);
        if (pixels == null) {
            return new ArrayList<ChannelData>();
        }
        List l = pixels.copyChannels();
        if (l == null) {
            return new ArrayList<ChannelData>();
        }
        Iterator i = l.iterator();
        ArrayList<ChannelData> m = new ArrayList<ChannelData>(l.size());
        int index = 0;
        while (i.hasNext()) {
            m.add(new ChannelData(index, (Channel)i.next()));
            ++index;
        }
        return m;
    }

    @Override
    public Map<Long, Collection<AnnotationData>> loadAnnotations(SecurityContext ctx, Class<? extends DataObject> rootType, List<Long> rootIDs, Class<?> annotationType, List<String> nsInclude, List<String> nsExclude) throws DSOutOfServiceException, DSAccessException {
        if (rootType == null || CollectionUtils.isEmpty(rootIDs)) {
            throw new IllegalArgumentException("No node specified");
        }
        if (annotationType == null) {
            throw new IllegalArgumentException("No annotation type specified");
        }
        if (nsExclude == null) {
            nsExclude = new ArrayList<String>();
        }
        nsExclude.add("openmicroscopy.org/omero/import/logFile");
        return this.gateway.loadSpecifiedAnnotationsLinkedTo(ctx, rootType, rootIDs, annotationType, nsInclude, nsExclude, new Parameters());
    }

    @Override
    public RequestCallback downloadMetadataFile(SecurityContext ctx, File file, long id) throws DSOutOfServiceException, DSAccessException, ProcessException {
        if (id < 0L) {
            return null;
        }
        OriginalMetadataRequest cmd = new OriginalMetadataRequest();
        cmd.imageId = id;
        return this.gateway.submit(Arrays.asList(cmd), ctx);
    }

    @Override
    public Map<Long, List<IObject>> loadLogFiles(SecurityContext ctx, Class<? extends DataObject> rootType, List<Long> rootIDs) throws DSOutOfServiceException, DSAccessException {
        if (rootType == null || CollectionUtils.isEmpty(rootIDs)) {
            throw new IllegalArgumentException("No node specified");
        }
        return this.gateway.loadLogFiles(ctx, rootType, rootIDs);
    }

    @Override
    public void saveAnnotationData(SecurityContext ctx, Map<DataObject, List<AnnotationData>> toAdd, Map<DataObject, List<AnnotationData>> toRemove, long userID) throws DSOutOfServiceException, DSAccessException {
        List<AnnotationData> annotations;
        if (toAdd != null && toAdd.size() > 0) {
            for (Map.Entry<DataObject, List<AnnotationData>> e : toAdd.entrySet()) {
                annotations = this.prepareAnnotationToAdd(ctx, e.getValue());
                if (annotations.size() <= 0) continue;
                for (AnnotationData ann : annotations) {
                    if (ann == null) continue;
                    this.linkAnnotation(ctx, e.getKey(), ann);
                }
            }
        }
        if (MapUtils.isNotEmpty(toRemove)) {
            ArrayList<IObject> toDelete = new ArrayList<IObject>();
            for (Map.Entry<DataObject, List<AnnotationData>> e : toRemove.entrySet()) {
                annotations = e.getValue();
                for (AnnotationData ann : annotations) {
                    if (ann == null) continue;
                    toDelete.addAll(this.getRemoveAnnotation(ctx, ann, e.getKey()));
                }
            }
            if (!toDelete.isEmpty()) {
                try {
                    this.gateway.deleteObjects(ctx, toDelete);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

