/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.login;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import omero.gateway.model.GroupData;

public class UserCredentials {
    public static final int HIGH = 0;
    public static final int MEDIUM = 1;
    public static final int LOW = 2;
    private String userName;
    private String password;
    private String hostName;
    private int speedLevel;
    private int port;
    private long group;
    private boolean encrypted;
    private Boolean administrator;
    private Boolean owner;
    private Boolean active;
    private Map<GroupData, Boolean> groupsOwner;

    private void checkSpeedLevel(int level) {
        switch (level) {
            case 0: 
            case 1: 
            case 2: {
                return;
            }
        }
        throw new IllegalArgumentException("Speed level not valid.");
    }

    public UserCredentials(String userName, String password, String hostName, int speedLevel) {
        this.checkSpeedLevel(speedLevel);
        this.speedLevel = speedLevel;
        this.userName = userName;
        this.password = password;
        this.hostName = hostName;
        this.port = -1;
        this.group = -1L;
        this.owner = null;
        this.administrator = null;
    }

    public UserCredentials(String userName, String password) {
        this(userName, password, "", 0);
    }

    public void setGroup(long group) {
        this.group = group;
    }

    public long getGroup() {
        return this.group;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public void resetPassword(String password) {
        if (password == null || password.trim().length() == 0) {
            throw new IllegalArgumentException("Please specify a password.");
        }
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public int getSpeedLevel() {
        return this.speedLevel;
    }

    public void setAdministrator(Boolean administrator) {
        this.administrator = administrator;
    }

    public Boolean isAdministrator() {
        return this.administrator;
    }

    public void setOwner(Boolean owner) {
        this.owner = owner;
    }

    public Boolean isOwner() {
        return this.owner;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Boolean isActive() {
        return this.active;
    }

    public void setGroupsOwner(Map<GroupData, Boolean> map) {
        this.groupsOwner = map;
    }

    public Map<GroupData, Boolean> getGroupsOwner() {
        return this.groupsOwner;
    }

    public Boolean isGroupOwner(GroupData group) {
        if (this.groupsOwner == null) {
            return null;
        }
        return this.groupsOwner.get(group);
    }

    public GroupData getGroupToHandle() {
        if (this.groupsOwner == null || this.groupsOwner.size() == 0) {
            return null;
        }
        Set<GroupData> groups = this.groupsOwner.keySet();
        Iterator<GroupData> i = groups.iterator();
        if (i.hasNext()) {
            return i.next();
        }
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("User Name: ");
        buf.append(this.userName);
        buf.append(" -- Password: ");
        if (this.password != null) {
            for (int i = 0; i < this.password.length(); ++i) {
                buf.append('*');
            }
        }
        return buf.toString();
    }
}

