/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import omero.RBool;
import omero.RDouble;
import omero.RFloat;
import omero.RInt;
import omero.RList;
import omero.RLong;
import omero.RMap;
import omero.RObject;
import omero.RString;
import omero.RType;
import omero.gateway.model.DataObject;
import omero.gateway.util.PojoMapper;
import omero.grid.Param;
import omero.model.IObject;
import omero.rtypes;
import org.apache.commons.collections.CollectionUtils;

public class ParamData {
    private Param param;
    private List<Object> values;
    private Object defaultValue;
    private Object minValue;
    private Object maxValue;
    private Class<?> type;
    private Object valueToPass;

    private void initialize() {
        List l;
        Number n;
        Object o;
        this.type = null;
        this.minValue = null;
        this.maxValue = null;
        RType t = this.param.prototype;
        this.defaultValue = o = ParamData.convertRType(t);
        if (o instanceof Long) {
            this.type = Long.class;
        } else if (o instanceof Integer) {
            this.type = Integer.class;
        } else if (o instanceof String) {
            this.type = String.class;
        } else if (o instanceof Boolean) {
            this.type = Boolean.class;
        } else if (o instanceof Float) {
            this.type = Float.class;
        } else if (o instanceof Double) {
            this.type = Double.class;
        } else if (o instanceof List) {
            this.type = List.class;
        } else if (o instanceof Map) {
            this.type = Map.class;
        } else if (o instanceof DataObject) {
            this.type = DataObject.class;
        }
        boolean set = false;
        Object value = ParamData.convertRType(this.param.min);
        if (value instanceof Number) {
            this.minValue = value;
            set = true;
            if (this.defaultValue == null) {
                this.defaultValue = this.minValue;
            } else {
                n = (Number)this.defaultValue;
                if (n.doubleValue() < ((Number)this.minValue).doubleValue()) {
                    this.defaultValue = this.minValue;
                }
            }
        }
        if ((value = ParamData.convertRType(this.param.max)) instanceof Number) {
            this.maxValue = value;
            if (!set) {
                if (this.defaultValue != null) {
                    n = (Number)this.defaultValue;
                    if (n.doubleValue() > ((Number)this.maxValue).doubleValue()) {
                        this.defaultValue = this.maxValue;
                    }
                } else {
                    this.defaultValue = this.maxValue;
                }
            }
        }
        if (this.defaultValue instanceof List && (l = (List)this.defaultValue).size() > 0) {
            this.defaultValue = l.get(0);
        }
    }

    private static RType convertBasicValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return rtypes.rbool((boolean)((Boolean)value));
        }
        if (value instanceof String) {
            String v = (String)value;
            if (v.length() == 0) {
                return null;
            }
            return rtypes.rstring((String)v);
        }
        if (value instanceof Long) {
            return rtypes.rlong((long)((Long)value));
        }
        if (value instanceof Integer) {
            return rtypes.rint((int)((Integer)value));
        }
        if (value instanceof Float) {
            return rtypes.rfloat((float)((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return rtypes.rdouble((double)((Double)value));
        }
        if (value instanceof DataObject) {
            IObject o = ((DataObject)value).asIObject();
            return rtypes.robject((IObject)o);
        }
        return null;
    }

    private static Object convertBasicRType(RType value) {
        if (value instanceof RBool) {
            return ((RBool)value).getValue();
        }
        if (value instanceof RString) {
            return ((RString)value).getValue();
        }
        if (value instanceof RLong) {
            return ((RLong)value).getValue();
        }
        if (value instanceof RInt) {
            return ((RInt)value).getValue();
        }
        if (value instanceof RFloat) {
            return Float.valueOf(((RFloat)value).getValue());
        }
        if (value instanceof RDouble) {
            return ((RDouble)value).getValue();
        }
        if (value instanceof RObject) {
            IObject o = ((RObject)value).getValue();
            DataObject r = PojoMapper.asDataObject((IObject)o);
            if (r != null) {
                return r;
            }
            return o;
        }
        return null;
    }

    public ParamData(Param param) {
        this.param = param;
        this.initialize();
    }

    public String getGrouping() {
        String grouping = "";
        if (this.param.grouping != null) {
            grouping = this.param.grouping.trim();
        }
        return grouping;
    }

    public String getParent() {
        String v = this.getGrouping();
        if (v.length() == 0) {
            return "";
        }
        int index = v.lastIndexOf(".");
        if (index >= 0) {
            return v.substring(0, index);
        }
        return "";
    }

    public boolean isOptional() {
        return this.param.optional;
    }

    public String getDescription() {
        return this.param.description;
    }

    public Class<?> getPrototype() {
        return this.type;
    }

    public Class<?> getKeyType() {
        if (List.class.equals(this.type)) {
            Object o;
            List l = ((RList)this.param.prototype).getValue();
            if (l.size() > 0 && ((o = ParamData.convertBasicRType((RType)l.get(0))) instanceof Long || o instanceof Integer || o instanceof Double || o instanceof Float)) {
                return o.getClass();
            }
            return String.class;
        }
        if (Map.class.equals(this.type)) {
            return String.class;
        }
        return null;
    }

    public Class<?> getValueType() {
        if (List.class.equals(this.type)) {
            return this.getKeyType();
        }
        if (Map.class.equals(this.type)) {
            Map l = ((RMap)this.param.prototype).getValue();
            if (l.size() > 0) {
                Map.Entry entry;
                Iterator i = l.entrySet().iterator();
                Object o = null;
                while (i.hasNext() && (o = ParamData.convertBasicRType((RType)(entry = i.next()).getValue())) == null) {
                }
                if (o instanceof Long || o instanceof Integer || o instanceof Double || o instanceof Float) {
                    return o.getClass();
                }
            }
            return String.class;
        }
        return null;
    }

    public List<Object> getValues() {
        if (this.values != null) {
            return this.values;
        }
        RList list = this.param.values;
        if (list == null) {
            return null;
        }
        List l = list.getValue();
        if (CollectionUtils.isEmpty((Collection)l)) {
            return null;
        }
        this.values = new ArrayList<Object>();
        Iterator i = l.iterator();
        while (i.hasNext()) {
            Object value = ParamData.convertRType((RType)i.next());
            if (value == null) continue;
            this.values.add(value);
        }
        return this.values;
    }

    public Number getMaxValue() {
        if (this.maxValue == null) {
            return null;
        }
        return (Number)this.maxValue;
    }

    public Number getMinValue() {
        if (this.minValue == null) {
            return null;
        }
        return (Number)this.minValue;
    }

    public Object getDefaultValue() {
        if (this.param.useDefault) {
            return this.defaultValue;
        }
        return null;
    }

    public void setValueToPass(Object valueToPass) {
        if (valueToPass == null) {
            valueToPass = this.getDefaultValue();
        }
        this.valueToPass = valueToPass;
    }

    public RType getValueToPassAsRType() {
        if (this.valueToPass instanceof Boolean || this.valueToPass instanceof String || this.valueToPass instanceof Long || this.valueToPass instanceof Integer || this.valueToPass instanceof Float || this.valueToPass instanceof Double) {
            return ParamData.convertBasicValue(this.valueToPass);
        }
        if (this.valueToPass instanceof List) {
            ArrayList<RType> l = new ArrayList<RType>();
            List list = (List)this.valueToPass;
            Iterator i = list.iterator();
            while (i.hasNext()) {
                RType key = ParamData.convertBasicValue(i.next());
                if (key == null) continue;
                l.add(key);
            }
            if (l.size() == 0) {
                return null;
            }
            return rtypes.rlist(l);
        }
        if (this.valueToPass instanceof Map) {
            HashMap m = new HashMap();
            Map map = (Map)this.valueToPass;
            for (Map.Entry entry : map.entrySet()) {
                RType type = ParamData.convertBasicValue(entry.getValue());
                if (type == null) continue;
                m.put(entry.getKey(), type);
            }
            if (m.size() == 0) {
                return null;
            }
            return rtypes.rmap(m);
        }
        return null;
    }

    public static Object convertRType(RType value) {
        if (value instanceof RBool || value instanceof RString || value instanceof RLong || value instanceof RInt || value instanceof RFloat || value instanceof RObject || value instanceof RDouble) {
            return ParamData.convertBasicRType(value);
        }
        if (value instanceof RList) {
            List list = ((RList)value).getValue();
            ArrayList<Object> l = new ArrayList<Object>();
            Iterator i = list.iterator();
            while (i.hasNext()) {
                Object o = ParamData.convertRType((RType)i.next());
                if (o == null) continue;
                l.add(o);
            }
            return l;
        }
        if (value instanceof RMap) {
            Map map = ((RMap)value).getValue();
            HashMap r = new HashMap();
            for (Map.Entry entry : map.entrySet()) {
                Object v = ParamData.convertRType((RType)entry.getValue());
                if (v == null) continue;
                r.put(entry.getKey(), v);
            }
            return r;
        }
        return null;
    }
}

