/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.model;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import omero.constants.projection.ProjectionType;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import org.openmicroscopy.shoola.env.data.OmeroImageService;

public class ProjectionParam {
    public static final int MAXIMUM_INTENSITY = OmeroImageService.MAX_INTENSITY;
    public static final int MEAN_INTENSITY = OmeroImageService.MEAN_INTENSITY;
    public static final int SUM_INTENSITY = OmeroImageService.SUM_INTENSITY;
    public static final String INT_8 = "int8";
    public static final String UINT_8 = "uint8";
    public static final String INT_16 = "int16";
    public static final String UINT_16 = "uint16";
    public static final String INT_32 = "int32";
    public static final String UINT_32 = "uint32";
    public static final String FLOAT = "float";
    public static final String DOUBLE = "double";
    public static final Map<Integer, String> PROJECTIONS = new LinkedHashMap<Integer, String>();
    private int startT;
    private int endT;
    private int startZ;
    private int endZ;
    private int stepping;
    private int algorithm;
    private List<DatasetData> datasets;
    private String name;
    private String description;
    private String pixelsType;
    private List<Integer> channels;
    private long pixelsID;
    private DataObject parent;

    static void checkProjectionAlgorithm(int value) {
        if (value == MAXIMUM_INTENSITY) {
            return;
        }
        if (value == MEAN_INTENSITY) {
            return;
        }
        if (value == SUM_INTENSITY) {
            return;
        }
        throw new IllegalArgumentException("Algorithm not valid");
    }

    public ProjectionParam(long pixelsID, int startZ, int endZ, int stepping, int algorithm, int startT, int endT, List<Integer> channels, String name) {
        if (pixelsID < 0L) {
            throw new IllegalArgumentException("Pixels ID not valid.");
        }
        if (startZ > endZ) {
            throw new IllegalArgumentException("Optical Interval not valid.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Image name cannot be null.");
        }
        ProjectionParam.checkProjectionAlgorithm(algorithm);
        this.algorithm = algorithm;
        if (stepping < 1) {
            stepping = 1;
        }
        this.startZ = startZ;
        this.endZ = endZ;
        this.startT = startT;
        this.endT = endT;
        this.stepping = stepping;
        this.name = name;
        this.pixelsID = pixelsID;
        this.channels = channels;
        this.pixelsType = null;
    }

    public ProjectionParam(long pixelsID, int startZ, int endZ, int stepping, int algorithm) {
        this(pixelsID, startZ, endZ, stepping, algorithm, -1, -1, null, "");
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getStartT() {
        return this.startT;
    }

    public int getEndT() {
        return this.endT;
    }

    public int getStartZ() {
        return this.startZ;
    }

    public int getEndZ() {
        return this.endZ;
    }

    public int getAlgorithm() {
        return this.algorithm;
    }

    public int getStepping() {
        return this.stepping;
    }

    public String getName() {
        return this.name;
    }

    public long getPixelsID() {
        return this.pixelsID;
    }

    public String getPixelsType() {
        return this.pixelsType;
    }

    public List<DatasetData> getDatasets() {
        return this.datasets;
    }

    public List<Integer> getChannels() {
        return this.channels;
    }

    public void setDatasets(List<DatasetData> datasets) {
        this.datasets = datasets;
    }

    public void setDatasetParent(DataObject parent) {
        this.parent = parent;
    }

    public DataObject getDatasetParent() {
        return this.parent;
    }

    public String getDescription() {
        return this.description;
    }

    public void setChannels(List<Integer> channels) {
        this.channels = channels;
    }

    public void setPixelsType(String type) {
        this.pixelsType = type;
    }

    public ProjectionType getProjectionType() {
        return ProjectionParam.convertType(this.getAlgorithm());
    }

    public static ProjectionType convertType(int type) {
        if (ProjectionType.MAXIMUMINTENSITY.ordinal() == type) {
            return ProjectionType.MAXIMUMINTENSITY;
        }
        if (ProjectionType.MEANINTENSITY.ordinal() == type) {
            return ProjectionType.MEANINTENSITY;
        }
        if (ProjectionType.SUMINTENSITY.ordinal() == type) {
            return ProjectionType.SUMINTENSITY;
        }
        return null;
    }

    static {
        PROJECTIONS.put(MAXIMUM_INTENSITY, "Maximum");
        PROJECTIONS.put(MEAN_INTENSITY, "Mean");
    }
}

