/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import com.google.common.io.Files;
import ij.IJ;
import ij.ImagePlus;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import omero.gateway.SecurityContext;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.ImageData;
import omero.gateway.model.ROIData;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.OmeroMetadataService;
import org.openmicroscopy.shoola.env.data.model.FileObject;
import org.openmicroscopy.shoola.env.data.model.ResultsObject;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.roi.io.ROIReader;

public class ResultsSaver
extends BatchCallTree {
    private SecurityContext ctx;
    private ResultsObject results;
    private OmeroImageService svc;
    private OmeroMetadataService msvc;
    private Object result;

    private File createFile(ImagePlus img, String fileName) {
        String name;
        File dir = Files.createTempDir();
        if (CommonsLangUtils.isBlank(fileName)) {
            name = "ImageJ-" + FilenameUtils.getBaseName((String)FilenameUtils.removeExtension((String)img.getTitle())) + "-Results-";
            name = name + new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        } else {
            name = FilenameUtils.removeExtension((String)fileName);
        }
        name = name + ".csv";
        try {
            File f = new File(dir, name);
            ROIReader reader = new ROIReader();
            if (!reader.readResults(f)) {
                f.delete();
                dir.delete();
                return null;
            }
            dir.deleteOnExit();
            return f;
        }
        catch (Exception e) {
            this.context.getLogger().error((Object)this, "Cannot create file to save results" + e.getMessage());
            return null;
        }
    }

    private void saveROIandTableResults() {
        List<Object> objects = this.results.getRefObjects();
        Iterator<Object> i = objects.iterator();
        ROIReader reader = new ROIReader();
        ExperimenterData exp = this.ctx.getExperimenterData();
        final long expID = exp.getId();
        while (i.hasNext()) {
            FileObject file;
            long id;
            Object o = i.next();
            if (!(o instanceof FileObject) || (id = (file = (FileObject)o).getOMEROID()) < 0L) continue;
            if (file.getGroupID() > 0L) {
                this.ctx = new SecurityContext(file.getGroupID());
            }
            ImagePlus img = (ImagePlus)file.getFile();
            List<ROIData> rois = reader.readImageJROIFromSources(id, img);
            File f = this.createFile(img, this.results.getTableName());
            String description = "Save ROIs Results";
            final long imageID = id;
            final File fi = f;
            final List<ROIData> list = rois;
            this.add(new BatchCall("Save ROIs Results"){

                @Override
                public void doCall() {
                    try {
                        if (CollectionUtils.isNotEmpty((Collection)list)) {
                            ResultsSaver.this.svc.saveROI(ResultsSaver.this.ctx, imageID, expID, list);
                        }
                        if (fi != null) {
                            FileAnnotationData fa = new FileAnnotationData(fi);
                            ResultsSaver.this.result = ResultsSaver.this.msvc.annotate(ResultsSaver.this.ctx, ImageData.class, imageID, (AnnotationData)fa);
                        }
                    }
                    catch (Exception e) {
                        IJ.log((String)("error:" + e.toString()));
                        ResultsSaver.this.context.getLogger().error((Object)this, "Cannot Save the ROIs results: " + e.getMessage());
                    }
                    finally {
                        if (fi != null) {
                            fi.delete();
                        }
                    }
                }
            });
        }
    }

    private void saveTableResults() {
        List<Object> objects = this.results.getRefObjects();
        for (Object o : objects) {
            ImagePlus img;
            File f;
            FileObject file;
            long id;
            if (!(o instanceof FileObject) || (id = (file = (FileObject)o).getOMEROID()) < 0L) continue;
            if (file.getGroupID() > 0L) {
                this.ctx = new SecurityContext(file.getGroupID());
            }
            if ((f = this.createFile(img = (ImagePlus)file.getFile(), this.results.getTableName())) == null) continue;
            String description = "Save Table Results";
            final long imageID = id;
            final File fi = f;
            this.add(new BatchCall("Save Table Results"){

                @Override
                public void doCall() {
                    try {
                        FileAnnotationData fa = new FileAnnotationData(fi);
                        ResultsSaver.this.result = ResultsSaver.this.msvc.annotate(ResultsSaver.this.ctx, ImageData.class, imageID, (AnnotationData)fa);
                    }
                    catch (Exception e) {
                        ResultsSaver.this.context.getLogger().error((Object)this, "Cannot Save the ROIs results: " + e.getMessage());
                    }
                    finally {
                        fi.delete();
                    }
                }
            });
        }
    }

    private void saveROI() {
        List<Object> objects = this.results.getRefObjects();
        Iterator<Object> i = objects.iterator();
        ROIReader reader = new ROIReader();
        ExperimenterData exp = this.ctx.getExperimenterData();
        final long expID = exp.getId();
        while (i.hasNext()) {
            ImagePlus img;
            List<ROIData> rois;
            FileObject file;
            long id;
            Object o = i.next();
            if (!(o instanceof FileObject) || (id = (file = (FileObject)o).getOMEROID()) < 0L) continue;
            if (file.getGroupID() > 0L) {
                this.ctx = new SecurityContext(file.getGroupID());
            }
            if (!CollectionUtils.isNotEmpty(rois = reader.readImageJROIFromSources(id, img = (ImagePlus)file.getFile()))) continue;
            String description = "Save ROIs";
            final long imageID = id;
            final List<ROIData> list = rois;
            this.add(new BatchCall("Save ROIs"){

                @Override
                public void doCall() {
                    try {
                        ResultsSaver.this.result = ResultsSaver.this.svc.saveROI(ResultsSaver.this.ctx, imageID, expID, list);
                    }
                    catch (Exception e) {
                        ResultsSaver.this.context.getLogger().error((Object)this, "Cannot Save ImageJ rois: " + e.getMessage());
                    }
                }
            });
        }
    }

    public ResultsSaver(SecurityContext ctx, ResultsObject results) {
        this.ctx = ctx;
        if (results == null) {
            throw new IllegalArgumentException("No results to save.");
        }
        this.results = results;
        this.svc = this.context.getImageService();
        this.msvc = this.context.getMetadataService();
    }

    @Override
    protected void buildTree() {
        List<Object> objects = this.results.getRefObjects();
        if (CollectionUtils.isNotEmpty(objects)) {
            if (this.results.isROI()) {
                if (this.results.isTable()) {
                    this.saveROIandTableResults();
                } else {
                    this.saveROI();
                }
            } else if (this.results.isTable()) {
                this.saveTableResults();
            }
        }
    }

    @Override
    protected Object getPartialResult() {
        return this.result;
    }

    @Override
    protected Object getResult() {
        return null;
    }
}

