/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.rnd;

import java.awt.Color;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import omero.model.RenderingDef;
import org.openmicroscopy.shoola.env.rnd.ChannelBindingsProxy;

public class RndProxyDef {
    private int defaultZ;
    private int defaultT;
    private int bitResolution;
    private int cdStart;
    private int cdEnd;
    private String colorModel;
    private Map<Integer, ChannelBindingsProxy> channels;
    private boolean typeSigned;
    private double compression;
    private Timestamp lastModified;
    private String name;
    private RenderingDef data;

    RndProxyDef(RenderingDef data) {
        this.data = data;
        this.compression = 1.0;
        this.channels = new HashMap<Integer, ChannelBindingsProxy>();
        this.name = "";
    }

    void setName(String name) {
        this.name = name;
    }

    String getName() {
        return this.name;
    }

    void setLastModified(Timestamp lastModified) {
        this.lastModified = lastModified;
    }

    int getNumberOfChannels() {
        return this.channels.size();
    }

    void setChannel(int index, ChannelBindingsProxy c) {
        this.channels.put(index, c);
    }

    ChannelBindingsProxy getChannel(int index) {
        return this.channels.get(index);
    }

    void setDefaultZ(int z) {
        this.defaultZ = z;
    }

    void setDefaultT(int t) {
        this.defaultT = t;
    }

    int getBitResolution() {
        return this.bitResolution;
    }

    void setBitResolution(int bitResolution) {
        this.bitResolution = bitResolution;
    }

    int getCdEnd() {
        return this.cdEnd;
    }

    void setCodomain(int cdStart, int cdEnd) {
        this.cdStart = cdStart;
        this.cdEnd = cdEnd;
    }

    int getCdStart() {
        return this.cdStart;
    }

    String getColorModel() {
        return this.colorModel;
    }

    void setColorModel(String colorModel) {
        this.colorModel = colorModel;
    }

    void setTypeSigned(boolean b) {
        this.typeSigned = b;
    }

    boolean isTypeSigned() {
        return this.typeSigned;
    }

    double getCompression() {
        return this.compression;
    }

    void setCompression(double compression) {
        if (compression <= 0.0) {
            compression = 0.1;
        } else if (compression > 1.0) {
            compression = 1.0;
        }
        this.compression = compression;
    }

    RndProxyDef copy() {
        RndProxyDef copy = new RndProxyDef(this.data);
        copy.setLastModified(this.getLastModified());
        copy.setCompression(this.getCompression());
        copy.setTypeSigned(this.isTypeSigned());
        copy.setDefaultZ(this.getDefaultZ());
        copy.setDefaultT(this.getDefaultT());
        copy.setBitResolution(this.getBitResolution());
        copy.setColorModel(this.getColorModel());
        copy.setCodomain(this.getCdStart(), this.getCdEnd());
        for (int index : this.channels.keySet()) {
            copy.setChannel(index, this.getChannel(index).copy());
        }
        return copy;
    }

    public int getDefaultT() {
        return this.defaultT;
    }

    public int getDefaultZ() {
        return this.defaultZ;
    }

    public Color getChannelColor(int index) {
        ChannelBindingsProxy channel = this.getChannel(index);
        if (channel == null) {
            return null;
        }
        int[] rgba = channel.getRGBA();
        return new Color(rgba[0], rgba[1], rgba[2], rgba[3]);
    }

    public String getLookupTable(int index) {
        ChannelBindingsProxy channel = this.getChannel(index);
        if (channel == null) {
            return null;
        }
        return channel.getLookupTable();
    }

    public Timestamp getLastModified() {
        return this.lastModified;
    }

    public long getOwnerID() {
        return this.data.getDetails().getOwner().getId().getValue();
    }

    public long getDataID() {
        return this.data.getId().getValue();
    }

    public RenderingDef getData() {
        return this.data;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName() + "\n");
        for (int index : this.channels.keySet()) {
            ChannelBindingsProxy channel = this.getChannel(index);
            int[] rgba = channel.getRGBA();
            if (channel.isActive()) {
                sb.append("* ");
            } else {
                sb.append(" ");
            }
            sb.append("[" + rgba[0] + "," + rgba[1] + "," + rgba[2] + "," + rgba[3] + "] ");
            sb.append(" start=" + channel.getInputStart() + ", end=" + channel.getInputEnd() + " \n");
        }
        return sb.toString();
    }
}

