/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import omero.gateway.model.ChannelData;
import org.apache.commons.lang.StringUtils;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.util.ui.ColourIcon;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ChannelDataListRenderer
extends JLabel
implements ListCellRenderer {
    private RenderingControl rnd;

    public ChannelDataListRenderer(RenderingControl rnd) {
        this.rnd = rnd;
        this.setOpaque(true);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (!(value instanceof ChannelData)) {
            this.setText("");
            this.setIcon(null);
            return this;
        }
        ChannelData ch = (ChannelData)value;
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        String lut = this.rnd.getLookupTable(ch.getIndex());
        Color col = this.rnd.getRGBA(ch.getIndex());
        ColourIcon icon = new ColourIcon(14, 14);
        if (StringUtils.isNotBlank((String)lut)) {
            icon.setLookupTable(lut);
        } else {
            icon.setColour(col);
        }
        this.setIcon(icon);
        this.setText(UIUtilities.formatPartialName2(ch.getName(), 10));
        return this;
    }
}

