/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.util.List;
import omero.gateway.SecurityContext;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.data.views.ProcessCallback;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;

public class FigureCreator
extends UserNotifierLoader {
    private CallHandle handle;
    private Object param;
    private List<Long> ids;
    private Class type;
    private ProcessCallback callBack;

    @Override
    protected void onException(String message, Throwable ex) {
        this.activity.notifyError("Unable to create figure", message, ex);
    }

    public FigureCreator(UserNotifier viewer, Registry registry, SecurityContext ctx, Object param, List<Long> ids, Class type, ActivityComponent activity) {
        super(viewer, registry, ctx, activity);
        if (ids == null || ids.size() == 0) {
            throw new IllegalArgumentException("Objects not valid.");
        }
        if (param == null) {
            throw new IllegalArgumentException("Parameters cannot be null.");
        }
        this.param = param;
        this.ids = ids;
        this.type = type;
    }

    @Override
    public void load() {
        this.handle = this.ivView.createFigure(this.ctx, this.ids, this.type, this.param, this);
    }

    @Override
    public void cancel() {
        try {
            if (this.callBack != null) {
                this.callBack.cancel();
                this.activity.onActivityCancelled();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.handle.cancel();
    }

    @Override
    public void update(DSCallFeedbackEvent fe) {
        Object o = fe.getPartialResult();
        if (o != null) {
            if (o instanceof Boolean) {
                Boolean b = (Boolean)o;
                if (!b.booleanValue()) {
                    this.onException("Unable to start the script.", null);
                }
            } else {
                this.callBack = (ProcessCallback)o;
                this.callBack.setAdapter(this);
                this.activity.onCallBackSet();
            }
        }
    }

    @Override
    public void handleResult(Object result) {
        if (result instanceof Boolean) {
            Boolean b = (Boolean)result;
            if (!b.booleanValue()) {
                this.onException("Unable to start the script.", null);
            }
        } else if (!(result instanceof Boolean)) {
            this.activity.endActivity(result);
        }
    }
}

