/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.io.File;
import omero.cmd.OriginalMetadataResponse;
import omero.gateway.SecurityContext;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.RequestCallback;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.util.OriginalMetadataParser;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;

public class FileLoader
extends UserNotifierLoader {
    public static final int ORIGINAL_FILE = 0;
    public static final int FILE_ANNOTATION = 1;
    public static final int METADATA_FROM_IMAGE = 2;
    private long id;
    private File file;
    private boolean toLoad;
    private int index;
    private CallHandle handle;

    @Override
    protected void onException(String message, Throwable ex) {
        this.activity.notifyError("Unable to download the file", message, ex);
    }

    FileLoader(UserNotifier viewer, Registry reg, SecurityContext ctx, File file, long id, boolean toLoad, ActivityComponent activity) {
        super(viewer, reg, ctx, activity);
        this.file = file;
        this.id = id;
        this.toLoad = toLoad;
        this.index = -1;
    }

    FileLoader(UserNotifier viewer, Registry reg, SecurityContext ctx, File file, long fileID, int index, boolean toLoad, ActivityComponent activity) {
        super(viewer, reg, ctx, activity);
        this.file = file;
        this.id = fileID;
        this.toLoad = toLoad;
        this.index = index;
    }

    @Override
    public void load() {
        if (this.toLoad) {
            switch (this.index) {
                case 0: 
                case 1: 
                case 2: {
                    this.handle = this.mhView.loadFile(this.ctx, this.file, this.id, this.index, this);
                    break;
                }
                default: {
                    this.handle = this.mhView.loadFile(this.ctx, this.file, this.id, this);
                    break;
                }
            }
        } else {
            this.handleResult(this.file);
        }
    }

    @Override
    public void cancel() {
        if (this.handle != null) {
            this.handle.cancel();
        }
        this.file.delete();
    }

    @Override
    public void handleCancellation() {
        String info = "The data retrieval has been cancelled.";
        this.registry.getLogger().info((Object)this, info);
    }

    @Override
    public void handleNullResult() {
        if (this.index != 2 && this.activity != null) {
            this.activity.notifyError("File no longer exists", "The file you wish to download no longer exists.", null);
        }
    }

    @Override
    public void update(DSCallFeedbackEvent fe) {
        Object o = fe.getPartialResult();
        if (o != null) {
            if (o instanceof Boolean) {
                this.handleNullResult();
            } else {
                RequestCallback callBack = (RequestCallback)((Object)o);
                callBack.setAdapter(this);
            }
        }
    }

    @Override
    public void handleResult(Object result) {
        if (result == null) {
            this.onException("No result returned.", null);
        } else {
            if (this.index == 2) {
                if (result instanceof Boolean) {
                    boolean b = (Boolean)result;
                    if (!b) {
                        this.onException("No result returned.", null);
                    }
                } else if (result instanceof OriginalMetadataResponse) {
                    OriginalMetadataParser parser = new OriginalMetadataParser(this.file);
                    try {
                        parser.read((OriginalMetadataResponse)result, "=");
                    }
                    catch (Exception e) {
                        this.onException("No result returned.", null);
                        return;
                    }
                }
            }
            if (this.activity != null) {
                this.activity.endActivity(result);
            }
        }
    }
}

