/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import omero.gateway.SecurityContext;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.model.SaveAsParam;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.data.views.ProcessCallback;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;

public class SaveAsLoader
extends UserNotifierLoader {
    private CallHandle handle;
    private SaveAsParam param;
    private ProcessCallback callBack;
    private boolean cancelled;

    @Override
    protected void onException(String message, Throwable ex) {
        this.activity.notifyError("Unable to save the images as " + this.param.getIndexAsString(), message, ex);
    }

    public SaveAsLoader(UserNotifier viewer, Registry registry, SecurityContext ctx, SaveAsParam param, ActivityComponent activity) {
        super(viewer, registry, ctx, activity);
        if (param == null) {
            throw new IllegalArgumentException("Parameters cannot be null.");
        }
        this.param = param;
    }

    @Override
    public void load() {
        this.handle = this.ivView.saveAs(this.ctx, this.param, this);
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        try {
            if (this.callBack != null) {
                this.callBack.cancel();
                this.activity.onActivityCancelled();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.handle.cancel();
    }

    @Override
    public void update(DSCallFeedbackEvent fe) {
        Object o = fe.getPartialResult();
        if (o != null) {
            if (o instanceof Boolean) {
                Boolean b = (Boolean)o;
                if (!b.booleanValue()) {
                    this.onException("Unable to start the script.", null);
                }
            } else {
                this.callBack = (ProcessCallback)o;
                this.callBack.setAdapter(this);
                this.activity.onCallBackSet();
                if (this.cancelled) {
                    this.cancel();
                }
            }
        }
    }

    @Override
    public void handleResult(Object result) {
        if (result instanceof Boolean) {
            Boolean b = (Boolean)result;
            if (!b.booleanValue()) {
                this.onException("Unable to start the script.", null);
            }
        } else if (!(result instanceof Boolean)) {
            this.activity.endActivity(result);
        }
    }
}

