/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import omero.gateway.SecurityContext;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.ResultsObject;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.SaveResultsLoader;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;

public class SaveResultsActivity
extends ActivityComponent {
    private static final String DESCRIPTION_CREATION = "Saving";
    private static final String DESCRIPTION_DONE = "Results saved";
    private static final String DESCRIPTION_CANCEL = "Saving cancelled";
    private ResultsObject results;

    public SaveResultsActivity(UserNotifier viewer, Registry registry, SecurityContext ctx, ResultsObject results) {
        super(viewer, registry, ctx);
        if (results == null) {
            throw new IllegalArgumentException("Parameters not valid.");
        }
        this.results = results;
        this.initialize(DESCRIPTION_CREATION, null);
    }

    @Override
    protected void notifyActivityCancelled() {
        this.type.setText(DESCRIPTION_CANCEL);
    }

    @Override
    protected void notifyActivityEnd() {
        if (this.results.isROI()) {
            if (this.results.isTable()) {
                this.type.setText("ROIs and Results Saved");
            } else {
                this.type.setText("ROIs Saved");
            }
        }
        if (this.results.isTable()) {
            this.type.setText("Results Saved");
        }
    }

    @Override
    protected void notifyActivityError() {
    }

    @Override
    protected UserNotifierLoader createLoader() {
        return new SaveResultsLoader(this.viewer, this.registry, this.ctx, this.results, this);
    }
}

