/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openmicroscopy.shoola.env.ui.TaskBar;
import org.openmicroscopy.shoola.env.ui.TopWindow;
import org.openmicroscopy.shoola.env.ui.TopWindowManager;

public class TopWindowGroup {
    private TaskBar taskBar;
    private JMenu winSubMenu;
    private Map windows;
    private JMenuItem closeAllWinSubMenuEntry;
    private JMenuItem closeAllDropDownButtonEntry;

    private WindowConfig makeConfigFor(TopWindow window) {
        WindowConfig cfg = new WindowConfig();
        cfg.winSubMenuEntry = new JMenuItem();
        cfg.manager = new TopWindowManager(window, new AbstractButton[]{cfg.winSubMenuEntry});
        return cfg;
    }

    private void makeCloseAllButtons() {
        String closeAll = "Close All";
        this.closeAllWinSubMenuEntry = new JMenuItem(closeAll);
        this.closeAllDropDownButtonEntry = new JMenuItem(closeAll);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TopWindowGroup.this.removeAll(true);
            }
        };
        this.closeAllWinSubMenuEntry.addActionListener(al);
        this.closeAllDropDownButtonEntry.addActionListener(al);
    }

    private void addCloseAllButtons() {
        this.winSubMenu.add(this.closeAllWinSubMenuEntry);
        this.winSubMenu.addSeparator();
    }

    private void clearMenus() {
        this.winSubMenu.removeAll();
        this.winSubMenu.setEnabled(false);
    }

    public TopWindowGroup(String name, Icon icon, TaskBar tb) {
        if (tb == null) {
            throw new NullPointerException("No reference to the TaskBar.");
        }
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Must provide a name.");
        }
        this.taskBar = tb;
        this.winSubMenu = new JMenu(name);
        this.winSubMenu.setIcon(icon);
        this.winSubMenu.setEnabled(false);
        this.taskBar.addToMenu(0, this.winSubMenu);
        this.windows = new HashMap();
        this.makeCloseAllButtons();
    }

    public JMenu getWinMenuEntry() {
        return this.winSubMenu;
    }

    public void add(TopWindow window, String name, Icon icon) {
        if (window == null) {
            return;
        }
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Must provide a name.");
        }
        WindowConfig cfg = (WindowConfig)this.windows.get(window);
        if (cfg == null) {
            cfg = this.makeConfigFor(window);
            this.windows.put(window, cfg);
        }
        cfg.winSubMenuEntry.setText(name);
        cfg.winSubMenuEntry.setIcon(icon);
        if (this.windows.size() == 1) {
            this.addCloseAllButtons();
        }
        this.winSubMenu.setEnabled(true);
        this.winSubMenu.add(cfg.winSubMenuEntry);
    }

    public void remove(JFrame window) {
        WindowConfig cfg = (WindowConfig)this.windows.get(window);
        if (cfg == null) {
            return;
        }
        this.windows.remove(window);
        if (this.windows.size() == 0) {
            this.clearMenus();
        }
        this.winSubMenu.remove(cfg.winSubMenuEntry);
    }

    public void remove(JFrame window, boolean dispose) {
        if (window == null) {
            return;
        }
        this.remove(window);
        if (dispose) {
            window.dispose();
        }
    }

    public void removeAll() {
        this.removeAll(false);
    }

    public void removeAll(boolean dispose) {
        int k = this.windows.size();
        if (k == 0) {
            return;
        }
        JFrame[] wIterator = new JFrame[k];
        this.windows.keySet().toArray(wIterator);
        for (k = 0; k < wIterator.length; ++k) {
            this.remove(wIterator[k], dispose);
        }
    }

    private static class WindowConfig {
        JMenuItem winSubMenuEntry;
        TopWindowManager manager;

        private WindowConfig() {
        }
    }
}

