/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.svc.transport;

import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.openmicroscopy.shoola.svc.proxy.Reply;
import org.openmicroscopy.shoola.svc.proxy.Request;
import org.openmicroscopy.shoola.svc.transport.TransportException;

public abstract class HttpChannel {
    public static final int DEFAULT = 0;
    public static final int CONNECTION_PER_REQUEST = 1;
    static final String PROXY_HOST = "http.proxyHost";
    static final String PROXY_PORT = "http.proxyPort";

    protected abstract CloseableHttpClient getCommunicationLink() throws TransportException;

    protected abstract String getRequestPath();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exchange(Request out, Reply in) throws TransportException, IOException {
        if (out == null) {
            throw new NullPointerException("No request.");
        }
        if (in == null) {
            throw new NullPointerException("No reply.");
        }
        HttpUriRequest method = null;
        try (CloseableHttpClient comLink = this.getCommunicationLink();){
            method = out.marshal(this.getRequestPath());
            CloseableHttpResponse response = comLink.execute(method);
            in.unmarshal(response, this);
        }
    }
}

