/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.filter.file.ExcelFilter;
import org.openmicroscopy.shoola.util.filter.file.PDFFilter;
import org.openmicroscopy.shoola.util.filter.file.WordFilter;

public class IOUtil {
    public static final String ZIP_EXTENSION = ".zip";
    private static final WordFilter WORD_FILTER = new WordFilter();
    private static final ExcelFilter EXCEL_FILTER;
    private static final PDFFilter PDF_FILTER;

    private static String readWordFile(File file) throws Exception {
        return null;
    }

    private static String readExcelFile(File file) throws Exception {
        return null;
    }

    private static String readPDFFile(File file) throws Exception {
        return null;
    }

    public static InputStream readFileAsInputStream(String fileName) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException("No file name specified.");
        }
        File f = new File(fileName);
        FileInputStream input = null;
        try {
            input = new FileInputStream(f);
            return new BufferedInputStream(input);
        }
        catch (Exception e) {
            if (input != null) {
                input.close();
            }
            throw new IOException("Cannot read the file " + fileName + ". Error: " + e.getMessage());
        }
    }

    public static OutputStream writeFile(String fileName) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException("No file name specified.");
        }
        File f = new File(fileName);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(f);
            return new BufferedOutputStream(out);
        }
        catch (Exception e) {
            if (out != null) {
                out.close();
            }
            throw new IOException("Cannot write the file " + fileName + ". Error: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(File file) throws IOException {
        StringBuffer contents = new StringBuffer();
        try (BufferedReader input = new BufferedReader(new FileReader(file));){
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
        }
        return contents.toString();
    }

    public static String readTextFile(String fileName) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException("No file name specified.");
        }
        return IOUtil.readTextFile(new File(fileName));
    }

    public static String readFile(File file) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException("No file name specified.");
        }
        if (WORD_FILTER.accept(file)) {
            return IOUtil.readWordFile(file);
        }
        if (EXCEL_FILTER.accept(file)) {
            return IOUtil.readExcelFile(file);
        }
        if (PDF_FILTER.accept(file)) {
            return IOUtil.readPDFFile(file);
        }
        return null;
    }

    public static String readFile(String fileName) throws Exception {
        if (fileName == null || fileName.trim().length() == 0) {
            throw new IllegalArgumentException("No file name specified.");
        }
        return IOUtil.readFile(new File(fileName));
    }

    public static InputStream readConfigFile(String fileName) throws IOException {
        return new FileInputStream(fileName);
    }

    private static void zipDir(File directory, ZipOutputStream out, String parentDirectoryName) throws Exception {
        File[] entries = directory.listFiles();
        byte[] buffer = new byte[4096];
        FileInputStream in = null;
        for (int i = 0; i < entries.length; ++i) {
            try {
                int bytesRead;
                File f = entries[i];
                if (f.isDirectory()) {
                    IOUtil.zipDir(f, out, f.getName());
                    continue;
                }
                in = new FileInputStream(f);
                String zipName = f.getName();
                if (!CommonsLangUtils.isEmpty(parentDirectoryName)) {
                    zipName = FilenameUtils.concat((String)parentDirectoryName, (String)zipName);
                }
                out.putNextEntry(new ZipEntry(zipName));
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
                continue;
            }
            catch (Exception e) {
                throw new Exception("Failure while creating zip.", e);
            }
            finally {
                if (out != null) {
                    out.closeEntry();
                }
                if (in != null) {
                    in.close();
                }
            }
        }
    }

    public static File zipDirectory(File zip, boolean compress) throws Exception {
        if (zip == null) {
            throw new IllegalArgumentException("No name specified.");
        }
        if (!zip.isDirectory() || !zip.exists()) {
            throw new IllegalArgumentException("Not a valid directory.");
        }
        String extension = FilenameUtils.getExtension((String)zip.getName());
        String name = zip.getName();
        if (CommonsLangUtils.isEmpty(extension) || !ZIP_EXTENSION.equals("." + extension)) {
            name = name + ZIP_EXTENSION;
        }
        File file = new File(zip.getParentFile(), name);
        try (ZipOutputStream out = null;){
            out = new ZipOutputStream(new FileOutputStream(file));
            if (!compress) {
                out.setLevel(0);
            }
            IOUtil.zipDir(zip, out, null);
        }
        return file;
    }

    public static File zipDirectory(File zip) throws Exception {
        return IOUtil.zipDirectory(zip, true);
    }

    public static Map<String, InputStream> extractJarFromPath(String name) throws Exception {
        HashMap<String, InputStream> values = new HashMap<String, InputStream>();
        if (name == null) {
            return values;
        }
        ClassLoader loader = IOUtil.class.getClassLoader();
        URL[] urls = ((URLClassLoader)loader).getURLs();
        try {
            for (URL url : urls) {
                String n = url.getFile();
                File f = new File(n);
                if (!f.getName().contains(name)) continue;
                IOUtil.readJar(values, f);
            }
        }
        catch (Exception e) {
            throw new Exception("Cannot read the requested jar.", e);
        }
        return values;
    }

    private static void readJar(Map<String, InputStream> values, File f) throws Exception {
        ZipFile zfile = new ZipFile(f);
        Enumeration<? extends ZipEntry> entries = zfile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            values.put(entry.getName(), zfile.getInputStream(entry));
        }
        zfile.close();
    }

    static {
        PDF_FILTER = new PDFFilter();
        EXCEL_FILTER = new ExcelFilter();
    }
}

