/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.file.modulo;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.util.CommonsLangUtils;

public class ModuloInfo {
    public static final int C = 0;
    public static final int Z = 1;
    public static final int T = 2;
    static final String MODULO_T = "ModuloAlongT";
    static final String MODULO_Z = "ModuloAlongZ";
    static final String MODULO_C = "ModuloAlongC";
    static final String END = "End";
    static final String START = "Start";
    static final String STEP = "Step";
    static final String TYPE = "Type";
    static final String TYPE_DESCRIPTION = "TypeDescription";
    static final String UNIT = "Unit";
    static final String LABEL = "Label";
    private double end;
    private double start;
    private String unit;
    private String type;
    private double step;
    private String typeDescription;
    private int modulo;
    private List<Double> labels;

    ModuloInfo(String moduloAlong) {
        if (CommonsLangUtils.isEmpty(moduloAlong)) {
            throw new IllegalArgumentException("Dimension not supported.");
        }
        this.modulo = -1;
        if (MODULO_C.equals(moduloAlong)) {
            this.modulo = 0;
        } else if (MODULO_Z.equals(moduloAlong)) {
            this.modulo = 1;
        } else if (MODULO_T.equals(moduloAlong)) {
            this.modulo = 2;
        }
        if (this.modulo == -1) {
            throw new IllegalArgumentException("Dimension not supported.");
        }
    }

    public void setLabels(List<Double> labels) {
        this.labels = labels;
    }

    public int getModuloIndex() {
        return this.modulo;
    }

    public void setEnd(double value) {
        this.end = value;
    }

    public void setStart(double value) {
        this.start = value;
    }

    public void setType(String value) {
        this.type = value;
    }

    public void setTypeDescription(String value) {
        this.typeDescription = value;
    }

    public void setUnit(String value) {
        this.unit = value;
    }

    public void setStep(double value) {
        this.step = value;
    }

    public double getEnd() {
        return this.end;
    }

    public double getStart() {
        return this.start;
    }

    public String getUnit() {
        return this.unit;
    }

    public double getStep() {
        return this.step;
    }

    public String getType() {
        return this.type;
    }

    public String getTypeDescription() {
        return this.typeDescription;
    }

    public double getRealValue(int bin) {
        if (CollectionUtils.isEmpty(this.labels)) {
            return this.start + (double)bin * this.step;
        }
        if (bin < 0) {
            bin = 0;
        }
        if (bin >= this.labels.size()) {
            bin = this.labels.size() - 1;
        }
        return this.start + this.labels.get(bin);
    }

    public int getSize() {
        if (!CollectionUtils.isEmpty(this.labels)) {
            return this.labels.size();
        }
        if (this.step == 0.0) {
            this.step = 1.0;
        }
        return (int)((this.end - this.start) / this.step) + 1;
    }
}

