/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.math.geom2D;

import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import org.openmicroscopy.shoola.util.math.geom2D.PlaneArea;
import org.openmicroscopy.shoola.util.math.geom2D.PlanePoint;

class EllipseAreaAdapter
extends Ellipse2D.Float
implements PlaneArea {
    private static double epsilon = 1.0;

    EllipseAreaAdapter(float x, float y, float width, float height) {
        super(x, y, width, height);
    }

    @Override
    public void scale(double factor) {
        Rectangle r = this.getBounds();
        this.setFrame((int)((double)r.x * factor), (int)((double)r.y * factor), (int)((double)r.width * factor), (int)((double)r.height * factor));
    }

    @Override
    public PlanePoint[] getPoints() {
        Rectangle r = this.getBounds();
        ArrayList<PlanePoint> vector = new ArrayList<PlanePoint>(r.height * r.width);
        int xEnd = r.x + r.width;
        int yEnd = r.y + r.height;
        for (int y = r.y; y < yEnd; ++y) {
            for (int x = r.x; x < xEnd; ++x) {
                if (!this.contains(x, y)) continue;
                vector.add(new PlanePoint(x, y));
            }
        }
        return vector.toArray(new PlanePoint[vector.size()]);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        this.setFrame(x, y, width, height);
    }

    @Override
    public boolean onBoundaries(double x, double y) {
        double normy;
        double wEps = this.getWidth() + 2.0 * epsilon;
        double hEps = this.getHeight() + 2.0 * epsilon;
        if (wEps <= 0.0 || hEps <= 0.0) {
            return false;
        }
        double normx = (x - this.getX()) / wEps - this.getWidth() / (2.0 * wEps);
        return normx * normx + (normy = (y - this.getY()) / hEps - this.getHeight() / (2.0 * hEps)) * normy <= 0.25 && !this.contains(x, y);
    }

    @Override
    public Object copy() {
        return super.clone();
    }
}

